{*<!--
/* ********************************************************************************
 * The content of this file is subject to the VTFarsi.ir Modules License("License");
 * You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is VTFarsi.ir
 * Portions created by VTFarsi.ir. are Copyright(C) VTFarsi Team
 * All Rights Reserved.
 * ****************************************************************************** */
-->*}
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex" />
    <meta name="author" content="{$smarty.server.SERVER_NAME}">
    <title>{$PAGETITLE}</title>
    <link type="text/css" href="{$SITEURL}layouts/v7/lib/todc/css/bootstrap.min.css" rel="stylesheet">  <!--BOOTSTRAP 3 CSS FILE-->
    <link type="text/css" href="{$SITEURL}layouts/v7/lib/font-awesome/css/font-awesome.min.css" rel="stylesheet"> <!--Font Awesome CSS FILE-->
    <style>
        {literal}
        @charset "UTF-8";body{font-family:'Open Sans',sans-seriff;font-size:14px;color:#2C3B49;background:url('data:image/png;base64,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');background-repeat:repeat}h1,h2,h3,h4,h5,h6{font-family:'Open Sans',sans-seriff;font-weight:700}h1{font-size:150px;margin-top:0}.center{text-align:center}.capital{text-transform:uppercase}.f1{font-size:34px}@keyframes bubbles1{0%{opacity:0;width:7px;height:7px;top:100px;left:70px}25%{opacity:.25;width:8px;height:8px;top:90px;left:70px}50%{opacity:.5;width:9px;height:9px;top:70px;left:70px}75%{opacity:.75;width:10px;height:10px;top:60px;left:65px}100%{opacity:0;width:11px;height:11px;top:30px;left:70px}}@-webkit-keyframes bubbles1{0%{opacity:0;width:5px;height:5px;top:100px;left:70px}25%{opacity:.25;width:6px;height:6px;top:90px;left:70px}50%{opacity:.5;width:7px;height:7px;top:50px;left:70px}75%{opacity:.75;width:9px;height:9px;top:40px;left:65px}100%{opacity:0;width:10px;height:10px;top:10px;left:75px}}#cflask-holder span{min-width:150px;min-height:150px;width:150px;display:block;background-color:#fff;margin:0 auto;text-align:center;border-radius:150px;position:relative}#cflask-holder span i{padding:40px 0 0 0;font-size:80px}#cflask-holder span i#b1{position:absolute;min-width:10px;min-height:10px;border-radius:50%;background-color:#204e81;left:70px;top:70px;-webkit-animation:bubbles1 infinite linear 1s;animation:bubbles1 infinite linear 1s;padding:0}#cflask-holder span i#b2{position:absolute;min-width:10px;min-height:10px;border-radius:50%;background-color:#204e81;left:70px;top:70px;-webkit-animation:bubbles1 infinite linear 2s;animation:bubbles1 infinite linear 2s;padding:0}#cflask-holder span i#b3{position:absolute;min-width:10px;min-height:10px;border-radius:50%;background-color:#204e81;left:70px;top:70px;-webkit-animation:bubbles1 infinite linear 2.5s;animation:bubbles1 infinite linear 2.5s;padding:0}.row1 p{font-size:35px}.search-form{margin-top:20px}input[type=text]{height:42px;border:1px solid #e6e4e4;outline-color:#ccc;transition:all .2s linear;-moz-transition:all .2s linear;-webkit-transition:all .2s linear;-o-transition:all .2s linear}input[type=text]:focus{outline-color:#204e81}input[type=submit]{height:42px;border:1px solid #c33a4c;background-color:#204e81;color:#fff;text-transform:uppercase;transition:all .2s linear;-moz-transition:all .2s linear;-webkit-transition:all .2s linear;-o-transition:all .2s linear}input[type=submit]:hover{background-color:#952317}.links-wrapper{margin-top:20px}ul.links{float:none;display:block;margin:0 auto}ul.links li{list-style-type:none;display:block;float:left;margin-right:10px;margin-bottom:20px}ul.links li a{height:50px;width:50px;min-width:50px;display:inline-block;padding:3px 0;background-color:#fff;border-radius:50%;text-align:center;color:#204e81;transition:all .2s linear;-moz-transition:all .2s linear;-webkit-transition:all .2s linear;-o-transition:all .2s linear}ul.links li a:hover{background-color:#204e81;color:#fff}ul.links li a i{padding:10px 0}.animated{-webkit-animation-duration:1s;animation-duration:1s;-webkit-animation-fill-mode:both;animation-fill-mode:both}.animated.hinge{-webkit-animation-duration:2s;animation-duration:2s}@-webkit-keyframes bounce{0%,100%,20%,50%,80%{-webkit-transform:translateY(0);transform:translateY(0)}40%{-webkit-transform:translateY(-30px);transform:translateY(-30px)}60%{-webkit-transform:translateY(-15px);transform:translateY(-15px)}}@keyframes bounce{0%,100%,20%,50%,80%{-webkit-transform:translateY(0);-ms-transform:translateY(0);transform:translateY(0)}40%{-webkit-transform:translateY(-30px);-ms-transform:translateY(-30px);transform:translateY(-30px)}60%{-webkit-transform:translateY(-15px);-ms-transform:translateY(-15px);transform:translateY(-15px)}}.bounce{-webkit-animation-name:bounce;animation-name:bounce}@-webkit-keyframes flash{0%,100%,50%{opacity:1}25%,75%{opacity:0}}@keyframes flash{0%,100%,50%{opacity:1}25%,75%{opacity:0}}.flash{-webkit-animation-name:flash;animation-name:flash}@-webkit-keyframes pulse{0%{-webkit-transform:scale(1);transform:scale(1)}50%{-webkit-transform:scale(1.1);transform:scale(1.1)}100%{-webkit-transform:scale(1);transform:scale(1)}}@keyframes pulse{0%{-webkit-transform:scale(1);-ms-transform:scale(1);transform:scale(1)}50%{-webkit-transform:scale(1.1);-ms-transform:scale(1.1);transform:scale(1.1)}100%{-webkit-transform:scale(1);-ms-transform:scale(1);transform:scale(1)}}.pulse{-webkit-animation-name:pulse;animation-name:pulse}@-webkit-keyframes shake{0%,100%{-webkit-transform:translateX(0);transform:translateX(0)}10%,30%,50%,70%,90%{-webkit-transform:translateX(-10px);transform:translateX(-10px)}20%,40%,60%,80%{-webkit-transform:translateX(10px);transform:translateX(10px)}}@keyframes shake{0%,100%{-webkit-transform:translateX(0);-ms-transform:translateX(0);transform:translateX(0)}10%,30%,50%,70%,90%{-webkit-transform:translateX(-10px);-ms-transform:translateX(-10px);transform:translateX(-10px)}20%,40%,60%,80%{-webkit-transform:translateX(10px);-ms-transform:translateX(10px);transform:translateX(10px)}}.shake{-webkit-animation-name:shake;animation-name:shake}@-webkit-keyframes swing{20%{-webkit-transform:rotate(15deg);transform:rotate(15deg)}40%{-webkit-transform:rotate(-10deg);transform:rotate(-10deg)}60%{-webkit-transform:rotate(5deg);transform:rotate(5deg)}80%{-webkit-transform:rotate(-5deg);transform:rotate(-5deg)}100%{-webkit-transform:rotate(0);transform:rotate(0)}}@keyframes swing{20%{-webkit-transform:rotate(15deg);-ms-transform:rotate(15deg);transform:rotate(15deg)}40%{-webkit-transform:rotate(-10deg);-ms-transform:rotate(-10deg);transform:rotate(-10deg)}60%{-webkit-transform:rotate(5deg);-ms-transform:rotate(5deg);transform:rotate(5deg)}80%{-webkit-transform:rotate(-5deg);-ms-transform:rotate(-5deg);transform:rotate(-5deg)}100%{-webkit-transform:rotate(0);-ms-transform:rotate(0);transform:rotate(0)}}.swing{-webkit-transform-origin:top center;-ms-transform-origin:top center;transform-origin:top center;-webkit-animation-name:swing;animation-name:swing}@-webkit-keyframes tada{0%{-webkit-transform:scale(1);transform:scale(1)}10%,20%{-webkit-transform:scale(.9) rotate(-3deg);transform:scale(.9) rotate(-3deg)}30%,50%,70%,90%{-webkit-transform:scale(1.1) rotate(3deg);transform:scale(1.1) rotate(3deg)}40%,60%,80%{-webkit-transform:scale(1.1) rotate(-3deg);transform:scale(1.1) rotate(-3deg)}100%{-webkit-transform:scale(1) rotate(0);transform:scale(1) rotate(0)}}@keyframes tada{0%{-webkit-transform:scale(1);-ms-transform:scale(1);transform:scale(1)}10%,20%{-webkit-transform:scale(.9) rotate(-3deg);-ms-transform:scale(.9) rotate(-3deg);transform:scale(.9) rotate(-3deg)}30%,50%,70%,90%{-webkit-transform:scale(1.1) rotate(3deg);-ms-transform:scale(1.1) rotate(3deg);transform:scale(1.1) rotate(3deg)}40%,60%,80%{-webkit-transform:scale(1.1) rotate(-3deg);-ms-transform:scale(1.1) rotate(-3deg);transform:scale(1.1) rotate(-3deg)}100%{-webkit-transform:scale(1) rotate(0);-ms-transform:scale(1) rotate(0);transform:scale(1) rotate(0)}}.tada{-webkit-animation-name:tada;animation-name:tada}@-webkit-keyframes wobble{0%{-webkit-transform:translateX(0);transform:translateX(0)}15%{-webkit-transform:translateX(-25%) rotate(-5deg);transform:translateX(-25%) rotate(-5deg)}30%{-webkit-transform:translateX(20%) rotate(3deg);transform:translateX(20%) rotate(3deg)}45%{-webkit-transform:translateX(-15%) rotate(-3deg);transform:translateX(-15%) rotate(-3deg)}60%{-webkit-transform:translateX(10%) rotate(2deg);transform:translateX(10%) rotate(2deg)}75%{-webkit-transform:translateX(-5%) rotate(-1deg);transform:translateX(-5%) rotate(-1deg)}100%{-webkit-transform:translateX(0);transform:translateX(0)}}@keyframes wobble{0%{-webkit-transform:translateX(0);-ms-transform:translateX(0);transform:translateX(0)}15%{-webkit-transform:translateX(-25%) rotate(-5deg);-ms-transform:translateX(-25%) rotate(-5deg);transform:translateX(-25%) rotate(-5deg)}30%{-webkit-transform:translateX(20%) rotate(3deg);-ms-transform:translateX(20%) rotate(3deg);transform:translateX(20%) rotate(3deg)}45%{-webkit-transform:translateX(-15%) rotate(-3deg);-ms-transform:translateX(-15%) rotate(-3deg);transform:translateX(-15%) rotate(-3deg)}60%{-webkit-transform:translateX(10%) rotate(2deg);-ms-transform:translateX(10%) rotate(2deg);transform:translateX(10%) rotate(2deg)}75%{-webkit-transform:translateX(-5%) rotate(-1deg);-ms-transform:translateX(-5%) rotate(-1deg);transform:translateX(-5%) rotate(-1deg)}100%{-webkit-transform:translateX(0);-ms-transform:translateX(0);transform:translateX(0)}}.wobble{-webkit-animation-name:wobble;animation-name:wobble}@-webkit-keyframes bounceIn{0%{opacity:0;-webkit-transform:scale(.3);transform:scale(.3)}50%{opacity:1;-webkit-transform:scale(1.05);transform:scale(1.05)}70%{-webkit-transform:scale(.9);transform:scale(.9)}100%{-webkit-transform:scale(1);transform:scale(1)}}@keyframes bounceIn{0%{opacity:0;-webkit-transform:scale(.3);-ms-transform:scale(.3);transform:scale(.3)}50%{opacity:1;-webkit-transform:scale(1.05);-ms-transform:scale(1.05);transform:scale(1.05)}70%{-webkit-transform:scale(.9);-ms-transform:scale(.9);transform:scale(.9)}100%{-webkit-transform:scale(1);-ms-transform:scale(1);transform:scale(1)}}.bounceIn{-webkit-animation-name:bounceIn;animation-name:bounceIn}@-webkit-keyframes bounceInDown{0%{opacity:0;-webkit-transform:translateY(-2000px);transform:translateY(-2000px)}60%{opacity:1;-webkit-transform:translateY(30px);transform:translateY(30px)}80%{-webkit-transform:translateY(-10px);transform:translateY(-10px)}100%{-webkit-transform:translateY(0);transform:translateY(0)}}@keyframes bounceInDown{0%{opacity:0;-webkit-transform:translateY(-2000px);-ms-transform:translateY(-2000px);transform:translateY(-2000px)}60%{opacity:1;-webkit-transform:translateY(30px);-ms-transform:translateY(30px);transform:translateY(30px)}80%{-webkit-transform:translateY(-10px);-ms-transform:translateY(-10px);transform:translateY(-10px)}100%{-webkit-transform:translateY(0);-ms-transform:translateY(0);transform:translateY(0)}}.bounceInDown{-webkit-animation-name:bounceInDown;animation-name:bounceInDown}@-webkit-keyframes bounceInLeft{0%{opacity:0;-webkit-transform:translateX(-2000px);transform:translateX(-2000px)}60%{opacity:1;-webkit-transform:translateX(30px);transform:translateX(30px)}80%{-webkit-transform:translateX(-10px);transform:translateX(-10px)}100%{-webkit-transform:translateX(0);transform:translateX(0)}}@keyframes bounceInLeft{0%{opacity:0;-webkit-transform:translateX(-2000px);-ms-transform:translateX(-2000px);transform:translateX(-2000px)}60%{opacity:1;-webkit-transform:translateX(30px);-ms-transform:translateX(30px);transform:translateX(30px)}80%{-webkit-transform:translateX(-10px);-ms-transform:translateX(-10px);transform:translateX(-10px)}100%{-webkit-transform:translateX(0);-ms-transform:translateX(0);transform:translateX(0)}}.bounceInLeft{-webkit-animation-name:bounceInLeft;animation-name:bounceInLeft}@-webkit-keyframes bounceInRight{0%{opacity:0;-webkit-transform:translateX(2000px);transform:translateX(2000px)}60%{opacity:1;-webkit-transform:translateX(-30px);transform:translateX(-30px)}80%{-webkit-transform:translateX(10px);transform:translateX(10px)}100%{-webkit-transform:translateX(0);transform:translateX(0)}}@keyframes bounceInRight{0%{opacity:0;-webkit-transform:translateX(2000px);-ms-transform:translateX(2000px);transform:translateX(2000px)}60%{opacity:1;-webkit-transform:translateX(-30px);-ms-transform:translateX(-30px);transform:translateX(-30px)}80%{-webkit-transform:translateX(10px);-ms-transform:translateX(10px);transform:translateX(10px)}100%{-webkit-transform:translateX(0);-ms-transform:translateX(0);transform:translateX(0)}}.bounceInRight{-webkit-animation-name:bounceInRight;animation-name:bounceInRight}@-webkit-keyframes bounceInUp{0%{opacity:0;-webkit-transform:translateY(2000px);transform:translateY(2000px)}60%{opacity:1;-webkit-transform:translateY(-30px);transform:translateY(-30px)}80%{-webkit-transform:translateY(10px);transform:translateY(10px)}100%{-webkit-transform:translateY(0);transform:translateY(0)}}@keyframes bounceInUp{0%{opacity:0;-webkit-transform:translateY(2000px);-ms-transform:translateY(2000px);transform:translateY(2000px)}60%{opacity:1;-webkit-transform:translateY(-30px);-ms-transform:translateY(-30px);transform:translateY(-30px)}80%{-webkit-transform:translateY(10px);-ms-transform:translateY(10px);transform:translateY(10px)}100%{-webkit-transform:translateY(0);-ms-transform:translateY(0);transform:translateY(0)}}.bounceInUp{-webkit-animation-name:bounceInUp;animation-name:bounceInUp}@-webkit-keyframes bounceOut{0%{-webkit-transform:scale(1);transform:scale(1)}25%{-webkit-transform:scale(.95);transform:scale(.95)}50%{opacity:1;-webkit-transform:scale(1.1);transform:scale(1.1)}100%{opacity:0;-webkit-transform:scale(.3);transform:scale(.3)}}@keyframes bounceOut{0%{-webkit-transform:scale(1);-ms-transform:scale(1);transform:scale(1)}25%{-webkit-transform:scale(.95);-ms-transform:scale(.95);transform:scale(.95)}50%{opacity:1;-webkit-transform:scale(1.1);-ms-transform:scale(1.1);transform:scale(1.1)}100%{opacity:0;-webkit-transform:scale(.3);-ms-transform:scale(.3);transform:scale(.3)}}.bounceOut{-webkit-animation-name:bounceOut;animation-name:bounceOut}@-webkit-keyframes bounceOutDown{0%{-webkit-transform:translateY(0);transform:translateY(0)}20%{opacity:1;-webkit-transform:translateY(-20px);transform:translateY(-20px)}100%{opacity:0;-webkit-transform:translateY(2000px);transform:translateY(2000px)}}@keyframes bounceOutDown{0%{-webkit-transform:translateY(0);-ms-transform:translateY(0);transform:translateY(0)}20%{opacity:1;-webkit-transform:translateY(-20px);-ms-transform:translateY(-20px);transform:translateY(-20px)}100%{opacity:0;-webkit-transform:translateY(2000px);-ms-transform:translateY(2000px);transform:translateY(2000px)}}.bounceOutDown{-webkit-animation-name:bounceOutDown;animation-name:bounceOutDown}@-webkit-keyframes bounceOutLeft{0%{-webkit-transform:translateX(0);transform:translateX(0)}20%{opacity:1;-webkit-transform:translateX(20px);transform:translateX(20px)}100%{opacity:0;-webkit-transform:translateX(-2000px);transform:translateX(-2000px)}}@keyframes bounceOutLeft{0%{-webkit-transform:translateX(0);-ms-transform:translateX(0);transform:translateX(0)}20%{opacity:1;-webkit-transform:translateX(20px);-ms-transform:translateX(20px);transform:translateX(20px)}100%{opacity:0;-webkit-transform:translateX(-2000px);-ms-transform:translateX(-2000px);transform:translateX(-2000px)}}.bounceOutLeft{-webkit-animation-name:bounceOutLeft;animation-name:bounceOutLeft}@-webkit-keyframes bounceOutRight{0%{-webkit-transform:translateX(0);transform:translateX(0)}20%{opacity:1;-webkit-transform:translateX(-20px);transform:translateX(-20px)}100%{opacity:0;-webkit-transform:translateX(2000px);transform:translateX(2000px)}}@keyframes bounceOutRight{0%{-webkit-transform:translateX(0);-ms-transform:translateX(0);transform:translateX(0)}20%{opacity:1;-webkit-transform:translateX(-20px);-ms-transform:translateX(-20px);transform:translateX(-20px)}100%{opacity:0;-webkit-transform:translateX(2000px);-ms-transform:translateX(2000px);transform:translateX(2000px)}}.bounceOutRight{-webkit-animation-name:bounceOutRight;animation-name:bounceOutRight}@-webkit-keyframes bounceOutUp{0%{-webkit-transform:translateY(0);transform:translateY(0)}20%{opacity:1;-webkit-transform:translateY(20px);transform:translateY(20px)}100%{opacity:0;-webkit-transform:translateY(-2000px);transform:translateY(-2000px)}}@keyframes bounceOutUp{0%{-webkit-transform:translateY(0);-ms-transform:translateY(0);transform:translateY(0)}20%{opacity:1;-webkit-transform:translateY(20px);-ms-transform:translateY(20px);transform:translateY(20px)}100%{opacity:0;-webkit-transform:translateY(-2000px);-ms-transform:translateY(-2000px);transform:translateY(-2000px)}}.bounceOutUp{-webkit-animation-name:bounceOutUp;animation-name:bounceOutUp}@-webkit-keyframes fadeIn{0%{opacity:0}100%{opacity:1}}@keyframes fadeIn{0%{opacity:0}100%{opacity:1}}.fadeIn{-webkit-animation-name:fadeIn;animation-name:fadeIn}@-webkit-keyframes fadeInDown{0%{opacity:0;-webkit-transform:translateY(-20px);transform:translateY(-20px)}100%{opacity:1;-webkit-transform:translateY(0);transform:translateY(0)}}@keyframes fadeInDown{0%{opacity:0;-webkit-transform:translateY(-20px);-ms-transform:translateY(-20px);transform:translateY(-20px)}100%{opacity:1;-webkit-transform:translateY(0);-ms-transform:translateY(0);transform:translateY(0)}}.fadeInDown{-webkit-animation-name:fadeInDown;animation-name:fadeInDown}@-webkit-keyframes fadeInDownBig{0%{opacity:0;-webkit-transform:translateY(-2000px);transform:translateY(-2000px)}100%{opacity:1;-webkit-transform:translateY(0);transform:translateY(0)}}@keyframes fadeInDownBig{0%{opacity:0;-webkit-transform:translateY(-2000px);-ms-transform:translateY(-2000px);transform:translateY(-2000px)}100%{opacity:1;-webkit-transform:translateY(0);-ms-transform:translateY(0);transform:translateY(0)}}.fadeInDownBig{-webkit-animation-name:fadeInDownBig;animation-name:fadeInDownBig}@-webkit-keyframes fadeInLeft{0%{opacity:0;-webkit-transform:translateX(-20px);transform:translateX(-20px)}100%{opacity:1;-webkit-transform:translateX(0);transform:translateX(0)}}@keyframes fadeInLeft{0%{opacity:0;-webkit-transform:translateX(-20px);-ms-transform:translateX(-20px);transform:translateX(-20px)}100%{opacity:1;-webkit-transform:translateX(0);-ms-transform:translateX(0);transform:translateX(0)}}.fadeInLeft{-webkit-animation-name:fadeInLeft;animation-name:fadeInLeft}@-webkit-keyframes fadeInLeftBig{0%{opacity:0;-webkit-transform:translateX(-2000px);transform:translateX(-2000px)}100%{opacity:1;-webkit-transform:translateX(0);transform:translateX(0)}}@keyframes fadeInLeftBig{0%{opacity:0;-webkit-transform:translateX(-2000px);-ms-transform:translateX(-2000px);transform:translateX(-2000px)}100%{opacity:1;-webkit-transform:translateX(0);-ms-transform:translateX(0);transform:translateX(0)}}.fadeInLeftBig{-webkit-animation-name:fadeInLeftBig;animation-name:fadeInLeftBig}@-webkit-keyframes fadeInRight{0%{opacity:0;-webkit-transform:translateX(20px);transform:translateX(20px)}100%{opacity:1;-webkit-transform:translateX(0);transform:translateX(0)}}@keyframes fadeInRight{0%{opacity:0;-webkit-transform:translateX(20px);-ms-transform:translateX(20px);transform:translateX(20px)}100%{opacity:1;-webkit-transform:translateX(0);-ms-transform:translateX(0);transform:translateX(0)}}.fadeInRight{-webkit-animation-name:fadeInRight;animation-name:fadeInRight}@-webkit-keyframes fadeInRightBig{0%{opacity:0;-webkit-transform:translateX(2000px);transform:translateX(2000px)}100%{opacity:1;-webkit-transform:translateX(0);transform:translateX(0)}}@keyframes fadeInRightBig{0%{opacity:0;-webkit-transform:translateX(2000px);-ms-transform:translateX(2000px);transform:translateX(2000px)}100%{opacity:1;-webkit-transform:translateX(0);-ms-transform:translateX(0);transform:translateX(0)}}.fadeInRightBig{-webkit-animation-name:fadeInRightBig;animation-name:fadeInRightBig}@-webkit-keyframes fadeInUp{0%{opacity:0;-webkit-transform:translateY(20px);transform:translateY(20px)}100%{opacity:1;-webkit-transform:translateY(0);transform:translateY(0)}}@keyframes fadeInUp{0%{opacity:0;-webkit-transform:translateY(20px);-ms-transform:translateY(20px);transform:translateY(20px)}100%{opacity:1;-webkit-transform:translateY(0);-ms-transform:translateY(0);transform:translateY(0)}}.fadeInUp{-webkit-animation-name:fadeInUp;animation-name:fadeInUp}@-webkit-keyframes fadeInUpBig{0%{opacity:0;-webkit-transform:translateY(2000px);transform:translateY(2000px)}100%{opacity:1;-webkit-transform:translateY(0);transform:translateY(0)}}@keyframes fadeInUpBig{0%{opacity:0;-webkit-transform:translateY(2000px);-ms-transform:translateY(2000px);transform:translateY(2000px)}100%{opacity:1;-webkit-transform:translateY(0);-ms-transform:translateY(0);transform:translateY(0)}}.fadeInUpBig{-webkit-animation-name:fadeInUpBig;animation-name:fadeInUpBig}@-webkit-keyframes fadeOut{0%{opacity:1}100%{opacity:0}}@keyframes fadeOut{0%{opacity:1}100%{opacity:0}}.fadeOut{-webkit-animation-name:fadeOut;animation-name:fadeOut}@-webkit-keyframes fadeOutDown{0%{opacity:1;-webkit-transform:translateY(0);transform:translateY(0)}100%{opacity:0;-webkit-transform:translateY(20px);transform:translateY(20px)}}@keyframes fadeOutDown{0%{opacity:1;-webkit-transform:translateY(0);-ms-transform:translateY(0);transform:translateY(0)}100%{opacity:0;-webkit-transform:translateY(20px);-ms-transform:translateY(20px);transform:translateY(20px)}}.fadeOutDown{-webkit-animation-name:fadeOutDown;animation-name:fadeOutDown}@-webkit-keyframes fadeOutDownBig{0%{opacity:1;-webkit-transform:translateY(0);transform:translateY(0)}100%{opacity:0;-webkit-transform:translateY(2000px);transform:translateY(2000px)}}@keyframes fadeOutDownBig{0%{opacity:1;-webkit-transform:translateY(0);-ms-transform:translateY(0);transform:translateY(0)}100%{opacity:0;-webkit-transform:translateY(2000px);-ms-transform:translateY(2000px);transform:translateY(2000px)}}.fadeOutDownBig{-webkit-animation-name:fadeOutDownBig;animation-name:fadeOutDownBig}@-webkit-keyframes fadeOutLeft{0%{opacity:1;-webkit-transform:translateX(0);transform:translateX(0)}100%{opacity:0;-webkit-transform:translateX(-20px);transform:translateX(-20px)}}@keyframes fadeOutLeft{0%{opacity:1;-webkit-transform:translateX(0);-ms-transform:translateX(0);transform:translateX(0)}100%{opacity:0;-webkit-transform:translateX(-20px);-ms-transform:translateX(-20px);transform:translateX(-20px)}}.fadeOutLeft{-webkit-animation-name:fadeOutLeft;animation-name:fadeOutLeft}@-webkit-keyframes fadeOutLeftBig{0%{opacity:1;-webkit-transform:translateX(0);transform:translateX(0)}100%{opacity:0;-webkit-transform:translateX(-2000px);transform:translateX(-2000px)}}@keyframes fadeOutLeftBig{0%{opacity:1;-webkit-transform:translateX(0);-ms-transform:translateX(0);transform:translateX(0)}100%{opacity:0;-webkit-transform:translateX(-2000px);-ms-transform:translateX(-2000px);transform:translateX(-2000px)}}.fadeOutLeftBig{-webkit-animation-name:fadeOutLeftBig;animation-name:fadeOutLeftBig}@-webkit-keyframes fadeOutRight{0%{opacity:1;-webkit-transform:translateX(0);transform:translateX(0)}100%{opacity:0;-webkit-transform:translateX(20px);transform:translateX(20px)}}@keyframes fadeOutRight{0%{opacity:1;-webkit-transform:translateX(0);-ms-transform:translateX(0);transform:translateX(0)}100%{opacity:0;-webkit-transform:translateX(20px);-ms-transform:translateX(20px);transform:translateX(20px)}}.fadeOutRight{-webkit-animation-name:fadeOutRight;animation-name:fadeOutRight}@-webkit-keyframes fadeOutRightBig{0%{opacity:1;-webkit-transform:translateX(0);transform:translateX(0)}100%{opacity:0;-webkit-transform:translateX(2000px);transform:translateX(2000px)}}@keyframes fadeOutRightBig{0%{opacity:1;-webkit-transform:translateX(0);-ms-transform:translateX(0);transform:translateX(0)}100%{opacity:0;-webkit-transform:translateX(2000px);-ms-transform:translateX(2000px);transform:translateX(2000px)}}.fadeOutRightBig{-webkit-animation-name:fadeOutRightBig;animation-name:fadeOutRightBig}@-webkit-keyframes fadeOutUp{0%{opacity:1;-webkit-transform:translateY(0);transform:translateY(0)}100%{opacity:0;-webkit-transform:translateY(-20px);transform:translateY(-20px)}}@keyframes fadeOutUp{0%{opacity:1;-webkit-transform:translateY(0);-ms-transform:translateY(0);transform:translateY(0)}100%{opacity:0;-webkit-transform:translateY(-20px);-ms-transform:translateY(-20px);transform:translateY(-20px)}}.fadeOutUp{-webkit-animation-name:fadeOutUp;animation-name:fadeOutUp}@-webkit-keyframes fadeOutUpBig{0%{opacity:1;-webkit-transform:translateY(0);transform:translateY(0)}100%{opacity:0;-webkit-transform:translateY(-2000px);transform:translateY(-2000px)}}@keyframes fadeOutUpBig{0%{opacity:1;-webkit-transform:translateY(0);-ms-transform:translateY(0);transform:translateY(0)}100%{opacity:0;-webkit-transform:translateY(-2000px);-ms-transform:translateY(-2000px);transform:translateY(-2000px)}}.fadeOutUpBig{-webkit-animation-name:fadeOutUpBig;animation-name:fadeOutUpBig}@-webkit-keyframes flip{0%{-webkit-transform:perspective(400px) translateZ(0) rotateY(0) scale(1);transform:perspective(400px) translateZ(0) rotateY(0) scale(1);-webkit-animation-timing-function:ease-out;animation-timing-function:ease-out}40%{-webkit-transform:perspective(400px) translateZ(150px) rotateY(170deg) scale(1);transform:perspective(400px) translateZ(150px) rotateY(170deg) scale(1);-webkit-animation-timing-function:ease-out;animation-timing-function:ease-out}50%{-webkit-transform:perspective(400px) translateZ(150px) rotateY(190deg) scale(1);transform:perspective(400px) translateZ(150px) rotateY(190deg) scale(1);-webkit-animation-timing-function:ease-in;animation-timing-function:ease-in}80%{-webkit-transform:perspective(400px) translateZ(0) rotateY(360deg) scale(.95);transform:perspective(400px) translateZ(0) rotateY(360deg) scale(.95);-webkit-animation-timing-function:ease-in;animation-timing-function:ease-in}100%{-webkit-transform:perspective(400px) translateZ(0) rotateY(360deg) scale(1);transform:perspective(400px) translateZ(0) rotateY(360deg) scale(1);-webkit-animation-timing-function:ease-in;animation-timing-function:ease-in}}@keyframes flip{0%{-webkit-transform:perspective(400px) translateZ(0) rotateY(0) scale(1);-ms-transform:perspective(400px) translateZ(0) rotateY(0) scale(1);transform:perspective(400px) translateZ(0) rotateY(0) scale(1);-webkit-animation-timing-function:ease-out;animation-timing-function:ease-out}40%{-webkit-transform:perspective(400px) translateZ(150px) rotateY(170deg) scale(1);-ms-transform:perspective(400px) translateZ(150px) rotateY(170deg) scale(1);transform:perspective(400px) translateZ(150px) rotateY(170deg) scale(1);-webkit-animation-timing-function:ease-out;animation-timing-function:ease-out}50%{-webkit-transform:perspective(400px) translateZ(150px) rotateY(190deg) scale(1);-ms-transform:perspective(400px) translateZ(150px) rotateY(190deg) scale(1);transform:perspective(400px) translateZ(150px) rotateY(190deg) scale(1);-webkit-animation-timing-function:ease-in;animation-timing-function:ease-in}80%{-webkit-transform:perspective(400px) translateZ(0) rotateY(360deg) scale(.95);-ms-transform:perspective(400px) translateZ(0) rotateY(360deg) scale(.95);transform:perspective(400px) translateZ(0) rotateY(360deg) scale(.95);-webkit-animation-timing-function:ease-in;animation-timing-function:ease-in}100%{-webkit-transform:perspective(400px) translateZ(0) rotateY(360deg) scale(1);-ms-transform:perspective(400px) translateZ(0) rotateY(360deg) scale(1);transform:perspective(400px) translateZ(0) rotateY(360deg) scale(1);-webkit-animation-timing-function:ease-in;animation-timing-function:ease-in}}.animated.flip{-webkit-backface-visibility:visible;-ms-backface-visibility:visible;backface-visibility:visible;-webkit-animation-name:flip;animation-name:flip}@-webkit-keyframes flipInX{0%{-webkit-transform:perspective(400px) rotateX(90deg);transform:perspective(400px) rotateX(90deg);opacity:0}40%{-webkit-transform:perspective(400px) rotateX(-10deg);transform:perspective(400px) rotateX(-10deg)}70%{-webkit-transform:perspective(400px) rotateX(10deg);transform:perspective(400px) rotateX(10deg)}100%{-webkit-transform:perspective(400px) rotateX(0);transform:perspective(400px) rotateX(0);opacity:1}}@keyframes flipInX{0%{-webkit-transform:perspective(400px) rotateX(90deg);-ms-transform:perspective(400px) rotateX(90deg);transform:perspective(400px) rotateX(90deg);opacity:0}40%{-webkit-transform:perspective(400px) rotateX(-10deg);-ms-transform:perspective(400px) rotateX(-10deg);transform:perspective(400px) rotateX(-10deg)}70%{-webkit-transform:perspective(400px) rotateX(10deg);-ms-transform:perspective(400px) rotateX(10deg);transform:perspective(400px) rotateX(10deg)}100%{-webkit-transform:perspective(400px) rotateX(0);-ms-transform:perspective(400px) rotateX(0);transform:perspective(400px) rotateX(0);opacity:1}}.flipInX{-webkit-backface-visibility:visible!important;-ms-backface-visibility:visible!important;backface-visibility:visible!important;-webkit-animation-name:flipInX;animation-name:flipInX}@-webkit-keyframes flipInY{0%{-webkit-transform:perspective(400px) rotateY(90deg);transform:perspective(400px) rotateY(90deg);opacity:0}40%{-webkit-transform:perspective(400px) rotateY(-10deg);transform:perspective(400px) rotateY(-10deg)}70%{-webkit-transform:perspective(400px) rotateY(10deg);transform:perspective(400px) rotateY(10deg)}100%{-webkit-transform:perspective(400px) rotateY(0);transform:perspective(400px) rotateY(0);opacity:1}}@keyframes flipInY{0%{-webkit-transform:perspective(400px) rotateY(90deg);-ms-transform:perspective(400px) rotateY(90deg);transform:perspective(400px) rotateY(90deg);opacity:0}40%{-webkit-transform:perspective(400px) rotateY(-10deg);-ms-transform:perspective(400px) rotateY(-10deg);transform:perspective(400px) rotateY(-10deg)}70%{-webkit-transform:perspective(400px) rotateY(10deg);-ms-transform:perspective(400px) rotateY(10deg);transform:perspective(400px) rotateY(10deg)}100%{-webkit-transform:perspective(400px) rotateY(0);-ms-transform:perspective(400px) rotateY(0);transform:perspective(400px) rotateY(0);opacity:1}}.flipInY{-webkit-backface-visibility:visible!important;-ms-backface-visibility:visible!important;backface-visibility:visible!important;-webkit-animation-name:flipInY;animation-name:flipInY}@-webkit-keyframes flipOutX{0%{-webkit-transform:perspective(400px) rotateX(0);transform:perspective(400px) rotateX(0);opacity:1}100%{-webkit-transform:perspective(400px) rotateX(90deg);transform:perspective(400px) rotateX(90deg);opacity:0}}@keyframes flipOutX{0%{-webkit-transform:perspective(400px) rotateX(0);-ms-transform:perspective(400px) rotateX(0);transform:perspective(400px) rotateX(0);opacity:1}100%{-webkit-transform:perspective(400px) rotateX(90deg);-ms-transform:perspective(400px) rotateX(90deg);transform:perspective(400px) rotateX(90deg);opacity:0}}.flipOutX{-webkit-animation-name:flipOutX;animation-name:flipOutX;-webkit-backface-visibility:visible!important;-ms-backface-visibility:visible!important;backface-visibility:visible!important}@-webkit-keyframes flipOutY{0%{-webkit-transform:perspective(400px) rotateY(0);transform:perspective(400px) rotateY(0);opacity:1}100%{-webkit-transform:perspective(400px) rotateY(90deg);transform:perspective(400px) rotateY(90deg);opacity:0}}@keyframes flipOutY{0%{-webkit-transform:perspective(400px) rotateY(0);-ms-transform:perspective(400px) rotateY(0);transform:perspective(400px) rotateY(0);opacity:1}100%{-webkit-transform:perspective(400px) rotateY(90deg);-ms-transform:perspective(400px) rotateY(90deg);transform:perspective(400px) rotateY(90deg);opacity:0}}.flipOutY{-webkit-backface-visibility:visible!important;-ms-backface-visibility:visible!important;backface-visibility:visible!important;-webkit-animation-name:flipOutY;animation-name:flipOutY}@-webkit-keyframes lightSpeedIn{0%{-webkit-transform:translateX(100%) skewX(-30deg);transform:translateX(100%) skewX(-30deg);opacity:0}60%{-webkit-transform:translateX(-20%) skewX(30deg);transform:translateX(-20%) skewX(30deg);opacity:1}80%{-webkit-transform:translateX(0) skewX(-15deg);transform:translateX(0) skewX(-15deg);opacity:1}100%{-webkit-transform:translateX(0) skewX(0);transform:translateX(0) skewX(0);opacity:1}}@keyframes lightSpeedIn{0%{-webkit-transform:translateX(100%) skewX(-30deg);-ms-transform:translateX(100%) skewX(-30deg);transform:translateX(100%) skewX(-30deg);opacity:0}60%{-webkit-transform:translateX(-20%) skewX(30deg);-ms-transform:translateX(-20%) skewX(30deg);transform:translateX(-20%) skewX(30deg);opacity:1}80%{-webkit-transform:translateX(0) skewX(-15deg);-ms-transform:translateX(0) skewX(-15deg);transform:translateX(0) skewX(-15deg);opacity:1}100%{-webkit-transform:translateX(0) skewX(0);-ms-transform:translateX(0) skewX(0);transform:translateX(0) skewX(0);opacity:1}}.lightSpeedIn{-webkit-animation-name:lightSpeedIn;animation-name:lightSpeedIn;-webkit-animation-timing-function:ease-out;animation-timing-function:ease-out}@-webkit-keyframes lightSpeedOut{0%{-webkit-transform:translateX(0) skewX(0);transform:translateX(0) skewX(0);opacity:1}100%{-webkit-transform:translateX(100%) skewX(-30deg);transform:translateX(100%) skewX(-30deg);opacity:0}}@keyframes lightSpeedOut{0%{-webkit-transform:translateX(0) skewX(0);-ms-transform:translateX(0) skewX(0);transform:translateX(0) skewX(0);opacity:1}100%{-webkit-transform:translateX(100%) skewX(-30deg);-ms-transform:translateX(100%) skewX(-30deg);transform:translateX(100%) skewX(-30deg);opacity:0}}.lightSpeedOut{-webkit-animation-name:lightSpeedOut;animation-name:lightSpeedOut;-webkit-animation-timing-function:ease-in;animation-timing-function:ease-in}@-webkit-keyframes rotateIn{0%{-webkit-transform-origin:center center;transform-origin:center center;-webkit-transform:rotate(-200deg);transform:rotate(-200deg);opacity:0}100%{-webkit-transform-origin:center center;transform-origin:center center;-webkit-transform:rotate(0);transform:rotate(0);opacity:1}}@keyframes rotateIn{0%{-webkit-transform-origin:center center;-ms-transform-origin:center center;transform-origin:center center;-webkit-transform:rotate(-200deg);-ms-transform:rotate(-200deg);transform:rotate(-200deg);opacity:0}100%{-webkit-transform-origin:center center;-ms-transform-origin:center center;transform-origin:center center;-webkit-transform:rotate(0);-ms-transform:rotate(0);transform:rotate(0);opacity:1}}.rotateIn{-webkit-animation-name:rotateIn;animation-name:rotateIn}@-webkit-keyframes rotateInDownLeft{0%{-webkit-transform-origin:left bottom;transform-origin:left bottom;-webkit-transform:rotate(-90deg);transform:rotate(-90deg);opacity:0}100%{-webkit-transform-origin:left bottom;transform-origin:left bottom;-webkit-transform:rotate(0);transform:rotate(0);opacity:1}}@keyframes rotateInDownLeft{0%{-webkit-transform-origin:left bottom;-ms-transform-origin:left bottom;transform-origin:left bottom;-webkit-transform:rotate(-90deg);-ms-transform:rotate(-90deg);transform:rotate(-90deg);opacity:0}100%{-webkit-transform-origin:left bottom;-ms-transform-origin:left bottom;transform-origin:left bottom;-webkit-transform:rotate(0);-ms-transform:rotate(0);transform:rotate(0);opacity:1}}.rotateInDownLeft{-webkit-animation-name:rotateInDownLeft;animation-name:rotateInDownLeft}@-webkit-keyframes rotateInDownRight{0%{-webkit-transform-origin:right bottom;transform-origin:right bottom;-webkit-transform:rotate(90deg);transform:rotate(90deg);opacity:0}100%{-webkit-transform-origin:right bottom;transform-origin:right bottom;-webkit-transform:rotate(0);transform:rotate(0);opacity:1}}@keyframes rotateInDownRight{0%{-webkit-transform-origin:right bottom;-ms-transform-origin:right bottom;transform-origin:right bottom;-webkit-transform:rotate(90deg);-ms-transform:rotate(90deg);transform:rotate(90deg);opacity:0}100%{-webkit-transform-origin:right bottom;-ms-transform-origin:right bottom;transform-origin:right bottom;-webkit-transform:rotate(0);-ms-transform:rotate(0);transform:rotate(0);opacity:1}}.rotateInDownRight{-webkit-animation-name:rotateInDownRight;animation-name:rotateInDownRight}@-webkit-keyframes rotateInUpLeft{0%{-webkit-transform-origin:left bottom;transform-origin:left bottom;-webkit-transform:rotate(90deg);transform:rotate(90deg);opacity:0}100%{-webkit-transform-origin:left bottom;transform-origin:left bottom;-webkit-transform:rotate(0);transform:rotate(0);opacity:1}}@keyframes rotateInUpLeft{0%{-webkit-transform-origin:left bottom;-ms-transform-origin:left bottom;transform-origin:left bottom;-webkit-transform:rotate(90deg);-ms-transform:rotate(90deg);transform:rotate(90deg);opacity:0}100%{-webkit-transform-origin:left bottom;-ms-transform-origin:left bottom;transform-origin:left bottom;-webkit-transform:rotate(0);-ms-transform:rotate(0);transform:rotate(0);opacity:1}}.rotateInUpLeft{-webkit-animation-name:rotateInUpLeft;animation-name:rotateInUpLeft}@-webkit-keyframes rotateInUpRight{0%{-webkit-transform-origin:right bottom;transform-origin:right bottom;-webkit-transform:rotate(-90deg);transform:rotate(-90deg);opacity:0}100%{-webkit-transform-origin:right bottom;transform-origin:right bottom;-webkit-transform:rotate(0);transform:rotate(0);opacity:1}}@keyframes rotateInUpRight{0%{-webkit-transform-origin:right bottom;-ms-transform-origin:right bottom;transform-origin:right bottom;-webkit-transform:rotate(-90deg);-ms-transform:rotate(-90deg);transform:rotate(-90deg);opacity:0}100%{-webkit-transform-origin:right bottom;-ms-transform-origin:right bottom;transform-origin:right bottom;-webkit-transform:rotate(0);-ms-transform:rotate(0);transform:rotate(0);opacity:1}}.rotateInUpRight{-webkit-animation-name:rotateInUpRight;animation-name:rotateInUpRight}@-webkit-keyframes rotateOut{0%{-webkit-transform-origin:center center;transform-origin:center center;-webkit-transform:rotate(0);transform:rotate(0);opacity:1}100%{-webkit-transform-origin:center center;transform-origin:center center;-webkit-transform:rotate(200deg);transform:rotate(200deg);opacity:0}}@keyframes rotateOut{0%{-webkit-transform-origin:center center;-ms-transform-origin:center center;transform-origin:center center;-webkit-transform:rotate(0);-ms-transform:rotate(0);transform:rotate(0);opacity:1}100%{-webkit-transform-origin:center center;-ms-transform-origin:center center;transform-origin:center center;-webkit-transform:rotate(200deg);-ms-transform:rotate(200deg);transform:rotate(200deg);opacity:0}}.rotateOut{-webkit-animation-name:rotateOut;animation-name:rotateOut}@-webkit-keyframes rotateOutDownLeft{0%{-webkit-transform-origin:left bottom;transform-origin:left bottom;-webkit-transform:rotate(0);transform:rotate(0);opacity:1}100%{-webkit-transform-origin:left bottom;transform-origin:left bottom;-webkit-transform:rotate(90deg);transform:rotate(90deg);opacity:0}}@keyframes rotateOutDownLeft{0%{-webkit-transform-origin:left bottom;-ms-transform-origin:left bottom;transform-origin:left bottom;-webkit-transform:rotate(0);-ms-transform:rotate(0);transform:rotate(0);opacity:1}100%{-webkit-transform-origin:left bottom;-ms-transform-origin:left bottom;transform-origin:left bottom;-webkit-transform:rotate(90deg);-ms-transform:rotate(90deg);transform:rotate(90deg);opacity:0}}.rotateOutDownLeft{-webkit-animation-name:rotateOutDownLeft;animation-name:rotateOutDownLeft}@-webkit-keyframes rotateOutDownRight{0%{-webkit-transform-origin:right bottom;transform-origin:right bottom;-webkit-transform:rotate(0);transform:rotate(0);opacity:1}100%{-webkit-transform-origin:right bottom;transform-origin:right bottom;-webkit-transform:rotate(-90deg);transform:rotate(-90deg);opacity:0}}@keyframes rotateOutDownRight{0%{-webkit-transform-origin:right bottom;-ms-transform-origin:right bottom;transform-origin:right bottom;-webkit-transform:rotate(0);-ms-transform:rotate(0);transform:rotate(0);opacity:1}100%{-webkit-transform-origin:right bottom;-ms-transform-origin:right bottom;transform-origin:right bottom;-webkit-transform:rotate(-90deg);-ms-transform:rotate(-90deg);transform:rotate(-90deg);opacity:0}}.rotateOutDownRight{-webkit-animation-name:rotateOutDownRight;animation-name:rotateOutDownRight}@-webkit-keyframes rotateOutUpLeft{0%{-webkit-transform-origin:left bottom;transform-origin:left bottom;-webkit-transform:rotate(0);transform:rotate(0);opacity:1}100%{-webkit-transform-origin:left bottom;transform-origin:left bottom;-webkit-transform:rotate(-90deg);transform:rotate(-90deg);opacity:0}}@keyframes rotateOutUpLeft{0%{-webkit-transform-origin:left bottom;-ms-transform-origin:left bottom;transform-origin:left bottom;-webkit-transform:rotate(0);-ms-transform:rotate(0);transform:rotate(0);opacity:1}100%{-webkit-transform-origin:left bottom;-ms-transform-origin:left bottom;transform-origin:left bottom;-webkit-transform:rotate(-90deg);-ms-transform:rotate(-90deg);transform:rotate(-90deg);opacity:0}}.rotateOutUpLeft{-webkit-animation-name:rotateOutUpLeft;animation-name:rotateOutUpLeft}@-webkit-keyframes rotateOutUpRight{0%{-webkit-transform-origin:right bottom;transform-origin:right bottom;-webkit-transform:rotate(0);transform:rotate(0);opacity:1}100%{-webkit-transform-origin:right bottom;transform-origin:right bottom;-webkit-transform:rotate(90deg);transform:rotate(90deg);opacity:0}}@keyframes rotateOutUpRight{0%{-webkit-transform-origin:right bottom;-ms-transform-origin:right bottom;transform-origin:right bottom;-webkit-transform:rotate(0);-ms-transform:rotate(0);transform:rotate(0);opacity:1}100%{-webkit-transform-origin:right bottom;-ms-transform-origin:right bottom;transform-origin:right bottom;-webkit-transform:rotate(90deg);-ms-transform:rotate(90deg);transform:rotate(90deg);opacity:0}}.rotateOutUpRight{-webkit-animation-name:rotateOutUpRight;animation-name:rotateOutUpRight}@-webkit-keyframes slideInDown{0%{opacity:0;-webkit-transform:translateY(-2000px);transform:translateY(-2000px)}100%{-webkit-transform:translateY(0);transform:translateY(0)}}@keyframes slideInDown{0%{opacity:0;-webkit-transform:translateY(-2000px);-ms-transform:translateY(-2000px);transform:translateY(-2000px)}100%{-webkit-transform:translateY(0);-ms-transform:translateY(0);transform:translateY(0)}}.slideInDown{-webkit-animation-name:slideInDown;animation-name:slideInDown}@-webkit-keyframes slideInLeft{0%{opacity:0;-webkit-transform:translateX(-2000px);transform:translateX(-2000px)}100%{-webkit-transform:translateX(0);transform:translateX(0)}}@keyframes slideInLeft{0%{opacity:0;-webkit-transform:translateX(-2000px);-ms-transform:translateX(-2000px);transform:translateX(-2000px)}100%{-webkit-transform:translateX(0);-ms-transform:translateX(0);transform:translateX(0)}}.slideInLeft{-webkit-animation-name:slideInLeft;animation-name:slideInLeft}@-webkit-keyframes slideInRight{0%{opacity:0;-webkit-transform:translateX(2000px);transform:translateX(2000px)}100%{-webkit-transform:translateX(0);transform:translateX(0)}}@keyframes slideInRight{0%{opacity:0;-webkit-transform:translateX(2000px);-ms-transform:translateX(2000px);transform:translateX(2000px)}100%{-webkit-transform:translateX(0);-ms-transform:translateX(0);transform:translateX(0)}}.slideInRight{-webkit-animation-name:slideInRight;animation-name:slideInRight}@-webkit-keyframes slideOutLeft{0%{-webkit-transform:translateX(0);transform:translateX(0)}100%{opacity:0;-webkit-transform:translateX(-2000px);transform:translateX(-2000px)}}@keyframes slideOutLeft{0%{-webkit-transform:translateX(0);-ms-transform:translateX(0);transform:translateX(0)}100%{opacity:0;-webkit-transform:translateX(-2000px);-ms-transform:translateX(-2000px);transform:translateX(-2000px)}}.slideOutLeft{-webkit-animation-name:slideOutLeft;animation-name:slideOutLeft}@-webkit-keyframes slideOutRight{0%{-webkit-transform:translateX(0);transform:translateX(0)}100%{opacity:0;-webkit-transform:translateX(2000px);transform:translateX(2000px)}}@keyframes slideOutRight{0%{-webkit-transform:translateX(0);-ms-transform:translateX(0);transform:translateX(0)}100%{opacity:0;-webkit-transform:translateX(2000px);-ms-transform:translateX(2000px);transform:translateX(2000px)}}.slideOutRight{-webkit-animation-name:slideOutRight;animation-name:slideOutRight}@-webkit-keyframes slideOutUp{0%{-webkit-transform:translateY(0);transform:translateY(0)}100%{opacity:0;-webkit-transform:translateY(-2000px);transform:translateY(-2000px)}}@keyframes slideOutUp{0%{-webkit-transform:translateY(0);-ms-transform:translateY(0);transform:translateY(0)}100%{opacity:0;-webkit-transform:translateY(-2000px);-ms-transform:translateY(-2000px);transform:translateY(-2000px)}}.slideOutUp{-webkit-animation-name:slideOutUp;animation-name:slideOutUp}@-webkit-keyframes hinge{0%{-webkit-transform:rotate(0);transform:rotate(0);-webkit-transform-origin:top left;transform-origin:top left;-webkit-animation-timing-function:ease-in-out;animation-timing-function:ease-in-out}20%,60%{-webkit-transform:rotate(80deg);transform:rotate(80deg);-webkit-transform-origin:top left;transform-origin:top left;-webkit-animation-timing-function:ease-in-out;animation-timing-function:ease-in-out}40%{-webkit-transform:rotate(60deg);transform:rotate(60deg);-webkit-transform-origin:top left;transform-origin:top left;-webkit-animation-timing-function:ease-in-out;animation-timing-function:ease-in-out}80%{-webkit-transform:rotate(60deg) translateY(0);transform:rotate(60deg) translateY(0);opacity:1;-webkit-transform-origin:top left;transform-origin:top left;-webkit-animation-timing-function:ease-in-out;animation-timing-function:ease-in-out}100%{-webkit-transform:translateY(700px);transform:translateY(700px);opacity:0}}@keyframes hinge{0%{-webkit-transform:rotate(0);-ms-transform:rotate(0);transform:rotate(0);-webkit-transform-origin:top left;-ms-transform-origin:top left;transform-origin:top left;-webkit-animation-timing-function:ease-in-out;animation-timing-function:ease-in-out}20%,60%{-webkit-transform:rotate(80deg);-ms-transform:rotate(80deg);transform:rotate(80deg);-webkit-transform-origin:top left;-ms-transform-origin:top left;transform-origin:top left;-webkit-animation-timing-function:ease-in-out;animation-timing-function:ease-in-out}40%{-webkit-transform:rotate(60deg);-ms-transform:rotate(60deg);transform:rotate(60deg);-webkit-transform-origin:top left;-ms-transform-origin:top left;transform-origin:top left;-webkit-animation-timing-function:ease-in-out;animation-timing-function:ease-in-out}80%{-webkit-transform:rotate(60deg) translateY(0);-ms-transform:rotate(60deg) translateY(0);transform:rotate(60deg) translateY(0);opacity:1;-webkit-transform-origin:top left;-ms-transform-origin:top left;transform-origin:top left;-webkit-animation-timing-function:ease-in-out;animation-timing-function:ease-in-out}100%{-webkit-transform:translateY(700px);-ms-transform:translateY(700px);transform:translateY(700px);opacity:0}}.hinge{-webkit-animation-name:hinge;animation-name:hinge}@-webkit-keyframes rollIn{0%{opacity:0;-webkit-transform:translateX(-100%) rotate(-120deg);transform:translateX(-100%) rotate(-120deg)}100%{opacity:1;-webkit-transform:translateX(0) rotate(0);transform:translateX(0) rotate(0)}}@keyframes rollIn{0%{opacity:0;-webkit-transform:translateX(-100%) rotate(-120deg);-ms-transform:translateX(-100%) rotate(-120deg);transform:translateX(-100%) rotate(-120deg)}100%{opacity:1;-webkit-transform:translateX(0) rotate(0);-ms-transform:translateX(0) rotate(0);transform:translateX(0) rotate(0)}}.rollIn{-webkit-animation-name:rollIn;animation-name:rollIn}@-webkit-keyframes rollOut{0%{opacity:1;-webkit-transform:translateX(0) rotate(0);transform:translateX(0) rotate(0)}100%{opacity:0;-webkit-transform:translateX(100%) rotate(120deg);transform:translateX(100%) rotate(120deg)}}@keyframes rollOut{0%{opacity:1;-webkit-transform:translateX(0) rotate(0);-ms-transform:translateX(0) rotate(0);transform:translateX(0) rotate(0)}100%{opacity:0;-webkit-transform:translateX(100%) rotate(120deg);-ms-transform:translateX(100%) rotate(120deg);transform:translateX(100%) rotate(120deg)}}.rollOut{-webkit-animation-name:rollOut;animation-name:rollOut}
        {/literal}
    </style>
</head>
<body>

<section>
    <div class="container">
        <div class="row row1">
            <div class="col-md-12">
                <h3 class="center capital f1 wow fadeInLeft" data-wow-duration="2s">Something went Wrong!</h3>
                <h1 id="errorCode" class="center wow fadeInRight" data-wow-duration="2s">0</h1>
                <p class="center wow bounceIn" data-wow-delay="2s">{$DESC}!</p>
                {if $SERVICEWORKER}
                    <p class="center wow bounceIn" data-wow-delay="2s"><small><small><a href="#" onClick="window.location.href='{$SITEURL}';">Reload Page</a></small></small></p>
                {else}
                <p class="center wow bounceIn" data-wow-delay="2s"><small><small>your current IP address ({$USERIP}) is being logged.</small></small></p>
                {/if}
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div id="cflask-holder" class="wow fadeIn" data-wow-delay="2800ms">
                            <span class="wow tada " data-wow-delay="3000ms">
                                <i class="fa fa-flask fa-5x flask wow flip" data-wow-delay="3300ms"></i>
                                <i id="b1" class="bubble"></i>
                                <i id="b2" class="bubble"></i>
                                <i id="b3" class="bubble"></i>
                            </span>
                </div>
            </div>
        </div>
    </div>
</section>
<script type="text/javascript">
    {literal}
    function countUp(a,t,n,e,i){for(var r=0,o=["webkit","moz","ms"],m=0;m<o.length&&!window.requestAnimationFrame;++m)window.requestAnimationFrame=window[o[m]+"RequestAnimationFrame"],window.cancelAnimationFrame=window[o[m]+"CancelAnimationFrame"]||window[o[m]+"CancelRequestAnimationFrame"];window.requestAnimationFrame||(window.requestAnimationFrame=function(a,t){var n=(new Date).getTime(),e=Math.max(0,16-(n-r)),i=window.setTimeout(function(){a(n+e)},e);return r=n+e,i}),window.cancelAnimationFrame||(window.cancelAnimationFrame=function(a){clearTimeout(a)});var s=this;this.useEasing=!0,this.d="string"==typeof a?document.getElementById(a):a,s.startVal=Number(t),n=Number(n),this.countDown=t>n,e=Math.max(0,e||0),this.dec=Math.pow(10,e),this.duration=1e3*i||2e3,this.startTime=null,this.timestamp=null,this.remaining=null,this.frameVal=s.startVal,this.rAF=null,this.easeOutExpo=function(a,t,n,e){return n*(1-Math.pow(2,-10*a/e))*1024/1023+t},this.count=function(a){null===s.startTime&&(s.startTime=a),s.timestamp=a;var t=a-s.startTime;if(s.remaining=s.duration-t,s.useEasing)if(s.countDown){i=s.easeOutExpo(t,0,s.startVal-n,s.duration);s.frameVal=s.startVal-i}else s.frameVal=s.easeOutExpo(t,s.startVal,n-s.startVal,s.duration);else if(s.countDown){var i=(s.startVal-n)*(t/s.duration);s.frameVal=s.startVal-i}else s.frameVal=s.startVal+(n-s.startVal)*(t/s.duration);s.frameVal=Math.round(s.frameVal*s.dec)/s.dec,s.countDown?s.frameVal=s.frameVal<n?n:s.frameVal:s.frameVal=s.frameVal>n?n:s.frameVal,s.d.innerHTML=s.addCommas(s.frameVal.toFixed(e)),t<s.duration?s.rAF=requestAnimationFrame(s.count):null!=s.callback&&s.callback()},this.start=function(a){return s.callback=a,isNaN(n)||isNaN(t)?(console.log("countUp error: startVal or endVal is not a number"),s.d.innerHTML="--"):s.rAF=requestAnimationFrame(s.count),!1},this.stop=function(){cancelAnimationFrame(s.rAF)},this.reset=function(){s.startTime=null,cancelAnimationFrame(s.rAF),s.d.innerHTML=s.addCommas(t.toFixed(e))},this.resume=function(){s.startTime=null,s.duration=s.remaining,s.startVal=s.frameVal,requestAnimationFrame(s.count)},this.addCommas=function(a){var t,n,e,i;for(n=(t=(a+="").split("."))[0],e=t.length>1?"."+t[1]:"",i=/(\d+)(\d{3})/;i.test(n);)n=n.replace(i,"$1,$2");return n+e},s.d.innerHTML=s.addCommas(t.toFixed(e))};
    (function(){var t,e=[].slice,i=function(t,e){return function(){return t.apply(e,arguments)}};t=function(){var i,n,o,s,a,r,l,c;for(o=arguments[0],i=2<=arguments.length?e.call(arguments,1):[],s=o||{},r=0,l=i.length;r<l;r++){c=i[r]||{};for(n in c)a=c[n],"object"==typeof s[n]?s[n]=t(s[n],a):s[n]||(s[n]=a)}return s},this.WOW=function(){function e(e){null==e&&(e={}),this.scrollCallback=i(this.scrollCallback,this),this.scrollHandler=i(this.scrollHandler,this),this.start=i(this.start,this),this.config=t(e,this.defaults),this.scrolled=!0}return e.prototype.defaults={boxClass:"wow",animateClass:"animated",offset:0},e.prototype.init=function(){var t;return"interactive"===(t=document.readyState)||"complete"===t?this.start():document.addEventListener("DOMContentLoaded",this.start)},e.prototype.start=function(){var t,e,i,n;if(this.element=window.document.documentElement,this.boxes=this.element.getElementsByClassName(this.config.boxClass),this.boxes.length){for(e=0,i=(n=this.boxes).length;e<i;e++)t=n[e],this.applyStyle(t,!0);return window.addEventListener("scroll",this.scrollHandler,!1),window.addEventListener("resize",this.scrollHandler,!1),this.interval=setInterval(this.scrollCallback,50)}},e.prototype.stop=function(){if(window.removeEventListener("scroll",this.scrollHandler,!1),window.removeEventListener("resize",this.scrollHandler,!1),null!=this.interval)return clearInterval(this.interval)},e.prototype.show=function(t){return this.applyStyle(t),t.className=t.className+" "+this.config.animateClass},e.prototype.applyStyle=function(t,e){var i,n,o;return n=t.getAttribute("data-wow-duration"),i=t.getAttribute("data-wow-delay"),o=t.getAttribute("data-wow-iteration"),t.setAttribute("style",this.customStyle(e,n,i,o))},e.prototype.customStyle=function(t,e,i,n){var o;return o=t?"visibility: hidden; -webkit-animation-name: none; -moz-animation-name: none; animation-name: none;":"visibility: visible;",e&&(o+="-webkit-animation-duration: "+e+"; -moz-animation-duration: "+e+"; animation-duration: "+e+";"),i&&(o+="-webkit-animation-delay: "+i+"; -moz-animation-delay: "+i+"; animation-delay: "+i+";"),n&&(o+="-webkit-animation-iteration-count: "+n+"; -moz-animation-iteration-count: "+n+"; animation-iteration-count: "+n+";"),o},e.prototype.scrollHandler=function(){return this.scrolled=!0},e.prototype.scrollCallback=function(){var t;if(this.scrolled&&(this.scrolled=!1,this.boxes=function(){var e,i,n,o;for(o=[],e=0,i=(n=this.boxes).length;e<i;e++)(t=n[e])&&(this.isVisible(t)?this.show(t):o.push(t));return o}.call(this),!this.boxes.length))return this.stop()},e.prototype.offsetTop=function(t){var e;for(e=t.offsetTop;t=t.offsetParent;)e+=t.offsetTop;return e},e.prototype.isVisible=function(t){var e,i,n,o,s;return i=t.getAttribute("data-wow-offset")||this.config.offset,s=window.pageYOffset,o=s+this.element.clientHeight-i,n=this.offsetTop(t),e=n+t.clientHeight,n<=o&&e>=s},e}()}).call(this);
    {/literal}
    "use strict";
    var count = new countUp("errorCode", 0,  {$CODE}, 0, 3);
    window.onload = function() {
        count.start();
    }
    "use strict";
    var wow = new WOW(
        {
            animateClass: 'animated',
            offset:       100
        }
    );
    wow.init();
</script>
</body>
</html>