{literal}
    <style>
        .image {
            width: 25px;
            height: 25px;
            overflow: hidden;
            cursor: pointer;
            color: #fff;
        }
        .image img {
            visibility: hidden;
        }
        .table-hover>tbody>tr:hover {
            background-color: #f5f5f5;
        }
    </style>
{/literal}
<div style="padding:20px;">
    {if empty($OTHER_OPTIONS)}
        <p style="text-align:justify" class="alert alert-info">
            {vtranslate('Invalid configuration.', $QUALIFIED_MODULE_NAME)}
        </p>
    {else}
        <div style="clear:both;"></div>
        <table class="table table-hover" style="width:100%;" cellpadding="10" id="otherOptions">
            <tbody>
            {foreach key=HEADER_NAME item=_OTHER_OPTIONS from=$OTHER_OPTIONS name="headerIterator"}
                <tr class="OptionHeader blockHeader">
                    <th colspan="2" class="textAlignCenter">
                        <label><i class="fa fa-wrench icon" style="margin: 0 5px"></i>{vtranslate($HEADER_NAME,'ParsVT')}</label>
                    </th>
                </tr>
                {foreach key=KEY_NAME item=OTHER_OPTION from=$_OTHER_OPTIONS}
                    <tr class="OptionRow">
                        <td style="padding: 15px; width: 200px">
                            {$OTHER_OPTION['label']}
                        </td>
                        <td style="padding: 10px">
                            <input style="opacity: 0;" {if $OTHER_OPTION['value']} value='1'  checked{else} value='0'{/if}
                                   class='cursorPointer bootstrap-switch' type="{$OTHER_OPTION['type']}" {if !$OTHER_OPTION['supported'] OR (isset($OTHER_OPTION['disable']) && $OTHER_OPTION['disable'])} disabled {/if}
                                   data-on-text="{vtranslate('Active', $QUALIFIED_MODULE)}"
                                   data-off-text="{vtranslate('Inactive', $QUALIFIED_MODULE)}"
                                   data-on-color="success" data-off-color="danger" data-toggle="toggle" data-type="{$KEY_NAME}"/>
                            {if $OTHER_OPTION['description'] neq ''}<br><small>{vtranslate($OTHER_OPTION['description'],$QUALIFIED_MODULE)}</small>{/if}
                        </td>
                    </tr>
                {/foreach}
            {/foreach}
            </tbody>
        </table>
    {/if}
</div>
<script type="text/javascript">
    jQuery(document).ready(function() {
        jQuery('.bootstrap-switch').bootstrapSwitch();
        jQuery('#otherOptions').on('switchChange.bootstrapSwitch', "input[type=checkbox]", function (e, state) {
            var currentElement = jQuery(e.currentTarget);
            var value = 0;
            if (state == 1) {
                currentElement.attr('value', 1);
                value = 1;
            } else {
                currentElement.attr('value', 0);
                value = 0;
            }
            var type = currentElement.data('type');
            ParsVT_LayoutEditor_Js.sendModuleOption(type, value, currentElement);
        });
    });
</script>
