{*<!--
/*********************************************************************************
** The contents of this file are subject to the vtiger CRM Public License Version 1.0
* ("License"); You may not use this file except in compliance with the License
* The Original Code is:  vtiger CRM Open Source
* The Initial Developer of the Original Code is vtiger.
* Portions created by vtiger are Copyright (C) vtiger.
* All Rights Reserved.
*
********************************************************************************/
-->*}
{strip}{/strip}

    {assign var=CURRENT_USER_MODEL value=Users_Record_Model::getCurrentUserModel()}
    {assign var=GANTT_DATA value=$GANTT_RECORDS['data']}
    {assign var=GANTT_LINKS value=$GANTT_RECORDS['links']}
    <style>
        {foreach from=$TASK_STATUS_COLOR item=COLOR key=STATUS}
        {Project_Record_Model::getGanttStatusCss($STATUS, $COLOR)}
        {Project_Record_Model::getGanttSvgStatusCss($STATUS, $COLOR)}
        {/foreach}
        {if $CURRENT_USER_MODEL->get('language') eq 'fa_ir' or  $CURRENT_USER_MODEL->get('language') eq 'fa_af'}
        .gantt_cal_quick_info.gantt_task, .highcharts-dialog-content, .highcharts-tooltip {
            direction: rtl;
        }
        .highcharts-dialog-close {

            right: unset !important;
            left: 8px !important;
        }
        {/if}
    </style>

    {if !empty($PROJECT_TASKS['tasks'])}
        <script>
            var GanttLanguageStrings = {
                LBL_TASK_NAME: "{vtranslate('LBL_TASK_NAME', $MODULE)}",
                LBL_START_DATE: "{vtranslate('LBL_START_DATE', $MODULE)}",
                LBL_END_DATE: "{vtranslate('LBL_END_DATE', $MODULE)}",
                LBL_DURATION: "{vtranslate('LBL_DURATION', $MODULE)}",
                LBL_QUICK_VIEW: "{vtranslate('LBL_QUICK_VIEW', $MODULE)}",
                LBL_ASSIGNED_TO: "{vtranslate('Assigned To', $MODULE)}",
                LBL_TYPE: "{vtranslate('Type', 'Project')}",
                LBL_STATUS: "{vtranslate('LBL_STATUS', $MODULE)}",
                LBL_VIEW_DETAILS: "{vtranslate('LBL_VIEW_DETAILS', $MODULE)}",
                LBL_PRIORITY: "{vtranslate('Priority', 'Project')}",
                LBL_PROGRESS: "{vtranslate('Progress', 'Project')}",
                LBL_TODAY: "{vtranslate('LBL_TODAY', 'Calendar')}",
                ONE_MONTH: "{vtranslate('1 Month', 'Project')}",
                THREE_MONTH: "{vtranslate('3 Months', 'Project')}",
                ONE_YEAR: "{vtranslate('1 Year', 'Project')}",
                ALL: "{vtranslate('All', 'Vtiger')}",
                RANGE: "",
            };
            {if $DEFAULT_GANTT eq 'dhtmlx'}
            var GanttData = {
                DATA: [
                    {foreach from=$GANTT_DATA item=DATA}
                    {$DATA},
                    {/foreach}
                ],
                LINKS: [
                    {foreach from=$GANTT_LINKS item=LINK}
                    {$LINK},
                    {/foreach}
                ],
                {*
                MESSAGE: [
                    "TEXT",
                ]*}
            };
            {else}
            var GanttData = [
                {foreach from=$GANTT_RECORDS key=key item=DATA}
                    {$DATA}{if $key < ($GANTT_RECORDS|count - 1)}, {/if}
                {/foreach}
            ];
            {/if}
        </script>
        <h3> {vtranslate('LBL_PROGRESS_CHART',$MODULE)} </h3>
        <br/>
        <input type="hidden" id="user_gantt_date_format" value="{ParsVT_GanttCharts_Model::getCurrentUserDateFormat()}">
        <input type="hidden" id="user_gantt_date_separator" value="{$USER_DATE_SEPARATOR}">
        <input type="hidden" id="gantt_start_day" value="{$CURRENT_USER_MODEL->get('dayoftheweek')}" />
        <input type="hidden" id="gantt_start_project" value="{$RECORD_MODEL->get('startdate')}" />
        <input type="hidden" id="default_gantt" value="{$DEFAULT_GANTT}" />
        <input id="recordId" type="hidden" value="{$PARENT_ID}" />
        <div class="scrolling-container">
            <div id="parsvt_gantt" dir="ltr" style="direction: ltr"></div>
        </div>
        <div id="workSpace" style="padding:0px;border:1px solid #e5e5e5;position:relative;margin:0 5px"></div>
        <div class="row" style="margin-top: 10px; padding: 5px;">
            <div class="col-lg-4">
                <table class="table table-condensed table-striped table-bordered ">
                    <thead>
                    <tr>
                        <td></td>
                        <td><b>{vtranslate('LBL_STATUS', $MODULE)}</b></td>
                    </tr>
                    </thead>
                    <tbody>
                    {foreach from=$TASK_STATUS item=STATUS_NAME}
                        {assign var=STATUS_NAME value=trim($STATUS_NAME)}
                        <tr>
                            <td>
                                <div class="row">
                                    <div class="col-lg-3"> &nbsp;</div>
                                    <div class="col-lg-3">
                                        <div status="{Project_Record_Model::getGanttStatus($STATUS_NAME)}"
                                             class="taskStatus cvcColorSquare"></div>
                                    </div>
                                    {if $STATUS_FIELD_MODEL->isEditable()}
                                        <div class="col-lg-3">
                                            <a onclick="javascript:Project_Detail_Js.showEditColorModel('index.php?module={$MODULE}&view=EditAjax&mode=editColor&status={$STATUS_NAME}', this)"
                                               data-status="{$STATUS_NAME}"
                                               data-color="{$TASK_STATUS_COLOR[$STATUS_NAME]}"><i
                                                        title="{vtranslate('LBL_EDIT_COLOR', $MODULE)}"
                                                        class="fa fa-pencil alignMiddle"></i></a>&nbsp;
                                        </div>
                                    {/if}
                                </div>
                            </td>
                            <td>{vtranslate($STATUS_NAME,'ProjectTask')}</td>
                        </tr>
                    {/foreach}
                    </tbody>
                </table>
            </div>

        </div>
    {else}
        <table class="emptyRecordsDiv">
            <tbody>
            <tr>
                <td>
                    {assign var="PROJECT_TASK_MODEL" value=Vtiger_Module_Model::getInstance('ProjectTask')}
                    {assign var="IS_MODULE_EDITABLE" value=$PROJECT_TASK_MODEL->isPermitted('CreateView')}
                    {assign var=SINGLE_MODULE value="SINGLE_ProjectTask"}
                    {if $CURRENT_USER_MODEL->get('language') eq 'fa_ir' or  $CURRENT_USER_MODEL->get('language') eq 'fa_af'}
                        {vtranslate('No %s found.', 'ParsVT',vtranslate('ProjectTask', 'ProjectTask'))}
                    {else}
                        {vtranslate('LBL_NO')} {vtranslate('ProjectTask', 'ProjectTask')} {vtranslate('LBL_FOUND')}
                    {/if}
                    {vtranslate('LBL_NO_DATE_VALUE_MSG', 'ProjectTask')}.{if $IS_MODULE_EDITABLE} <a href="{$PROJECT_TASK_MODEL->getCreateRecordUrl()}&projectid={$PARENT_ID}">{vtranslate('LBL_CREATE')} {vtranslate('ProjectTask', 'ProjectTask')}</a>{/if}
                </td>
            </tr>
            </tbody>
        </table>
    {/if}
{strip}
{/strip}