<div class="container-fluid">

    <form action="index.php" method="post">
        <div class="contentHeader row-fluid">
            <div class="span4 btn-toolbar">
                <div class="pull-left widget_header">
                    <h3>{vtranslate('Timeline View', $QUALIFIED_MODULE)}</h3>
                </div>
            </div>
            <div class="span4 btn-toolbar">
                <div class="pull-right">
                    <button class="btn btn-success saveButton" type="submit" title="{vtranslate('LBL_SAVE',$QUALIFIED_MODULE)}"><strong>{vtranslate('LBL_SAVE',$QUALIFIED_MODULE)}</strong></button>
                </div>
            </div>
        </div>
        <hr>
        <div class="clearfix"></div>
        <div class="listViewContentDiv row-fluid" id="listViewContents">
            <table class="table table-bordered table-condensed themeTableColor">
                <tbody>
                <tr>
                    <td class="medium" nowrap="">
                        <label class="muted pull-right marginRight10px">{vtranslate('Number of Fields to show',$QUALIFIED_MODULE)}</label>
                    </td>
                    <td class="medium" style="border-left: none;">
                        <input type="text" value="{$SETTINGS.limit_field}" class="inputElement" name="settings[limit_field]"/>
                    </td>
                    <td class="medium" style="border-left: none;">
                        <i class="fa fa-info-circle"></i>&nbsp;{vtranslate('Updates will be limited to the number of fields set. If the update contains more than number set, it will show option "Show More" to expand and see additional updates',$QUALIFIED_MODULE)}
                    </td>
                </tr>
                <tr>
                    <td class="medium" nowrap="">
                        <label class="muted pull-right marginRight10px">{vtranslate('Number of Characters to show',$QUALIFIED_MODULE)}</label>
                    </td>
                    <td class="medium" style="border-left: none;">
                        <input type="text" value="{$SETTINGS.limit_character}" class="inputElement" name="settings[limit_character]"/>
                    </td>
                    <td class="medium" style="border-left: none;">
                        <i class="fa fa-info-circle"></i>&nbsp;{vtranslate('This only applies to Comments and Emails. You can specify how much text to show. If there are more text than number set, it will show option "Show More" to expand and see additional text',$QUALIFIED_MODULE)}
                    </td>
                </tr>
                <tr>
                    <td class="medium" nowrap="">
                        <label class="muted pull-right marginRight10px">{vtranslate('Active Modules',$QUALIFIED_MODULE)}</label>
                    </td>
                    <td class="medium" style="border-left: none;">
                        <select name="settings[modules][]" class="select2 inputElement" multiple>
                            {foreach item=MODULE_INFO from=$LIST_MODULE}
                            <option value="{$MODULE_INFO.name}" {if in_array($MODULE_INFO.name, $SETTINGS.modules)} selected{/if}>{vtranslate($MODULE_INFO.tablabel, $MODULE_INFO.name)}</option>
                            {/foreach}
                        </select>
                    </td>
                    <td class="medium" style="border-left: none;">
                        <i class="fa fa-info-circle"></i>&nbsp;{vtranslate('Timeline will be enabled for selected modules only.',$QUALIFIED_MODULE)}
                    </td>
                </tr>
                <tr>
                    <td class="medium" nowrap="">
                        <label class="muted pull-right marginRight10px">{vtranslate('Include updates from M:M related modules?',$QUALIFIED_MODULE)}</label>
                    </td>
                    <td class="medium" style="border-left: none;">
                        <select name="settings[multiple_relation_type]" class="select2 inputElement">
                            <option value="0" {if $SETTINGS.multiple_relation_type neq 1} selected{/if}>{vtranslate('LBL_NO', $QUALIFIED_MODULE)}</option>
                            <option value="1" {if $SETTINGS.multiple_relation_type eq 1} selected{/if}>{vtranslate('LBL_YES', $QUALIFIED_MODULE)}</option>
                        </select>
                    </td>
                    <td class="medium" style="border-left: none;">
                        <i class="fa fa-info-circle"></i>&nbsp;{vtranslate("Option to see updates from modules that have M:M relationship, e.g Opportunities & Products. If Product is linked to Opportunity and there's an update on the product - it will show up on the Opportunity.",$QUALIFIED_MODULE)}
                    </td>
                </tr>
                <tr>
                    <td class="medium" nowrap="">
                        <label class="muted pull-right marginRight10px">{vtranslate('Automatically show Timeline View?',$QUALIFIED_MODULE)}</label>
                    </td>
                    <td class="medium" style="border-left: none;">
                        <select name="settings[automatically_show]" class="select2 inputElement">
                            <option value="1" {if $SETTINGS.automatically_show eq 1} selected{/if}>{vtranslate('LBL_YES', $QUALIFIED_MODULE)}</option>
                            <option value="0" {if $SETTINGS.automatically_show neq 1} selected{/if}>{vtranslate('LBL_NO', $QUALIFIED_MODULE)}</option>
                        </select>
                    </td>
                    <td class="medium" style="border-left: none;">
                        <i class="fa fa-info-circle"></i>&nbsp;{vtranslate('Option to automatically load the timeline when clicked on Touchpoints.',$QUALIFIED_MODULE)}
                    </td>
                </tr>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="module" value="ParsVT" />
        <input type="hidden" name="parent" value="Settings" />
        <input type="hidden" name="action" value="Save" />
        <input type="hidden" name="mode" value="SaveTimeline" />
    </form>
</div>

