jQuery.Class('Vtiger_TimelineLog_Js', {
    showUpdates : function(element){
        var parentElement = $(element).closest('.details');

        parentElement.find(".historyButtons").find("button").removeAttr("disabled").removeClass("btn-success");
        var currentElement = jQuery(element);
        currentElement.attr("disabled","disabled").addClass("btn-success");

        var params = [];
        var recordId = jQuery('#recordId').val();
        params.url = "index.php?view=Detail&module="+app.getModuleName()+"&mode=showRecentActivities&record="+recordId;

        app.helper.showProgress();
        app.request.get(params).then(function(error,response){
            parentElement.html(response);
            //add button again
            var aDeferred = jQuery.Deferred();
            var params = {
                module: 'ParsVT',
                view: 'HistoryAjax',
                mode: 'addButton',
                page: 1,
                recordId: app.getRecordId(),
                sourceModule: app.getModuleName()
            };
            app.request.post({data: params}).then(function(err, data) {
                if(err===null){
                    if(parentElement.find('.TimelineHistoryButtons').length==0) {
                        parentElement.find('.recentActivitiesContainer').prepend(data);
                        parentElement.find('.historyButtons button').attr('disabled', true);
                        parentElement.find('.TimelineHistoryButtons button').removeAttr('disabled');
                        parentElement.find('.TimelineHistoryButtons').next(".btn-group").remove();
                    }
                }
                app.helper.hideProgress();
            });
            return aDeferred.promise();
        });
    },

    showHistoryLog: function (element) {
        $(element).attr('disabled', true);
        var thisInstance = this;
        var currentModule = app.getModuleName();
        var TimelineLog_Js_Instance = new Vtiger_TimelineLog_Js();
        TimelineLog_Js_Instance.getCurrentVtigerVersion().then(function (data) {
            var current_vtiger_version = data.version;
        var filterModule = $(".active_modules li.active");
        if (filterModule.length > 0){
            filterModule = filterModule.data("module");
        } else {
            filterModule = '';
        }
        if($('.details>.HistoryContainer').length > 0 &&  (currentModule=='Leads' || currentModule=='Accounts' || currentModule=='Contacts') && current_vtiger_version > '7.1.0') {
		   var container = $('.details>.HistoryContainer');
            var recordId = jQuery('#recordId').val();
            if (container.find('.data-body').length > 0) {
                var aDeferred = jQuery.Deferred();
                var params = {
                    module: 'ParsVT',
                    view: 'HistoryAjax',
                    mode: 'showHistoryLog',
                    sourceModule: app.getModuleName(),
                    record: recordId,
                    filterModule: filterModule
                };
                app.helper.showProgress();
                app.request.post({data: params}).then(function (err, data) {
                    if (err === null) {
                        container.find(".data-body").html(data);
                        container.find('.historyButtons button').removeAttr('disabled');
                        app.helper.hideProgress();
                        thisInstance.registerModuleQtips(container);
                    }
                });
                return aDeferred.promise();
            }
        }else{
            var detailViewInstance = new Vtiger_Detail_Js();
            var detailViewContainer = detailViewInstance.getDetailViewContainer();
            var container = detailViewContainer.find('.recentActivitiesContainer').closest('.details');
            var recordId = jQuery('#recordId').val();
            if (container.length > 0) {
                var aDeferred = jQuery.Deferred();
                var params = {
                    module: 'ParsVT',
                    view: 'HistoryAjax',
                    mode: 'showHistoryLog',
                    sourceModule: app.getModuleName(),
                    record: recordId,
                    filterModule: filterModule
                };
                app.helper.showProgress();
                app.request.post({data: params}).then(function (err, data) {
                    if (err === null) {
                        container.html(data);
                        container.find('.historyButtons button').removeAttr('disabled');

                        thisInstance.registerModuleQtips(container);

                        //add button again
                        var aDeferred = jQuery.Deferred();
                        var params = {
                            module: 'ParsVT',
                            view: 'HistoryAjax',
                            mode: 'addButton',
                            page: 1,
                            recordId: app.getRecordId(),
                            filterModule: filterModule,
                            sourceModule: app.getModuleName()
                        };
                        app.request.post({data: params}).then(function(err, data) {
                            if(err===null){
                                if(container.find('.TimelineHistoryButtons').length==0) {
                                    container.find('.recentActivitiesContainer').prepend(data);
                                    container.find('.TimelineHistoryButtons button').attr('disabled', true);
                                    container.find('.historyButtons button').removeAttr('disabled');
                                }
                            }
                            app.helper.hideProgress();
                        });
                        return aDeferred.promise();
                    }
                });
                return aDeferred.promise();
            }
        }
        });

    },

    showHistoryLogMore: function (el) {
        var thisInstance = this;
        var container = $(el).closest('#updates');
        app.helper.showProgress();
        var currentPage = container.find("#updatesCurrentPage").val();
        var recordId = app.getRecordId();
        var sourceModule = app.getModuleName();
        var nextPage = parseInt(currentPage) + 1;
        var url = "index.php?module=ParsVT&view=HistoryAjax&record="
            + recordId + "&sourceModule="+sourceModule+"&mode=showHistoryLogMore&page="
            + nextPage + "&tab_label=LBL_UPDATES";
        var postParams  = app.convertUrlToDataParams(url);

        app.request.post({data:postParams}).then(function(err,data){
            container.find("#updatesCurrentPage").val(nextPage);
            container.find('#more_button').remove();
            container.find('ul.updates_timeline.updates_timeline_contents').append(data);
            app.helper.hideProgress();
            thisInstance.registerModuleQtips(container);
        });
    },

    registerModuleQtips : function(container) {
        container.find('.module-qtip').qtip({
            position: {
                my: 'left center',
                at: 'center right',
                adjust: {
                    y: 1
                }
            },
            style: {
                classes: 'qtip-dark qtip-shadow module-name-tooltip'
            },
            show: {
                delay: 500
            }
        });
    },

    showHistoryLogMoreField: function (el) {
        var container = $(el).closest('.update_info_block_content');
        container.find('.updateInfoContainer').each(function () {
           if($(this).hasClass('hide')){
               $(this).addClass('show-more-fields');
           };
        });
        container.find('.updateInfoContainer-show-more').addClass('hide');
        container.find('.updateInfoContainer-show-less').removeClass('hide');
    },

    showHistoryLogLessField: function (el) {
        var container = $(el).closest('.update_info_block_content');
        container.find('.updateInfoContainer').each(function () {
            if($(this).hasClass('hide')){
                $(this).removeClass('show-more-fields');
            };
        });
        container.find('.updateInfoContainer-show-more').removeClass('hide');
        container.find('.updateInfoContainer-show-less').addClass('hide');
    },

    showHistoryLogMoreCharacter: function (el) {
        var container = $(el).closest('.update_info_block_content');
        var full_content = container.data('fullcontent');
        full_content= full_content.replace(/&amp;nbsp;/g, ' ');
        full_content= full_content.replace(/&amp;/g, '&');
        full_content = $("<div />").html(full_content).text()
        full_content = full_content.trim().replace(/\n{2,}/gi, '\n');
        full_content = full_content.trim().replace(/(\r?\n){2,}/m, '\r\n');
        container.find('.updateInfoContainer-full-content').html($("<div />").html(full_content).text());
        //container.find('.updateInfoContainer-full-content').text(full_content);
        container.find('.updateInfoContainer-show-more').addClass('hide');
        container.find('.updateInfoContainer-show-less').removeClass('hide');
    },

    showHistoryLogLessCharacter: function (el) {
        var container = $(el).closest('.update_info_block_content');
        var less_content = container.data('lesscontent');
        less_content = less_content.replace(/&amp;nbsp;/g, ' ');
        less_content = less_content.replace(/&amp;/g, '&');
        less_content = $("<div />").html(less_content).text()
        less_content = less_content.trim().replace(/\n{2,}/gi, '\n');
        less_content = less_content.trim().replace(/(\r?\n){2,}/m, '\r\n');
        container.find('.updateInfoContainer-full-content').html($("<div />").html(less_content).text());
        //container.find('.updateInfoContainer-full-content').text(less_content);
        container.find('.updateInfoContainer-show-more').removeClass('hide');
        container.find('.updateInfoContainer-show-less').addClass('hide');
    },

    showHistoryLogMoreEmailCharacter: function (el) {
        var container = $(el).closest('.update_info_block_content');
        var full_content = container.find('.updateInfoContainer-show-more').data('fullcontent');
        container.find('.created-emails-description').text(full_content);
        container.find('.updateInfoContainer-show-more').addClass('hide');
        container.find('.updateInfoContainer-show-less').removeClass('hide');
    },

    showHistoryLogLessEmailCharacter: function (el) {
        var container = $(el).closest('.update_info_block_content');
        var less_content = container.find('.updateInfoContainer-show-less').data('lesscontent');
        container.find('.created-emails-description').text(less_content);
        container.find('.updateInfoContainer-show-more').removeClass('hide');
        container.find('.updateInfoContainer-show-less').addClass('hide');
    },

    showDetailOverlay: function (url) {
        if(typeof url != "undefined"){
            var params = app.convertUrlToDataParams(url);
            //Display Mode to show details in overlay
            params['mode'] = 'showDetailViewByMode';
            params['requestMode'] = 'full';
            params['displayMode'] = 'overlay';
            var parentRecordId = app.getRecordId();
            app.helper.showProgress();
            app.request.get({data: params}).then(function(err, response) {
                app.helper.hideProgress();
                var overlayParams = {'backdrop' : 'static', 'keyboard' : false};
                app.helper.loadPageContentOverlay(response, overlayParams).then(function(container) {
                    var detailjs = Vtiger_Detail_Js.getInstanceByModuleName(params.module);
                    detailjs.showScroll(jQuery('.overlayDetail .modal-body'));
                    detailjs.setModuleName(params.module);
                    detailjs.setOverlayDetailMode(true);
                    detailjs.setContentHolder(container.find('.overlayDetail'));
                    detailjs.setDetailViewContainer(container.find('.overlayDetail'));
                    detailjs.registerOverlayEditEvent();
                    detailjs.registerBasicEvents();
                    detailjs.registerClickEvent();
                    detailjs.registerHeaderAjaxEditEvents(container.find('.overlayDetailHeader'));
                    detailjs.registerEventToReloadRelatedListOnCloseOverlay(parentRecordId);
                    app.event.trigger('post.overlay.load', parentRecordId, params);
                    container.find('form#detailView').on('submit', function(e) {
                        e.preventDefault();
                    });
                });
            });
        }
    },

    showComposeEmail: function (record) {
        var params = {};
        params['module'] = "Emails";
        params['view'] = "ComposeEmail";
        //params['parentId'] = 2;
        params['relatedLoad'] = true;
        //params['parentModule'] = app.getModuleName();
        params['mode'] = 'emailPreview';
        params['record'] = record;
        app.helper.showProgress();
        app.request.post({data:params}).then(function(err,data){
            app.helper.hideProgress();
            if(err === null){
                var dataObj = jQuery(data);
                var descriptionContent = dataObj.find('#iframeDescription').val();
                app.helper.showModal(data,{cb:function(){
                    app.event.trigger('post.EmailPreview.load',null);
                    jQuery('#emailPreviewIframe').contents().find('html').html(descriptionContent);
                    jQuery("#emailPreviewIframe").height(jQuery('.email-body-preview').height());
                    jQuery('#emailPreviewIframe').contents().find('html').find('a').on('click', function(e) {
                        e.preventDefault();
                        var url = jQuery(e.currentTarget).attr('href');
                        window.open(url, '_blank');
                    });
                }});
            }
        });
    }

}, {
    initialize: function(){
        var detailViewInstance = new Vtiger_Detail_Js();
        var detailViewContainer = detailViewInstance.getDetailViewContainer();
        var currentModule = app.getModuleName();
        this.getCurrentVtigerVersion().then(function (data) {
            var current_vtiger_version = data.version;
        if(detailViewContainer.find('.HistoryContainer').length > 0 && (currentModule=='Leads' || currentModule=='Accounts' || currentModule=='Contacts') && current_vtiger_version > '7.1.0') {
            var container = detailViewContainer.find('.HistoryContainer');

            if(container.find('.TimelineHistoryButtons').length==0){
                var aDeferred = jQuery.Deferred();
                var params = {
                    module: 'ParsVT',
                    view: 'HistoryAjax',
                    mode: 'addButton',
                    page: 1,
                    recordId: app.getRecordId(),
                    sourceModule: app.getModuleName()
                };
                app.request.post({data: params}).then(function(err, data) {
                    if(err===null){
                        if(container.find('.TimelineHistoryButtons').length==0) {
                            container.find("div:first-child").after(data);
                            var automatically_show = $(data).find('button').data('automatically-show');
                            if(automatically_show===1){
                                container.find('.TimelineHistoryButtons button').trigger('click');
                            }
                        }
                    }
                });
                return aDeferred.promise();
            }
        }else{
            var container = detailViewContainer.find('.recentActivitiesContainer');
            if(container.find('.TimelineHistoryButtons').length==0){
                var aDeferred = jQuery.Deferred();
                var params = {
                    module: 'ParsVT',
                    view: 'HistoryAjax',
                    mode: 'addButton',
                    page: 1,
                    recordId: app.getRecordId(),
                    sourceModule: app.getModuleName()
                };
                app.request.post({data: params}).then(function(err, data) {
                    if(err===null){
                        if(container.find('.TimelineHistoryButtons').length==0) {
                            container.prepend(data);
                            var automatically_show = container.find('.TimelineHistoryButtons button').data('automatically-show');
                            if(automatically_show===1){
                                container.find('.TimelineHistoryButtons button').trigger('click');
                            }
                        }
                    }
                });
                return aDeferred.promise();
            }
        }
        });
    },

    getCurrentVtigerVersion: function () {
        var aDeferred = jQuery.Deferred();
        var params = {
            module: 'ParsVT',
            action: 'ActionAjax',
            mode: 'getCurrentVtigerVersion',
        };
        app.request.post({data: params}).then(function(err, data) {
            aDeferred.resolve(data);
        });

        return aDeferred.promise();
    },

    // Extract "GET" parameters from a JS include querystring
    getParams: function (script_name) {
        // Find all script tags
        var scripts = document.getElementsByTagName("script");

        // Look through them trying to find ourselves
        for(var i=0; i<scripts.length; i++) {
            if(scripts[i].src.indexOf(script_name) > -1) {
                // Get an array of key=value strings of params
                var pa = scripts[i].src.split("?").pop().split("&");

                // Split each key=value into array, the construct js object
                var p = {};
                for(var j=0; j<pa.length; j++) {
                    var kv = pa[j].split("=");
                    p[kv[0]] = kv[1];
                }
                return p;
            }
        }

        // No scripts match
        return {};
    }

});

//On Page Load
jQuery(document).ready(function() {
    setTimeout(function () {
        initData_Timelog();
    }, 1000);
});
function initData_Timelog() {
    // Event for filter module
    $("body").undelegate(".active_modules li", "click");
    $("body").delegate(".active_modules li", "click", function(){
        if ($(this).hasClass("active")){
            $(".active_modules li").removeClass("active");
        } else {
            $(".active_modules li").removeClass("active");
            $(this).addClass("active");
        }
        Vtiger_TimelineLog_Js.showHistoryLog(".TimelineHistoryButtons button");
    });
        
    // Event for filter module
    $("body").undelegate(".btnResetFilter", "click");
    $("body").delegate(".btnResetFilter", "click", function(){
        if ($(".active_modules li.active").length > 0){
            $(".active_modules li").removeClass("active");
            Vtiger_TimelineLog_Js.showHistoryLog(".TimelineHistoryButtons button");
        }
    });

    jQuery( document ).ajaxComplete(function(event, request, settings) {
        var request_url = settings.url;
        if(request_url.indexOf('index.php?view=Detail&mode=showHistory') != -1 || (request_url.indexOf('mode=showRecentActivities') != -1 && request_url.indexOf('view=Detail') != -1 && request_url.indexOf('LBL_UPDATE') != -1)){
            if(request.status==200){
                var instance = new Vtiger_TimelineLog_Js();
                instance.initialize();
            }
        }
        if(request_url.indexOf('mode=showRecentActivities') != -1 && request_url.indexOf('view=Detail') != -1){
            if($('.TimelineHistoryButtons').length>0) {
                $('.TimelineHistoryButtons button').removeAttr('disabled');
            }
        }
        var commentList = $('.updateInfoContainer-full-content');
        for(var i=0;i < commentList.length; i++){
            var curComment = jQuery(commentList[i]);
            var fullcomment = curComment.html();
            if(typeof fullcomment != 'undefined'){
                fullcomment= fullcomment.replace(/&amp;nbsp;/g, ' ');
                fullcomment= fullcomment.replace(/&amp;/g, '&');
                fullcomment = $("<div />").html(fullcomment).text()
                fullcomment = fullcomment.trim().replace(/\n{2,}/gi, '\n');
                fullcomment = fullcomment.trim().replace(/(\r?\n){2,}/m, '\r\n');
                $(curComment).html($("<div />").html(fullcomment).text());
            }


        }
    });
    var current_url = window.location.href;
    if(current_url.indexOf('index.php?view=Detail&mode=showHistory') != -1 || (current_url.indexOf('mode=showRecentActivities') != -1 && current_url.indexOf('view=Detail') != -1 && current_url.indexOf('LBL_UPDATE') != -1)){
        var instance = new Vtiger_TimelineLog_Js();
        instance.initialize();
    }
}