{*<!--
/* ********************************************************************************
 * The content of this file is subject to the VTFarsi.ir Modules License("License");
 * You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is VTFarsi.ir
 * Portions created by VTFarsi.ir. are Copyright(C) VTFarsi Team
 * All Rights Reserved.
 * ****************************************************************************** */
-->*}
{if $content}
<style>
    .card-container {
        width: 100%;
        display: flex;
        justify-content: space-evenly;
        align-items: flex-start;
        flex-wrap: wrap;
        gap: 10px;
        margin-bottom: 50px !important;
    }
    .card {
        min-width: 200px;
        width: clamp(250px, 20vw, 500px);
        height: fit-content;
        background-color: #2C3B49;
        color: #FFF;
        text-align: center;
        display: flex;
        flex-direction: row;
        border-radius: 2px;
        align-items: center;
        justify-content: space-between;
        overflow: hidden;
    }
    .card-title {
        margin: 0;
        font-size: 1.5rem;
        color: #FFF;
        white-space: nowrap;
        word-break: break-word;
        width: 80%;
    }
    .card:hover {
        text-decoration: none;
        color: #FFF;
        background-color: #596875;
    }
    .card:visited,
    .card:active,
    .card:hover {
        color: #FFF;
    }
    .card-price {
        padding: 10px;
        margin: 0;
        width: 20%;
        background-color: #EF5E29;
        font-size: 1.5rem;
        color: #FFF;
    }
    .dashBoardContainer .tab-pane .dashBoardTabContents ul {
        width: auto !important;
    }
    .select2-search-field {
        position: static !important;
        border: none !important;
    }
</style>
<div class="dashboardWidgetHeader">
    {include file="dashboards/WidgetHeader.tpl"|@vtemplate_path:$MODULE_NAME}
</div>
<div class="dashboardWidgetContent cartable-container" style="height: 100%;min-height: 100%">
    {/if}
    <input class="widgetData" type='hidden' value='{Vtiger_Util_Helper::toSafeHTML(ZEND_JSON::encode($MODELS))}'/>
    <div style='padding:5px'>
        <div class="card-container" style="margin-bottom: 30px;">
            {if !empty($MODELS)}
            {foreach item=module from=$MODELS}
                <a href="{$SITEURL}index.php?module={$module['setype']}&view=CartableList" class="card">
                    <p class="card-title">{vtranslate($module['setype'], $module['setype'])}</p>
                    <p class="card-price">{$module['c']}</p>
                </a>
            {/foreach}
            {else}
                {vtranslate('No new records to view', 'ParsVT')}
            {/if}
        </div>
    </div>
    {if $content}
</div>
<div class="widgeticons dashBoardWidgetFooter">
    <div class="filterContainer" >
        <div class="row">
            <div class="col-sm-12" style="align-items: center; justify-content: space-evenly; display: flex;">
                <span class="col-lg-4">
                        <span>
                            <strong>{vtranslate('Hidden Modules', $MODULE_NAME)}</strong>
                        </span>
                </span>
                <span class="col-lg-7">
                    <select class="select2 col-sm-12  " multiple id="Cartable_restricted" multiple="true" name="restricted_module">
                         {foreach item=MODULE from=$ALL_MODULES}
                             <option value="{$MODULE}" {if in_array($MODULE,$SETTING_EXIST) }selected=""{/if}>{vtranslate($MODULE, $MODULE)}</option>
                         {/foreach}
                    </select>
                </span>
            </div>
        </div>
    </div>
    <div class="footerIcons pull-right">
        {include file="dashboards/DashboardFooterIcons.tpl"|@vtemplate_path:$MODULE_NAME SETTING_EXIST=true}
    </div>
</div>
{/if}
{if $content}
{literal}
    <script type="text/javascript">
        $(document).ready(function () {
            var parent = $(".dashboardWidgetContent");
            var contentContainer = $(".cartable-container");
            contentContainer.mCustomScrollbar('destroy');
            app.helper.showVerticalScroll(contentContainer,{ });
            contentContainer.height(function (index, height) {
                return (height -20);
            });
            $(document).on("change", "#Cartable_restricted", function () {
                let el = $(this);
                let val = $('#Cartable_restricted').val();
                let params = {};
                params['module'] = 'ParsVT';
                params['action'] = 'Misc';
                params['mode'] = 'saveCartableRestrictedModules';
                params['data'] = val;

                app.request.post({'data': params}).then(
                    function (err, data) {
                        app.helper.showSuccessNotification({message: app.vtranslate('Saved!')});
                        el.parents(".dashboardWidget").find('a[name="drefresh"]').trigger("click");
                    });
            });
        });
        Vtiger_Barchat_Widget_Js('Vtiger_Cartable_Widget_Js', {}, {});
    </script>
{/literal}
{/if}
