(function (a) {
    a.Chart.prototype.createCanvas = function () {
        var c = this.getSVG(), e = parseInt(c.match(/width="([0-9]+)"/)[1]),
            b = parseInt(c.match(/height="([0-9]+)"/)[1]), d = document.createElement("canvas");
        d.setAttribute("width", e);
        d.setAttribute("height", b);
        if (d.getContext && d.getContext("2d")) {
            canvg(d, c);
            var f = d.toDataURL("image/png");
            return f;
        } else {
            alert("Your browser doesn't support this feature, please use a modern browser");
            return false;
        }
    };
}(Highcharts));
(function (b) {
    var a = {colors: ["#7cb5ec", "#434348", "#90ed7d", "#f7a35c", "#8085e9", "#f15c80", "#e4d354", "#8d4653", "#91e8e1", "#ED1B42", "#69BD44", "#6A2D91", "#42525D", "#C88B11", "#0A7CDA", "#990099", "#990033", "#8C5B43", "#FF9900", "#00509D", "#FF0099", "#081833", "#559E83", "#FF6666", "#712D8E", "#DB4900", "#4C1647", "#547701", "#242E8F", "#574D29", "#C3CB71", "#CC0000", "#004833", "#008752", "#5A5255", "#F15B21", "#1B85B8", "#72243C", "#EC4699", "#999900", "#F7BC19"]};
    b.setOptions(a);
    b.setOptions({lang: {decimalPoint: app.getDecimalSeparator(), thousandsSep: app.getGroupingSeparator()}});
}(Highcharts));
var parsvtHighChart = {
    isExtendedMethodRequired: function () {
        var protocol = window.location.protocol.toLowerCase();
        var hostname = window.location.hostname;
        if (/^(25[0-5]|2[0-4][0-9]|[1]?[1-9][1-9]?)\.(25[0-5]|2[0-4][0-9]|[1]?[1-9][1-9]?)\.(25[0-5]|2[0-4][0-9]|[1]?[1-9][1-9]?)\.(25[0-5]|2[0-4][0-9]|[1]?[1-9][1-9]?)$/.test(hostname)) {
          return true;
        } else {
            if (protocol == 'https') {
                return false;
            } else {
                return true;
            }
        }
    },
    downloadHighcharts: function(exportingOptions, svg) {
        var url = 'layouts/v7/modules/ParsVT/libraries/exportHighCharts.php';
        var highchartForm = document.createElement("form");
        highchartForm.target = "DownloadHighChart";
        highchartForm.method = "POST"; // or "post" if appropriate
        highchartForm.action = url;

        var mapInput = document.createElement("input");
        mapInput.type = "hidden";
        mapInput.name = "filename";
        mapInput.value = exportingOptions.filename || 'chart';
        highchartForm.appendChild(mapInput);
        mapInput = document.createElement("input");
        mapInput.type = "hidden";
        mapInput.name = "type";
        mapInput.value = exportingOptions.type;
        highchartForm.appendChild(mapInput);
        mapInput = document.createElement("input");
        mapInput.type = "hidden";
        mapInput.name = "width";
        mapInput.value = exportingOptions.width || 0;
        highchartForm.appendChild(mapInput);
        mapInput = document.createElement("input");
        mapInput.type = "hidden";
        mapInput.name = "scale";
        mapInput.value = exportingOptions.scale;
        highchartForm.appendChild(mapInput);
        mapInput = document.createElement("input");
        mapInput.type = "hidden";
        mapInput.name = "svg";
        mapInput.value = svg;
        highchartForm.appendChild(mapInput);
        mapInput = document.createElement("input");
        mapInput.type = "hidden";
        mapInput.name = "b64";
        mapInput.value = true;
        highchartForm.appendChild(mapInput);
        document.body.appendChild(highchartForm);
        DownloadHighChart = window.open("", "DownloadHighChart", "status=0,title=0,height=200,width=400,scrollbars=1");
        if (DownloadHighChart) {
            highchartForm.submit();
            setTimeout(function () {
                DownloadHighChart.close();
                }, 8000);
        } else {
            app.helper.showErrorNotification({
                message: 'You must allow popups for this map to work.'
            });
        }
    },
    convertCurrencyToUserFormat: function(value, appendCurrencySymbol) {
            if (value.toString() !== value.toString().replace(/\D/g,'')) return value;
            var displayValue;
      		var isNegative = false;
            if (!((value % 1) === 0)) {
                displayValue = Highcharts.numberFormat(value, app.getNumberOfDecimals(), app.getDecimalSeparator(), app.getGroupingSeparator());
            } else {
                displayValue = Highcharts.numberFormat(value, "", "", app.getGroupingSeparator());
            }

            if (isNegative) {
                displayValue = '-' + displayValue.toString();
            }

       		if(appendCurrencySymbol) {
       			displayValue = app.appendUserCurrencySymbol(displayValue);
       		}

       		return displayValue;
       	}
}
var vtHighChartInterface = function () {
    this.helper = new function () {
        this.getLabelSteps = function (e, b) {
            var c = 1;
            var d = e.length;
            if (d > 20) {
                var a = b.data("mode") === "preview" ? 25 : 10;
                c = Math.round(d / a);
            }
            return c;
        };
    };

    this.getDisplayValue = function (b, a) {
        var c = this.element.closest("div.dashboardWidgetContent").find(".yAxisFieldType").val();
        if (c === "currency" || a === "currency" || c === "multicurrency" || a === "multicurrency") {
            return parsvtHighChart.convertCurrencyToUserFormat(b, true);
        }
        return b;
    };
    this.renderPie = function () {
        var b = this;
        //var a = this.element.closest(".dashboardWidgetContent").data("displaymode") === "fullscreen";
        var a = true;
        //var c = jQuery('input[name="isPrintPermitted"]').val();
        var c = true;
        var d = {
            chart: {
                type: "pie",
                zoomType: "xy",
                options3d: {enabled: false, alpha: 45, beta: 0},
                backgroundColor: "white",
                events: {
                    load: function (h) {
                        var g = 0;
                        for (var f = 0, e = this.series[0].yData.length;
                             f < e;
                             f++) {
                            g += this.series[0].yData[f];
                        }
                        if (b.element.closest("div.dashboardWidgetContent").find(".yAxisFieldType").val() != "currency" && b.element.closest("div.dashboardWidgetContent").find(".yAxisFieldType").val() != "multicurrency") {
                            if (!((g % 1) === 0)) {
                                g = Highcharts.numberFormat(g, app.getNumberOfDecimals(), app.getDecimalSeparator(), app.getGroupingSeparator());
                            } else {
                                g = Highcharts.numberFormat(g, "", "", app.getGroupingSeparator());
                            }
                        } else {
                            g = b.getDisplayValue(g);
                        }
                        this.renderer.text(app.vtranslate("JS_TOTAL_RECORDS") + " : " + g, this.plotLeft, this.plotTop + 5).attr({
                            zIndex: 5,
                            style: "font-size:12px;font-weight:bold;"
                        }).add();
                    }
                }
            },
            credits: {enabled: false},
            title: {text: null},
            tooltip: {
                useHTML: true, formatter: function () {
                    var h = this.y, g = this.total, f = this.percentage;
                    if (b.element.closest("div.dashboardWidgetContent").find(".yAxisFieldType").val() != "currency" && b.element.closest("div.dashboardWidgetContent").find(".yAxisFieldType").val() != "multicurrency") {
                        if (!((h % 1) === 0)) {
                            h = Highcharts.numberFormat(h, app.getNumberOfDecimals(), app.getDecimalSeparator(), app.getGroupingSeparator());
                        } else {
                            h = Highcharts.numberFormat(h, "", "", app.getGroupingSeparator());
                        }
                        if (!((g % 1) === 0)) {
                            g = Highcharts.numberFormat(g, app.getNumberOfDecimals(), app.getDecimalSeparator(), app.getGroupingSeparator());
                        } else {
                            g = Highcharts.numberFormat(g, "", "", app.getGroupingSeparator());
                        }
                        if (!((f % 1) === 0)) {
                            f = Highcharts.numberFormat(f, app.getNumberOfDecimals(), app.getDecimalSeparator(), app.getGroupingSeparator());
                        } else {
                            f = Highcharts.numberFormat(f, "", "", app.getGroupingSeparator());
                        }
                    }
                    var e = this.key;
                    if (typeof this.key == "undefined") {
                        e = "Unavailable";
                    }
                    if (jQuery('body').data('language').substring(0, 2) == 'fa' || jQuery('body').data('language').substring(0, 2) == 'ar') {
                        return '<span style="font-size:12px">' + e + "</span><br><span style='font-weight: bold; direction: rtl;'>" + f + "% = " +  b.getDisplayValue(h) + "/" + b.getDisplayValue(g) + "</span>";
                    } else {
                        return '<span style="font-size:12px">' + e + "</span><br><span style='font-weight: bold;'>" + b.getDisplayValue(h) + "/" + b.getDisplayValue(g) + " = " + f + "%</span>";
                    }
                }, backgroundColor: "rgba(255,255,255,1)"
            },
            colors: this.data["colors"] && this.data["colors"].length ? this.data["colors"] : Highcharts.defaultOptions.colors,
            plotOptions: {
                pie: {
                    allowPointSelect: true,
                    cursor: "pointer",
                    depth: 35,
                    dataLabels: {enabled: a, connectorPadding: 0},
                    showInLegend: true
                }, series: {
                    dataLabels: {
                        enabled: true, formatter: function () {
                            return "<b>" + Math.round(this.percentage * 100) / 100 + " %</b>";
                        }
                    }, cursor: "pointer", point: {events: {}}
                }
            },
            series: [{type: "pie", name: this.data["title"], data: this.data["chartData"]}],
            legend: {
                verticalAlign: "bottom", y: 10, labelFormatter: function () {
                    var h = this.y, g = this.total, f = this.percentage;
                    if (!((h % 1) === 0)) {
                        h = Highcharts.numberFormat(h, app.getNumberOfDecimals(), app.getDecimalSeparator(), app.getGroupingSeparator());
                    } else {
                        h = Highcharts.numberFormat(h, "", "", app.getGroupingSeparator());
                    }
                    if (!((g % 1) === 0)) {
                        g = Highcharts.numberFormat(g, app.getNumberOfDecimals(), app.getDecimalSeparator(), app.getGroupingSeparator());
                    } else {
                        g = Highcharts.numberFormat(g, "", "", app.getGroupingSeparator());
                    }
                    if (!((f % 1) === 0)) {
                        f = Highcharts.numberFormat(f, app.getNumberOfDecimals(), app.getDecimalSeparator(), app.getGroupingSeparator());
                    } else {
                        f = Highcharts.numberFormat(f, "", "", app.getGroupingSeparator());
                    }
                    var e = this.name;
                    if (e.trim() == "") {
                        e = "Unavailable";
                    }
                    return '<span title="' + b.getDisplayValue(h) + "/" + b.getDisplayValue(g) + " = " + b.getDisplayValue(f) + '%">' + e + "</span>";
                }, useHTML: true
            },
            exporting: {
                buttons: {
                    contextButton: {
                        menuItems: [
                            {
                                textKey: 'viewFullscreen',
                                text: app.vtranslate("View in full screen"),
                                onclick: function () {
                                    if (this.fullscreen) {
                                        this.fullscreen.toggle();
                                    }
                                }
                            },
                            {
                                textKey: 'printChart',
                                text: app.vtranslate("JS_PRINT"),
                                onclick: function () {
                                    this.print();
                                }
                            },

                            {
                                textKey: 'downloadPNG',
                                text: app.vtranslate("JS_SAVE_AS_IMAGE"),
                                onclick: function () {
                                    if (parsvtHighChart.isExtendedMethodRequired()) {
                                        var svg = this.getSVGForExport();
                                        var exportingOptions = {};
                                        exportingOptions = Object.assign({}, this.options.exporting, exportingOptions);
                                        parsvtHighChart.downloadHighcharts(exportingOptions, svg);
                                    } else {
                                        this.exportChart();
                                    }
                                }
                            },
                            {
                                textKey: 'downloadPDF',
                                text: app.vtranslate("Download PDF document"),
                                onclick: function () {
                                    if (parsvtHighChart.isExtendedMethodRequired()) {
                                        var svg = this.getSVGForExport();
                                        var exportingOptions = {type: 'application/pdf'};
                                        exportingOptions = Object.assign({}, this.options.exporting, exportingOptions);
                                        parsvtHighChart.downloadHighcharts(exportingOptions, svg);
                                    } else {
                                        this.exportChart({
                                            type: 'application/pdf'
                                        });
                                    }
                                }
                            }
                        ]
                    }
                }
            }
        };
        if (!c) {
            d.exporting = function () {
                return false;
            };
        }
        if (this.options.links) {
            d.series[0].url = this.options.links;
            d.plotOptions.series.point.events.click = function () {
                var e = this.series.userOptions.url[this.x];
                if (e) {
                    b.triggerClick({"url": e});
                }
            };
        }
        if (this.options.options3d === false) {
            d.chart.options3d.enabled = false;
        }
        jQuery.extend(true, d, this.options.customChartOptions);
        this.element.highcharts(d);
    };
    this.renderFunnel = function () {
        var g = this;
        //var a = this.element.closest(".dashboardWidgetContent").data("displaymode") === "fullscreen";
        var a = true;
        var f = JSON.parse(this.data);
        var b = [];
        var d = [];
        for (var e = 0;
             e < f.length;
             e++) {
            var c = {"name": f[e][0], "y": parseFloat(f[e][1])};
            if (typeof f[e]["color"] != "undefined") {
                c["color"] = f[e]["color"];
            }
            b.push(c);
            d[f[e][0]] = (f[e][3]);
        }
        var h = {
            chart: {type: "funnel", marginRight: 8, backgroundColor: "white"},
            credits: {enabled: false},
            title: {text: null, x: -50},
            tooltip: {
                headerFormat: '<span style="font-size:12px">{point.key}</span><table>',
                pointFormat: '<tr><td style="color:{series.color};padding:0;padding:0;"><b>{point.y}</b></td></tr>',
                footerFormat: "</table>",
                shared: false,
                useHTML: true,
                backgroundColor: "rgba(255,255,255,1)"
            },
            plotOptions: {
                series: {
                    dataLabels: {
                        enabled: true,
                        format: "<b>{point.name}</b> ({point.y})",
                        color: (Highcharts.theme && Highcharts.theme.contrastTextColor) || "black",
                        softConnector: true
                    },
                    neckWidth: "30%",
                    neckHeight: "25%",
                    events: {},
                    cursor: "pointer",
                    width: "80%",
                    center: ["40%", "50%"]
                }
            },
            legend: {enabled: true, verticalAlign: "bottom", y: 10},
            series: [{data: b, url: d}],
            exporting: {
                buttons: {
                    contextButton: {
                        menuItems: [
                            {
                                textKey: 'viewFullscreen',
                                text: app.vtranslate("View in full screen"),
                                onclick: function () {
                                    if (this.fullscreen) {
                                        this.fullscreen.toggle();
                                    }
                                }
                            },
                            {
                                textKey: 'printChart',
                                text: app.vtranslate("JS_PRINT"),
                                onclick: function () {
                                    this.print();
                                }
                            },

                            {
                                textKey: 'downloadPNG',
                                text: app.vtranslate("JS_SAVE_AS_IMAGE"),
                                onclick: function () {
                                    if (parsvtHighChart.isExtendedMethodRequired()) {
                                        var svg = this.getSVGForExport();
                                        var exportingOptions = {};
                                        exportingOptions = Object.assign({}, this.options.exporting, exportingOptions);
                                        parsvtHighChart.downloadHighcharts(exportingOptions, svg);
                                    } else {
                                        this.exportChart();
                                    }
                                }
                            },
                            {
                                textKey: 'downloadPDF',
                                text: app.vtranslate("Download PDF document"),
                                onclick: function () {
                                    if (parsvtHighChart.isExtendedMethodRequired()) {
                                        var svg = this.getSVGForExport();
                                        var exportingOptions = {type: 'application/pdf'};
                                        exportingOptions = Object.assign({}, this.options.exporting, exportingOptions);
                                        parsvtHighChart.downloadHighcharts(exportingOptions, svg);
                                    } else {
                                        this.exportChart({
                                            type: 'application/pdf'
                                        });
                                    }
                                }
                            }
                        ]
                    }
                }
            }
        };
        if (d) {
            h.plotOptions.series.events.click = function (i) {
                var j = this.chart.series[0].options.url[i.point.name];
                if (j) {
                    g.triggerClick({"url": j});
                }
            };
        }
        this.element.highcharts(h);
    };
    this.renderMultibar = function () {
        var g = this;
        //var f = this.element.closest(".dashboardWidgetContent").data("displaymode") === "fullscreen";
        var f = true;
        var c = this.data.data;
        var h = this.data.ticks;
        var e = this.data.labels;
        var j = this.data.links;
        var a = [];
        for (var d = 0;
             d < e.length;
             d++) {
            var k = {name: e[d], data: c[d]};
            k.url = j[d];
            a.push(k);
        }
        var b = {
            chart: {
                type: "column",
                zoomType: "xy",
                backgroundColor: "white",
                resetZoomButton: {position: {x: -10, y: 10}, relativeTo: "chart"}
            },
            credits: {enabled: false},
            title: {text: null},
            xAxis: {useHTML: true, categories: h},
            yAxis: {
                min: 0, stackLabels: {
                    enabled: f, formatter: function () {
                        var i = this.total;
                        if (!((i % 1) == 0)) {
                            i = Highcharts.numberFormat(i, app.getNumberOfDecimals(), app.getDecimalSeparator(), app.getGroupingSeparator());
                        } else {
                            i = Highcharts.numberFormat(i, "", "", app.getGroupingSeparator());
                        }
                        return g.getDisplayValue(i);
                    }, style: {color: "black"}
                }, labels: {
                    useHTML: true, formatter: function () {
                        return g.getDisplayValue(this.value);
                    }
                }, title: {text: null}
            },
            tooltip: {
                useHTML: true, formatter: function () {
                    var l = this.y;
                    var i = this.point.stackTotal;
                    if (g.element.closest("div.dashboardWidgetContent").find(".yAxisFieldType").val() != "currency" && g.element.closest("div.dashboardWidgetContent").find(".yAxisFieldType").val() != "multicurrency") {
                        if (!((l % 1) == 0)) {
                            l = Highcharts.numberFormat(l, app.getNumberOfDecimals(), app.getDecimalSeparator(), app.getGroupingSeparator());
                        } else {
                            l = Highcharts.numberFormat(l, "", "", app.getGroupingSeparator());
                        }
                        if (!((i % 1) == 0)) {
                            i = Highcharts.numberFormat(i, app.getNumberOfDecimals(), app.getDecimalSeparator(), app.getGroupingSeparator());
                        } else {
                            i = Highcharts.numberFormat(i, "", "", app.getGroupingSeparator());
                        }
                    }
                    return "<b>" + this.x + "</b><br/>" + this.series.name + ": " + g.getDisplayValue(l) + "<br/>" + app.vtranslate("JS_TOTAL_RECORDS") + ": " + g.getDisplayValue(i);
                }, backgroundColor: "rgba(255,255,255,1)"
            },
            colors: this.data["colors"] && this.data["colors"].length ? this.data["colors"] : Highcharts.defaultOptions.colors,
            plotOptions: {
                column: {
                    stacking: "normal", dataLabels: {
                        enabled: false,
                        color: (Highcharts.theme && Highcharts.theme.dataLabelsColor) || "white",
                        style: {textShadow: "0 0 3px black, 0 0 3px black"},
                        formatter: function () {
                            var i = this.y;
                            if (i <= 0) {
                                return "";
                            }
                            if (!((i % 1) == 0)) {
                                i = Highcharts.numberFormat(i, app.getNumberOfDecimals(), app.getDecimalSeparator(), app.getGroupingSeparator());
                            } else {
                                i = Highcharts.numberFormat(i, "", "", app.getGroupingSeparator());
                            }
                            return g.getDisplayValue(i);
                        },
                        crop: false,
                        overflow: "none"
                    }
                }, series: {cursor: "pointer", events: {}}
            },
            series: a,
            legend: {useHTML: true, verticalAlign: "bottom", y: 10},
            exporting: {
                buttons: {
                    contextButton: {
                        menuItems: [
                            {
                                textKey: 'viewFullscreen',
                                text: app.vtranslate("View in full screen"),
                                onclick: function () {
                                    if (this.fullscreen) {
                                        this.fullscreen.toggle();
                                    }
                                }
                            },
                            {
                                textKey: 'printChart',
                                text: app.vtranslate("JS_PRINT"),
                                onclick: function () {
                                    this.print();
                                }
                            },

                            {
                                textKey: 'downloadPNG',
                                text: app.vtranslate("JS_SAVE_AS_IMAGE"),
                                onclick: function () {
                                    if (parsvtHighChart.isExtendedMethodRequired()) {
                                        var svg = this.getSVGForExport();
                                        var exportingOptions = {};
                                        exportingOptions = Object.assign({}, this.options.exporting, exportingOptions);
                                        parsvtHighChart.downloadHighcharts(exportingOptions, svg);
                                    } else {
                                        this.exportChart();
                                    }
                                }
                            },
                            {
                                textKey: 'downloadPDF',
                                text: app.vtranslate("Download PDF document"),
                                onclick: function () {
                                    if (parsvtHighChart.isExtendedMethodRequired()) {
                                        var svg = this.getSVGForExport();
                                        var exportingOptions = {type: 'application/pdf'};
                                        exportingOptions = Object.assign({}, this.options.exporting, exportingOptions);
                                        parsvtHighChart.downloadHighcharts(exportingOptions, svg);
                                    } else {
                                        this.exportChart({
                                            type: 'application/pdf'
                                        });
                                    }
                                }
                            }
                        ]
                    }
                }
            },
            navigation: {buttonOptions: {verticalAlign: "top", y: -14, x: 10}}
        };
        b.plotOptions.series.events.click = function (i) {
            var l = this.options.url[i.point.x];
            if (l) {
                g.triggerClick({"url": l});
            }
        };
        if (this.options.hasOwnProperty("customChartOptions")) {
            jQuery.extend(true, b, this.options.customChartOptions);
        }
        this.element.highcharts(b);
    };
    this.renderHorizontalbar = function () {
        var k = this;
        //var h = this.element.closest(".dashboardWidgetContent").data("displaymode") === "fullscreen";
        var h = true;
        var g = null;
        if (this.data["labels"].length > 100) {
            g = Math.ceil(this.data["labels"].length / 10);
        }
        var c = {
            chart: {
                type: "bar",
                zoomType: "xy",
                backgroundColor: "white",
                resetZoomButton: {position: {x: -10, y: 10}, relativeTo: "chart"}
            },
            credits: {enabled: false},
            title: {text: null},
            xAxis: {
                tickInterval: g, categories: this.data["labels"], title: {text: null}, labels: {
                    rotation: -20,
                    overflow: "justify",
                    useHTML: true,
                    step: this.helper.getLabelSteps(this.data["labels"], this.element),
                    formatter: function () {
                        var j = this.value, i = j.length > 30 ? j.substring(0, 29) + ".." : j;
                        if (i == "") {
                            i = "Unavailable";
                        }
                        return i;
                    }
                }
            },
            yAxis: {
                min: 0, title: {text: null, align: "high"}, labels: {
                    overflow: "justify", useHTML: true, formatter: function () {
                        return k.getDisplayValue(this.value);
                    }
                }
            },
            tooltip: {
                formatter: function () {
                    var m = this.y;
                    if (k.element.closest("div.dashboardWidgetContent").find(".yAxisFieldType").val() != "currency" && k.element.closest("div.dashboardWidgetContent").find(".yAxisFieldType").val() != "multicurrency") {
                        if (!((m % 1) === 0)) {
                            m = Highcharts.numberFormat(this.y, app.getNumberOfDecimals(), app.getDecimalSeparator(), app.getGroupingSeparator());
                        } else {
                            m = Highcharts.numberFormat(this.y, "", "", app.getGroupingSeparator());
                        }
                    }
                    var j = this.x;
                    if (this.x == "") {
                        j = "Unavailable";
                    }
                    var i = "";
                    if (k.data && k.data.data_labels) {
                        if (k.data.data_labels.length > 1) {
                            if (this.series.name) {
                                i = this.series.name;
                            }
                        } else {
                            i = k.data.data_labels[0];
                        }
                    }
                    return '<span style="font-size:12px">' + j + '</span><br><span style="font-size:12px">' + i + "</span><table>" + '<tr><td style="color:{series.color};padding:0;padding:0;"><b>' + k.getDisplayValue(m) + "</b></td></tr></table>";
                }, shared: false, useHTML: true, backgroundColor: "rgba(255,255,255,1)"
            },
            colors: this.data["colors"] && this.data["colors"].length ? this.data["colors"] : Highcharts.defaultOptions.colors,
            plotOptions: {
                bar: {
                    dataLabels: {
                        enabled: h, formatter: function () {
                            var i = this.y;
                            if (!((i % 1) === 0)) {
                                i = Highcharts.numberFormat(i, app.getNumberOfDecimals(), app.getDecimalSeparator(), app.getGroupingSeparator());
                            } else {
                                i = Highcharts.numberFormat(i, "", "", app.getGroupingSeparator());
                            }
                            return k.getDisplayValue(i, this.series.userOptions.data_type);
                        }
                    }
                }, series: {
                    dataLabels: {
                        enabled: true, formatter: function () {
                            var j = this.y;
                            if (!((j % 1) === 0)) {
                                j = Highcharts.numberFormat(this.y, app.getNumberOfDecimals(), app.getDecimalSeparator(), app.getGroupingSeparator());
                            } else {
                                j = Highcharts.numberFormat(this.y, "", "", app.getGroupingSeparator());
                            }
                            var i;
                            if (k.element.closest("div.dashboardWidgetContent").find(".yAxisFieldType").val() === "currency" || k.element.closest("div.dashboardWidgetContent").find(".yAxisFieldType").val() === "multicurrency") {
                                i = k.getDisplayValue(this.y, true);
                            } else {
                                i = k.getDisplayValue(j);
                            }
                            return "<b>" + i + "</b>";
                        }, style: {fontSize: "12px"}
                    }, cursor: "pointer", events: {}, colorByPoint: true
                }
            },
            series: [],
            legend: {verticalAlign: "bottom", y: 10},
            exporting: {
                buttons: {
                    contextButton: {
                        menuItems: [
                            {
                                textKey: 'viewFullscreen',
                                text: app.vtranslate("View in full screen"),
                                onclick: function () {
                                    if (this.fullscreen) {
                                        this.fullscreen.toggle();
                                    }
                                }
                            },
                            {
                                textKey: 'printChart',
                                text: app.vtranslate("JS_PRINT"),
                                onclick: function () {
                                    this.print();
                                }
                            },

                            {
                                textKey: 'downloadPNG',
                                text: app.vtranslate("JS_SAVE_AS_IMAGE"),
                                onclick: function () {
                                    if (parsvtHighChart.isExtendedMethodRequired()) {
                                        var svg = this.getSVGForExport();
                                        var exportingOptions = {};
                                        exportingOptions = Object.assign({}, this.options.exporting, exportingOptions);
                                        parsvtHighChart.downloadHighcharts(exportingOptions, svg);
                                    } else {
                                        this.exportChart();
                                    }
                                }
                            },
                            {
                                textKey: 'downloadPDF',
                                text: app.vtranslate("Download PDF document"),
                                onclick: function () {
                                    if (parsvtHighChart.isExtendedMethodRequired()) {
                                        var svg = this.getSVGForExport();
                                        var exportingOptions = {type: 'application/pdf'};
                                        exportingOptions = Object.assign({}, this.options.exporting, exportingOptions);
                                        parsvtHighChart.downloadHighcharts(exportingOptions, svg);
                                    } else {
                                        this.exportChart({
                                            type: 'application/pdf'
                                        });
                                    }
                                }
                            }
                        ]
                    }
                }
            },
            navigation: {buttonOptions: {verticalAlign: "top", y: -14, x: 10}}
        };
        var d = this.data["chartData"];
        var e = [];
        for (var f = 0;
             f < d.length;
             f++) {
            var l = [];
            for (var b = 0;
                 b < d[f].length;
                 b++) {
                l.push(parseFloat(d[f][b][0]));
            }
            var a = {};
            a.name = this.data.data_labels[f];
            a.data = l;
            a.data_type = this.data.data_type[f], e.push(a);
        }
        c.series = e;
        if (this.options.links) {
            c.plotOptions.series.events.click = function (i) {
                var j = k.options.links[i.point.x];
                if (j) {
                    k.triggerClick({"url": j});
                }
            };
        }
        if (this.options.hasOwnProperty("customChartOptions")) {
            jQuery.extend(true, c, this.options.customChartOptions);
        }
        this.element.highcharts(c);
    };
    this.renderLine = function () {
        var d = this;
        var f = {
            chart: {
                type: "line",
                zoomType: "xy",
                options3d: {enabled: false},
                backgroundColor: "white",
                resetZoomButton: {position: {x: -10, y: 10}, relativeTo: "chart"}
            },
            credits: {enabled: false},
            title: {text: this.data["graph_label"], x: -20},
            xAxis: {
                categories: this.data["labels"], labels: {
                    useHTML: true,
                    rotation: -45,
                    step: this.helper.getLabelSteps(this.data["labels"], this.element),
                    formatter: function () {
                        var h = this.value, g = h.length > 30 ? h.substring(0, 29) + ".." : h;
                        if (g == "") {
                            g = "Unavailable";
                        }
                        return g;
                    }
                }
            },
            yAxis: {
                title: {text: null}, labels: {
                    useHTML: true, formatter: function () {
                        return d.getDisplayValue(this.value);
                    }
                }, plotLines: [{value: 0, width: 1, color: "#808080"}]
            },
            tooltip: {
                formatter: function () {
                    var i = this.y;
                    if (d.element.closest("div.dashboardWidgetContent").find(".yAxisFieldType").val() != "currency" && d.element.closest("div.dashboardWidgetContent").find(".yAxisFieldType").val() != "multicurrency") {
                        if (!((i % 1) === 0)) {
                            i = Highcharts.numberFormat(this.y, app.getNumberOfDecimals(), app.getDecimalSeparator(), app.getGroupingSeparator());
                        } else {
                            i = Highcharts.numberFormat(this.y, "", "", app.getGroupingSeparator());
                        }
                    }
                    var h = this.x;
                    if (this.x == "") {
                        h = "Unavailable";
                    }
                    var g = "";
                    if (d.data && d.data.data_labels) {
                        if (d.data.data_labels.length > 1) {
                            if (this.series.name) {
                                g = this.series.name;
                            }
                        } else {
                            g = d.data.data_labels[0];
                        }
                    }
                    return '<span style="font-size:12px">' + h + '</span><br><span style="font-size:12px">' + g + "</span><table>" + '<tr><td style="color:{series.color};padding:0;padding:0;"><b>' + d.getDisplayValue(i) + "</b></td></tr></table>";
                }, shared: false, useHTML: true, backgroundColor: "rgba(255,255,255,1)"
            },
            legend: {verticalAlign: "bottom", y: 10},
            plotOptions: {series: {cursor: "pointer", events: {}}},
            series: [],
            exporting: {
                buttons: {
                    contextButton: {
                        menuItems: [
                            {
                                textKey: 'viewFullscreen',
                                text: app.vtranslate("View in full screen"),
                                onclick: function () {
                                    if (this.fullscreen) {
                                        this.fullscreen.toggle();
                                    }
                                }
                            },
                            {
                                textKey: 'printChart',
                                text: app.vtranslate("JS_PRINT"),
                                onclick: function () {
                                    this.print();
                                }
                            },

                            {
                                textKey: 'downloadPNG',
                                text: app.vtranslate("JS_SAVE_AS_IMAGE"),
                                onclick: function () {
                                    if (parsvtHighChart.isExtendedMethodRequired()) {
                                        var svg = this.getSVGForExport();
                                        var exportingOptions = {};
                                        exportingOptions = Object.assign({}, this.options.exporting, exportingOptions);
                                        parsvtHighChart.downloadHighcharts(exportingOptions, svg);
                                    } else {
                                        this.exportChart();
                                    }
                                }
                            },
                            {
                                textKey: 'downloadPDF',
                                text: app.vtranslate("Download PDF document"),
                                onclick: function () {
                                    if (parsvtHighChart.isExtendedMethodRequired()) {
                                        var svg = this.getSVGForExport();
                                        var exportingOptions = {type: 'application/pdf'};
                                        exportingOptions = Object.assign({}, this.options.exporting, exportingOptions);
                                        parsvtHighChart.downloadHighcharts(exportingOptions, svg);
                                    } else {
                                        this.exportChart({
                                            type: 'application/pdf'
                                        });
                                    }
                                }
                            }
                        ]
                    }
                }
            },
            navigation: {buttonOptions: {verticalAlign: "top", y: -14, x: 10}}
        };
        var b = [];
        var e = this.data.chartData;
        for (var a = 0;
             a < e.length;
             a++) {
            var c = {};
            c.name = this.data.data_labels[a];
            c.data = e[a];
            c.data_type = this.data.data_type[a], b.push(c);
        }
        f.series = b;
        if (this.options.links) {
            f.plotOptions.series.events.click = function (g) {
                var h = d.options.links[g.point.x];
                if (h) {
                    d.triggerClick({"url": h});
                }
            };
        }
        if (this.options.customChartOptions) {
            jQuery.extend(f, this.options.customChartOptions);
        }
        this.element.highcharts(f);
    };
    this.renderbar = function () {
        var f = this;
        var a;

        if (
            app.getModuleName() == 'Home' &&
            (
                f.element.closest("div.dashboardWidgetContent").find(".yAxisFieldType").val() === "currency" ||
                f.element.closest("div.dashboardWidgetContent").find(".yAxisFieldType").val() === "multicurrency"
            ) &&
            this.data["labels"].length > 5 ||
            this.element.closest(".dashboardWidgetContent").width() < 400
        ) {
            a = this.element.closest("div.dashboardWidgetContent").data("displaymode") === "fullscreen";
        } else {
            a = true;
        }

        var e = null;
        if (this.data["labels"].length > 100) {
            e = Math.ceil(this.data["labels"].length / 10);
        }

        var g = {
            chart: {
                type: "column",
                zoomType: "xy",
                margin: 75,
                options3d: { enabled: false, viewDistance: 15, alpha: 8, beta: 8, depth: 70 },
                backgroundColor: "white",
                resetZoomButton: { position: { x: -10, y: 10 }, relativeTo: "chart" }
            },
            credits: { enabled: false },
            title: { text: null },
            xAxis: {
                tickInterval: e,
                categories: this.data["labels"],
                labels: {
                    rotation: -30,
                    step: this.helper.getLabelSteps(this.data["labels"], this.element),
                    useHTML: true,
                    formatter: function () {
                        var i = this.value, h = i.length > 30 ? i.substring(0, 29) + ".." : i;
                        return h === "" ? "Unavailable" : h;
                    }
                }
            },
            yAxis: {
                min: 0,
                max: this.data["yMaxValue"],
                maxPadding: 0.1,
                labels: {
                    useHTML: true,
                    formatter: function () {
                        if (
                            f.element.closest("div.dashboardWidgetContent").find(".yAxisFieldType").val() === "currency" ||
                            f.element.closest("div.dashboardWidgetContent").find(".yAxisFieldType").val() === "multicurrency"
                        ) {
                            return parsvtHighChart.convertCurrencyToUserFormat(this.value, true);
                        }
                        return f.getDisplayValue(this.value);
                    }
                },
                title: { text: null }
            },
            tooltip: {
                formatter: function () {
                    var k = this.y;
                    k = (k % 1 === 0)
                        ? Highcharts.numberFormat(this.y, "", "", app.getGroupingSeparator())
                        : Highcharts.numberFormat(this.y, app.getNumberOfDecimals(), app.getDecimalSeparator(), app.getGroupingSeparator());

                    var j = (f.element.closest("div.dashboardWidgetContent").find(".yAxisFieldType").val() === "currency" ||
                        f.element.closest("div.dashboardWidgetContent").find(".yAxisFieldType").val() === "multicurrency")
                        ? f.getDisplayValue(this.y, true)
                        : f.getDisplayValue(k);

                    var i = this.x === "" ? "Unavailable" : this.x;
                    var h = "";

                    if (f.data && f.data.data_labels) {
                        h = (f.data.data_labels.length > 1 && this.series.name) ? this.series.name : f.data.data_labels[0];
                    }

                    return '<span style="font-size:12px">' + i + '</span><br><span style="font-size:12px">' + h + "</span><table>" +
                        '<tr><td style="color:{series.color};padding:0;"><b>' + j + "</b></td></tr></table>";
                },
                shared: false,
                useHTML: true,
                backgroundColor: "rgba(255,255,255,1)"
            },
            colors: this.data["colors"] && this.data["colors"].length ? this.data["colors"] : Highcharts.defaultOptions.colors,
            plotOptions: {
                column: {
                    pointPadding: 0.2,
                    borderWidth: 0,
                    depth: 25,
                    dataLabels: {
                        enabled: a,
                        crop: false,
                        overflow: "none",
                        formatter: function () {
                            var h = this.y;
                            h = (h % 1 === 0)
                                ? Highcharts.numberFormat(h, "", "", app.getGroupingSeparator())
                                : Highcharts.numberFormat(h, app.getNumberOfDecimals(), app.getDecimalSeparator(), app.getGroupingSeparator());
                            return f.getDisplayValue(h, this.series.userOptions.data_type);
                        }
                    }
                },
                series: {
                    dataLabels: {
                        enabled: true,
                        formatter: function () {
                            var i = this.y;
                            i = (i % 1 === 0)
                                ? Highcharts.numberFormat(this.y, "", "", app.getGroupingSeparator())
                                : Highcharts.numberFormat(this.y, app.getNumberOfDecimals(), app.getDecimalSeparator(), app.getGroupingSeparator());
                            return "<b>" + f.getDisplayValue(i, this.series.userOptions.data_type) + "</b>";
                        },
                        style: { fontSize: "12px" }
                    },
                    cursor: "pointer",
                    point: { events: {} }
                }
            },
            series: [],
            legend: { verticalAlign: "bottom", y: 10 },
            exporting: {
                buttons: {
                    contextButton: {
                        menuItems: [
                            {
                                textKey: 'viewFullscreen',
                                text: app.vtranslate("View in full screen"),
                                onclick: function () { this.fullscreen?.toggle(); }
                            },
                            {
                                textKey: 'printChart',
                                text: app.vtranslate("JS_PRINT"),
                                onclick: function () { this.print(); }
                            },
                            {
                                textKey: 'downloadPNG',
                                text: app.vtranslate("JS_SAVE_AS_IMAGE"),
                                onclick: function () {
                                    if (parsvtHighChart.isExtendedMethodRequired()) {
                                        var svg = this.getSVGForExport();
                                        var exportingOptions = Object.assign({}, this.options.exporting);
                                        parsvtHighChart.downloadHighcharts(exportingOptions, svg);
                                    } else {
                                        this.exportChart();
                                    }
                                }
                            },
                            {
                                textKey: 'downloadPDF',
                                text: app.vtranslate("Download PDF document"),
                                onclick: function () {
                                    if (parsvtHighChart.isExtendedMethodRequired()) {
                                        var svg = this.getSVGForExport();
                                        var exportingOptions = Object.assign({}, this.options.exporting, { type: 'application/pdf' });
                                        parsvtHighChart.downloadHighcharts(exportingOptions, svg);
                                    } else {
                                        this.exportChart({ type: 'application/pdf' });
                                    }
                                }
                            }
                        ]
                    }
                }
            }
        };



        var d = [];

        if (this.data.data_labels && this.data.chartData.length > 1) {
            for (var c = 0; c < this.data.data_labels.length; c++) {
                var b = {};
                b.name = this.data.data_labels[c];
                b.data = this.data.chartData[c];
                b.data_type = this.data.data_type[c];

                // Assign color from array or generate random
                b.color = (this.data.colors && this.data.colors[c]) ? this.data.colors[c] : this.getRandomColor();

                d.push(b);
            }

            delete g.xAxis.labels;
        } else {
            // fallback if only one series
            d = [{
                showInLegend: false,
                data: this.data["chartData"][0],
                colorByPoint: true
            }];
        }

        g.series = d;

        if (this.options.options3d === false) {
            g.chart.options3d.enabled = false;
        }

        if (this.options.links) {
            g.plotOptions.series.point.events.click = function () {
                var h = f.options.links[this.x];
                if (h) {
                    f.triggerClick({ "url": h });
                }
            };
        }

        if (this.options.hasOwnProperty("customStyles")) {
            jQuery.extend(g.chart, this.options.customStyles);
        }

        jQuery.extend(true, g, this.options.customStyles);
        jQuery.extend(true, g, this.options.customChartOptions);

        this.element.highcharts(g);
    };
    this.renderColumn = function () {
        var a = this;
        var b = {
            chart: {
                type: "column",
                backgroundColor: "white",
                resetZoomButton: {position: {x: -10, y: 10}, relativeTo: "chart"}
            }, title: {text: null}, credits: {enabled: false}, xAxis: {
                categories: this.data["categories"],
                step: this.helper.getLabelSteps(this.data["categories"], this.element),
                labels: {
                    useHTML: true, formatter: function () {
                        var d = this.value, c = d.length > 30 ? d.substring(0, 29) + ".." : d;
                        return c;
                    }
                }
            }, yAxis: {
                min: 0, labels: {
                    useHTML: true, formatter: function () {
                        return a.getDisplayValue(this.value);
                    }
                }, title: {text: null}
            }, tooltip: {
                formatter: function () {
                    var c = this.y;
                    if (!((c % 1) === 0)) {
                        c = Highcharts.numberFormat(this.y, app.getNumberOfDecimals(), app.getDecimalSeparator(), app.getGroupingSeparator());
                    } else {
                        c = Highcharts.numberFormat(this.y, "", "", app.getGroupingSeparator());
                    }
                    return '<span style="font-size:12px">' + this.x + "</span><table>" + '<tr><td style="color:{series.color};padding:0;padding:0;"><b>' + a.getDisplayValue(c) + "%</b></td></tr></table>";
                }, shared: false, useHTML: true, backgroundColor: "rgba(255,255,255,1)"
            }, plotOptions: {column: {pointPadding: 0.2, borderWidth: 0}}, series: this.data["chartData"],
            exporting: {
                buttons: {
                    contextButton: {
                        menuItems: [
                            {
                                textKey: 'viewFullscreen',
                                text: app.vtranslate("View in full screen"),
                                onclick: function () {
                                    if (this.fullscreen) {
                                        this.fullscreen.toggle();
                                    }
                                }
                            },
                            {
                                textKey: 'printChart',
                                text: app.vtranslate("JS_PRINT"),
                                onclick: function () {
                                    this.print();
                                }
                            },

                            {
                                textKey: 'downloadPNG',
                                text: app.vtranslate("JS_SAVE_AS_IMAGE"),
                                onclick: function () {
                                    if (parsvtHighChart.isExtendedMethodRequired()) {
                                        var svg = this.getSVGForExport();
                                        var exportingOptions = {};
                                        exportingOptions = Object.assign({}, this.options.exporting, exportingOptions);
                                        parsvtHighChart.downloadHighcharts(exportingOptions, svg);
                                    } else {
                                        this.exportChart();
                                    }
                                }
                            },
                            {
                                textKey: 'downloadPDF',
                                text: app.vtranslate("Download PDF document"),
                                onclick: function () {
                                    if (parsvtHighChart.isExtendedMethodRequired()) {
                                        var svg = this.getSVGForExport();
                                        var exportingOptions = {type: 'application/pdf'};
                                        exportingOptions = Object.assign({}, this.options.exporting, exportingOptions);
                                        parsvtHighChart.downloadHighcharts(exportingOptions, svg);
                                    } else {
                                        this.exportChart({
                                            type: 'application/pdf'
                                        });
                                    }
                                }
                            }
                        ]
                    }
                }
            }
        };
        jQuery.extend(true, b, this.options.customChartOptions);
        this.element.highcharts(b);
    };
    this.getRandomColor=function () {
        return '#' + Math.floor(Math.random() * 16777215).toString(16).padStart(6, '0');
    };
    this.init = function (b, c, a) {
        this.element = b;
        this.data = c;
        this.options = a;
        switch (a.renderer) {
            case"pie":
                this.renderPie();
                break;
            case"bar":
                this.renderbar();
                break;
            case"funnel":
                this.renderFunnel();
                break;
            case"multibar":
                this.renderMultibar();
                break;
            case"horizontalbar":
                this.renderHorizontalbar();
                break;
            case"linechart":
                this.renderLine();
                break;
            case"column":
                this.renderColumn();
                break;
            default:
                console.log("highchart renderer not supported");
        }
    };
};
