!/**
 * Highstock JS v11.4.1 (2024-04-04)
 *
 * Highcharts Stock as a plugin for Highcharts
 *
 * (c) 2010-2024 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/stock",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function i(t,e,i,s){t.hasOwnProperty(e)||(t[e]=s.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}i(e,"Series/DataModifyComposition.js",[e["Core/Axis/Axis.js"],e["Core/Series/Point.js"],e["Core/Series/Series.js"],e["Core/Utilities.js"]],function(t,e,i,s){var o;let{tooltipFormatter:r}=e.prototype,{addEvent:a,arrayMax:n,arrayMin:l,correctFloat:h,defined:d,isArray:p,isNumber:c,isString:u,pick:g}=s;return function(t){function e(t,e,i){!this.isXAxis&&(this.series.forEach(function(i){"compare"===t&&"boolean"!=typeof e?i.setCompare(e,!1):"cumulative"!==t||u(e)||i.setCumulative(e,!1)}),g(i,!0)&&this.chart.redraw())}function i(t){let e=this,{numberFormatter:i}=e.series.chart,s=function(s){t=t.replace("{point."+s+"}",(e[s]>0&&"change"===s?"+":"")+i(e[s],g(e.series.tooltipOptions.changeDecimals,2)))};return d(e.change)&&s("change"),d(e.cumulativeSum)&&s("cumulativeSum"),r.apply(this,[t])}function s(){let t;let e=this.options.compare;("percent"===e||"value"===e||this.options.cumulative)&&(t=new y(this),"percent"===e||"value"===e?t.initCompare(e):t.initCumulative()),this.dataModify=t}function o(t){let e=t.dataExtremes,i=e.activeYData;if(this.dataModify&&e){let t;this.options.compare?t=[this.dataModify.modifyValue(e.dataMin),this.dataModify.modifyValue(e.dataMax)]:this.options.cumulative&&p(i)&&i.length>=2&&(t=y.getCumulativeExtremes(i)),t&&(e.dataMin=l(t),e.dataMax=n(t))}}function f(t,e){this.options.compare=this.userOptions.compare=t,this.update({},g(e,!0)),this.dataModify&&("value"===t||"percent"===t)?this.dataModify.initCompare(t):this.points.forEach(t=>{delete t.change})}function x(){if(this.xAxis&&this.processedYData&&this.dataModify){let t=this.processedXData,e=this.processedYData,i=e.length,s=!0===this.options.compareStart?0:1,o=-1,r;for(this.pointArrayMap&&(o=this.pointArrayMap.indexOf(this.options.pointValKey||this.pointValKey||"y")),r=0;r<i-s;r++){let i=e[r]&&o>-1?e[r][o]:e[r];if(c(i)&&0!==i&&t[r+s]>=(this.xAxis.min||0)){this.dataModify.compareValue=i;break}}}}function m(t,e){this.setModifier("compare",t,e)}function b(t,e){t=g(t,!1),this.options.cumulative=this.userOptions.cumulative=t,this.update({},g(e,!0)),this.dataModify?this.dataModify.initCumulative():this.points.forEach(t=>{delete t.cumulativeSum})}function v(t,e){this.setModifier("cumulative",t,e)}t.compose=function(t,r,n){let l=r.prototype,h=n.prototype,d=t.prototype;return d.setCompare||(d.setCompare=f,d.setCumulative=b,a(t,"afterInit",s),a(t,"afterGetExtremes",o),a(t,"afterProcessData",x)),l.setCompare||(l.setCompare=m,l.setModifier=e,l.setCumulative=v,h.tooltipFormatter=i),t};class y{constructor(t){this.series=t}modifyValue(){return 0}static getCumulativeExtremes(t){let e=1/0,i=-1/0;return t.reduce((t,s)=>{let o=t+s;return e=Math.min(e,o,t),i=Math.max(i,o,t),o}),[e,i]}initCompare(t){this.modifyValue=function(e,i){null===e&&(e=0);let s=this.compareValue;if(void 0!==e&&void 0!==s){if("value"===t?e-=s:e=e/s*100-(100===this.series.options.compareBase?0:100),void 0!==i){let t=this.series.points[i];t&&(t.change=e)}return e}return 0}}initCumulative(){this.modifyValue=function(t,e){if(null===t&&(t=0),void 0!==t&&void 0!==e){let i=e>0?this.series.points[e-1]:null;i&&i.cumulativeSum&&(t=h(i.cumulativeSum+t));let s=this.series.points[e];return s&&(s.cumulativeSum=t),t}return 0}}}t.Additions=y}(o||(o={})),o}),i(e,"Stock/Navigator/ChartNavigatorComposition.js",[e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e){let i;let{isTouchDevice:s}=t,{addEvent:o,merge:r,pick:a}=e,n=[];function l(){this.navigator&&this.navigator.setBaseSeries(null,!1)}function h(){let t,e,i;let s=this.legend,o=this.navigator;if(o){t=s&&s.options,e=o.xAxis,i=o.yAxis;let{scrollbarHeight:r,scrollButtonSize:n}=o;this.inverted?(o.left=o.opposite?this.chartWidth-r-o.height:this.spacing[3]+r,o.top=this.plotTop+n):(o.left=a(e.left,this.plotLeft+n),o.top=o.navigatorOptions.top||this.chartHeight-o.height-r-(this.scrollbar?.options.margin||0)-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(t&&"bottom"===t.verticalAlign&&"proximate"!==t.layout&&t.enabled&&!t.floating?s.legendHeight+a(t.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0)),e&&i&&(this.inverted?e.options.left=i.options.left=o.left:e.options.top=i.options.top=o.top,e.setAxisSize(),i.setAxisSize())}}function d(t){!this.navigator&&!this.scroller&&(this.options.navigator.enabled||this.options.scrollbar.enabled)&&(this.scroller=this.navigator=new i(this),a(t.redraw,!0)&&this.redraw(t.animation))}function p(){let t=this.options;(t.navigator.enabled||t.scrollbar.enabled)&&(this.scroller=this.navigator=new i(this))}function c(){let t=this.options,e=t.navigator,i=t.rangeSelector;if((e&&e.enabled||i&&i.enabled)&&(!s&&"x"===this.zooming.type||s&&"x"===this.zooming.pinchType))return!1}function u(t){let e=t.navigator;if(e&&t.xAxis[0]){let i=t.xAxis[0].getExtremes();e.render(i.min,i.max)}}function g(t){let e=t.options.navigator||{},i=t.options.scrollbar||{};!this.navigator&&!this.scroller&&(e.enabled||i.enabled)&&(r(!0,this.options.navigator,e),r(!0,this.options.scrollbar,i),delete t.options.navigator,delete t.options.scrollbar)}return{compose:function(t,s){if(e.pushUnique(n,t)){let e=t.prototype;i=s,e.callbacks.push(u),o(t,"afterAddSeries",l),o(t,"afterSetChartSize",h),o(t,"afterUpdate",d),o(t,"beforeRender",p),o(t,"beforeShowResetZoom",c),o(t,"update",g)}}}}),i(e,"Core/Axis/NavigatorAxisComposition.js",[e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e){let{isTouchDevice:i}=t,{addEvent:s,correctFloat:o,defined:r,isNumber:a,pick:n}=e;function l(){this.navigatorAxis||(this.navigatorAxis=new d(this))}function h(t){let e;let s=this.chart,o=s.options,a=o.navigator,n=this.navigatorAxis,l=s.zooming.pinchType,h=o.rangeSelector,d=s.zooming.type;if(this.isXAxis&&(a?.enabled||h?.enabled)){if("y"===d&&"zoom"===t.trigger)e=!1;else if(("zoom"===t.trigger&&"xy"===d||i&&"xy"===l)&&this.options.range){let e=n.previousZoom;r(t.min)?n.previousZoom=[this.min,this.max]:e&&(t.min=e[0],t.max=e[1],n.previousZoom=void 0)}}void 0!==e&&t.preventDefault()}class d{static compose(t){t.keepProps.includes("navigatorAxis")||(t.keepProps.push("navigatorAxis"),s(t,"init",l),s(t,"setExtremes",h))}constructor(t){this.axis=t}destroy(){this.axis=void 0}toFixedRange(t,e,i,s){let l=this.axis,h=(l.pointRange||0)/2,d=n(i,l.translate(t,!0,!l.horiz)),p=n(s,l.translate(e,!0,!l.horiz));return r(i)||(d=o(d+h)),r(s)||(p=o(p-h)),a(d)&&a(p)||(d=p=void 0),{min:d,max:p}}}return d}),i(e,"Stock/Navigator/NavigatorDefaults.js",[e["Core/Color/Color.js"],e["Core/Series/SeriesRegistry.js"]],function(t,e){let{parse:i}=t,{seriesTypes:s}=e;return{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:"#f2f2f2",borderColor:"#999999"},maskFill:i("#667aff").setOpacity(.3).get(),outlineColor:"#999999",outlineWidth:1,series:{type:void 0===s.areaspline?"line":"areaspline",fillOpacity:.05,lineWidth:1,compare:null,sonification:{enabled:!1},dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:"#e6e6e6",gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:"#000000",fontSize:"0.7em",opacity:.6,textOutline:"2px contrast"},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}}),i(e,"Stock/Navigator/NavigatorSymbols.js",[],function(){return{"navigator-handle":function(t,e,i,s,o={}){let r=o.width?o.width/2:i,a=Math.round(r/3)+.5;return[["M",-r-1,.5],["L",r,.5],["L",r,(s=o.height||s)+.5],["L",-r-1,s+.5],["L",-r-1,.5],["M",-a,4],["L",-a,s-3],["M",a-1,4],["L",a-1,s-3]]}}}),i(e,"Stock/Utilities/StockUtilities.js",[e["Core/Utilities.js"]],function(t){let{defined:e}=t;return{setFixedRange:function(t){let i=this.xAxis[0];e(i.dataMax)&&e(i.dataMin)&&t?this.fixedRange=Math.min(t,i.dataMax-i.dataMin):this.fixedRange=t}}}),i(e,"Stock/Navigator/NavigatorComposition.js",[e["Core/Defaults.js"],e["Core/Globals.js"],e["Core/Axis/NavigatorAxisComposition.js"],e["Stock/Navigator/NavigatorDefaults.js"],e["Stock/Navigator/NavigatorSymbols.js"],e["Core/Renderer/RendererRegistry.js"],e["Stock/Utilities/StockUtilities.js"],e["Core/Utilities.js"]],function(t,e,i,s,o,r,a,n){let{setOptions:l}=t,{composed:h}=e,{getRendererType:d}=r,{setFixedRange:p}=a,{addEvent:c,extend:u,pushUnique:g}=n;function f(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}return{compose:function(t,e,r){i.compose(e),g(h,"Navigator")&&(t.prototype.setFixedRange=p,u(d().prototype.symbols,o),c(r,"afterUpdate",f),l({navigator:s}))}}}),i(e,"Core/Axis/ScrollbarAxis.js",[e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e){var i;let{composed:s}=t,{addEvent:o,defined:r,pick:a,pushUnique:n}=e;return function(t){let e;function i(t){let e=a(t.options&&t.options.min,t.min),i=a(t.options&&t.options.max,t.max);return{axisMin:e,axisMax:i,scrollMin:r(t.dataMin)?Math.min(e,t.min,t.dataMin,a(t.threshold,1/0)):e,scrollMax:r(t.dataMax)?Math.max(i,t.max,t.dataMax,a(t.threshold,-1/0)):i}}function l(){let t=this.scrollbar,e=t&&!t.options.opposite,i=this.horiz?2:e?3:1;t&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[i]+=t.size+(t.options.margin||0))}function h(){let t=this;t.options&&t.options.scrollbar&&t.options.scrollbar.enabled&&(t.options.scrollbar.vertical=!t.horiz,t.options.startOnTick=t.options.endOnTick=!1,t.scrollbar=new e(t.chart.renderer,t.options.scrollbar,t.chart),o(t.scrollbar,"changed",function(e){let s,o;let{axisMin:a,axisMax:n,scrollMin:l,scrollMax:h}=i(t),d=h-l;if(r(a)&&r(n)){if(t.horiz&&!t.reversed||!t.horiz&&t.reversed?(s=l+d*this.to,o=l+d*this.from):(s=l+d*(1-this.from),o=l+d*(1-this.to)),this.shouldUpdateExtremes(e.DOMType)){let i="mousemove"!==e.DOMType&&"touchmove"!==e.DOMType&&void 0;t.setExtremes(o,s,!0,i,e)}else this.setRange(this.from,this.to)}}))}function d(){let t,e,s;let{scrollMin:o,scrollMax:a}=i(this),n=this.scrollbar,l=this.axisTitleMargin+(this.titleOffset||0),h=this.chart.scrollbarsOffsets,d=this.options.margin||0;if(n&&h){if(this.horiz)this.opposite||(h[1]+=l),n.position(this.left,this.top+this.height+2+h[1]-(this.opposite?d:0),this.width,this.height),this.opposite||(h[1]+=d),t=1;else{let e;this.opposite&&(h[0]+=l),e=n.options.opposite?this.left+this.width+2+h[0]-(this.opposite?0:d):this.opposite?0:d,n.position(e,this.top,this.width,this.height),this.opposite&&(h[0]+=d),t=0}h[t]+=n.size+(n.options.margin||0),isNaN(o)||isNaN(a)||!r(this.min)||!r(this.max)||this.min===this.max?n.setRange(0,1):(e=(this.min-o)/(a-o),s=(this.max-o)/(a-o),this.horiz&&!this.reversed||!this.horiz&&this.reversed?n.setRange(e,s):n.setRange(1-s,1-e))}}t.compose=function(t,i){n(s,"Axis.Scrollbar")&&(e=i,o(t,"afterGetOffset",l),o(t,"afterInit",h),o(t,"afterRender",d))}}(i||(i={})),i}),i(e,"Stock/Scrollbar/ScrollbarDefaults.js",[],function(){return{height:10,barBorderRadius:5,buttonBorderRadius:0,buttonsEnabled:!1,liveRedraw:void 0,margin:void 0,minWidth:6,opposite:!0,step:.2,zIndex:3,barBackgroundColor:"#cccccc",barBorderWidth:0,barBorderColor:"#cccccc",buttonArrowColor:"#333333",buttonBackgroundColor:"#e6e6e6",buttonBorderColor:"#cccccc",buttonBorderWidth:1,rifleColor:"none",trackBackgroundColor:"rgba(255, 255, 255, 0.001)",trackBorderColor:"#cccccc",trackBorderRadius:5,trackBorderWidth:1}}),i(e,"Stock/Scrollbar/Scrollbar.js",[e["Core/Defaults.js"],e["Core/Globals.js"],e["Core/Axis/ScrollbarAxis.js"],e["Stock/Scrollbar/ScrollbarDefaults.js"],e["Core/Utilities.js"]],function(t,e,i,s,o){let{defaultOptions:r}=t,{addEvent:a,correctFloat:n,defined:l,destroyObjectProperties:h,fireEvent:d,merge:p,pick:c,removeEvent:u}=o;class g{static compose(t){i.compose(t,g)}static swapXY(t,e){return e&&t.forEach(t=>{let e;let i=t.length;for(let s=0;s<i;s+=2)"number"==typeof(e=t[s+1])&&(t[s+1]=t[s+2],t[s+2]=e)}),t}constructor(t,e,i){this._events=[],this.chartX=0,this.chartY=0,this.from=0,this.scrollbarButtons=[],this.scrollbarLeft=0,this.scrollbarStrokeWidth=1,this.scrollbarTop=0,this.size=0,this.to=0,this.trackBorderWidth=1,this.x=0,this.y=0,this.init(t,e,i)}addEvents(){let t=this.options.inverted?[1,0]:[0,1],e=this.scrollbarButtons,i=this.scrollbarGroup.element,s=this.track.element,o=this.mouseDownHandler.bind(this),r=this.mouseMoveHandler.bind(this),n=this.mouseUpHandler.bind(this),l=[[e[t[0]].element,"click",this.buttonToMinClick.bind(this)],[e[t[1]].element,"click",this.buttonToMaxClick.bind(this)],[s,"click",this.trackClick.bind(this)],[i,"mousedown",o],[i.ownerDocument,"mousemove",r],[i.ownerDocument,"mouseup",n],[i,"touchstart",o],[i.ownerDocument,"touchmove",r],[i.ownerDocument,"touchend",n]];l.forEach(function(t){a.apply(null,t)}),this._events=l}buttonToMaxClick(t){let e=(this.to-this.from)*c(this.options.step,.2);this.updatePosition(this.from+e,this.to+e),d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})}buttonToMinClick(t){let e=n(this.to-this.from)*c(this.options.step,.2);this.updatePosition(n(this.from-e),n(this.to-e)),d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})}cursorToScrollbarPosition(t){let e=this.options,i=e.minWidth>this.calculatedWidth?e.minWidth:0;return{chartX:(t.chartX-this.x-this.xOffset)/(this.barWidth-i),chartY:(t.chartY-this.y-this.yOffset)/(this.barWidth-i)}}destroy(){let t=this,e=t.chart.scroller;t.removeEvents(),["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(e){t[e]&&t[e].destroy&&(t[e]=t[e].destroy())}),e&&t===e.scrollbar&&(e.scrollbar=null,h(e.scrollbarButtons))}drawScrollbarButton(t){let e=this.renderer,i=this.scrollbarButtons,s=this.options,o=this.size,r=e.g().add(this.group);if(i.push(r),s.buttonsEnabled){let a=e.rect().addClass("highcharts-scrollbar-button").add(r);this.chart.styledMode||a.attr({stroke:s.buttonBorderColor,"stroke-width":s.buttonBorderWidth,fill:s.buttonBackgroundColor}),a.attr(a.crisp({x:-.5,y:-.5,width:o+1,height:o+1,r:s.buttonBorderRadius},a.strokeWidth()));let n=e.path(g.swapXY([["M",o/2+(t?-1:1),o/2-3],["L",o/2+(t?-1:1),o/2+3],["L",o/2+(t?2:-2),o/2]],s.vertical)).addClass("highcharts-scrollbar-arrow").add(i[t]);this.chart.styledMode||n.attr({fill:s.buttonArrowColor})}}init(t,e,i){this.scrollbarButtons=[],this.renderer=t,this.userOptions=e,this.options=p(s,r.scrollbar,e),this.options.margin=c(this.options.margin,10),this.chart=i,this.size=c(this.options.size,this.options.height),e.enabled&&(this.render(),this.addEvents())}mouseDownHandler(t){let e=this.chart.pointer?.normalize(t)||t,i=this.cursorToScrollbarPosition(e);this.chartX=i.chartX,this.chartY=i.chartY,this.initPositions=[this.from,this.to],this.grabbedCenter=!0}mouseMoveHandler(t){let e;let i=this.chart.pointer?.normalize(t)||t,s=this.options.vertical?"chartY":"chartX",o=this.initPositions||[];this.grabbedCenter&&(!t.touches||0!==t.touches[0][s])&&(e=this.cursorToScrollbarPosition(i)[s]-this[s],this.hasDragged=!0,this.updatePosition(o[0]+e,o[1]+e),this.hasDragged&&d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:t.type,DOMEvent:t}))}mouseUpHandler(t){this.hasDragged&&d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:t.type,DOMEvent:t}),this.grabbedCenter=this.hasDragged=this.chartX=this.chartY=null}position(t,e,i,s){let{buttonsEnabled:o,margin:r=0,vertical:a}=this.options,n=this.rendered?"animate":"attr",l=s,h=0;this.group.show(),this.x=t,this.y=e+this.trackBorderWidth,this.width=i,this.height=s,this.xOffset=l,this.yOffset=h,a?(this.width=this.yOffset=i=h=this.size,this.xOffset=l=0,this.yOffset=h=o?this.size:0,this.barWidth=s-(o?2*i:0),this.x=t+=r):(this.height=s=this.size,this.xOffset=l=o?this.size:0,this.barWidth=i-(o?2*s:0),this.y=this.y+r),this.group[n]({translateX:t,translateY:this.y}),this.track[n]({width:i,height:s}),this.scrollbarButtons[1][n]({translateX:a?0:i-l,translateY:a?s-h:0})}removeEvents(){this._events.forEach(function(t){u.apply(null,t)}),this._events.length=0}render(){let t=this.renderer,e=this.options,i=this.size,s=this.chart.styledMode,o=t.g("scrollbar").attr({zIndex:e.zIndex}).hide().add();this.group=o,this.track=t.rect().addClass("highcharts-scrollbar-track").attr({r:e.trackBorderRadius||0,height:i,width:i}).add(o),s||this.track.attr({fill:e.trackBackgroundColor,stroke:e.trackBorderColor,"stroke-width":e.trackBorderWidth});let r=this.trackBorderWidth=this.track.strokeWidth();this.track.attr({x:-r%2/2,y:-r%2/2}),this.scrollbarGroup=t.g().add(o),this.scrollbar=t.rect().addClass("highcharts-scrollbar-thumb").attr({height:i-r,width:i-r,r:e.barBorderRadius||0}).add(this.scrollbarGroup),this.scrollbarRifles=t.path(g.swapXY([["M",-3,i/4],["L",-3,2*i/3],["M",0,i/4],["L",0,2*i/3],["M",3,i/4],["L",3,2*i/3]],e.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup),s||(this.scrollbar.attr({fill:e.barBackgroundColor,stroke:e.barBorderColor,"stroke-width":e.barBorderWidth}),this.scrollbarRifles.attr({stroke:e.rifleColor,"stroke-width":1})),this.scrollbarStrokeWidth=this.scrollbar.strokeWidth(),this.scrollbarGroup.translate(-this.scrollbarStrokeWidth%2/2,-this.scrollbarStrokeWidth%2/2),this.drawScrollbarButton(0),this.drawScrollbarButton(1)}setRange(t,e){let i,s;let o=this.options,r=o.vertical,a=o.minWidth,h=this.barWidth,d=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?"attr":"animate";if(!l(h))return;let p=h*Math.min(e,1);i=Math.ceil(h*(t=Math.max(t,0))),this.calculatedWidth=s=n(p-i),s<a&&(i=(h-a+s)*t,s=a);let c=Math.floor(i+this.xOffset+this.yOffset),u=s/2-.5;this.from=t,this.to=e,r?(this.scrollbarGroup[d]({translateY:c}),this.scrollbar[d]({height:s}),this.scrollbarRifles[d]({translateY:u}),this.scrollbarTop=c,this.scrollbarLeft=0):(this.scrollbarGroup[d]({translateX:c}),this.scrollbar[d]({width:s}),this.scrollbarRifles[d]({translateX:u}),this.scrollbarLeft=c,this.scrollbarTop=0),s<=12?this.scrollbarRifles.hide():this.scrollbarRifles.show(),!1===o.showFull&&(t<=0&&e>=1?this.group.hide():this.group.show()),this.rendered=!0}shouldUpdateExtremes(t){return c(this.options.liveRedraw,e.svg&&!e.isTouchDevice&&!this.chart.boosted)||"mouseup"===t||"touchend"===t||!l(t)}trackClick(t){let e=this.chart.pointer?.normalize(t)||t,i=this.to-this.from,s=this.y+this.scrollbarTop,o=this.x+this.scrollbarLeft;this.options.vertical&&e.chartY>s||!this.options.vertical&&e.chartX>o?this.updatePosition(this.from+i,this.to+i):this.updatePosition(this.from-i,this.to-i),d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})}update(t){this.destroy(),this.init(this.chart.renderer,p(!0,this.options,t),this.chart)}updatePosition(t,e){e>1&&(t=n(1-n(e-t)),e=1),t<0&&(e=n(e-t),t=0),this.from=t,this.to=e}}return g.defaultOptions=s,r.scrollbar=p(!0,g.defaultOptions,r.scrollbar),g}),i(e,"Stock/Navigator/Navigator.js",[e["Core/Axis/Axis.js"],e["Stock/Navigator/ChartNavigatorComposition.js"],e["Core/Defaults.js"],e["Core/Globals.js"],e["Core/Axis/NavigatorAxisComposition.js"],e["Stock/Navigator/NavigatorComposition.js"],e["Stock/Scrollbar/Scrollbar.js"],e["Core/Utilities.js"]],function(t,e,i,s,o,r,a,n){let{defaultOptions:l}=i,{isTouchDevice:h}=s,{addEvent:d,clamp:p,correctFloat:c,defined:u,destroyObjectProperties:g,erase:f,extend:x,find:m,fireEvent:b,isArray:v,isNumber:y,merge:M,pick:S,removeEvent:A,splat:k}=n;function C(t,...e){let i=[].filter.call(e,y);if(i.length)return Math[t].apply(0,i)}class D{static compose(t,i,s){e.compose(t,D),r.compose(t,i,s)}constructor(t){this.scrollbarHeight=0,this.init(t)}drawHandle(t,e,i,s){let o=this.navigatorOptions.handles.height;this.handles[e][s](i?{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+parseInt(t,10)+.5-o)}:{translateX:Math.round(this.left+parseInt(t,10)),translateY:Math.round(this.top+this.height/2-o/2-1)})}drawOutline(t,e,i,s){let o=this.navigatorOptions.maskInside,r=this.outline.strokeWidth(),a=r/2,n=r%2/2,l=this.scrollButtonSize,h=this.size,d=this.top,p=this.height,c=d-a,u=d+p,g=this.left,f,x;i?(f=d+e+n,e=d+t+n,x=[["M",g+p,d-l-n],["L",g+p,f],["L",g,f],["M",g,e],["L",g+p,e],["L",g+p,d+h+l]],o&&x.push(["M",g+p,f-a],["L",g+p,e+a])):(g-=l,t+=g+l-n,e+=g+l-n,x=[["M",g,c],["L",t,c],["L",t,u],["M",e,u],["L",e,c],["L",g+h+2*l,d+a]],o&&x.push(["M",t-a,c],["L",e+a,c])),this.outline[s]({d:x})}drawMasks(t,e,i,s){let o,r,a,n;let l=this.left,h=this.top,d=this.height;i?(a=[l,l,l],n=[h,h+t,h+e],r=[d,d,d],o=[t,e-t,this.size-e]):(a=[l,l+t,l+e],n=[h,h,h],r=[t,e-t,this.size-e],o=[d,d,d]),this.shades.forEach((t,e)=>{t[s]({x:a[e],y:n[e],width:r[e],height:o[e]})})}renderElements(){let t=this,e=t.navigatorOptions,i=e.maskInside,s=t.chart,o=s.inverted,r=s.renderer,a={cursor:o?"ns-resize":"ew-resize"},n=t.navigatorGroup=r.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();if([!i,i,!i].forEach((i,o)=>{let l=r.rect().addClass("highcharts-navigator-mask"+(1===o?"-inside":"-outside")).add(n);s.styledMode||(l.attr({fill:i?e.maskFill:"rgba(0,0,0,0)"}),1===o&&l.css(a)),t.shades[o]=l}),t.outline=r.path().addClass("highcharts-navigator-outline").add(n),s.styledMode||t.outline.attr({"stroke-width":e.outlineWidth,stroke:e.outlineColor}),e.handles&&e.handles.enabled){let i=e.handles,{height:o,width:l}=i;[0,1].forEach(e=>{t.handles[e]=r.symbol(i.symbols[e],-l/2-1,0,l,o,i),s.inverted&&t.handles[e].attr({rotation:90,rotationOriginX:Math.floor(-l/2),rotationOriginY:(o+l)/2}),t.handles[e].attr({zIndex:7-e}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][e]).add(n),s.styledMode||t.handles[e].attr({fill:i.backgroundColor,stroke:i.borderColor,"stroke-width":i.lineWidth}).css(a)})}}update(t){(this.series||[]).forEach(t=>{t.baseSeries&&delete t.baseSeries.navigatorSeries}),this.destroy(),M(!0,this.chart.options.navigator,t),this.init(this.chart)}render(t,e,i,s){let o=this.chart,r=this.xAxis,a=r.pointRange||0,n=r.navigatorAxis.fake?o.xAxis[0]:r,l=this.navigatorEnabled,h=this.rendered,d=o.inverted,g=o.xAxis[0].minRange,f=o.xAxis[0].options.maxRange,x=this.scrollButtonSize,m,v,M,A=this.scrollbarHeight,k,C;if(this.hasDragged&&!u(i))return;if(t=c(t-a/2),e=c(e+a/2),!y(t)||!y(e)){if(!h)return;i=0,s=S(r.width,n.width)}this.left=S(r.left,o.plotLeft+x+(d?o.plotWidth:0));let D=this.size=k=S(r.len,(d?o.plotHeight:o.plotWidth)-2*x);m=d?A:k+2*x,i=S(i,r.toPixels(t,!0)),s=S(s,r.toPixels(e,!0)),y(i)&&Math.abs(i)!==1/0||(i=0,s=m);let w=r.toValue(i,!0),O=r.toValue(s,!0),B=Math.abs(c(O-w));B<g?this.grabbedLeft?i=r.toPixels(O-g-a,!0):this.grabbedRight&&(s=r.toPixels(w+g+a,!0)):u(f)&&c(B-a)>f&&(this.grabbedLeft?i=r.toPixels(O-f-a,!0):this.grabbedRight&&(s=r.toPixels(w+f+a,!0))),this.zoomedMax=p(Math.max(i,s),0,D),this.zoomedMin=p(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(i,s),0,D),this.range=this.zoomedMax-this.zoomedMin,D=Math.round(this.zoomedMax);let E=Math.round(this.zoomedMin);l&&(this.navigatorGroup.attr({visibility:"inherit"}),C=h&&!this.hasDragged?"animate":"attr",this.drawMasks(E,D,d,C),this.drawOutline(E,D,d,C),this.navigatorOptions.handles.enabled&&(this.drawHandle(E,0,d,C),this.drawHandle(D,1,d,C))),this.scrollbar&&(d?(M=this.top-x,v=this.left-A+(l||!n.opposite?0:(n.titleOffset||0)+n.axisTitleMargin),A=k+2*x):(M=this.top+(l?this.height:-A),v=this.left-x),this.scrollbar.position(v,M,m,A),this.scrollbar.setRange(this.zoomedMin/(k||1),this.zoomedMax/(k||1))),this.rendered=!0,b(this,"afterRender")}addMouseEvents(){let t=this,e=t.chart,i=e.container,s=[],o,r;t.mouseMoveHandler=o=function(e){t.onMouseMove(e)},t.mouseUpHandler=r=function(e){t.onMouseUp(e)},(s=t.getPartsEvents("mousedown")).push(d(e.renderTo,"mousemove",o),d(i.ownerDocument,"mouseup",r),d(e.renderTo,"touchmove",o),d(i.ownerDocument,"touchend",r)),s.concat(t.getPartsEvents("touchstart")),t.eventsToUnbind=s,t.series&&t.series[0]&&s.push(d(t.series[0].xAxis,"foundExtremes",function(){e.navigator.modifyNavigatorAxisExtremes()}))}getPartsEvents(t){let e=this,i=[];return["shades","handles"].forEach(function(s){e[s].forEach(function(o,r){i.push(d(o.element,t,function(t){e[s+"Mousedown"](t,r)}))})}),i}shadesMousedown(t,e){t=this.chart.pointer?.normalize(t)||t;let i=this.chart,s=this.xAxis,o=this.zoomedMin,r=this.size,a=this.range,n=this.left,l=t.chartX,h,d,p,c;i.inverted&&(l=t.chartY,n=this.top),1===e?(this.grabbedCenter=l,this.fixedWidth=a,this.dragOffset=l-o):(c=l-n-a/2,0===e?c=Math.max(0,c):2===e&&c+a>=r&&(c=r-a,this.reversedExtremes?(c-=a,d=this.getUnionExtremes().dataMin):h=this.getUnionExtremes().dataMax),c!==o&&(this.fixedWidth=a,u((p=s.navigatorAxis.toFixedRange(c,c+a,d,h)).min)&&b(this,"setRange",{min:Math.min(p.min,p.max),max:Math.max(p.min,p.max),redraw:!0,eventArguments:{trigger:"navigator"}})))}handlesMousedown(t,e){t=this.chart.pointer?.normalize(t)||t;let i=this.chart,s=i.xAxis[0],o=this.reversedExtremes;0===e?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=o?s.min:s.max):(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=o?s.max:s.min),i.setFixedRange(void 0)}onMouseMove(t){let e=this,i=e.chart,s=e.navigatorSize,o=e.range,r=e.dragOffset,a=i.inverted,n=e.left,l;(!t.touches||0!==t.touches[0].pageX)&&(l=(t=i.pointer?.normalize(t)||t).chartX,a&&(n=e.top,l=t.chartY),e.grabbedLeft?(e.hasDragged=!0,e.render(0,0,l-n,e.otherHandlePos)):e.grabbedRight?(e.hasDragged=!0,e.render(0,0,e.otherHandlePos,l-n)):e.grabbedCenter&&(e.hasDragged=!0,l<r?l=r:l>s+r-o&&(l=s+r-o),e.render(0,0,l-r,l-r+o)),e.hasDragged&&e.scrollbar&&S(e.scrollbar.options.liveRedraw,!h&&!this.chart.boosted)&&(t.DOMType=t.type,setTimeout(function(){e.onMouseUp(t)},0)))}onMouseUp(t){let e,i,s,o,r,a;let n=this.chart,l=this.xAxis,h=this.scrollbar,d=t.DOMEvent||t,p=n.inverted,c=this.rendered&&!this.hasDragged?"animate":"attr";(this.hasDragged&&(!h||!h.hasDragged)||"scrollbar"===t.trigger)&&(s=this.getUnionExtremes(),this.zoomedMin===this.otherHandlePos?o=this.fixedExtreme:this.zoomedMax===this.otherHandlePos&&(r=this.fixedExtreme),this.zoomedMax===this.size&&(r=this.reversedExtremes?s.dataMin:s.dataMax),0===this.zoomedMin&&(o=this.reversedExtremes?s.dataMax:s.dataMin),u((a=l.navigatorAxis.toFixedRange(this.zoomedMin,this.zoomedMax,o,r)).min)&&b(this,"setRange",{min:Math.min(a.min,a.max),max:Math.max(a.min,a.max),redraw:!0,animation:!this.hasDragged&&null,eventArguments:{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:d}})),"mousemove"!==t.DOMType&&"touchmove"!==t.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=this.hasDragged=this.dragOffset=null),this.navigatorEnabled&&y(this.zoomedMin)&&y(this.zoomedMax)&&(i=Math.round(this.zoomedMin),e=Math.round(this.zoomedMax),this.shades&&this.drawMasks(i,e,p,c),this.outline&&this.drawOutline(i,e,p,c),this.navigatorOptions.handles.enabled&&Object.keys(this.handles).length===this.handles.length&&(this.drawHandle(i,0,p,c),this.drawHandle(e,1,p,c)))}removeEvents(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(t){t()}),this.eventsToUnbind=void 0),this.removeBaseSeriesEvents()}removeBaseSeriesEvents(){let t=this.baseSeries||[];this.navigatorEnabled&&t[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&t.forEach(function(t){A(t,"updatedData",this.updatedDataHandler)},this),t[0].xAxis&&A(t[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))}init(e){let i=e.options,s=i.navigator||{},r=s.enabled,n=i.scrollbar||{},l=n.enabled,h=r&&s.height||0,p=l&&n.height||0,c=n.buttonsEnabled&&p||0;this.handles=[],this.shades=[],this.chart=e,this.setBaseSeries(),this.height=h,this.scrollbarHeight=p,this.scrollButtonSize=c,this.scrollbarEnabled=l,this.navigatorEnabled=r,this.navigatorOptions=s,this.scrollbarOptions=n,this.opposite=S(s.opposite,!!(!r&&e.inverted));let u=this,g=u.baseSeries,f=e.xAxis.length,x=e.yAxis.length,m=g&&g[0]&&g[0].xAxis||e.xAxis[0]||{options:{}};if(e.isDirtyBox=!0,u.navigatorEnabled?(u.xAxis=new t(e,M({breaks:m.options.breaks,ordinal:m.options.ordinal,overscroll:m.options.overscroll},s.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",type:"datetime",index:f,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},e.inverted?{offsets:[c,0,-c,0],width:h}:{offsets:[0,-c,0,c],height:h}),"xAxis"),u.yAxis=new t(e,M(s.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:x,isInternal:!0,reversed:S(s.yAxis&&s.yAxis.reversed,e.yAxis[0]&&e.yAxis[0].reversed,!1),zoomEnabled:!1},e.inverted?{width:h}:{height:h}),"yAxis"),g||s.series.data?u.updateNavigatorSeries(!1):0===e.series.length&&(u.unbindRedraw=d(e,"beforeRedraw",function(){e.series.length>0&&!u.series&&(u.setBaseSeries(),u.unbindRedraw())})),u.reversedExtremes=e.inverted&&!u.xAxis.reversed||!e.inverted&&u.xAxis.reversed,u.renderElements(),u.addMouseEvents()):(u.xAxis={chart:e,navigatorAxis:{fake:!0},translate:function(t,i){let s=e.xAxis[0],o=s.getExtremes(),r=s.len-2*c,a=C("min",s.options.min,o.dataMin),n=C("max",s.options.max,o.dataMax)-a;return i?t*n/r+a:r*(t-a)/n},toPixels:function(t){return this.translate(t)},toValue:function(t){return this.translate(t,!0)}},u.xAxis.navigatorAxis.axis=u.xAxis,u.xAxis.navigatorAxis.toFixedRange=o.prototype.toFixedRange.bind(u.xAxis.navigatorAxis)),e.options.scrollbar.enabled){let t=M(e.options.scrollbar,{vertical:e.inverted});!y(t.margin)&&u.navigatorEnabled&&(t.margin=e.inverted?-3:3),e.scrollbar=u.scrollbar=new a(e.renderer,t,e),d(u.scrollbar,"changed",function(t){let e=u.size,i=e*this.to,s=e*this.from;u.hasDragged=u.scrollbar.hasDragged,u.render(0,0,s,i),this.shouldUpdateExtremes(t.DOMType)&&setTimeout(function(){u.onMouseUp(t)})})}u.addBaseSeriesEvents(),u.addChartEvents()}getUnionExtremes(t){let e;let i=this.chart.xAxis[0],s=this.xAxis,o=s.options,r=i.options;return t&&null===i.dataMin||(e={dataMin:S(o&&o.min,C("min",r.min,i.dataMin,s.dataMin,s.min)),dataMax:S(o&&o.max,C("max",r.max,i.dataMax,s.dataMax,s.max))}),e}setBaseSeries(t,e){let i=this.chart,s=this.baseSeries=[];t=t||i.options&&i.options.navigator.baseSeries||(i.series.length?m(i.series,t=>!t.options.isInternal).index:0),(i.series||[]).forEach((e,i)=>{!e.options.isInternal&&(e.options.showInNavigator||(i===t||e.options.id===t)&&!1!==e.options.showInNavigator)&&s.push(e)}),this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,e)}updateNavigatorSeries(t,e){let i=this,s=i.chart,o=i.baseSeries,r={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},a=i.series=(i.series||[]).filter(t=>{let e=t.baseSeries;return!(0>o.indexOf(e))||(e&&(A(e,"updatedData",i.updatedDataHandler),delete e.navigatorSeries),t.chart&&t.destroy(),!1)}),n,h,d=i.navigatorOptions.series,p;o&&o.length&&o.forEach(t=>{let c=t.navigatorSeries,u=x({color:t.color,visible:t.visible},v(d)?l.navigator.series:d);if(c&&!1===i.navigatorOptions.adaptToUpdatedData)return;r.name="Navigator "+o.length,p=(n=t.options||{}).navigatorOptions||{},u.dataLabels=k(u.dataLabels),(h=M(n,r,u,p)).pointRange=S(u.pointRange,p.pointRange,l.plotOptions[h.type||"line"].pointRange);let g=p.data||u.data;i.hasNavigatorData=i.hasNavigatorData||!!g,h.data=g||n.data&&n.data.slice(0),c&&c.options?c.update(h,e):(t.navigatorSeries=s.initSeries(h),s.setSortedData(),t.navigatorSeries.baseSeries=t,a.push(t.navigatorSeries))}),(d.data&&!(o&&o.length)||v(d))&&(i.hasNavigatorData=!1,(d=k(d)).forEach((t,e)=>{r.name="Navigator "+(a.length+1),(h=M(l.navigator.series,{color:s.series[e]&&!s.series[e].options.isInternal&&s.series[e].color||s.options.colors[e]||s.options.colors[0]},r,t)).data=t.data,h.data&&(i.hasNavigatorData=!0,a.push(s.initSeries(h)))})),t&&this.addBaseSeriesEvents()}addBaseSeriesEvents(){let t=this,e=t.baseSeries||[];e[0]&&e[0].xAxis&&e[0].eventsToUnbind.push(d(e[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes)),e.forEach(e=>{e.eventsToUnbind.push(d(e,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)})),e.eventsToUnbind.push(d(e,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)})),!1!==this.navigatorOptions.adaptToUpdatedData&&e.xAxis&&e.eventsToUnbind.push(d(e,"updatedData",this.updatedDataHandler)),e.eventsToUnbind.push(d(e,"remove",function(){this.navigatorSeries&&(f(t.series,this.navigatorSeries),u(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))})}getBaseSeriesMin(t){return this.baseSeries.reduce(function(t,e){return Math.min(t,e.xData&&e.xData.length?e.xData[0]:t)},t)}modifyNavigatorAxisExtremes(){let t=this.xAxis;if(void 0!==t.getExtremes){let e=this.getUnionExtremes(!0);e&&(e.dataMin!==t.min||e.dataMax!==t.max)&&(t.min=e.dataMin,t.max=e.dataMax)}}modifyBaseAxisExtremes(){let t,e;let i=this.chart.navigator,s=this.getExtremes(),o=s.min,r=s.max,a=s.dataMin,n=s.dataMax,l=r-o,h=i.stickToMin,d=i.stickToMax,p=S(this.ordinal?.convertOverscroll(this.options.overscroll),0),c=i.series&&i.series[0],u=!!this.setExtremes;!(this.eventArgs&&"rangeSelectorButton"===this.eventArgs.trigger)&&(h&&(t=(e=a)+l),d&&(t=n+p,h||(e=Math.max(a,t-l,i.getBaseSeriesMin(c&&c.xData?c.xData[0]:-Number.MAX_VALUE)))),u&&(h||d)&&y(e)&&(this.min=this.userMin=e,this.max=this.userMax=t)),i.stickToMin=i.stickToMax=null}updatedDataHandler(){let t=this.chart.navigator,e=this.navigatorSeries,i=t.reversedExtremes?0===Math.round(t.zoomedMin):Math.round(t.zoomedMax)>=Math.round(t.size);t.stickToMax=S(this.chart.options.navigator&&this.chart.options.navigator.stickToMax,i),t.stickToMin=t.shouldStickToMin(this,t),e&&!t.hasNavigatorData&&(e.options.pointStart=this.xData[0],e.setData(this.options.data,!1,null,!1))}shouldStickToMin(t,e){let i=e.getBaseSeriesMin(t.xData[0]),s=t.xAxis,o=s.max,r=s.min,a=s.options.range;return!!(y(o)&&y(r))&&(a&&o-i>0?o-i<a:r<=i)}addChartEvents(){this.eventsToUnbind||(this.eventsToUnbind=[]),this.eventsToUnbind.push(d(this.chart,"redraw",function(){let t=this.navigator,e=t&&(t.baseSeries&&t.baseSeries[0]&&t.baseSeries[0].xAxis||this.xAxis[0]);e&&t.render(e.min,e.max)}),d(this.chart,"getMargins",function(){let t=this.navigator,e=t.opposite?"plotTop":"marginBottom";this.inverted&&(e=t.opposite?"marginRight":"plotLeft"),this[e]=(this[e]||0)+(t.navigatorEnabled||!this.inverted?t.height+t.scrollbarHeight:0)+t.navigatorOptions.margin}),d(D,"setRange",function(t){this.chart.xAxis[0].setExtremes(t.min,t.max,t.redraw,t.animation,t.eventArguments)}))}destroy(){this.removeEvents(),this.xAxis&&(f(this.chart.xAxis,this.xAxis),f(this.chart.axes,this.xAxis)),this.yAxis&&(f(this.chart.yAxis,this.yAxis),f(this.chart.axes,this.yAxis)),(this.series||[]).forEach(t=>{t.destroy&&t.destroy()}),["series","xAxis","yAxis","shades","outline","scrollbarTrack","scrollbarRifles","scrollbarGroup","scrollbar","navigatorGroup","rendered"].forEach(t=>{this[t]&&this[t].destroy&&this[t].destroy(),this[t]=null}),[this.handles].forEach(t=>{g(t)})}}return D}),i(e,"Core/Axis/OrdinalAxis.js",[e["Core/Axis/Axis.js"],e["Core/Globals.js"],e["Core/Series/Series.js"],e["Core/Utilities.js"]],function(t,e,i,s){var o;let{addEvent:r,correctFloat:a,css:n,defined:l,error:h,isNumber:d,pick:p,timeUnits:c,isString:u}=s;return function(t){function s(t,e,i,s,o=[],r=0,a){let n={},d=this.options.tickPixelInterval,p=this.chart.time,u=[],g,f,x,m,b,v=0,y=[],M=-Number.MAX_VALUE;if(!this.options.ordinal&&!this.options.breaks||!o||o.length<3||void 0===e)return p.getTimeTicks.apply(p,arguments);let S=o.length;for(g=0;g<S;g++){if(b=g&&o[g-1]>i,o[g]<e&&(v=g),g===S-1||o[g+1]-o[g]>5*r||b){if(o[g]>M){for(f=p.getTimeTicks(t,o[v],o[g],s);f.length&&f[0]<=M;)f.shift();f.length&&(M=f[f.length-1]),u.push(y.length),y=y.concat(f)}v=g+1}if(b)break}if(f){if(m=f.info,a&&m.unitRange<=c.hour){for(v=1,g=y.length-1;v<g;v++)p.dateFormat("%d",y[v])!==p.dateFormat("%d",y[v-1])&&(n[y[v]]="day",x=!0);x&&(n[y[0]]="day"),m.higherRanks=n}m.segmentStarts=u,y.info=m}else h(12,!1,this.chart);if(a&&l(d)){let t=y.length,e=[],s=[],o,r,a,l,h,p=t;for(;p--;)r=this.translate(y[p]),a&&(s[p]=a-r),e[p]=a=r;for(s.sort(),(l=s[Math.floor(s.length/2)])<.6*d&&(l=null),p=y[t-1]>i?t-1:t,a=void 0;p--;)h=Math.abs(a-(r=e[p])),a&&h<.8*d&&(null===l||h<.8*l)?(n[y[p]]&&!n[y[p+1]]?(o=p+1,a=r):o=p,y.splice(o,1)):a=r}return y}function o(t){let e=this.ordinal.positions;if(!e)return t;let i=e.length-1,s;return(t<0?t=e[0]:t>i?t=e[i]:(i=Math.floor(t),s=t-i),void 0!==s&&void 0!==e[i])?e[i]+(s?s*(e[i+1]-e[i]):0):t}function g(t){let e=this.ordinal,i=this.old?this.old.min:this.min,s=this.old?this.old.transA:this.transA,o=e.getExtendedPositions();if(o&&o.length){let r=a((t-i)*s+this.minPixelPadding),n=a(e.getIndexOfPoint(r,o)),l=a(n%1);if(n>=0&&n<=o.length-1){let t=o[Math.floor(n)],e=o[Math.ceil(n)];return o[Math.floor(n)]+l*(e-t)}}return t}function f(e,i){let s=t.Additions.findIndexOf(e,i,!0);if(e[s]===i)return s;let o=(i-e[s])/(e[s+1]-e[s]);return s+o}function x(){this.ordinal||(this.ordinal=new t.Additions(this))}function m(){let{eventArgs:t,options:e}=this;if(this.isXAxis&&l(e.overscroll)&&0!==e.overscroll&&d(this.max)&&d(this.min)&&(this.options.ordinal&&!this.ordinal.originalOrdinalRange&&this.ordinal.getExtendedPositions(!1),this.max===this.dataMax&&(t?.trigger!=="pan"||this.isInternal)&&t?.trigger!=="navigator")){let i=this.ordinal.convertOverscroll(e.overscroll);this.max+=i,!this.isInternal&&l(this.userMin)&&t?.trigger!=="mousewheel"&&(this.min+=i)}}function b(){this.horiz&&!this.isDirty&&(this.isDirty=this.isOrdinal&&this.chart.navigator&&!this.chart.navigator.adaptToUpdatedData)}function v(){this.ordinal&&(this.ordinal.beforeSetTickPositions(),this.tickInterval=this.ordinal.postProcessTickInterval(this.tickInterval))}function y(t){let e=this.xAxis[0],i=e.ordinal.convertOverscroll(e.options.overscroll),s=t.originalEvent.chartX,o=this.options.chart.panning,r=!1;if(o&&"y"!==o.type&&e.options.ordinal&&e.series.length){let t,o;let a=this.mouseDownX,l=e.getExtremes(),h=l.dataMin,d=l.dataMax,p=l.min,c=l.max,u=this.hoverPoints,g=e.closestPointRange||e.ordinal&&e.ordinal.overscrollPointsRange,f=Math.round((a-s)/(e.translationSlope*(e.ordinal.slope||g))),x=e.ordinal.getExtendedPositions(),m={ordinal:{positions:x,extendedOrdinalPositions:x}},b=e.index2val,v=e.val2lin;if(p<=h&&f<0||c+i>=d&&f>0)return;m.ordinal.positions?Math.abs(f)>1&&(u&&u.forEach(function(t){t.setState()}),d>(o=m.ordinal.positions)[o.length-1]&&o.push(d),this.setFixedRange(c-p),(t=e.navigatorAxis.toFixedRange(void 0,void 0,b.apply(m,[v.apply(m,[p,!0])+f]),b.apply(m,[v.apply(m,[c,!0])+f]))).min>=Math.min(l.dataMin,p)&&t.max<=Math.max(d,c)+i&&e.setExtremes(t.min,t.max,!0,!1,{trigger:"pan"}),this.mouseDownX=s,n(this.container,{cursor:"move"})):r=!0}else r=!0;r||o&&/y/.test(o.type)?i&&(e.max=e.dataMax+i):t.preventDefault()}function M(){let t=this.xAxis;t&&t.options.ordinal&&(delete t.ordinal.index,delete t.ordinal.originalOrdinalRange)}function S(t,e){let i;let s=this.ordinal,o=s.positions,r=s.slope,a;if(!o)return t;let n=o.length;if(o[0]<=t&&o[n-1]>=t)i=f(o,t);else{if(!((a=s.getExtendedPositions&&s.getExtendedPositions())&&a.length))return t;let n=a.length;r||(r=(a[n-1]-a[0])/n);let l=f(a,o[0]);if(t>=a[0]&&t<=a[n-1])i=f(a,t)-l;else{if(!e)return t;i=t<a[0]?-l-(a[0]-t)/r:(t-a[n-1])/r+n-l}}return e?i:r*(i||0)+s.offset}t.compose=function(t,e,i){let a=t.prototype;return a.ordinal2lin||(a.getTimeTicks=s,a.index2val=o,a.lin2val=g,a.val2lin=S,a.ordinal2lin=a.val2lin,r(t,"afterInit",x),r(t,"foundExtremes",m),r(t,"afterSetScale",b),r(t,"initialAxisTranslation",v),r(i,"pan",y),r(e,"updatedData",M)),t};class A{constructor(t){this.index={},this.axis=t}beforeSetTickPositions(){let t=this.axis,e=t.ordinal,i=t.getExtremes(),s=i.min,o=i.max,r=t.brokenAxis?.hasBreaks,a=t.options.ordinal,n,l,h,d,c,u,g,f=[],x=Number.MAX_VALUE,m=!1,b=!1,v=!1;if(a||r){let i=0;if(t.series.forEach(function(t,e){if(l=[],e>0&&"highcharts-navigator-series"!==t.options.id&&t.processedXData.length>1&&(b=i!==t.processedXData[1]-t.processedXData[0]),i=t.processedXData[1]-t.processedXData[0],t.boosted&&(v=t.boosted),t.reserveSpace()&&(!1!==t.takeOrdinalPosition||r)&&(n=(f=f.concat(t.processedXData)).length,f.sort(function(t,e){return t-e}),x=Math.min(x,p(t.closestPointRange,x)),n)){for(e=0;e<n-1;)f[e]!==f[e+1]&&l.push(f[e+1]),e++;l[0]!==f[0]&&l.unshift(f[0]),f=l}}),t.ordinal.originalOrdinalRange||(t.ordinal.originalOrdinalRange=(f.length-1)*x),b&&v&&(f.pop(),f.shift()),(n=f.length)>2){for(h=f[1]-f[0],g=n-1;g--&&!m;)f[g+1]-f[g]!==h&&(m=!0);!t.options.keepOrdinalPadding&&(f[0]-s>h||o-f[f.length-1]>h)&&(m=!0)}else t.options.overscroll&&(2===n?x=f[1]-f[0]:1===n?(x=t.ordinal.convertOverscroll(t.options.overscroll),f=[f[0],f[0]+x]):x=e.overscrollPointsRange);m||t.forceOrdinal?(t.options.overscroll&&(e.overscrollPointsRange=x,f=f.concat(e.getOverscrollPositions())),e.positions=f,d=t.ordinal2lin(Math.max(s,f[0]),!0),c=Math.max(t.ordinal2lin(Math.min(o,f[f.length-1]),!0),1),e.slope=u=(o-s)/(c-d),e.offset=s-d*u):(e.overscrollPointsRange=p(t.closestPointRange,e.overscrollPointsRange),e.positions=t.ordinal.slope=e.offset=void 0)}t.isOrdinal=a&&m,e.groupIntervalFactor=null}static findIndexOf(t,e,i){let s=0,o=t.length-1,r;for(;s<o;)t[r=Math.ceil((s+o)/2)]<=e?s=r:o=r-1;return t[s]===e?s:i?s:-1}getExtendedPositions(t=!0){let s=this,o=s.axis,r=o.constructor.prototype,a=o.chart,n=o.series[0]?.currentDataGrouping,l=n?n.count+n.unitName:"raw",h=t?o.ordinal.convertOverscroll(o.options.overscroll):0,d=o.getExtremes(),p,c,u=s.index;return u||(u=s.index={}),u[l]||((p={series:[],chart:a,forceOrdinal:!1,getExtremes:function(){return{min:d.dataMin,max:d.dataMax+h}},applyGrouping:r.applyGrouping,getGroupPixelWidth:r.getGroupPixelWidth,getTimeTicks:r.getTimeTicks,options:{ordinal:!0},ordinal:{getGroupIntervalFactor:this.getGroupIntervalFactor},ordinal2lin:r.ordinal2lin,getIndexOfPoint:r.getIndexOfPoint,val2lin:r.val2lin}).ordinal.axis=p,o.series.forEach(function(o){c={xAxis:p,xData:o.xData.slice(),chart:a,groupPixelWidth:o.groupPixelWidth,destroyGroupedData:e.noop,getProcessedData:i.prototype.getProcessedData,applyGrouping:i.prototype.applyGrouping,reserveSpace:i.prototype.reserveSpace,visible:o.visible},t&&(c.xData=c.xData.concat(s.getOverscrollPositions())),c.options={dataGrouping:n?{firstAnchor:o.options.dataGrouping?.firstAnchor,anchor:o.options.dataGrouping?.anchor,lastAnchor:o.options.dataGrouping?.firstAnchor,enabled:!0,forced:!0,approximation:"open",units:[[n.unitName,[n.count]]]}:{enabled:!1}},p.series.push(c),o.processData.apply(c)}),p.applyGrouping({hasExtremesChanged:!0}),c?.closestPointRange!==c?.basePointRange&&c.currentDataGrouping&&(p.forceOrdinal=!0),o.ordinal.beforeSetTickPositions.apply({axis:p}),!o.ordinal.originalOrdinalRange&&p.ordinal.originalOrdinalRange&&(o.ordinal.originalOrdinalRange=p.ordinal.originalOrdinalRange),u[l]=p.ordinal.positions),u[l]}getGroupIntervalFactor(t,e,i){let s=i.processedXData,o=s.length,r=[],a,n,l=this.groupIntervalFactor;if(!l){for(n=0;n<o-1;n++)r[n]=s[n+1]-s[n];r.sort(function(t,e){return t-e}),a=r[Math.floor(o/2)],t=Math.max(t,s[0]),e=Math.min(e,s[o-1]),this.groupIntervalFactor=l=o*a/(e-t)}return l}getIndexOfPoint(t,e){let i;let s=this.axis,o=0,r=function(t){let{min:e,max:i}=s;return!!(l(e)&&l(i))&&t.points.some(t=>t.x>=e&&t.x<=i)};s.series.forEach(t=>{let e=t.points?.[0];l(e?.plotX)&&(e.plotX<i||!l(i))&&r(t)&&(i=e.plotX,o=e.x)}),i??(i=s.minPixelPadding);let n=s.translationSlope*(this.slope||s.closestPointRange||this.overscrollPointsRange),h=a((t-i)/n);return A.findIndexOf(e,o,!0)+h}getOverscrollPositions(){let t=this.axis,e=this.convertOverscroll(t.options.overscroll),i=this.overscrollPointsRange,s=[],o=t.dataMax;if(l(i))for(;o<=t.dataMax+e;)s.push(o+=i);return s}postProcessTickInterval(t){let e=this.axis,i=this.slope;return i?e.options.breaks?e.closestPointRange||t:t/(i/e.closestPointRange):t}convertOverscroll(t=0){let e=this,i=e.axis,s=function(t){return p(e.originalOrdinalRange,l(i.dataMax)&&l(i.dataMin)?i.dataMax-i.dataMin:0)*t};if(u(t)){let e=parseInt(t,10);if(/%$/.test(t))return s(e/100);if(/px/.test(t)){let t=Math.min(e,.9*i.len)/i.len;return s(t/(1-t))}return 0}return t}}t.Additions=A}(o||(o={})),o}),i(e,"Stock/RangeSelector/RangeSelectorDefaults.js",[],function(){return{lang:{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"→"},rangeSelector:{allButtonsEnabled:!1,buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%e %b %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:"#334eff",cursor:"pointer",fontSize:"0.8em"},labelStyle:{color:"#666666",fontSize:"0.8em"}}}}),i(e,"Stock/RangeSelector/RangeSelectorComposition.js",[e["Core/Defaults.js"],e["Core/Globals.js"],e["Stock/RangeSelector/RangeSelectorDefaults.js"],e["Core/Utilities.js"]],function(t,e,i,s){let o;let{defaultOptions:r}=t,{composed:a}=e,{addEvent:n,defined:l,extend:h,find:d,isNumber:p,merge:c,pick:u,pushUnique:g}=s,f=[];function x(){let t,e;let i=this.range,s=i.type,o=this.max,r=this.chart.time,a=function(t,e){let i="year"===s?"FullYear":"Month",o=new r.Date(t),a=r.get(i,o);return r.set(i,o,a+e),a===r.get(i,o)&&r.set("Date",o,0),o.getTime()-t};p(i)?(t=o-i,e=i):i&&(t=o+a(o,-(i.count||1)),this.chart&&this.chart.setFixedRange(o-t));let n=u(this.dataMin,Number.MIN_VALUE);return p(t)||(t=n),t<=n&&(t=n,void 0===e&&(e=a(t,i.count)),this.newMax=Math.min(t+e,u(this.dataMax,Number.MAX_VALUE))),p(o)?!p(i)&&i&&i._offsetMin&&(t+=i._offsetMin):t=void 0,t}function m(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new o(this))}function b(){let t=this.axes,e=this.rangeSelector;if(e){p(e.deferredYTDClick)&&(e.clickButton(e.deferredYTDClick),delete e.deferredYTDClick),t.forEach(t=>{t.updateNames(),t.setScale()}),this.getAxisMargins(),e.render();let i=e.options.verticalAlign;e.options.floating||("bottom"===i?this.extraBottomMargin=!0:"middle"===i||(this.extraTopMargin=!0))}}function v(t){let e,i,s,o;let r=t.rangeSelector,a=()=>{r&&(e=t.xAxis[0].getExtremes(),i=t.legend,o=r&&r.options.verticalAlign,p(e.min)&&r.render(e.min,e.max),i.display&&"top"===o&&o===i.options.verticalAlign&&(s=c(t.spacingBox),"vertical"===i.options.layout?s.y=t.plotTop:s.y+=r.getHeight(),i.group.placed=!1,i.align(s)))};r&&(d(f,e=>e[0]===t)||f.push([t,[n(t.xAxis[0],"afterSetExtremes",function(t){r&&r.render(t.min,t.max)}),n(t,"redraw",a)]]),a())}function y(){for(let t=0,e=f.length;t<e;++t){let e=f[t];if(e[0]===this){e[1].forEach(t=>t()),f.splice(t,1);return}}}function M(){let t=this.rangeSelector;if(t){let e=t.getHeight();this.extraTopMargin&&(this.plotTop+=e),this.extraBottomMargin&&(this.marginBottom+=e)}}function S(){let t=this.rangeSelector;if(t&&!t.options.floating){t.render();let e=t.options.verticalAlign;"bottom"===e?this.extraBottomMargin=!0:"middle"!==e&&(this.extraTopMargin=!0)}}function A(t){let e=t.options.rangeSelector,i=this.extraBottomMargin,s=this.extraTopMargin,r=this.rangeSelector;if(e&&e.enabled&&!l(r)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=r=new o(this)),this.extraBottomMargin=!1,this.extraTopMargin=!1,r){v(this);let t=e&&e.verticalAlign||r.options&&r.options.verticalAlign;r.options.floating||("bottom"===t?this.extraBottomMargin=!0:"middle"===t||(this.extraTopMargin=!0)),(this.extraBottomMargin!==i||this.extraTopMargin!==s)&&(this.isDirtyBox=!0)}}return{compose:function(t,e,s){if(o=s,g(a,"RangeSelector")){let s=e.prototype;t.prototype.minFromRange=x,n(e,"afterGetContainer",m),n(e,"beforeRender",b),n(e,"destroy",y),n(e,"getMargins",M),n(e,"render",S),n(e,"update",A),s.callbacks.push(v),h(r,{rangeSelector:i.rangeSelector}),h(r.lang,i.lang)}}}}),i(e,"Stock/RangeSelector/RangeSelector.js",[e["Core/Axis/Axis.js"],e["Core/Defaults.js"],e["Core/Globals.js"],e["Stock/RangeSelector/RangeSelectorComposition.js"],e["Core/Renderer/SVG/SVGElement.js"],e["Core/Utilities.js"]],function(t,e,i,s,o,r){let{defaultOptions:a}=e,{addEvent:n,createElement:l,css:h,defined:d,destroyObjectProperties:p,discardElement:c,extend:u,fireEvent:g,isNumber:f,merge:x,objectEach:m,pad:b,pick:v,pInt:y,splat:M}=r;class S{static compose(t,e){s.compose(t,e,S)}constructor(t){this.buttonOptions=S.prototype.defaultButtons,this.initialButtonGroupWidth=0,this.chart=t,this.init(t)}clickButton(e,i){let s=this.chart,o=this.buttonOptions[e],r=s.xAxis[0],a=s.scroller&&s.scroller.getUnionExtremes()||r||{},l=o.type,h=o.dataGrouping,p=a.dataMin,c=a.dataMax,u,x=r&&Math.round(Math.min(r.max,v(c,r.max))),m,b=o._range,y,S,A,k,C,D=!0;if(null!==p&&null!==c){if(this.setSelected(e),h&&(this.forcedDataGrouping=!0,t.prototype.setDataGrouping.call(r||{chart:this.chart},h,!1),this.frozenStates=o.preserveDataGrouping),"month"===l||"year"===l)r?(k={range:o,max:x,chart:s,dataMin:p,dataMax:c},u=r.minFromRange.call(k),f(k.newMax)&&(x=k.newMax),D=!1):b=o;else if(b)x=Math.min((u=Math.max(x-b,p))+b,c),D=!1;else if("ytd"===l){if(r)(void 0===c||void 0===p)&&(p=Number.MAX_VALUE,c=Number.MIN_VALUE,s.series.forEach(t=>{let e=t.xData;e&&(p=Math.min(e[0],p),c=Math.max(e[e.length-1],c))}),i=!1),u=y=(C=this.getYTDExtremes(c,p,s.time.useUTC)).min,x=C.max;else{this.deferredYTDClick=e;return}}else"all"===l&&r&&(s.navigator&&s.navigator.baseSeries[0]&&(s.navigator.baseSeries[0].xAxis.options.range=void 0),u=p,x=c);D&&o._offsetMin&&d(u)&&(u+=o._offsetMin),o._offsetMax&&d(x)&&(x+=o._offsetMax),this.dropdown&&(this.dropdown.selectedIndex=e+1),r?(r.setExtremes(u,x,v(i,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:o}),s.setFixedRange(o._range)):(A=(m=M(s.options.xAxis)[0]).range,m.range=b,S=m.min,m.min=y,n(s,"load",function(){s.setFixedRange(o._range),m.range=A,m.min=S})),g(this,"afterBtnClick")}}setSelected(t){this.selected=this.options.selected=t}init(t){let e=this,i=t.options.rangeSelector,s=i.buttons||e.defaultButtons.slice(),o=i.selected,r=function(){let t=e.minInput,i=e.maxInput;t&&t.blur&&g(t,"blur"),i&&i.blur&&g(i,"blur")};e.chart=t,e.options=i,e.buttons=[],e.buttonOptions=s,this.eventsToUnbind=[],this.eventsToUnbind.push(n(t.container,"mousedown",r)),this.eventsToUnbind.push(n(t,"resize",r)),s.forEach(e.computeButtonRange),void 0!==o&&s[o]&&this.clickButton(o,!1),this.eventsToUnbind.push(n(t,"load",function(){t.xAxis&&t.xAxis[0]&&n(t.xAxis[0],"setExtremes",function(i){f(this.max)&&f(this.min)&&this.max-this.min!==t.fixedRange&&"rangeSelectorButton"!==i.trigger&&"updatedData"!==i.trigger&&e.forcedDataGrouping&&!e.frozenStates&&this.setDataGrouping(!1,!1)})}))}updateButtonStates(){let t=this,e=this.chart,i=this.dropdown,s=e.xAxis[0],o=Math.round(s.max-s.min),r=!s.hasVisibleSeries,a=24*36e5,n=e.scroller&&e.scroller.getUnionExtremes()||s,l=n.dataMin,h=n.dataMax,p=t.getYTDExtremes(h,l,e.time.useUTC),c=p.min,u=p.max,g=t.selected,x=t.options.allButtonsEnabled,m=t.buttons,b=f(g),v=!1;t.buttonOptions.forEach((e,n)=>{let p=e._range,f=e.type,y=e.count||1,M=m[n],S=e._offsetMax-e._offsetMin,A=n===g,k=p>h-l,C=p<s.minRange,D=0,w=!1,O=!1,B=p===o;if(A&&k&&(v=!0),s.isOrdinal&&s.ordinal?.positions&&p&&o<p){let t=s.ordinal.positions;t[t.length-1]-t[0]>p&&(B=!0)}else("month"===f||"year"===f)&&o+36e5>=({month:28,year:365})[f]*a*y-S&&o-36e5<=({month:31,year:366})[f]*a*y+S?B=!0:"ytd"===f?(B=u-c+S===o,w=!A):"all"===f&&(B=s.max-s.min>=h-l,O=!A&&b&&B);let E=!x&&!(v&&"all"===f)&&(k||C||O||r),T=v&&"all"===f||A&&B||B&&!b&&!w||A&&t.frozenStates;E?D=3:T&&(b=!0,D=2),M.state!==D&&(M.setState(D),i&&(i.options[n+1].disabled=E,2===D&&(i.selectedIndex=n+1)),0===D&&g===n?t.setSelected():(2===D&&!d(g)||v)&&t.setSelected(n))})}computeButtonRange(t){let e=t.type,i=t.count||1,s={millisecond:1,second:1e3,minute:6e4,hour:36e5,day:864e5,week:6048e5};s[e]?t._range=s[e]*i:("month"===e||"year"===e)&&(t._range=24*({month:30,year:365})[e]*36e5*i),t._offsetMin=v(t.offsetMin,0),t._offsetMax=v(t.offsetMax,0),t._range+=t._offsetMax-t._offsetMin}getInputValue(t){let e="min"===t?this.minInput:this.maxInput,i=this.chart.options.rangeSelector,s=this.chart.time;return e?("text"===e.type&&i.inputDateParser||this.defaultInputDateParser)(e.value,s.useUTC,s):0}setInputValue(t,e){let i=this.options,s=this.chart.time,o="min"===t?this.minInput:this.maxInput,r="min"===t?this.minDateBox:this.maxDateBox;if(o){let t=o.getAttribute("data-hc-time"),a=d(t)?Number(t):void 0;if(d(e)){let t=a;d(t)&&o.setAttribute("data-hc-time-previous",t),o.setAttribute("data-hc-time",e),a=e}o.value=s.dateFormat(this.inputTypeFormats[o.type]||i.inputEditDateFormat,a),r&&r.attr({text:s.dateFormat(i.inputDateFormat,a)})}}setInputExtremes(t,e,i){let s="min"===t?this.minInput:this.maxInput;if(s){let t=this.inputTypeFormats[s.type],o=this.chart.time;if(t){let r=o.dateFormat(t,e);s.min!==r&&(s.min=r);let a=o.dateFormat(t,i);s.max!==a&&(s.max=a)}}}showInput(t){let e="min"===t?this.minDateBox:this.maxDateBox,i="min"===t?this.minInput:this.maxInput;if(i&&e&&this.inputGroup){let t="text"===i.type,{translateX:s=0,translateY:o=0}=this.inputGroup,{x:r=0,width:a=0,height:n=0}=e,{inputBoxWidth:l}=this.options;h(i,{width:t?a+(l?-2:20)+"px":"auto",height:n-2+"px",border:"2px solid silver"}),t&&l?h(i,{left:s+r+"px",top:o+"px"}):h(i,{left:Math.min(Math.round(r+s-(i.offsetWidth-a)/2),this.chart.chartWidth-i.offsetWidth)+"px",top:o-(i.offsetHeight-n)/2+"px"})}}hideInput(t){let e="min"===t?this.minInput:this.maxInput;e&&h(e,{top:"-9999em",border:0,width:"1px",height:"1px"})}defaultInputDateParser(t,e,s){let o=t.split("/").join("-").split(" ").join("T");if(-1===o.indexOf("T")&&(o+="T00:00"),e)o+="Z";else{let t;if(i.isSafari&&!((t=o).length>6&&(t.lastIndexOf("-")===t.length-6||t.lastIndexOf("+")===t.length-6))){let t=new Date(o).getTimezoneOffset()/60;o+=t<=0?`+${b(-t)}:00`:`-${b(t)}:00`}}let r=Date.parse(o);if(!f(r)){let e=t.split("-");r=Date.UTC(y(e[0]),y(e[1])-1,y(e[2]))}return s&&e&&f(r)&&(r+=s.getTimezoneOffset(r)),r}drawInput(t){let{chart:e,div:s,inputGroup:o}=this,r=this,n=e.renderer.style||{},d=e.renderer,p=e.options.rangeSelector,c=a.lang,g="min"===t;function m(){let{maxInput:i,minInput:s}=r,o=e.xAxis[0],a=e.scroller&&e.scroller.getUnionExtremes()||o,n=a.dataMin,l=a.dataMax,h=r.getInputValue(t);h!==Number(M.getAttribute("data-hc-time-previous"))&&f(h)&&(M.setAttribute("data-hc-time-previous",h),g&&i&&f(n)?h>Number(i.getAttribute("data-hc-time"))?h=void 0:h<n&&(h=n):s&&f(l)&&(h<Number(s.getAttribute("data-hc-time"))?h=void 0:h>l&&(h=l)),void 0!==h&&o.setExtremes(g?h:o.min,g?o.max:h,void 0,void 0,{trigger:"rangeSelectorInput"}))}let b=c[g?"rangeSelectorFrom":"rangeSelectorTo"]||"",v=d.label(b,0).addClass("highcharts-range-label").attr({padding:b?2:0,height:b?p.inputBoxHeight:0}).add(o),y=d.label("",0).addClass("highcharts-range-input").attr({padding:2,width:p.inputBoxWidth,height:p.inputBoxHeight,"text-align":"center"}).on("click",function(){r.showInput(t),r[t+"Input"].focus()});e.styledMode||y.attr({stroke:p.inputBoxBorderColor,"stroke-width":1}),y.add(o);let M=l("input",{name:t,className:"highcharts-range-selector"},void 0,s);M.setAttribute("type",function(t){if(-1!==t.indexOf("%L"))return"text";let e=["a","A","d","e","w","b","B","m","o","y","Y"].some(e=>-1!==t.indexOf("%"+e)),i=["H","k","I","l","M","S"].some(e=>-1!==t.indexOf("%"+e));return e&&i?"datetime-local":e?"date":i?"time":"text"}(p.inputDateFormat||"%e %b %Y")),e.styledMode||(v.css(x(n,p.labelStyle)),y.css(x({color:"#333333"},n,p.inputStyle)),h(M,u({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:n.fontSize,fontFamily:n.fontFamily,top:"-9999em"},p.inputStyle))),M.onfocus=()=>{r.showInput(t)},M.onblur=()=>{M===i.doc.activeElement&&m(),r.hideInput(t),r.setInputValue(t),M.blur()};let S=!1;return M.onchange=()=>{S||(m(),r.hideInput(t),M.blur())},M.onkeypress=t=>{13===t.keyCode&&m()},M.onkeydown=t=>{S=!0,(38===t.keyCode||40===t.keyCode)&&m()},M.onkeyup=()=>{S=!1},{dateBox:y,input:M,label:v}}getPosition(){let t=this.chart,e=t.options.rangeSelector,i="top"===e.verticalAlign?t.plotTop-t.axisOffset[0]:0;return{buttonTop:i+e.buttonPosition.y,inputTop:i+e.inputPosition.y-10}}getYTDExtremes(t,e,i){let s=this.chart.time,o=new s.Date(t),r=s.get("FullYear",o),a=i?s.Date.UTC(r,0,1):+new s.Date(r,0,1),n=o.getTime();return{max:Math.min(t||n,n),min:Math.max(e,a)}}render(t,e){let i=this.chart,s=i.renderer,o=i.container,r=i.options,a=r.rangeSelector,n=v(r.chart.style&&r.chart.style.zIndex,0)+1,h=a.inputEnabled,p=this.rendered;if(!1!==a.enabled){if(!p&&(this.group=s.g("range-selector-group").attr({zIndex:7}).add(),this.div=l("div",void 0,{position:"relative",height:0,zIndex:n}),this.buttonOptions.length&&this.renderButtons(),o.parentNode&&o.parentNode.insertBefore(this.div,o),h)){this.inputGroup=s.g("input-group").add(this.group);let t=this.drawInput("min");this.minDateBox=t.dateBox,this.minLabel=t.label,this.minInput=t.input;let e=this.drawInput("max");this.maxDateBox=e.dateBox,this.maxLabel=e.label,this.maxInput=e.input}if(h){this.setInputValue("min",t),this.setInputValue("max",e);let s=i.scroller&&i.scroller.getUnionExtremes()||i.xAxis[0]||{};if(d(s.dataMin)&&d(s.dataMax)){let t=i.xAxis[0].minRange||0;this.setInputExtremes("min",s.dataMin,Math.min(s.dataMax,this.getInputValue("max"))-t),this.setInputExtremes("max",Math.max(s.dataMin,this.getInputValue("min"))+t,s.dataMax)}if(this.inputGroup){let t=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(e=>{if(e){let{width:i}=e.getBBox();i&&(e.attr({x:t}),t+=i+a.inputSpacing)}})}}this.alignElements(),this.rendered=!0}}renderButtons(){let{buttons:t,chart:e,options:s}=this,o=a.lang,r=e.renderer,h=x(s.buttonTheme),d=h&&h.states,p=h.width||28;delete h.width,delete h.states,this.buttonGroup=r.g("range-selector-buttons").add(this.group);let c=this.dropdown=l("select",void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:1e-4},this.div);n(c,"touchstart",()=>{c.style.fontSize="16px"}),[[i.isMS?"mouseover":"mouseenter"],[i.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(([e,i])=>{n(c,e,()=>{let s=t[this.currentButtonIndex()];s&&g(s.element,i||e)})}),this.zoomText=r.label(o&&o.rangeSelectorZoom||"",0).attr({padding:s.buttonTheme.padding,height:s.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup),this.chart.styledMode||(this.zoomText.css(s.labelStyle),h["stroke-width"]=v(h["stroke-width"],0)),l("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,c),this.buttonOptions.forEach((e,i)=>{l("option",{textContent:e.title||e.text},void 0,c),t[i]=r.button(e.text,0,0,t=>{let s;let o=e.events&&e.events.click;o&&(s=o.call(e,t)),!1!==s&&this.clickButton(i),this.isActive=!0},h,d&&d.hover,d&&d.select,d&&d.disabled).attr({"text-align":"center",width:p}).add(this.buttonGroup),e.title&&t[i].attr("title",e.title)})}alignElements(){let{buttonGroup:t,buttons:e,chart:i,group:s,inputGroup:o,options:r,zoomText:a}=this,n=i.options,l=n.exporting&&!1!==n.exporting.enabled&&n.navigation&&n.navigation.buttonOptions,{buttonPosition:h,inputPosition:d,verticalAlign:p}=r,c=(t,e)=>l&&this.titleCollision(i)&&"top"===p&&"right"===e.align&&e.y-t.getBBox().height-12<(l.y||0)+(l.height||0)+i.spacing[0]?-40:0,u=i.plotLeft;if(s&&h&&d){let n=h.x-i.spacing[3];if(t){if(this.positionButtons(),!this.initialButtonGroupWidth){let t=0;a&&(t+=a.getBBox().width+5),e.forEach((i,s)=>{t+=i.width||0,s!==e.length-1&&(t+=r.buttonSpacing)}),this.initialButtonGroupWidth=t}u-=i.spacing[3],this.updateButtonStates();let o=c(t,h);this.alignButtonGroup(o),s.placed=t.placed=i.hasLoaded}let l=0;o&&(l=c(o,d),"left"===d.align?n=u:"right"===d.align&&(n=-Math.max(i.axisOffset[1],-l)),o.align({y:d.y,width:o.getBBox().width,align:d.align,x:d.x+n-2},!0,i.spacingBox),o.placed=i.hasLoaded),this.handleCollision(l),s.align({verticalAlign:p},!0,i.spacingBox);let g=s.alignAttr.translateY,f=s.getBBox().height+20,x=0;if("bottom"===p){let t=i.legend&&i.legend.options;x=g-(f=f+(t&&"bottom"===t.verticalAlign&&t.enabled&&!t.floating?i.legend.legendHeight+v(t.margin,10):0)-20)-(r.floating?0:r.y)-(i.titleOffset?i.titleOffset[2]:0)-10}"top"===p?(r.floating&&(x=0),i.titleOffset&&i.titleOffset[0]&&(x=i.titleOffset[0]),x+=i.margin[0]-i.spacing[0]||0):"middle"===p&&(d.y===h.y?x=g:(d.y||h.y)&&(d.y<0||h.y<0?x-=Math.min(d.y,h.y):x=g-f)),s.translate(r.x,r.y+Math.floor(x));let{minInput:m,maxInput:b,dropdown:y}=this;r.inputEnabled&&m&&b&&(m.style.marginTop=s.translateY+"px",b.style.marginTop=s.translateY+"px"),y&&(y.style.marginTop=s.translateY+"px")}}alignButtonGroup(t,e){let{chart:i,options:s,buttonGroup:o}=this,{buttonPosition:r}=s,a=i.plotLeft-i.spacing[3],n=r.x-i.spacing[3];"right"===r.align?n+=t-a:"center"===r.align&&(n-=a/2),o&&o.align({y:r.y,width:v(e,this.initialButtonGroupWidth),align:r.align,x:n},!0,i.spacingBox)}positionButtons(){let{buttons:t,chart:e,options:i,zoomText:s}=this,o=e.hasLoaded?"animate":"attr",{buttonPosition:r}=i,a=e.plotLeft,n=a;s&&"hidden"!==s.visibility&&(s[o]({x:v(a+r.x,a)}),n+=r.x+s.getBBox().width+5);for(let e=0,s=this.buttonOptions.length;e<s;++e)"hidden"!==t[e].visibility?(t[e][o]({x:n}),n+=(t[e].width||0)+i.buttonSpacing):t[e][o]({x:a})}handleCollision(t){let{chart:e,buttonGroup:i,inputGroup:s}=this,{buttonPosition:o,dropdown:r,inputPosition:a}=this.options,n=()=>{let t=0;return this.buttons.forEach(e=>{let i=e.getBBox();i.width>t&&(t=i.width)}),t},l=e=>{if(s&&i){let r=s.alignAttr.translateX+s.alignOptions.x-t+s.getBBox().x+2,n=s.alignOptions.width,l=i.alignAttr.translateX+i.getBBox().x;return l+e>r&&r+n>l&&o.y<a.y+s.getBBox().height}return!1},h=()=>{s&&i&&s.attr({translateX:s.alignAttr.translateX+(e.axisOffset[1]>=-t?0:-t),translateY:s.alignAttr.translateY+i.getBBox().height+10})};if(i){if("always"===r){this.collapseButtons(t),l(n())&&h();return}"never"===r&&this.expandButtons()}s&&i?a.align===o.align||l(this.initialButtonGroupWidth+20)?"responsive"===r?(this.collapseButtons(t),l(n())&&h()):h():"responsive"===r&&this.expandButtons():i&&"responsive"===r&&(this.initialButtonGroupWidth>e.plotWidth?this.collapseButtons(t):this.expandButtons())}collapseButtons(t){let{buttons:e,buttonOptions:i,chart:s,dropdown:o,options:r,zoomText:a}=this;if(!0===this.isCollapsed)return;this.isCollapsed=!0;let n=s.userOptions.rangeSelector&&s.userOptions.rangeSelector.buttonTheme||{},l=t=>({text:t?`${t} ▾`:"▾",width:"auto",paddingLeft:v(r.buttonTheme.paddingLeft,n.padding,8),paddingRight:v(r.buttonTheme.paddingRight,n.padding,8)});a&&a.hide();let h=!1;i.forEach((t,i)=>{let s=e[i];2!==s.state?s.hide():(s.show(),s.attr(l(t.text)),h=!0)}),h||(o&&(o.selectedIndex=0),e[0].show(),e[0].attr(l(this.zoomText&&this.zoomText.textStr)));let{align:d}=r.buttonPosition;this.positionButtons(),("right"===d||"center"===d)&&this.alignButtonGroup(t,e[this.currentButtonIndex()].getBBox().width),this.showDropdown()}expandButtons(){let{buttons:t,buttonOptions:e,options:i,zoomText:s}=this;this.hideDropdown(),!1!==this.isCollapsed&&(this.isCollapsed=!1,s&&s.show(),e.forEach((e,s)=>{let o=t[s];o.show(),o.attr({text:e.text,width:i.buttonTheme.width||28,paddingLeft:v(i.buttonTheme.paddingLeft,"unset"),paddingRight:v(i.buttonTheme.paddingRight,"unset")}),o.state<2&&o.setState(0)}),this.positionButtons())}currentButtonIndex(){let{dropdown:t}=this;return t&&t.selectedIndex>0?t.selectedIndex-1:0}showDropdown(){let{buttonGroup:t,buttons:e,chart:i,dropdown:s}=this;if(t&&s){let{translateX:o=0,translateY:r=0}=t,a=e[this.currentButtonIndex()].getBBox();h(s,{left:i.plotLeft+o+"px",top:r+.5+"px",width:a.width+"px",height:a.height+"px"}),this.hasVisibleDropdown=!0}}hideDropdown(){let{dropdown:t}=this;t&&(h(t,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)}getHeight(){let t=this.options,e=this.group,i=t.inputPosition,s=t.buttonPosition,o=t.y,r=s.y,a=i.y,n=0;return t.height?t.height:(this.alignElements(),n=e?e.getBBox(!0).height+13+o:0,(a<0&&r<0||a>0&&r>0)&&(n+=Math.abs(Math.min(a,r))),n)}titleCollision(t){return!(t.options.title.text||t.options.subtitle.text)}update(t){let e=this.chart;x(!0,e.options.rangeSelector,t),this.destroy(),this.init(e),this.render()}destroy(){let t=this,e=t.minInput,i=t.maxInput;t.eventsToUnbind&&(t.eventsToUnbind.forEach(t=>t()),t.eventsToUnbind=void 0),p(t.buttons),e&&(e.onfocus=e.onblur=e.onchange=null),i&&(i.onfocus=i.onblur=i.onchange=null),m(t,function(e,i){e&&"chart"!==i&&(e instanceof o?e.destroy():e instanceof window.HTMLElement&&c(e)),e!==S.prototype[i]&&(t[i]=null)},this)}}return u(S.prototype,{defaultButtons:[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}],inputTypeFormats:{"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",time:"%H:%M:%S"}}),S}),i(e,"Core/Chart/StockChart.js",[e["Core/Chart/Chart.js"],e["Core/Templating.js"],e["Core/Defaults.js"],e["Stock/Navigator/NavigatorDefaults.js"],e["Stock/RangeSelector/RangeSelectorDefaults.js"],e["Stock/Scrollbar/ScrollbarDefaults.js"],e["Stock/Utilities/StockUtilities.js"],e["Core/Utilities.js"]],function(t,e,i,s,o,r,a,n){let{format:l}=e,{getOptions:h}=i,{setFixedRange:d}=a,{addEvent:p,clamp:c,defined:u,extend:g,find:f,isNumber:x,isString:m,merge:b,pick:v,splat:y}=n;function M(t,e,i){return"xAxis"===t?{minPadding:0,maxPadding:0,overscroll:0,ordinal:!0}:"yAxis"===t?{labels:{y:-2},opposite:i.opposite??e.opposite??!0,showLastLabel:!!(e.categories||"category"===e.type),title:{text:i.title?.text!=="Values"?i.title?.text:null}}:{}}function S(t,e){if("xAxis"===t){let t=v(e.navigator&&e.navigator.enabled,s.enabled,!0),i={type:"datetime",categories:void 0};return t&&(i.startOnTick=!1,i.endOnTick=!1),i}return{}}class A extends t{init(t,e){let i=h(),a=t.xAxis,n=t.yAxis,l=v(t.navigator&&t.navigator.enabled,s.enabled,!0);t.xAxis=t.yAxis=void 0;let d=b({chart:{panning:{enabled:!0,type:"x"},zooming:{pinchType:"x",mouseWheel:{type:"x"}}},navigator:{enabled:l},scrollbar:{enabled:v(r.enabled,!0)},rangeSelector:{enabled:v(o.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:v(i.tooltip&&i.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1}},t,{isStock:!0});t.xAxis=a,t.yAxis=n,d.xAxis=y(t.xAxis||{}).map(e=>b(M("xAxis",e,i.xAxis),e,S("xAxis",t))),d.yAxis=y(t.yAxis||{}).map(t=>b(M("yAxis",t,i.yAxis),t)),super.init(d,e)}createAxis(t,e){return e.axis=b(M(t,e.axis,h()[t]),e.axis,S(t,this.userOptions)),super.createAxis(t,e)}}return p(t,"update",function(t){let e=t.options;"scrollbar"in e&&this.navigator&&(b(!0,this.options.scrollbar,e.scrollbar),this.navigator.update({}),delete e.scrollbar)}),function(t){function e(t){if(!this.crosshair||!this.crosshair.label||!this.crosshair.label.enabled||!this.cross||!x(this.min)||!x(this.max))return;let e=this.chart,i=this.logarithmic,s=this.crosshair.label,o=this.horiz,r=this.opposite,a=this.left,n=this.top,h=this.width,d="inside"===this.options.tickPosition,p=!1!==this.crosshair.snap,c=t.e||this.cross&&this.cross.e,u=t.point,f=this.crossLabel,m,b,y=s.format,M="",S,A=0,k=this.min,C=this.max;i&&(k=i.lin2log(this.min),C=i.lin2log(this.max));let D=o?"center":r?"right"===this.labelAlign?"right":"left":"left"===this.labelAlign?"left":"center";f||(f=this.crossLabel=e.renderer.label("",0,void 0,s.shape||"callout").addClass("highcharts-crosshair-label highcharts-color-"+(u&&u.series?u.series.colorIndex:this.series[0]&&this.series[0].colorIndex)).attr({align:s.align||D,padding:v(s.padding,8),r:v(s.borderRadius,3),zIndex:2}).add(this.labelGroup),e.styledMode||f.attr({fill:s.backgroundColor||u&&u.series&&u.series.color||"#666666",stroke:s.borderColor||"","stroke-width":s.borderWidth||0}).css(g({color:"#ffffff",fontWeight:"normal",fontSize:"0.7em",textAlign:"center"},s.style||{}))),o?(m=p?(u.plotX||0)+a:c.chartX,b=n+(r?0:this.height)):(m=a+this.offset+(r?h:0),b=p?(u.plotY||0)+n:c.chartY),y||s.formatter||(this.dateTime&&(M="%b %d, %Y"),y="{value"+(M?":"+M:"")+"}");let w=p?this.isXAxis?u.x:u.y:this.toValue(o?c.chartX:c.chartY),O=u&&u.series?u.series.isPointInside(u):x(w)&&w>k&&w<C,B="";y?B=l(y,{value:w},e):s.formatter&&x(w)&&(B=s.formatter.call(this,w)),f.attr({text:B,x:m,y:b,visibility:O?"inherit":"hidden"});let E=f.getBBox();!x(f.x)||o||r||(m=f.x-E.width/2),x(f.y)&&(o?(d&&!r||!d&&r)&&(b=f.y-E.height):b=f.y-E.height/2),S=o?{left:a,right:a+this.width}:{left:"left"===this.labelAlign?a:0,right:"right"===this.labelAlign?a+this.width:e.chartWidth};let T=f.translateX||0;T<S.left&&(A=S.left-T),T+E.width>=S.right&&(A=-(T+E.width-S.right)),f.attr({x:m+A,y:b,anchorX:o?m:this.opposite?0:e.chartWidth,anchorY:o?this.opposite?e.chartHeight:0:b+E.height/2})}function i(){this.crossLabel&&(this.crossLabel=this.crossLabel.hide())}function s(t){let e=this.chart,i=this.options,s=e._labelPanes=e._labelPanes||{},o=i.labels;if(e.options.isStock&&"yAxis"===this.coll){let e=i.top+","+i.height;!s[e]&&o.enabled&&(15===o.distance&&1===this.side&&(o.distance=0),void 0===o.align&&(o.align="right"),s[e]=this,t.align="right",t.preventDefault())}}function o(){let t=this.chart,e=this.options&&this.options.top+","+this.options.height;e&&t._labelPanes&&t._labelPanes[e]===this&&delete t._labelPanes[e]}function r(t){let e=this,i=e.isLinked&&!e.series&&e.linkedParent?e.linkedParent.series:e.series,s=e.chart,o=s.renderer,r=e.left,a=e.top,n=[],l=t.translatedValue,h=t.value,d=t.force,p,g,b,y,M=[],S,A;if(s.options.isStock&&!1!==t.acrossPanes&&"xAxis"===e.coll||"yAxis"===e.coll){for(let o of(t.preventDefault(),M=(t=>{let o="xAxis"===t?"yAxis":"xAxis",r=e.options[o];return x(r)?[s[o][r]]:m(r)?[s.get(r)]:i.map(t=>t[o])})(e.coll),e.isXAxis?s.yAxis:s.xAxis))if(!u(o.options.id)||-1===o.options.id.indexOf("navigator")){let t=o.isXAxis?"yAxis":"xAxis";e===(u(o.options[t])?s[t][o.options[t]]:s[t][0])&&M.push(o)}for(let t of(S=M.length?[]:[e.isXAxis?s.yAxis[0]:s.xAxis[0]],M))-1!==S.indexOf(t)||f(S,e=>e.pos===t.pos&&e.len===t.len)||S.push(t);if(x(A=v(l,e.translate(h||0,void 0,void 0,t.old)))){if(e.horiz)for(let t of S){let i;y=(g=t.pos)+t.len,p=b=Math.round(A+e.transB),"pass"!==d&&(p<r||p>r+e.width)&&(d?p=b=c(p,r,r+e.width):i=!0),i||n.push(["M",p,g],["L",b,y])}else for(let t of S){let i;b=(p=t.pos)+t.len,g=y=Math.round(a+e.height-A),"pass"!==d&&(g<a||g>a+e.height)&&(d?g=y=c(g,a,a+e.height):i=!0),i||n.push(["M",p,g],["L",b,y])}}t.path=n.length>0?o.crispPolyLine(n,t.lineWidth||1):void 0}}function a(t){if(this.chart.options.isStock){let e;this.is("column")||this.is("columnrange")?e={borderWidth:0,shadow:!1}:this.is("scatter")||this.is("sma")||(e={marker:{enabled:!1,radius:2}}),e&&(t.plotOptions[this.type]=b(t.plotOptions[this.type],e))}}function n(){let t=this.chart,e=this.options.dataGrouping;return!1!==this.allowDG&&e&&v(e.enabled,t.options.isStock)}function h(t,e){for(let i=0;i<t.length;i+=2){let s=t[i],o=t[i+1];s[1]===o[1]&&(s[1]=o[1]=Math.round(s[1])-e%2/2),s[2]===o[2]&&(s[2]=o[2]=Math.round(s[2])+e%2/2)}return t}t.compose=function(t,l,c,u){let g=c.prototype;g.forceCropping||(p(l,"afterDrawCrosshair",e),p(l,"afterHideCrosshair",i),p(l,"autoLabelAlign",s),p(l,"destroy",o),p(l,"getPlotLinePath",r),t.prototype.setFixedRange=d,g.forceCropping=n,p(c,"setOptions",a),u.prototype.crispPolyLine=h)},t.stockChart=function(e,i,s){return new t(e,i,s)}}(A||(A={})),A}),i(e,"Series/HLC/HLCPoint.js",[e["Core/Series/SeriesRegistry.js"]],function(t){let{column:{prototype:{pointClass:e}}}=t.seriesTypes;return class extends e{}}),i(e,"Series/HLC/HLCSeriesDefaults.js",[],function(){return{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0}}),i(e,"Series/HLC/HLCSeries.js",[e["Series/HLC/HLCPoint.js"],e["Series/HLC/HLCSeriesDefaults.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,i,s){let{column:o}=i.seriesTypes,{extend:r,merge:a}=s;class n extends o{extendStem(t,e,i){let s=t[0],o=t[1];"number"==typeof s[2]&&(s[2]=Math.max(i+e,s[2])),"number"==typeof o[2]&&(o[2]=Math.min(i-e,o[2]))}getPointPath(t,e){let i=e.strokeWidth(),s=t.series,o=i%2/2,r=Math.round(t.plotX)-o,a=Math.round(t.shapeArgs.width/2),n=t.plotClose,l=[["M",r,Math.round(t.yBottom)],["L",r,Math.round(t.plotHigh)]];return null!==t.close&&(n=Math.round(t.plotClose)+o,l.push(["M",r,n],["L",r+a,n]),s.extendStem(l,i/2,n)),l}drawSinglePoint(t){let e=t.series,i=e.chart,s,o=t.graphic;void 0!==t.plotY&&(o||(t.graphic=o=i.renderer.path().add(e.group)),i.styledMode||o.attr(e.pointAttribs(t,t.selected&&"select")),s=e.getPointPath(t,o),o[o?"animate":"attr"]({d:s}).addClass(t.getClassName(),!0))}drawPoints(){this.points.forEach(this.drawSinglePoint)}init(){super.init.apply(this,arguments),this.options.stacking=void 0}pointAttribs(t,e){let i=super.pointAttribs.call(this,t,e);return delete i.fill,i}toYData(t){return[t.high,t.low,t.close]}translate(){let t=this,e=t.yAxis,i=this.pointArrayMap&&this.pointArrayMap.slice()||[],s=i.map(t=>`plot${t.charAt(0).toUpperCase()+t.slice(1)}`);s.push("yBottom"),i.push("low"),super.translate.apply(t),t.points.forEach(function(o){i.forEach(function(i,r){let a=o[i];null!==a&&(t.dataModify&&(a=t.dataModify.modifyValue(a)),o[s[r]]=e.toPixels(a,!0))}),o.tooltipPos[1]=o.plotHigh+e.pos-t.chart.plotTop})}}return n.defaultOptions=a(o.defaultOptions,e),r(n.prototype,{pointClass:t,animate:null,directTouch:!1,pointArrayMap:["high","low","close"],pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},pointValKey:"close"}),i.registerSeriesType("hlc",n),n}),i(e,"Series/OHLC/OHLCPoint.js",[e["Core/Series/SeriesRegistry.js"]],function(t){let{seriesTypes:{hlc:e}}=t;class i extends e.prototype.pointClass{getClassName(){return super.getClassName.call(this)+(this.open<this.close?" highcharts-point-up":" highcharts-point-down")}resolveUpColor(){this.open<this.close&&!this.options.color&&this.series.options.upColor&&(this.color=this.series.options.upColor)}resolveColor(){super.resolveColor(),this.series.is("heikinashi")||this.resolveUpColor()}getZone(){let t=super.getZone();return this.resolveUpColor(),t}applyOptions(){return super.applyOptions.apply(this,arguments),this.resolveColor&&this.resolveColor(),this}}return i}),i(e,"Series/OHLC/OHLCSeriesDefaults.js",[],function(){return{tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'}}}),i(e,"Series/OHLC/OHLCSeries.js",[e["Core/Globals.js"],e["Series/OHLC/OHLCPoint.js"],e["Series/OHLC/OHLCSeriesDefaults.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,i,s,o){let{composed:r}=t,{hlc:a}=s.seriesTypes,{addEvent:n,extend:l,merge:h,pushUnique:d}=o;function p(t){let e=t.options,i=e.dataGrouping;i&&e.useOhlcData&&"highcharts-navigator-series"!==e.id&&(i.approximation="ohlc")}function c(t){let e=t.options;e.useOhlcData&&"highcharts-navigator-series"!==e.id&&l(this,{pointValKey:u.prototype.pointValKey,pointArrayMap:u.prototype.pointArrayMap,toYData:u.prototype.toYData})}class u extends a{static compose(t,...e){d(r,"OHLCSeries")&&(n(t,"afterSetOptions",p),n(t,"init",c))}getPointPath(t,e){let i=super.getPointPath(t,e),s=e.strokeWidth(),o=s%2/2,r=Math.round(t.plotX)-o,a=Math.round(t.shapeArgs.width/2),n=t.plotOpen;return null!==t.open&&(n=Math.round(t.plotOpen)+o,i.push(["M",r,n],["L",r-a,n]),super.extendStem(i,s/2,n)),i}pointAttribs(t,e){let i=super.pointAttribs.call(this,t,e),s=this.options;return delete i.fill,!t.options.color&&s.upColor&&t.open<t.close&&(i.stroke=s.upColor),i}toYData(t){return[t.open,t.high,t.low,t.close]}}return u.defaultOptions=h(a.defaultOptions,i),l(u.prototype,{pointClass:e,pointArrayMap:["open","high","low","close"]}),s.registerSeriesType("ohlc",u),u}),i(e,"Series/Candlestick/CandlestickSeriesDefaults.js",[],function(){return{states:{hover:{lineWidth:2}},threshold:null,lineColor:"#000000",lineWidth:1,upColor:"#ffffff",stickyTracking:!0}}),i(e,"Series/Candlestick/CandlestickSeries.js",[e["Series/Candlestick/CandlestickSeriesDefaults.js"],e["Core/Defaults.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,i,s){let{defaultOptions:o}=e,{column:r,ohlc:a}=i.seriesTypes,{merge:n}=s;class l extends a{pointAttribs(t,e){let i=r.prototype.pointAttribs.call(this,t,e),s=this.options,o=t.open<t.close,a=s.lineColor||this.color,n=t.color||this.color;if(i["stroke-width"]=s.lineWidth,i.fill=t.options.color||o&&s.upColor||n,i.stroke=t.options.lineColor||o&&s.upLineColor||a,e){let t=s.states[e];i.fill=t.color||i.fill,i.stroke=t.lineColor||i.stroke,i["stroke-width"]=t.lineWidth||i["stroke-width"]}return i}drawPoints(){let t=this.points,e=this.chart,i=this.yAxis.reversed;for(let s of t){let t=s.graphic,o,r,a,n,l,h,d,p,c,u,g=!t;void 0!==s.plotY&&(t||(s.graphic=t=e.renderer.path().add(this.group)),this.chart.styledMode||t.attr(this.pointAttribs(s,s.selected&&"select")).shadow(this.options.shadow),d=t.strokeWidth()%2/2,p=Math.round(s.plotX)-d,a=Math.min(o=s.plotOpen,r=s.plotClose),n=Math.max(o,r),u=Math.round(s.shapeArgs.width/2),l=i?n!==s.yBottom:Math.round(a)!==Math.round(s.plotHigh),h=i?Math.round(a)!==Math.round(s.plotHigh):n!==s.yBottom,a=Math.round(a)+d,n=Math.round(n)+d,(c=[]).push(["M",p-u,n],["L",p-u,a],["L",p+u,a],["L",p+u,n],["Z"],["M",p,a],["L",p,l?Math.round(i?s.yBottom:s.plotHigh):a],["M",p,n],["L",p,h?Math.round(i?s.plotHigh:s.yBottom):n]),t[g?"attr":"animate"]({d:c}).addClass(s.getClassName(),!0))}}}return l.defaultOptions=n(a.defaultOptions,o.plotOptions,{tooltip:a.defaultOptions.tooltip},t),i.registerSeriesType("candlestick",l),l}),i(e,"Series/Flags/FlagsPoint.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){let{column:{prototype:{pointClass:i}}}=t.seriesTypes,{isNumber:s}=e;return class extends i{constructor(){super(...arguments),this.ttBelow=!1}isValid(){return s(this.y)||void 0===this.y}hasNewShapeType(){let t=this.options.shape||this.series.options.shape;return this.graphic&&t&&t!==this.graphic.symbolKey}}}),i(e,"Series/Flags/FlagsSeriesDefaults.js",[],function(){return{borderRadius:0,pointRange:0,allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",tooltip:{pointFormat:"{point.text}"},threshold:null,y:-30,fillColor:"#ffffff",lineWidth:1,states:{hover:{lineColor:"#000000",fillColor:"#ccd3ff"}},style:{fontSize:"0.7em",fontWeight:"bold"}}}),i(e,"Series/Flags/FlagsSymbols.js",[e["Core/Renderer/RendererRegistry.js"]],function(t){var e;return function(e){let i=[];function s(t,e,i,s,o){let r=o&&o.anchorX||t,a=o&&o.anchorY||e,n=this.circle(r-1,a-1,2,2);return n.push(["M",r,a],["L",t,e+s],["L",t,e],["L",t+i,e],["L",t+i,e+s],["L",t,e+s],["Z"]),n}function o(t,e){t[e+"pin"]=function(i,s,o,r,a){let n;let l=a&&a.anchorX,h=a&&a.anchorY;if("circle"===e&&r>o&&(i-=Math.round((r-o)/2),o=r),n=t[e](i,s,o,r,a),l&&h){let a=l;if("circle"===e)a=i+o/2;else{let t=n[0],e=n[1];"M"===t[0]&&"L"===e[0]&&(a=(t[1]+e[1])/2)}let d=s>h?s:s+r;n.push(["M",a,d],["L",l,h]),n=n.concat(t.circle(l-1,h-1,2,2))}return n}}e.compose=function(e){if(-1===i.indexOf(e)){i.push(e);let t=e.prototype.symbols;t.flag=s,o(t,"circle"),o(t,"square")}let r=t.getRendererType();i.indexOf(r)&&i.push(r)}}(e||(e={})),e}),i(e,"Series/OnSeriesComposition.js",[e["Series/Column/ColumnSeries.js"],e["Core/Globals.js"],e["Core/Series/Series.js"],e["Core/Utilities.js"]],function(t,e,i,s){var o;let{composed:r}=e,{prototype:a}=t,{prototype:n}=i,{defined:l,pushUnique:h,stableSort:d}=s;return function(t){function e(t){return n.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this,t)}function i(){a.translate.apply(this);let t=this,e=t.options,i=t.chart,s=t.points,o=e.onSeries,r=o&&i.get(o),n=r&&r.options.step,h=r&&r.points,p=i.inverted,c=t.xAxis,u=t.yAxis,g=s.length-1,f,x,m=e.onKey||"y",b=h&&h.length,v=0,y,M,S,A,k;if(r&&r.visible&&b){for(v=(r.pointXOffset||0)+(r.barW||0)/2,A=r.currentDataGrouping,M=h[b-1].x+(A?A.totalRange:0),d(s,(t,e)=>t.x-e.x),m="plot"+m[0].toUpperCase()+m.substr(1);b--&&s[g];)if(y=h[b],(f=s[g]).y=y.y,y.x<=f.x&&void 0!==y[m]){if(f.x<=M&&(f.plotY=y[m],y.x<f.x&&!n&&(S=h[b+1])&&void 0!==S[m])){if(l(f.plotX)&&r.is("spline")){let t=[y.plotX||0,y.plotY||0],e=[S.plotX||0,S.plotY||0],i=y.controlPoints?.high||t,s=S.controlPoints?.low||e,o=(o,r)=>Math.pow(1-o,3)*t[r]+3*(1-o)*(1-o)*o*i[r]+3*(1-o)*o*o*s[r]+o*o*o*e[r],r=0,a=1,n;for(let t=0;t<100;t++){let t=(r+a)/2,e=o(t,0);if(null===e)break;if(.25>Math.abs(e-f.plotX)){n=t;break}e<f.plotX?r=t:a=t}l(n)&&(f.plotY=o(n,1),f.y=u.toValue(f.plotY,!0))}else k=(f.x-y.x)/(S.x-y.x),f.plotY+=k*(S[m]-y[m]),f.y+=k*(S.y-y.y)}if(g--,b++,g<0)break}}s.forEach((e,i)=>{let o;e.plotX+=v,(void 0===e.plotY||p)&&(e.plotX>=0&&e.plotX<=c.len?p?(e.plotY=c.translate(e.x,0,1,0,1),e.plotX=l(e.y)?u.translate(e.y,0,0,0,1):0):e.plotY=(c.opposite?0:t.yAxis.len)+c.offset:e.shapeArgs={}),(x=s[i-1])&&x.plotX===e.plotX&&(void 0===x.stackIndex&&(x.stackIndex=0),o=x.stackIndex+1),e.stackIndex=o}),this.onSeries=r}t.compose=function(t){if(h(r,"OnSeries")){let s=t.prototype;s.getPlotBox=e,s.translate=i}return t},t.getPlotBox=e,t.translate=i}(o||(o={})),o}),i(e,"Series/Flags/FlagsSeries.js",[e["Series/Flags/FlagsPoint.js"],e["Series/Flags/FlagsSeriesDefaults.js"],e["Series/Flags/FlagsSymbols.js"],e["Core/Globals.js"],e["Series/OnSeriesComposition.js"],e["Core/Renderer/RendererUtilities.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Renderer/SVG/SVGElement.js"],e["Core/Utilities.js"]],function(t,e,i,s,o,r,a,n,l){let{noop:h}=s,{distribute:d}=r,{series:p,seriesTypes:{column:c}}=a,{addEvent:u,defined:g,extend:f,isNumber:x,merge:m,objectEach:b,wrap:v}=l;class y extends c{animate(t){t&&this.setClip()}drawPoints(){let t,e,i,s,o,r,a,l,h,p,c;let u=this.points,f=this.chart,y=f.renderer,M=f.inverted,S=this.options,A=S.y,k=this.yAxis,C={},D=[],w=x(S.borderRadius)?S.borderRadius:0;for(s=u.length;s--;)o=u[s],p=(M?o.plotY:o.plotX)>this.xAxis.len,t=o.plotX,a=o.stackIndex,i=o.options.shape||S.shape,void 0!==(e=o.plotY)&&(e=o.plotY+A-(void 0!==a&&a*S.stackDistance)),o.anchorX=a?void 0:o.plotX,l=a?void 0:o.plotY,c="flag"!==i,r=o.graphic,void 0!==e&&t>=0&&!p?(r&&o.hasNewShapeType()&&(r=r.destroy()),r||(r=o.graphic=y.label("",0,void 0,i,void 0,void 0,S.useHTML).addClass("highcharts-point").add(this.markerGroup),o.graphic.div&&(o.graphic.div.point=o),r.isNew=!0),r.attr({align:c?"center":"left",width:S.width,height:S.height,"text-align":S.textAlign,r:w}),f.styledMode||r.attr(this.pointAttribs(o)).css(m(S.style,o.style)).shadow(S.shadow),t>0&&(t-=r.strokeWidth()%2),h={y:e,anchorY:l},S.allowOverlapX&&(h.x=t,h.anchorX=o.anchorX),r.attr({text:o.options.title||S.title||"A"})[r.isNew?"attr":"animate"](h),S.allowOverlapX||(C[o.plotX]?C[o.plotX].size=Math.max(C[o.plotX].size,r.width||0):C[o.plotX]={align:c?.5:0,size:r.width||0,target:t,anchorX:t}),o.tooltipPos=[t,e+k.pos-f.plotTop]):r&&(o.graphic=r.destroy());if(!S.allowOverlapX){let t=100;for(let e of(b(C,function(e){e.plotX=e.anchorX,D.push(e),t=Math.max(e.size,t)}),d(D,M?k.len:this.xAxis.len,t),u)){let t=e.plotX,i=e.graphic,s=i&&C[t];s&&i&&(g(s.pos)?i[i.isNew?"attr":"animate"]({x:s.pos+(s.align||0)*s.size,anchorX:e.anchorX}).show().isNew=!1:i.hide().isNew=!0)}}S.useHTML&&this.markerGroup&&v(this.markerGroup,"on",function(t){return n.prototype.on.apply(t.apply(this,[].slice.call(arguments,1)),[].slice.call(arguments,1))})}drawTracker(){let t=this.points;for(let e of(super.drawTracker(),t)){let i=e.graphic;i&&(e.unbindMouseOver&&e.unbindMouseOver(),e.unbindMouseOver=u(i.element,"mouseover",function(){for(let s of(e.stackIndex>0&&!e.raised&&(e._y=i.y,i.attr({y:e._y-8}),e.raised=!0),t))s!==e&&s.raised&&s.graphic&&(s.graphic.attr({y:s._y}),s.raised=!1)}))}}pointAttribs(t,e){let i=this.options,s=t&&t.color||this.color,o=i.lineColor,r=t&&t.lineWidth,a=t&&t.fillColor||i.fillColor;return e&&(a=i.states[e].fillColor,o=i.states[e].lineColor,r=i.states[e].lineWidth),{fill:a||s,stroke:o||s,"stroke-width":r||i.lineWidth||0}}setClip(){p.prototype.setClip.apply(this,arguments),!1!==this.options.clip&&this.sharedClipKey&&this.markerGroup&&this.markerGroup.clip(this.chart.sharedClips[this.sharedClipKey])}}return y.compose=i.compose,y.defaultOptions=m(c.defaultOptions,e),o.compose(y),f(y.prototype,{allowDG:!1,forceCrop:!0,invertible:!1,noSharedTooltip:!0,pointClass:t,sorted:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],buildKDTree:h,init:p.prototype.init}),a.registerSeriesType("flags",y),y}),i(e,"Core/Axis/BrokenAxis.js",[e["Core/Axis/Stacking/StackItem.js"],e["Core/Utilities.js"]],function(t,e){var i;let{addEvent:s,find:o,fireEvent:r,isArray:a,isNumber:n,pick:l}=e;return function(e){function i(){void 0!==this.brokenAxis&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function h(){this.brokenAxis?.hasBreaks&&(this.options.ordinal=!1)}function d(){let t=this.brokenAxis;if(t?.hasBreaks){let e=this.tickPositions,i=this.tickPositions.info,s=[];for(let i=0;i<e.length;i++)t.isInAnyBreak(e[i])||s.push(e[i]);this.tickPositions=s,this.tickPositions.info=i}}function p(){this.brokenAxis||(this.brokenAxis=new x(this))}function c(){let{isDirty:t,options:{connectNulls:e},points:i,xAxis:s,yAxis:o}=this;if(t){let t=i.length;for(;t--;){let r=i[t],a=!(null===r.y&&!1===e)&&(s?.brokenAxis?.isInAnyBreak(r.x,!0)||o?.brokenAxis?.isInAnyBreak(r.y,!0));r.visible=!a&&!1!==r.options.visible}}}function u(){this.drawBreaks(this.xAxis,["x"]),this.drawBreaks(this.yAxis,l(this.pointArrayMap,["y"]))}function g(t,e){let i,s,o;let a=this,h=a.points;if(t?.brokenAxis?.hasBreaks){let d=t.brokenAxis;e.forEach(function(e){i=d?.breakArray||[],s=t.isXAxis?t.min:l(a.options.threshold,t.min);let p=t?.options?.breaks?.filter(function(t){let e=!0;for(let s=0;s<i.length;s++){let o=i[s];if(o.from===t.from&&o.to===t.to){e=!1;break}}return e});h.forEach(function(a){o=l(a["stack"+e.toUpperCase()],a[e]),i.forEach(function(e){if(n(s)&&n(o)){let i="";s<e.from&&o>e.to||s>e.from&&o<e.from?i="pointBreak":(s<e.from&&o>e.from&&o<e.to||s>e.from&&o>e.to&&o<e.from)&&(i="pointInBreak"),i&&r(t,i,{point:a,brk:e})}}),p?.forEach(function(e){r(t,"pointOutsideOfBreak",{point:a,brk:e})})})})}}function f(){let e=this.currentDataGrouping,i=e?.gapSize,s=this.points.slice(),o=this.yAxis,r=this.options.gapSize,a=s.length-1;if(r&&a>0){let e,n;for("value"!==this.options.gapUnit&&(r*=this.basePointRange),i&&i>r&&i>=this.basePointRange&&(r=i);a--;)if(n&&!1!==n.visible||(n=s[a+1]),e=s[a],!1!==n.visible&&!1!==e.visible){if(n.x-e.x>r){let i=(e.x+n.x)/2;s.splice(a+1,0,{isNull:!0,x:i}),o.stacking&&this.options.stacking&&((o.stacking.stacks[this.stackKey][i]=new t(o,o.options.stackLabels,!1,i,this.stack)).total=0)}n=e}}return this.getGraphPath(s)}e.compose=function(t,e){if(!t.keepProps.includes("brokenAxis")){t.keepProps.push("brokenAxis"),s(t,"init",p),s(t,"afterInit",i),s(t,"afterSetTickPositions",d),s(t,"afterSetOptions",h);let o=e.prototype;o.drawBreaks=g,o.gappedPath=f,s(e,"afterGeneratePoints",c),s(e,"afterRender",u)}return t};class x{static isInBreak(t,e){let i=t.repeat||1/0,s=t.from,o=t.to-t.from,r=e>=s?(e-s)%i:i-(s-e)%i;return t.inclusive?r<=o:r<o&&0!==r}static lin2Val(t){let e=this.brokenAxis,i=e&&e.breakArray;if(!i||!n(t))return t;let s=t,o,r;for(r=0;r<i.length&&!((o=i[r]).from>=s);r++)o.to<s?s+=o.len:x.isInBreak(o,s)&&(s+=o.len);return s}static val2Lin(t){let e=this.brokenAxis,i=e&&e.breakArray;if(!i||!n(t))return t;let s=t,o,r;for(r=0;r<i.length;r++)if((o=i[r]).to<=t)s-=o.len;else if(o.from>=t)break;else if(x.isInBreak(o,t)){s-=t-o.from;break}return s}constructor(t){this.hasBreaks=!1,this.axis=t}findBreakAt(t,e){return o(e,function(e){return e.from<t&&t<e.to})}isInAnyBreak(t,e){let i=this.axis,s=i.options.breaks||[],o=s.length,r,a,h;if(o&&n(t)){for(;o--;)x.isInBreak(s[o],t)&&(r=!0,a||(a=l(s[o].showPoints,!i.isXAxis)));h=r&&e?r&&!a:r}return h}setBreaks(t,e){let i=this,s=i.axis,o=a(t)&&!!t.length&&!!Object.keys(t[0]).length;s.isDirty=i.hasBreaks!==o,i.hasBreaks=o,t!==s.options.breaks&&(s.options.breaks=s.userOptions.breaks=t),s.forceRedraw=!0,s.series.forEach(function(t){t.isDirty=!0}),o||s.val2lin!==x.val2Lin||(delete s.val2lin,delete s.lin2val),o&&(s.userOptions.ordinal=!1,s.lin2val=x.lin2Val,s.val2lin=x.val2Lin,s.setExtremes=function(t,e,o,r,a){if(i.hasBreaks){let s;let o=this.options.breaks||[];for(;s=i.findBreakAt(t,o);)t=s.to;for(;s=i.findBreakAt(e,o);)e=s.from;e<t&&(e=t)}s.constructor.prototype.setExtremes.call(this,t,e,o,r,a)},s.setAxisTranslation=function(){if(s.constructor.prototype.setAxisTranslation.call(this),i.unitLength=void 0,i.hasBreaks){let t=s.options.breaks||[],e=[],o=[],a=l(s.pointRangePadding,0),h=0,d,p,c=s.userMin||s.min,u=s.userMax||s.max,g,f;t.forEach(function(t){p=t.repeat||1/0,n(c)&&n(u)&&(x.isInBreak(t,c)&&(c+=t.to%p-c%p),x.isInBreak(t,u)&&(u-=u%p-t.from%p))}),t.forEach(function(t){if(g=t.from,p=t.repeat||1/0,n(c)&&n(u)){for(;g-p>c;)g-=p;for(;g<c;)g+=p;for(f=g;f<u;f+=p)e.push({value:f,move:"in"}),e.push({value:f+t.to-t.from,move:"out",size:t.breakSize})}}),e.sort(function(t,e){return t.value===e.value?("in"===t.move?0:1)-("in"===e.move?0:1):t.value-e.value}),d=0,g=c,e.forEach(function(t){1===(d+="in"===t.move?1:-1)&&"in"===t.move&&(g=t.value),0===d&&n(g)&&(o.push({from:g,to:t.value,len:t.value-g-(t.size||0)}),h+=t.value-g-(t.size||0))}),i.breakArray=o,n(c)&&n(u)&&n(s.min)&&(i.unitLength=u-c-h+a,r(s,"afterBreaks"),s.staticScale?s.transA=s.staticScale:i.unitLength&&(s.transA*=(u-s.min+a)/i.unitLength),a&&(s.minPixelPadding=s.transA*(s.minPointOffset||0)),s.min=c,s.max=u)}}),l(e,!0)&&s.chart.redraw()}}e.Additions=x}(i||(i={})),i}),i(e,"masters/modules/broken-axis.src.js",[e["Core/Globals.js"],e["Core/Axis/BrokenAxis.js"]],function(t,e){return t.BrokenAxis=t.BrokenAxis||e,t.BrokenAxis.compose(t.Axis,t.Series),t}),i(e,"Extensions/DataGrouping/ApproximationRegistry.js",[],function(){return{}}),i(e,"Extensions/DataGrouping/ApproximationDefaults.js",[e["Extensions/DataGrouping/ApproximationRegistry.js"],e["Core/Utilities.js"]],function(t,e){let{arrayMax:i,arrayMin:s,correctFloat:o,extend:r,isNumber:a}=e;function n(t){let e=t.length,i=l(t);return a(i)&&e&&(i=o(i/e)),i}function l(t){let e=t.length,i;if(!e&&t.hasNulls)i=null;else if(e)for(i=0;e--;)i+=t[e];return i}let h={average:n,averages:function(){let t=[];return[].forEach.call(arguments,function(e){t.push(n(e))}),void 0===t[0]?void 0:t},close:function(t){return t.length?t[t.length-1]:t.hasNulls?null:void 0},high:function(t){return t.length?i(t):t.hasNulls?null:void 0},hlc:function(e,i,s){if(e=t.high(e),i=t.low(i),s=t.close(s),a(e)||a(i)||a(s))return[e,i,s]},low:function(t){return t.length?s(t):t.hasNulls?null:void 0},ohlc:function(e,i,s,o){if(e=t.open(e),i=t.high(i),s=t.low(s),o=t.close(o),a(e)||a(i)||a(s)||a(o))return[e,i,s,o]},open:function(t){return t.length?t[0]:t.hasNulls?null:void 0},range:function(e,i){return(e=t.low(e),i=t.high(i),a(e)||a(i))?[e,i]:null===e&&null===i?null:void 0},sum:l};return r(t,h),h}),i(e,"Extensions/DataGrouping/DataGroupingDefaults.js",[],function(){return{common:{groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %e %b, %H:%M:%S.%L","%A, %e %b, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %e %b, %H:%M:%S","%A, %e %b, %H:%M:%S","-%H:%M:%S"],minute:["%A, %e %b, %H:%M","%A, %e %b, %H:%M","-%H:%M"],hour:["%A, %e %b, %H:%M","%A, %e %b, %H:%M","-%H:%M"],day:["%A, %e %b %Y","%A, %e %b","-%A, %e %b %Y"],week:["Week from %A, %e %b %Y","%A, %e %b","-%A, %e %b %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},seriesSpecific:{line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5},hlc:{groupPixelWidth:5},heikinashi:{groupPixelWidth:10}},units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]]}}),i(e,"Extensions/DataGrouping/DataGroupingAxisComposition.js",[e["Extensions/DataGrouping/DataGroupingDefaults.js"],e["Core/Utilities.js"]],function(t,e){let i;let{addEvent:s,extend:o,merge:r,pick:a}=e;function n(t){let e=this,i=e.series;i.forEach(function(t){t.groupPixelWidth=void 0}),i.forEach(function(i){i.groupPixelWidth=e.getGroupPixelWidth&&e.getGroupPixelWidth(),i.groupPixelWidth&&(i.hasProcessed=!0),i.applyGrouping(!!t.hasExtremesChanged)})}function l(){let e=this.series,i=e.length,s=0,o=!1,r,n;for(;i--;)(n=e[i].options.dataGrouping)&&(s=Math.max(s,a(n.groupPixelWidth,t.common.groupPixelWidth)),r=(e[i].processedXData||e[i].data).length,(e[i].groupPixelWidth||r>this.chart.plotSizeX/s||r&&n.forced)&&(o=!0));return o?s:0}function h(){this.series.forEach(function(t){t.hasProcessed=!1})}function d(t,e){let s;if(e=a(e,!0),t||(t={forced:!1,units:null}),this instanceof i)for(s=this.series.length;s--;)this.series[s].update({dataGrouping:t},!1);else this.chart.options.series.forEach(function(e){e.dataGrouping="boolean"==typeof t?t:r(t,e.dataGrouping)});this.ordinal&&(this.ordinal.slope=void 0),e&&this.chart.redraw()}return{compose:function(t){i=t;let e=t.prototype;e.applyGrouping||(s(t,"afterSetScale",h),s(t,"postProcessData",n),o(e,{applyGrouping:n,getGroupPixelWidth:l,setDataGrouping:d}))}}}),i(e,"Extensions/DataGrouping/DataGroupingSeriesComposition.js",[e["Extensions/DataGrouping/ApproximationRegistry.js"],e["Extensions/DataGrouping/DataGroupingDefaults.js"],e["Core/Axis/DateTimeAxis.js"],e["Core/Defaults.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,i,s,o,r){let{series:{prototype:a}}=o,{addEvent:n,defined:l,error:h,extend:d,isNumber:p,merge:c,pick:u}=r,g=a.generatePoints;function f(t){var s;let o,r;let n=this.chart,d=this.options.dataGrouping,c=!1!==this.allowDG&&d&&u(d.enabled,n.options.isStock),g=this.reserveSpace(),f=this.currentDataGrouping,x,m,b=!1;c&&!this.requireSorting&&(this.requireSorting=b=!0);let v=!1==!(this.isCartesian&&!this.isDirty&&!this.xAxis.isDirty&&!this.yAxis.isDirty&&!t)||!c;if(b&&(this.requireSorting=!1),v)return;this.destroyGroupedData();let y=d.groupAll?this.xData:this.processedXData,M=d.groupAll?this.yData:this.processedYData,S=n.plotSizeX,A=this.xAxis,k=A.options.ordinal,C=this.groupPixelWidth;if(C&&y&&y.length&&S){r=!0,this.isDirty=!0,this.points=null;let t=A.getExtremes(),c=t.min,u=t.max,f=k&&A.ordinal&&A.ordinal.getGroupIntervalFactor(c,u,this)||1,b=C*(u-c)/S*f,v=A.getTimeTicks(i.Additions.prototype.normalizeTimeTickInterval(b,d.units||e.units),Math.min(c,y[0]),Math.max(u,y[y.length-1]),A.options.startOfWeek,y,this.closestPointRange),D=a.groupData.apply(this,[y,M,v,d.approximation]),w=D.groupedXData,O=D.groupedYData,B=0;for(d&&d.smoothed&&w.length&&(d.firstAnchor="firstPoint",d.anchor="middle",d.lastAnchor="lastPoint",h(32,!1,n,{"dataGrouping.smoothed":"use dataGrouping.anchor"})),o=1;o<v.length;o++)v.info.segmentStarts&&-1!==v.info.segmentStarts.indexOf(o)||(B=Math.max(v[o]-v[o-1],B));(x=v.info).gapSize=B,this.closestPointRange=v.info.totalRange,this.groupMap=D.groupMap,this.currentDataGrouping=x,function(t,e,i){let s=t.options.dataGrouping,o=t.currentDataGrouping&&t.currentDataGrouping.gapSize;if(!(s&&t.xData&&o&&t.groupMap))return;let r=e.length-1,a=s.anchor,n=s.firstAnchor,l=s.lastAnchor,h=e.length-1,d=0;if(n&&t.xData[0]>=e[0]){let i;d++;let s=t.groupMap[0].start,r=t.groupMap[0].length;p(s)&&p(r)&&(i=s+(r-1)),e[0]=({start:e[0],middle:e[0]+.5*o,end:e[0]+o,firstPoint:t.xData[0],lastPoint:i&&t.xData[i]})[n]}if(r>0&&l&&o&&e[r]>=i-o){h--;let i=t.groupMap[t.groupMap.length-1].start;e[r]=({start:e[r],middle:e[r]+.5*o,end:e[r]+o,firstPoint:i&&t.xData[i],lastPoint:t.xData[t.xData.length-1]})[l]}if(a&&"start"!==a){let t=o*({middle:.5,end:1})[a];for(;h>=d;)e[h]+=t,h--}}(this,w,u),g&&(l((s=w)[0])&&p(A.min)&&p(A.dataMin)&&s[0]<A.min&&((!l(A.options.min)&&A.min<=A.dataMin||A.min===A.dataMin)&&(A.min=Math.min(s[0],A.min)),A.dataMin=Math.min(s[0],A.dataMin)),l(s[s.length-1])&&p(A.max)&&p(A.dataMax)&&s[s.length-1]>A.max&&((!l(A.options.max)&&p(A.dataMax)&&A.max>=A.dataMax||A.max===A.dataMax)&&(A.max=Math.max(s[s.length-1],A.max)),A.dataMax=Math.max(s[s.length-1],A.dataMax))),d.groupAll&&(this.allGroupedData=O,w=(m=this.cropData(w,O,A.min,A.max)).xData,O=m.yData,this.cropStart=m.start),this.processedXData=w,this.processedYData=O}else this.groupMap=null;this.hasGroupedData=r,this.preventGraphAnimation=(f&&f.totalRange)!==(x&&x.totalRange)}function x(){this.groupedData&&(this.groupedData.forEach(function(t,e){t&&(this.groupedData[e]=t.destroy?t.destroy():null)},this),this.groupedData.length=0,delete this.allGroupedData)}function m(){g.apply(this),this.destroyGroupedData(),this.groupedData=this.hasGroupedData?this.points:null}function b(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("hlc")?"hlc":this.is("column")||this.options.cumulative?"sum":"average"}function v(e,i,s,o){let r=this,a=r.data,n=r.options&&r.options.data,h=[],d=[],u=[],g=e.length,f=!!i,x=[],m=r.pointArrayMap,b=m&&m.length,v=["x"].concat(m||["y"]),y=this.options.dataGrouping&&this.options.dataGrouping.groupAll,M,S,A,k=0,C=0,D="function"==typeof o?o:o&&t[o]?t[o]:t[r.getDGApproximation&&r.getDGApproximation()||"average"];if(b){let t=m.length;for(;t--;)x.push([])}else x.push([]);let w=b||1;for(let t=0;t<=g;t++)if(!(e[t]<s[0])){for(;void 0!==s[k+1]&&e[t]>=s[k+1]||t===g;){M=s[k],r.dataGroupInfo={start:y?C:r.cropStart+C,length:x[0].length,groupStart:M},A=D.apply(r,x),r.pointClass&&!l(r.dataGroupInfo.options)&&(r.dataGroupInfo.options=c(r.pointClass.prototype.optionsToObject.call({series:r},r.options.data[r.cropStart+C])),v.forEach(function(t){delete r.dataGroupInfo.options[t]})),void 0!==A&&(h.push(M),d.push(A),u.push(r.dataGroupInfo)),C=t;for(let t=0;t<w;t++)x[t].length=0,x[t].hasNulls=!1;if(k+=1,t===g)break}if(t===g)break;if(m){let e;let i=r.options.dataGrouping&&r.options.dataGrouping.groupAll?t:r.cropStart+t,s=a&&a[i]||r.pointClass.prototype.applyOptions.apply({series:r},[n[i]]);for(let t=0;t<b;t++)p(e=s[m[t]])?x[t].push(e):null===e&&(x[t].hasNulls=!0)}else p(S=f?i[t]:null)?x[0].push(S):null===S&&(x[0].hasNulls=!0)}return{groupedXData:h,groupedYData:d,groupMap:u}}function y(t){let i=t.options,o=this.type,r=this.chart.options.plotOptions,a=this.useCommonDataGrouping&&e.common,n=e.seriesSpecific,l=s.defaultOptions.plotOptions[o].dataGrouping;if(r&&(n[o]||a)){let t=this.chart.rangeSelector;l||(l=c(e.common,n[o])),i.dataGrouping=c(a,l,r.series&&r.series.dataGrouping,r[o].dataGrouping,this.userOptions.dataGrouping,!i.isInternal&&t&&p(t.selected)&&t.buttonOptions[t.selected].dataGrouping)}}return{compose:function(t){let e=t.prototype;e.applyGrouping||(n(t.prototype.pointClass,"update",function(){if(this.dataGroup)return h(24,!1,this.series.chart),!1}),n(t,"afterSetOptions",y),n(t,"destroy",x),d(e,{applyGrouping:f,destroyGroupedData:x,generatePoints:m,getDGApproximation:b,groupData:v}))},groupData:v}}),i(e,"Extensions/DataGrouping/DataGrouping.js",[e["Extensions/DataGrouping/DataGroupingAxisComposition.js"],e["Extensions/DataGrouping/DataGroupingDefaults.js"],e["Extensions/DataGrouping/DataGroupingSeriesComposition.js"],e["Core/Templating.js"],e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e,i,s,o,r){let{format:a}=s,{composed:n}=o,{addEvent:l,extend:h,isNumber:d,pick:p,pushUnique:c}=r;function u(t){let i=this.chart,s=i.time,o=t.labelConfig,r=o.series,n=o.point,l=r.options,c=r.tooltipOptions,u=l.dataGrouping,g=r.xAxis,f=c.xDateFormat,x,m,b,v,y,M=c[t.isFooter?"footerFormat":"headerFormat"];if(g&&"datetime"===g.options.type&&u&&d(o.key)){m=r.currentDataGrouping,b=u.dateTimeLabelFormats||e.common.dateTimeLabelFormats,m?(v=b[m.unitName],1===m.count?f=v[0]:(f=v[1],x=v[2])):!f&&b&&g.dateTime&&(f=g.dateTime.getXDateFormat(o.x,c.dateTimeLabelFormats));let l=p(r.groupMap?.[n.index].groupStart,o.key),d=l+m?.totalRange-1;y=s.dateFormat(f,l),x&&(y+=s.dateFormat(x,d)),r.chart.styledMode&&(M=this.styledModeFormat(M)),t.text=a(M,{point:h(o.point,{key:y}),series:r},i),t.preventDefault()}}return{compose:function(e,s,o){t.compose(e),i.compose(s),o&&c(n,"DataGrouping")&&l(o,"headerFormatter",u)},groupData:i.groupData}}),i(e,"masters/modules/datagrouping.src.js",[e["Core/Globals.js"],e["Extensions/DataGrouping/ApproximationDefaults.js"],e["Extensions/DataGrouping/ApproximationRegistry.js"],e["Extensions/DataGrouping/DataGrouping.js"]],function(t,e,i,s){return t.dataGrouping=t.dataGrouping||{},t.dataGrouping.approximationDefaults=t.dataGrouping.approximationDefaults||e,t.dataGrouping.approximations=t.dataGrouping.approximations||i,s.compose(t.Axis,t.Series,t.Tooltip),t}),i(e,"Extensions/Annotations/NavigationBindingsUtilities.js",[e["Core/Utilities.js"]],function(t){let{defined:e,isNumber:i,pick:s}=t,o={backgroundColor:"string",borderColor:"string",borderRadius:"string",color:"string",fill:"string",fontSize:"string",labels:"string",name:"string",stroke:"string",title:"string"};return{annotationsFieldsTypes:o,getAssignedAxis:function(t){return t.filter(t=>{let e=t.axis.getExtremes(),o=e.min,r=e.max,a=s(t.axis.minPointOffset,0);return i(o)&&i(r)&&t.value>=o-a&&t.value<=r+a&&!t.axis.options.isInternal})[0]},getFieldType:function(t,i){let s=o[t],r=typeof i;return e(s)&&(r=s),({string:"text",number:"number",boolean:"checkbox"})[r]}}}),i(e,"Extensions/MouseWheelZoom/MouseWheelZoom.js",[e["Core/Utilities.js"],e["Extensions/Annotations/NavigationBindingsUtilities.js"]],function(t,e){let i;let{addEvent:s,isObject:o,pick:r,defined:a,merge:n}=t,{getAssignedAxis:l}=e,h=[],d={enabled:!0,sensitivity:1.1},p=t=>(o(t)||(t={enabled:t??!0}),n(d,t)),c=function(t,e,s,o,n,l,h){let d=r(h.type,t.zooming.type,""),p=[];"x"===d?p=s:"y"===d?p=o:"xy"===d&&(p=t.axes);let c=t.transform({axes:p,to:{x:n-5,y:l-5,width:10,height:10},from:{x:n-5*e,y:l-5*e,width:10*e,height:10*e},trigger:"mousewheel"});return c&&(a(i)&&clearTimeout(i),i=setTimeout(()=>{t.pointer?.drop()},400)),c};function u(){let t=p(this.zooming.mouseWheel);t.enabled&&s(this.container,"wheel",e=>{e=this.pointer?.normalize(e)||e;let{pointer:i}=this,s=i&&!i.inClass(e.target,"highcharts-no-mousewheel");if(this.isInsidePlot(e.chartX-this.plotLeft,e.chartY-this.plotTop)&&s){let s=t.sensitivity||1.1,o=e.detail||(e.deltaY||0)/120,r=l(i.getCoordinates(e).xAxis),a=l(i.getCoordinates(e).yAxis);c(this,Math.pow(s,o),r?[r.axis]:this.xAxis,a?[a.axis]:this.yAxis,e.chartX,e.chartY,t)&&e.preventDefault?.()}})}return{compose:function(t){-1===h.indexOf(t)&&(h.push(t),s(t,"afterGetContainer",u))}}}),i(e,"masters/modules/mouse-wheel-zoom.src.js",[e["Core/Globals.js"],e["Extensions/MouseWheelZoom/MouseWheelZoom.js"]],function(t,e){return t.MouseWheelZoom=t.MouseWheelZoom||e,t.MouseWheelZoom.compose(t.Chart),t}),i(e,"masters/modules/stock.src.js",[e["Core/Globals.js"],e["Series/DataModifyComposition.js"],e["Stock/Navigator/Navigator.js"],e["Core/Axis/OrdinalAxis.js"],e["Stock/RangeSelector/RangeSelector.js"],e["Stock/Scrollbar/Scrollbar.js"],e["Core/Chart/StockChart.js"],e["Series/OHLC/OHLCSeries.js"],e["Series/Flags/FlagsSeries.js"]],function(t,e,i,s,o,r,a,n,l){return t.Navigator=t.Navigator||i,t.OrdinalAxis=t.OrdinalAxis||s,t.RangeSelector=t.RangeSelector||o,t.Scrollbar=t.Scrollbar||r,t.stockChart=t.stockChart||a.stockChart,t.StockChart=t.StockChart||t.stockChart,t.extend(t.StockChart,a),e.compose(t.Series,t.Axis,t.Point),l.compose(t.Renderer),n.compose(t.Series),t.Navigator.compose(t.Chart,t.Axis,t.Series),t.OrdinalAxis.compose(t.Axis,t.Series,t.Chart),t.RangeSelector.compose(t.Axis,t.Chart),t.Scrollbar.compose(t.Axis),t.StockChart.compose(t.Chart,t.Axis,t.Series,t.SVGRenderer),t})});