{*<!--
/*********************************************************************************
** The contents of this file are subject to the vtiger CRM Public License Version 1.0
* ("License"); You may not use this file except in compliance with the License
* The Original Code is: vtiger CRM Open Source
* The Initial Developer of the Original Code is vtiger.
* Portions created by vtiger are Copyright (C) vtiger.
* All Rights Reserved.
*
********************************************************************************/
-->*}
{strip}
    {assign var=PROVIDER_NAME value=$TASK_OBJECT->provider_name}
    {assign var=PROVIDER_INFO value=ZEND_JSON::encode($TASK_OBJECT->provider_params)}
    {assign var=PROVIDER_PARAMS value=$TASK_OBJECT->provider_params}
    {assign var=PROVIDERS_FIELDS value=$TASK_OBJECT->getProviderLists($PROVIDER_NAME, $PROVIDER_PARAMS)}
    <div class="row" style="margin-bottom: 70px;">
        <div class="col-lg-9">
            <div class="row form-group">
                <div class="col-lg-2">{vtranslate('Provider',"SMSNotifier")}<span class="redColor">*</span></div>
                <div class="col-lg-8">
                    <div class="row">
                        <div class="col-lg-6">
                            <select class="select2 inputElement task-fields" style="min-width: 150px;" id="provider_name" name="provider_name"  data-placeholder="{vtranslate('LBL_SELECT_FIELDS', $QUALIFIED_MODULE)}" data-validation-engine='validate[required]' data-rule-required="false" required="">
                                <option></option>
                                {foreach from=$PROVIDERS_FIELDS item=PROVIDER_FIELDS key=PROVIDER_NAME}
                                    <option {if $TASK_OBJECT->provider_name eq $PROVIDER_NAME}selected readonly {/if} value="{$PROVIDER_NAME}">{$PROVIDER_NAME}</option>
                                {/foreach}
                            </select>
                            <textarea id="provider_params" name="provider_params" class="hide">{$PROVIDER_INFO}</textarea>
                        </div>
                    </div>
                </div>
            </div>
            {foreach from=$PROVIDERS_FIELDS item=PROVIDER_FIELDS key=PROVIDER_NAME}
                <div id="{$PROVIDER_NAME}_id" class="providerContainer {if $PROVIDER_NAME neq $TASK_OBJECT->provider_name}hide{/if}">
                        {foreach from=$PROVIDER_FIELDS item=FIELD_DATA key=FIELD_NAME}
                            <div class="row form-group">
                                    <div class="col-lg-2">
                                        {$FIELD_DATA['label']} {if $FIELD_DATA['required']}<span class="redColor">*</span>{/if}
                                    </div>
                                    <div class="col-lg-8">
                                        <div class="row">
                                            {assign var=FIELD_TYPE value=$FIELD_DATA['type']}
                                            {assign var=FIELD_VALUE value=$FIELD_DATA['value']}
                                            <div class="col-lg-6">
                                                {if $FIELD_TYPE == 'picklist'}
                                                    <select class="select2 form-control provider_data" data-name="{$FIELD_NAME}" id="{$PROVIDER_NAME}_{$FIELD_NAME}" data-rule-required="false"  placeholder="{vtranslate('LBL_SELECT_ONE', $QUALIFIED_MODULE_NAME)}">
                                                        <option></option>
                                                        {assign var=PICKLIST_VALUES value=$FIELD_DATA['picklistvalues']}
                                                        {foreach item=PICKLIST_VALUE key=PICKLIST_KEY from=$PICKLIST_VALUES}
                                                            <option value="{$PICKLIST_KEY}" {if $FIELD_VALUE eq $PICKLIST_KEY} selected {/if}>
                                                                {vtranslate($PICKLIST_VALUE, $QUALIFIED_MODULE_NAME)}
                                                            </option>
                                                        {/foreach}
                                                    </select>
                                                {elseif $FIELD_TYPE == 'radio'}
                                                    <input class="provider_data" type="radio" value='1' data-name="{$FIELD_NAME}" id="{$PROVIDER_NAME}_{$FIELD_NAME}" {if $FIELD_VALUE} checked="checked" {/if} />&nbsp;{vtranslate('LBL_YES', $QUALIFIED_MODULE_NAME)}&nbsp;&nbsp;&nbsp;
                                                    <input class="provider_data" type="radio" value='0' data-name="{$FIELD_NAME}" id="{$PROVIDER_NAME}_{$FIELD_NAME}" {if !$FIELD_VALUE} checked="checked" {/if}/>&nbsp;{vtranslate('LBL_NO', $QUALIFIED_MODULE_NAME)}
                                                {elseif $FIELD_TYPE == 'password'}
                                                    <input type="password" id="{$PROVIDER_NAME}_{$FIELD_NAME}" data-name="{$FIELD_NAME}" class="form-control provider_data" data-rule-required="false" name="{$FIELD_NAME}" value="{$FIELD_VALUE}" />
                                                {else}
                                                    <input type="text" id="{$PROVIDER_NAME}_{$FIELD_NAME}" data-name="{$FIELD_NAME}" class="form-control provider_data" data-rule-required="false" {if $FIELD_NAME == 'username'} {/if} value="{$FIELD_VALUE}" />
                                                {/if}
                                            </div>
                                        </div>
                                    </div>
                            </div>
                        {/foreach}
                </div>
            {/foreach}

            <div class="row form-group">
                <div class="col-lg-2">{vtranslate('LBL_RECEPIENTS',$QUALIFIED_MODULE)}<span class="redColor">*</span></div>
                <div class="col-lg-8">
                    <div class="row">
                        <div class="col-lg-5">
                            <input type="text" class="inputElement fields" data-rule-required="false" name="sms_recepient" value="{$TASK_OBJECT->sms_recepient}" />
                        </div>
                        <div class="col-lg-6">
                            <select class="select2 task-fields" style="min-width: 150px;" data-placeholder="{vtranslate('LBL_SELECT_FIELDS', $QUALIFIED_MODULE)}">
                                <option></option>
                                {foreach from=$RECORD_STRUCTURE_MODEL->getFieldsByType('phone') item=FIELD key=FIELD_VALUE}
                                    <option value=",${$FIELD_VALUE}">({vtranslate($FIELD->getModule()->get('name'),$FIELD->getModule()->get('name'))})  {vtranslate($FIELD->get('label'),$FIELD->getModule()->get('name'))}</option>
                                {/foreach}
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row form-group">
                <div class="col-lg-2">{vtranslate('LBL_ADD_FIELDS',$QUALIFIED_MODULE)}</div>
                <div class="col-lg-10">
                    <select class="select2 task-fields" style="min-width: 150px;" data-placeholder="{vtranslate('LBL_SELECT_FIELDS', $QUALIFIED_MODULE)}">
                        <option></option>
                        {$ALL_FIELD_OPTIONS}
                    </select>
                </div>
                <div class="col-lg-2"> &nbsp; </div>
                <div class="col-lg-10"> &nbsp; </div>
                <div class="col-lg-2">{vtranslate('LBL_SMS_TEXT',$QUALIFIED_MODULE)}</div>
                <div class="col-lg-6">
                    <textarea name="content" class="inputElement fields" style="height: inherit;">{$TASK_OBJECT->content}</textarea>
                </div>
            </div>
        </div>
    </div>
{/strip}
<script>

    jQuery(document).ready(function () {
        $('#provider_name').on('change', function () {
            var providername = $(this).val();
            $(".providerContainer").addClass('hide');
            $("#" + providername + "_id").removeClass('hide');
        });
        $('.provider_data').on('input change keyup', function () {
            var provider_name = $('#provider_name').val();
            var field_id = $(this).attr('id');
            var prefix = field_id.split("_")[0];
            if (provider_name != '' && prefix == provider_name) {
                var inputs = $("input[id^='" + prefix + "_']");
                var inputs2 = $("select[id^='" + prefix + "_']");
                var provider_params_values = {};
                inputs.each(function () {
                    provider_params_values[$(this).attr('data-name')] = $(this).val();
                });
                inputs2.each(function () {
                    provider_params_values[$(this).attr('data-name')] = $(this).val();
                });
                $("#provider_params").val(JSON.stringify(provider_params_values));
            }
        });

    });

    </script>
