{*<!--
/*********************************************************************************
  ** The contents of this file are subject to the vtiger CRM Public License Version 1.0
   * ("License"); You may not use this file except in compliance with the License
   * The Original Code is: vtiger CRM Open Source
   * The Initial Developer of the Original Code is vtiger.
   * Portions created by vtiger are Copyright (C) vtiger.
   * All Rights Reserved.
  *
 ********************************************************************************/
-->*}
{strip}
	{assign var="FIELD_INFO" value=$FIELD_MODEL->getFieldInfo()}
	{assign var="SPECIAL_VALIDATOR" value=$FIELD_MODEL->getValidator()}
	{assign var="FIELD_VALUE_LIST" value=explode(' |##| ',$FIELD_MODEL->get('fieldvalue'))}
	{if isset($FIELD_INFO['editablepicklistvalues']) && !empty($FIELD_INFO['editablepicklistvalues'])}
		{assign var=PICKLIST_VALUES value=$FIELD_INFO['editablepicklistvalues']}
	{else}
		{assign var=PICKLIST_VALUES value=$FIELD_INFO['picklistvalues']}
	{/if}

	{if $FIELD_NAME|strstr:'cf_pcf_tmf' && $FIELD_NAME|strpos:'cf_pcf_tmf' == '0'}
			{assign var="FIELD_VALUES" value=ParsVT_Constant_Model::getPickListValues($FIELD_NAME, $MODULE)}
			{if !empty($FIELD_VALUES['All']) && is_array($FIELD_VALUES['All'])}
				{assign var="ALL" value=$FIELD_VALUES['All']}
			{else}
				{assign var="ALL" value=[]}
			{/if}
			{if !empty($FIELD_VALUES['Primary']) && is_array($FIELD_VALUES['Primary'])}
				{assign var="PRIMARY" value=$FIELD_VALUES['Primary']}
			{else}
				{assign var="PRIMARY" value=[]}
			{/if}
			{if !empty($FIELD_VALUES['Secondary']) && is_array($FIELD_VALUES['Secondary'])}
				{assign var="SECONDARY" value=$FIELD_VALUES['Secondary']}
			{else}
				{assign var="SECONDARY" value=[]}
			{/if}
		<input id="taggble_{$FIELD_NAME}" data-fieldname="{$FIELD_NAME}" data-fieldtype="picklist" class="inputElement {if $OCCUPY_COMPLETE_WIDTH} row {/if}"  name="{$FIELD_NAME}" {if !empty($SPECIAL_VALIDATOR)}data-validator='{Zend_Json::encode($SPECIAL_VALIDATOR)}'{/if} data-selected-value='{','|implode:$FIELD_VALUE_LIST}'  value='{','|implode:$FIELD_VALUE_LIST}'
								{if $FIELD_INFO["mandatory"] eq true} data-rule-required="true" {/if}
								{if !empty($FIELD_INFO['validator']) && is_array(empty($FIELD_INFO['validator']))}
									data-specific-rules='{ZEND_JSON::encode($FIELD_INFO["validator"])}'
				{/if} >
		<script>
			let DefVALUES_{$FIELD_NAME|@strtoupper}=JSON.parse('{ZEND_JSON::encode($FIELD_VALUE_LIST)}');
			var ALL_{$FIELD_NAME|@strtoupper} = JSON.parse('{ZEND_JSON::encode($ALL)}');
			var PRIMARY_{$FIELD_NAME|@strtoupper} = JSON.parse('{ZEND_JSON::encode($PRIMARY)}');
			var SECONDARY_{$FIELD_NAME|@strtoupper} = JSON.parse('{ZEND_JSON::encode($SECONDARY)}');
			jQuery(document).ready(function () {
				var params_{$FIELD_NAME|lower} = {
					tags: [],
					tokenSeparators: [","] ,
					query: function (query) {
						var data = { results: [] };
						if (query.term != '') {
							var picklist_finded = false;
							for (key in ALL_{$FIELD_NAME|@strtoupper}) {
								if (key == query.term) {
									picklist_finded = true;
									data.results.push({ id: key, text: ALL_{$FIELD_NAME|@strtoupper}[key] });
									break;
								} else if (ALL_{$FIELD_NAME|@strtoupper}[key] == query.term) {
									picklist_finded = true;
									data.results.push({ id: key, text: ALL_{$FIELD_NAME|@strtoupper}[key] });
									break;
								} else {
									if (!key.startsWith(query.term) && !ALL_{$FIELD_NAME|@strtoupper}[key].startsWith(query.term)) continue;
									data.results.push({ id: key, text: ALL_{$FIELD_NAME|@strtoupper}[key] });
									data.results.push({ id: query.term, text: query.term });
									picklist_finded = true;
								}
							}
							if (!picklist_finded) {
								data.results.push({ id: query.term, text: query.term });
							}
						} else {
							Object.keys(PRIMARY_{$FIELD_NAME|@strtoupper}).forEach(function (key) {
								data.results.push({ id: key, text: PRIMARY_{$FIELD_NAME|@strtoupper}[key] });
							});
						}
						query.callback(data);
					}
				};
				app.showSelect2ElementView(jQuery('#taggble_{$FIELD_NAME}'), params_{$FIELD_NAME|lower});
				if (typeof DefVALUES_{$FIELD_NAME|@strtoupper} != 'undefined' && DefVALUES_{$FIELD_NAME|@strtoupper}.length > 0) {
					var preloadData=[];
					for(var i in DefVALUES_{$FIELD_NAME|@strtoupper}) {
						var value = DefVALUES_{$FIELD_NAME|@strtoupper}[i];
						if (value != '') {
							var values = {
								'id': value,
								'text': (typeof ALL_{$FIELD_NAME|@strtoupper}[value] !== 'undefined' ? ALL_{$FIELD_NAME|@strtoupper}[value] : value)

							};
							preloadData.push(values);
						}
					}
					jQuery('#taggble_{$FIELD_NAME}').select2('data', preloadData);
				}
			});
		</script>
	{else}
		{assign var=PICKLIST_COLORS value=$FIELD_INFO['picklistColors']}
		<input type="hidden" name="{$FIELD_MODEL->getFieldName()}" value=""  data-fieldtype="multipicklist"/>
		<select id="{$MODULE}_{$smarty.request.view}_fieldName_{$FIELD_MODEL->getFieldName()}" multiple class="select2" name="{$FIELD_MODEL->getFieldName()}[]" data-fieldtype="multipicklist" style='width:210px;height:30px;'
				{if $FIELD_INFO["mandatory"] eq true} data-rule-required="true" {/if}
				{if !empty($FIELD_INFO['validator']) && is_array(empty($FIELD_INFO['validator']))}
					data-specific-rules='{ZEND_JSON::encode($FIELD_INFO["validator"])}'
				{/if}
				>
			{foreach item=PICKLIST_VALUE key=PICKLIST_NAME from=$PICKLIST_VALUES}
				{assign var=CLASS_NAME value="picklistColor_{$FIELD_MODEL->getFieldName()}_{$PICKLIST_NAME|replace:' ':'_'}"}
				<option value="{Vtiger_Util_Helper::toSafeHTML($PICKLIST_NAME)}" {if $PICKLIST_COLORS[$PICKLIST_NAME]}class="{$CLASS_NAME}"{/if} {if in_array(Vtiger_Util_Helper::toSafeHTML($PICKLIST_NAME), $FIELD_VALUE_LIST)} selected {/if}>{vtranslate($PICKLIST_VALUE, $MODULE)}</option>
			{/foreach}
		</select>
		{if $PICKLIST_COLORS}
			<style type="text/css">
				{foreach item=PICKLIST_VALUE key=PICKLIST_NAME from=$PICKLIST_VALUES}
				{assign var=CLASS_NAME value="{$FIELD_MODEL->getFieldName()}_{$PICKLIST_NAME|replace:' ':'_'}"}
				.picklistColor_{$CLASS_NAME} {
					background-color: {$PICKLIST_COLORS[$PICKLIST_NAME]} !important;
				}
				{/foreach}
			</style>
		{/if}
	{/if}
{/strip}