<?php
/* ********************************************************************************
 * The content of this file is subject to the VTFarsi.ir Modules License("License");
 * You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is VTFarsi.ir
 * Portions created by VTFarsi.ir. are Copyright(C) VTFarsi Team
 * All Rights Reserved.
 * ****************************************************************************** */

chdir(dirname(__FILE__) . '/../..');
ini_set('display_errors','off'); error_reporting(0); // STRICT DEVELOPMENT
if (file_exists('vendor/autoload.php')) {
    include_once 'config.php';
    require_once 'vendor/autoload.php';
}
include_once 'vtlib/Vtiger/Module.php';
include_once 'vtlib/Vtiger/Package.php';
include_once 'includes/main/WebUI.php';
include_once 'include/Webservices/Utils.php';


error_reporting(0);

/**
 * Class ParsVT_Tools_Console_Controller
 */
class ParsVT_Tools_Console_Controller
{
    /**
     *
     */
    const PROMPT_ANY = 1;

    /**
     *
     */
    const PROMPT_OPTIONAL = 2;

    /**
     *
     */
    const PROMPT_NUMERIC = 3;

    /**
     *
     */
    const PROMPT_ALPHANUMERIC = 4;

    /**
     *
     */
    const PROMPT_NAME = 5;

    /**
     *
     */
    const PROMPT_LABEL = 6;

    /**
     *
     */
    const PROMPT_PATH = 7;

    /**
     * @var bool
     */
    protected $interactive = true;

    /**
     * @var array
     */
    protected $arguments = array();

    /**
     * ParsVT_Tools_Console_Controller constructor.
     */
    public function __construct()
    {
    }

    /**
     * @param $args
     * @param $interactive
     * @return $this
     */
    public function setArguments($args, $interactive)
    {
        $this->arguments = $args;
        $this->interactive = $interactive;

        return $this;
    }

    /**
     *
     */
    protected function handle()
    {
        global $argv;
        $this->arguments = $argv;
        // Discard the script name.
        array_shift($this->arguments);
        if ($this->arguments) {
            $this->arguments = explode('=', $this->arguments[1]);
            $this->interactive = false;
        }

        $this->welcome();
        $this->options();
    }

    /**
     * Print the welcome message.
     */
    protected function welcome()
    {
        if ($this->interactive) {
            echo "
   _____                __      __ _______                       
  |  __ \               \ \    / /|__   __|                      
  | |__) |__ _  _ __  ___\ \  / /    | |    ___  ___   _ __ ___  
  |  ___// _` || '__|/ __|\ \/ /     | |   / __|/ _ \ | '_ ` _ \ 
  | |   | (_| || |   \__ \ \  /      | | _| (__| (_) || | | | | |
  |_|    \__,_||_|   |___/  \/       |_|(_)\___|\___/ |_| |_| |_|
                                                                          
\n\n";
            echo "  Welcome to ParsVT CRM Console.\n";
            echo "  This tool will enable you to get started with developing extensions with ease.\n";
            echo "  Have a good time. Press CTRL+C or type \"exit\" to quit.\n";
        }
    }

    /**
     *
     */
    protected function options()
    {
        if ($this->interactive) {
            echo "  Choose the options below:\n";
            echo "  1. Create New Entity Module.\n";
            echo "  2. Create New Extension Module.\n";
            echo "  3. Create New Layout.\n";
            echo "  4. Create New Language Pack.\n";
            echo "  5. Create Test Language Pack.\n";
            echo "  6. Import Module.\n";
            echo "  7. Update Module.\n";
            echo "  8. Remove Module.\n";
            $option = $this->prompt("  Enter your choice: ", self::PROMPT_NUMERIC);
        } else {
            $option = array_shift($this->arguments);
            switch ($option) {
                case '--import':
                    $option = 6;
                    break;
                case '--update':
                    $option = 7;
                    break;
                case '--remove':
                    $option = 8;
                    break;
            }
        }

        try {
            switch (intval($option)) {
                case 1:
                    $this->handleCreateEntityModule();
                    break;
                case 2:
                    $this->handleCreateExtensionModule();
                    break;
                case 3:
                    $this->handleCreateLayout();
                    break;
                case 4:
                    $this->handleCreateLanguage();
                    break;
                case 5:
                    $this->handleCreateTestLanguage();
                    break;
                case 6:
                    $this->handleImportModule();
                    break;
                case 7:
                    $this->handleUpdateModule();
                    break;
                case 8:
                    $this->handleRemoveModule();
                    break;
            }
        } catch (Exception $e) {
            echo "  ERROR: " . $e->getMessage() . "\n";
            echo $e->getTraceAsString();
            echo "  \n";
        }
    }

    /**
     * @param string $msg
     * @param int $type
     * @return string
     */
    protected function prompt($msg = '', $type = self::PROMPT_ANY)
    {
        do {
            if ($msg) {
                echo $msg;
            }

            $value = trim(fgets(STDIN));

            if ($value == 'exit') {
                exit;
            }

            if (!$value && $type == self::PROMPT_OPTIONAL) {
                return $value;
            } else if ($value || $value === '0') {
                switch ($type) {
                    case self::PROMPT_NUMERIC:
                        if (is_numeric($value)) {
                            return $value;
                        }
                        break;
                    case self::PROMPT_ALPHANUMERIC:
                        if (!preg_match("/^[a-zA-Z0-9]+$/", $value)) {
                            return $value;
                        }
                        break;
                    case self::PROMPT_NAME:
                        if (!preg_match("/^[a-zA-Z][^a-zA-Z0-9_ ]*$/", $value)) {
                            return $value;
                        }
                        break;
                    case self::PROMPT_LABEL:
                        if (!preg_match("/^[a-zA-Z0-9_ ]+$/", $value)) {
                            return $value;
                        }
                        break;
                    case self::PROMPT_PATH:
                        if (!preg_match("/^[a-zA-Z0-9_:+.-\/\\\\]+$/", $value)) {
                            return $value;
                        }
                    default:
                        return $value;
                }
            }
        } while (true);
    }

    /**
     * @param $value
     * @return mixed
     */
    protected function toAlphaNumeric($value)
    {
        return preg_replace("/[^a-zA-Z0-9_]/", "", $value);
    }

    /**
     * @param $dir
     * @param $file_pattern
     * @param $files
     */
    protected function findFiles($dir, $file_pattern, &$files)
    {
        $items = glob($dir . '/*', GLOB_NOSORT);
        foreach ($items as $item) {
            if (is_file($item)) {
                if (!$file_pattern || preg_match("/$file_pattern/", $item)) {
                    $files[] = $item;
                }
            } else if (is_dir($item) && ($dir != $item)) {
                $this->findFiles($item, $file_pattern, $files);
            }
        }
    }

    // Option Handlers
    protected function handleCreateEntityModule()
    {
        $controller = new ParsVT_Tools_Console_EntityModuleController();
        $controller->setArguments($this->arguments, $this->interactive)->handle();
    }

    // Option Handlers
    protected function handleCreateExtensionModule()
    {
        $controller = new ParsVT_Tools_Console_ExtensionModuleController();
        $controller->setArguments($this->arguments, $this->interactive)->handle();
    }

    protected function handleCreateLanguage()
    {
        $controller = new ParsVT_Tools_Console_LanguageController();
        $controller->setArguments($this->arguments, $this->interactive)->handle();
    }

    protected function handleCreateTestLanguage()
    {
        $controller = new ParsVT_Tools_Console_TestLanguageController();
        $controller->setArguments($this->arguments, $this->interactive)->handle();
    }

    protected function handleCreateLayout()
    {
        $controller = new ParsVT_Tools_Console_LayoutController();
        $controller->setArguments($this->arguments, $this->interactive)->handle();
    }

    protected function handleImportModule()
    {
        $controller = new ParsVT_Tools_Console_ImportController();
        $controller->setArguments($this->arguments, $this->interactive)->handle();
    }

    protected function handleUpdateModule()
    {
        $controller = new ParsVT_Tools_Console_UpdateController();
        $controller->setArguments($this->arguments, $this->interactive)->handle();
    }

    protected function handleRemoveModule()
    {
        $controller = new ParsVT_Tools_Console_RemoveController();
        $controller->setArguments($this->arguments, $this->interactive)->handle();
    }

    // Static
    public static function run()
    {
        $singleton = new self();
        $singleton->handle();
    }

    public function __loadMethod($sMethod, $Parameters = array())
    {
        if (method_exists($this, $sMethod)) {
            $reflection = new ReflectionMethod($this, $sMethod);
            if (!$reflection->isPublic() && !$reflection->isProtected()) {
                throw new Exception('Permission denied');
            }
            return call_user_func_array(array($this, $sMethod), $Parameters);
        } else {
            throw new Exception('Invalid parameters!');
        }
    }
}

/**
 * Class ParsVT_Tools_Console_EntityModuleController
 */
class ParsVT_Tools_Console_EntityModuleController extends ParsVT_Tools_Console_Controller
{

    public function handle()
    {
        $Vtiger_Utils_Log = true;
        echo "  >>> ENTITY MODULE <<<\n";
        $moduleCreater = false;
        $moduleLinkCreater= Vtiger_Module_Model::getInstance('ModuleLinkCreator');
        if($moduleLinkCreater && $moduleLinkCreater->isActive()){
            do {
                echo "  Choose how to create the module:\n";
                echo "  1. Custom Module Using vtlib.\n";
                echo "  2. Custom Module Using ModuleLinkCreator.\n";

                $moduleBuilderType = ucwords($this->prompt("  Enter your choice: ", self::PROMPT_ANY));
                if (in_array($moduleBuilderType, [1 , 2])) {
                    if ($moduleBuilderType == 2) {
                        $moduleCreater = true;
                    }
                    break;
                }
            } while (true);
        }
        $moduleInformation = array();
        do {
            $moduleInformation['name'] = ucwords($this->prompt("  Enter module name: ", self::PROMPT_NAME));
            $firstChar = $moduleInformation['name'][0];
            if (is_numeric($firstChar)) {
                echo "  ERROR: Module name cannot start with a number., try another.\n";
            } else if (strlen($moduleInformation['name']) > 25) {
                echo "  ERROR: The name of the module must be at most 25 characters., try another.\n";
            } else {
                $module = $this->find($moduleInformation['name']);
                if (!$module) {
                    break;
                }
                echo "  ERROR: " . $moduleInformation['name'] . " module already exists, try another.\n";
            }
        } while (true);

        do {
            echo "  Select the module app menu:\n";
            echo "  1. Marketing.\n";
            echo "  2. Sales.\n";
            echo "  3. Inventory.\n";
            echo "  4. Tools.\n";
            echo "  5. Support.\n";
            echo "  6. Projects.\n";
            $moduleInformation['parent'] = 'Tools';
            $parent = ucwords($this->prompt("  Enter your choice: ", self::PROMPT_ANY));
            if (in_array($parent, [1 , 2, 3, 4, 5, 6])) {
                switch ($parent) {
                    case "1":
                        $moduleInformation['parent'] = 'Marketing';
                        break;
                    case "2":
                        $moduleInformation['parent'] = 'Sales';
                        break;
                    case "3":
                        $moduleInformation['parent'] = 'Inventory';
                        break;
                    case "5":
                        $moduleInformation['parent'] = 'Support';
                        break;
                    case "6":
                        $moduleInformation['parent'] = 'Projects';
                        break;
                    default:
                        $moduleInformation['parent'] = 'Tools';
                }
                break;
            }
        } while (true);


        if($moduleCreater){
            echo "  Creating via ModuleLinkCreator ...\n";
            echo "  Creating ...\n";

            $this->createModuleLinkCreator($moduleInformation);
            echo "  DONE.\n";
        } else {
            echo "  Creating via vtlib ...\n";

            $moduleInformation['entityfieldlabel'] = 'Name';

            $entityfieldlabel = ucwords($this->prompt(sprintf("  Entity field (%s): ",
                $moduleInformation['entityfieldlabel']), self::PROMPT_OPTIONAL));
            if ($entityfieldlabel) {
                $moduleInformation['entityfieldlabel'] = $entityfieldlabel;
            }


            echo "  Creating ...\n";
            $this->create($moduleInformation);
            echo "  DONE.\n";
        }

    }

    public function find($name)
    {
        return Vtiger_Module::getInstance($name);
    }

    protected function createModuleLinkCreator($moduleInformation)
    {
        include 'vtigerversion.php';
        global $adb, $vtiger_current_version;
        $params = array();
        $parent = $moduleInformation['parent'];
        $params["module_name"] = $moduleInformation['name'];
        $params["module_label"] = $moduleInformation['name'];
        $params["module_type"] = 1;
        $params["module_fields"] = json_encode([0,1,2,3,4,5,6,7]);
        $params["module_list_view_filter_fields"] = json_encode([0,1,2,3]);
        $params["module_summary_fields"] = json_encode([0,1,2,3]);
        $params["module_quick_create_fields"] = json_encode([0,1,2]);
        $module_links = ['Updates', 'Comments', 'Documents','Activities','Emails'];
        $params["module_links"] = json_encode($module_links);
        $params["description"] =null;
        $icons = '\\e671';
        set_time_limit(0);
        $moduleController = new ModuleLinkCreator_EntityModuleController();
        $module = $moduleController->createModule($params["module_name"], $parent, "Name");
        if ($module) {
            if (version_compare($vtiger_current_version, "7.0.0", ">=")) {
                Settings_MenuEditor_Module_Model::addModuleToApp($params["module_name"], $parent);
                vtws_addDefaultModuleTypeEntity($params["module_name"]);
            }
            $module->initWebservice();
            $baseBlockLabel = "LBL_" . strtoupper($module->name) . "_INFORMATION";
            $lowerModuleName = strtolower($module->name);
            $tblCrmentity = "vtiger_crmentity";
            $module_basetable = "vtiger_" . $lowerModuleName;
            $otherFields = array($module->name => array($baseBlockLabel => array((string) $lowerModuleName . "no" => array("label" => (string) $module->label . " No", "table" => $module_basetable, "uitype" => 4, "summaryfield" => 0), "description" => array("label" => "Description", "uitype" => 19, "table" => $tblCrmentity, "quickcreate" => 0, "summaryfield" => 1, "quickcreatesequence" => 3, "filter" => array("name" => "All", "isdefault" => false)), "created_user_id" => array("label" => "Created By", "uitype" => 52, "columnname" => "smcreatorid", "summaryfield" => 0, "masseditable" => 0, "table" => $tblCrmentity, "displaytype" => 2), "modifiedby" => array("label" => "Last Modified By", "uitype" => 52, "presence" => 0, "summaryfield" => 0, "masseditable" => 0, "table" => $tblCrmentity, "displaytype" => 2))));
            $moduleController->createFields($module, $otherFields);
            $prefix = "NO";
            if (2 <= strlen($module->name)) {
                $prefix = substr($module->name, 0, 2);
                $prefix = strtoupper($prefix);
            }
            $moduleController->customizeRecordNumbering($module->name, $prefix, 1);
            $languageStrings = array($params["module_name"] => $params["module_label"], "SINGLE_" . $params["module_name"] => $params["module_label"], (string) $params["module_name"] . " ID" => (string) $params["module_label"] . " ID", $baseBlockLabel => (string) $params["module_label"] . " Information");
            $jsLanguageStrings = array();
            $languageController = new ModuleLinkCreator_Console_LanguageController();
            $languageController->createLanguage($params["module_name"], $languageStrings, $jsLanguageStrings);
            $moduleController->createCustomViews($module, $icons);
            $moduleController->createCustomModels($module);
            $commentInstance = Vtiger_Module::getInstance("ModComments");
            $commentRelatedToFieldInstance = Vtiger_Field::getInstance("related_to", $commentInstance);
            if ($commentRelatedToFieldInstance) {
                $commentRelatedToFieldInstance->setRelatedModules(array($module->name));
                if (version_compare($vtiger_current_version, "7.0.0", ">=")) {
                    $module->setRelatedList($commentInstance, "ModComments", false, "get_comments");
                }
            }
            $moduleDocuments = Vtiger_Module::getInstance("Documents");
            $module->setRelatedList($moduleDocuments, "Documents", array("ADD", "SELECT"), "get_attachments");
            $moduleCalendar = Vtiger_Module::getInstance("Calendar");
            $parentIDFieldModel = Vtiger_Field_Model::getInstance("parent_id", $moduleCalendar);
            $module->setRelatedList($moduleCalendar, "Activities", array("ADD"), "get_activities", $parentIDFieldModel->getId());
            $adb->pquery("INSERT INTO `vtiger_fieldmodulerel` (`fieldid`, `module`, `relmodule`) VALUES (?, ?, ?)", array($parentIDFieldModel->getId(), $params["module_name"], "Calendar"));
            $moduleEmails = Vtiger_Module::getInstance("Emails");
            $module->setRelatedList($moduleEmails, "Emails", array("ADD"), "get_emails");
            $activityFieldTypeId = 34;
            $moduleController->addModuleRelatedToForEvents($module->name, $activityFieldTypeId);
            $result = $adb->pquery("SELECT * FROM com_vtiger_workflow_tasktypes WHERE tasktypename IN (?,?);", array("VTCreateTodoTask", "VTCreateEventTask"));
            if (0 < $adb->num_rows($result)) {
                while ($rowTask = $adb->fetch_array($result)) {
                    $id = $rowTask["id"];
                    $tasktypename = $rowTask["tasktypename"];
                    $moduleslist = $rowTask["modules"];
                    $modules = Zend_Json::decode(html_entity_decode($moduleslist));
                    $includeModules = $modules["include"];
                    $excludeModules = $modules["exclude"];
                    $includeModules[] = $module->name;
                    $moduleslist = Zend_Json::encode(array("include" => $includeModules, "exclude" => $excludeModules));
                    $adb->pquery("update `com_vtiger_workflow_tasktypes` set `modules`=? where `id`=? AND `tasktypename`=? LIMIT 1;", array($moduleslist, $id, $tasktypename));
                }
            }
            require_once "modules/ModTracker/ModTracker.php";
            ModTracker::enableTrackingForModule($module->id);
            $recordModel = new ModuleLinkCreator_Record_Model();
            $record = 0;
            $params["module_id"] = $module->getId();
            $recordModel->save($record, $params);
            $settingRecordModel = new ModuleLinkCreator_SettingRecord_Model();
            $settings = array();
            $settingRecordModel->saveByModule($params["module_id"], $settings);
            $sql = "UPDATE `vtiger_field` SET `summaryfield`='1' WHERE fieldname IN ('name','assigned_user_id') AND tabid = (SELECT tabid FROM vtiger_tab WHERE name = '" . $module->name . "');";
            $adb->query($sql);
        }
        if (version_compare($vtiger_current_version, "7.0.0", "<")) {
            $template_folder = "layouts/vlayout";
        } else {
            $template_folder = "layouts/v7";
            $css_widgetType = "HEADERCSS";
            $css_widgetName = $params["module_name"];
            $css_link = (string) $template_folder . "/modules/" . $params["module_name"] . "/resources/Styles.css";
            if ($module) {
                $module->addLink($css_widgetType, $css_widgetName, $css_link);
            }
        }
    }

    protected function create($moduleInformation)
    {
        $moduleInformation['entityfieldname'] = strtolower($this->toAlphaNumeric($moduleInformation['entityfieldlabel']));

        $module = new Vtiger_Module();
        $module->name = $moduleInformation['name'];
        $module->parent = strtoupper($moduleInformation['parent']);
        $module->save();

        $module->initTables();

        $block = new Vtiger_Block();
        $block->label = 'LBL_' . strtoupper($module->name) . '_INFORMATION';
        $module->addBlock($block);

        $blockcf = new Vtiger_Block();
        $blockcf->label = 'LBL_CUSTOM_INFORMATION';
        $module->addBlock($blockcf);

        $field1 = new Vtiger_Field();
        $field1->name = $moduleInformation['entityfieldname'];
        $field1->label = $moduleInformation['entityfieldlabel'];
        $field1->uitype = 2;
        $field1->column = $field1->name;
        $field1->columntype = 'VARCHAR(255)';
        $field1->typeofdata = 'V~M';
        $block->addField($field1);

        $module->setEntityIdentifier($field1);

        /** Common fields that should be in every module, linked to vtiger CRM core table */
        $field2 = new Vtiger_Field();
        $field2->name = 'assigned_user_id';
        $field2->label = 'Assigned To';
        $field2->table = 'vtiger_crmentity';
        $field2->column = 'smownerid';
        $field2->uitype = 53;
        $field2->typeofdata = 'V~M';
        $block->addField($field2);

        $field3 = new Vtiger_Field();
        $field3->name = 'createdtime';
        $field3->label = 'Created Time';
        $field3->table = 'vtiger_crmentity';
        $field3->column = 'createdtime';
        $field3->uitype = 70;
        $field3->typeofdata = 'T~O';
        $field3->displaytype = 2;
        $block->addField($field3);

        $field4 = new Vtiger_Field();
        $field4->name = 'modifiedtime';
        $field4->label = 'Modified Time';
        $field4->table = 'vtiger_crmentity';
        $field4->column = 'modifiedtime';
        $field4->uitype = 70;
        $field4->typeofdata = 'T~O';
        $field4->displaytype = 2;
        $block->addField($field4);

        // Create default custom filter (mandatory)
        $filter1 = new Vtiger_Filter();
        $filter1->name = 'All';
        $filter1->isdefault = true;
        $module->addFilter($filter1);
        // Add fields to the filter created
        $filter1->addField($field1)->addField($field2, 1)->addField($field3, 2);

        // Set sharing access of this module
        $module->setDefaultSharing();

        // Enable and Disable available tools
        $module->enableTools(Array('Import', 'Export', 'Merge'));

        // Initialize Webservice support
        $module->initWebservice();

        // Create files
        $this->createFiles($module, $field1);

        // Link to menu
        Settings_MenuEditor_Module_Model::addModuleToApp($module->name, $module->parent);
    }

    protected function createFiles(Vtiger_Module $module, Vtiger_Field $entityField)
    {
        $targetpath = 'modules/' . $module->name;
        if (!is_file($targetpath)) {
            mkdir($targetpath);
            //mkdir($targetpath . '/language');

            $templatepath = 'vtlib/ModuleDir/6.0.0';

            $moduleFileContents = file_get_contents($templatepath . '/ModuleName.php');
            $replacevars = array(
                'ModuleName' => $module->name,
                '<modulename>' => strtolower($module->name),
                '<entityfieldlabel>' => $entityField->label,
                '<entitycolumn>' => $entityField->column,
                '<entityfieldname>' => $entityField->name,
            );

            foreach ($replacevars as $key => $value) {
                $moduleFileContents = str_replace($key, $value, $moduleFileContents);
            }
            file_put_contents($targetpath . '/' . $module->name . '.php', $moduleFileContents);
        }
        $targetpath = 'languages/en_us/' . $module->name.'.php';
        if (!is_file($targetpath)) {
            $templatepath = 'vtlib/ModuleDir/6.0.0';
            if (file_exists($templatepath . '/languages/en_us/ModuleName.php')) {
                $moduleFileContents = file_get_contents($templatepath . '/languages/en_us/ModuleName.php');
                $replacevars = array(
                    'ModuleName' => $module->name,
                    'Module Name' => ucfirst($module->name),
                );
                foreach ($replacevars as $key => $value) {
                    $moduleFileContents = str_replace($key, $value, $moduleFileContents);
                }
                file_put_contents($targetpath, $moduleFileContents);
                if (is_dir('languages/fa_ir/')) {
                    $targetpath = 'languages/fa_ir/' . $module->name.'.php';
                    file_put_contents($targetpath, $moduleFileContents);
                    if (file_exists($targetpath)) {
                        include_once $targetpath;
                        $languageStringsTranslation = array();
                        if(isset($languageStrings)){
                            foreach ($languageStrings as $key=>$text){
                                $translatedString = ParsVT_Tools_Console_Translate::translate('en','fa', $text);
                                $languageStringsTranslation[$key] = ($translatedString != '' ? $translatedString : $text);
                            }
                            $string  = "<?php \n/* ********************************************************************************\n * The content of this file is subject to the VTFarsi.ir Modules License(\"License\");\n * You may not use this file except in compliance with the License\n * The Initial Developer of the Original Code is VTFarsi.ir\n * Portions created by VTFarsi.ir. are Copyright(C) VTFarsi Team\n * All Rights Reserved.\n * ****************************************************************************** */\n\n";
                            $string .= '$languageStrings = ' . var_export( $languageStringsTranslation, true ) . ";\n\n";
                            file_put_contents( $targetpath, $string );
                        }
                    }
                }
            }
        }
    }

}

/**
 * Class ParsVT_Tools_Console_ExtensionModuleController
 */
class ParsVT_Tools_Console_ExtensionModuleController extends ParsVT_Tools_Console_Controller
{

    public static $directories = [
        'modules/%s' => [
            '%s.php' => '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'
        ],
        'modules/%s/crons' => [
            '%s.php.rename' => 'PD9waHANCg0KaW5jbHVkZSAibW9kdWxlcy9FbWFpbHMvbWFpbC5waHAiOw0KZWNobyAiVGhpcyBpcyBhbiBleGFtcGxlIGNyb250YWIgZm9yIE1vZHVsZU5hbWUuLi4iLlBIUF9FT0w7DQpnbG9iYWwgJEhFTFBERVNLX1NVUFBPUlRfTkFNRSwgJEhFTFBERVNLX1NVUFBPUlRfRU1BSUxfSUQ7DQokb3V0Z29pbmdzZXJ2ZXIgPSAgbmV3IFNldHRpbmdzX1Z0aWdlcl9PdXRnb2luZ1NlcnZlcl9Nb2RlbDsNCiRtYWlsX3N0YXR1cyA9IHNlbmRfbWFpbCgiVXNlcnMiLCRIRUxQREVTS19TVVBQT1JUX0VNQUlMX0lELCAkSEVMUERFU0tfU1VQUE9SVF9OQU1FLCRIRUxQREVTS19TVVBQT1JUX0VNQUlMX0lELCRvdXRnb2luZ3NlcnZlci0+Z2V0U3ViamVjdCgpLCRvdXRnb2luZ3NlcnZlci0+Z2V0Qm9keSgpLCIiLCIiLCIiLCIiLCIiLHRydWUpOw0KaWYoJG1haWxfc3RhdHVzICE9IDEgKSB7DQogICAgZWNobyAiRXJyb3Igb2NjdXJyZWQgd2hpbGUgc2VuZGluZyBtYWlsIi5QSFBfRU9MOw0KfQ0KPz4NCg==',
            '%s.service.rename' => 'PD9waHANCnJlcXVpcmVfb25jZSgibW9kdWxlcy9Nb2R1bGVOYW1lL2Nyb25zL01vZHVsZU5hbWUucGhwIik7DQo'
        ],
        'modules/%s/helpers' => [
            'Version.php' => 'PD9waHANCg0KY2xhc3MgTW9kdWxlTmFtZV9WZXJzaW9uX0hlbHBlciB7DQoNCiAgICBwdWJsaWMgc3RhdGljICR2ZXJzaW9uID0gJzEuMC4wJzsNCiAgICBwdWJsaWMgc3RhdGljICRwYXRjaCA9ICcnOw0KDQogICAgcHVibGljIHN0YXRpYyBmdW5jdGlvbiBnZXRWZXJzaW9uKCkNCiAgICB7DQogICAgICAgIHJldHVybiBzZWxmOjokdmVyc2lvbjsNCiAgICB9DQogICAgDQogICAgcHVibGljIHN0YXRpYyBmdW5jdGlvbiBnZXRQYXRjaCgpDQogICAgew0KICAgICAgICByZXR1cm4gKGVtcHR5KHNlbGY6OiRwYXRjaCkgPyBkYXRlKCdZbWQnKSA6IHNlbGY6OiRwYXRjaCk7DQogICAgfQ0KDQp9',
        ],
        'modules/%s/models' => [
            'Module.php' => 'PD9waHANCmNsYXNzIE1vZHVsZU5hbWVfTW9kdWxlX01vZGVsIGV4dGVuZHMgVnRpZ2VyX01vZHVsZV9Nb2RlbCB7DQoNCiAgICAvKioNCiAgICAgKiBGdW5jdGlvbiB0byBnZXQgU2V0dGluZ3MgbGlua3MNCiAgICAgKiBAcmV0dXJuIDxBcnJheT4NCiAgICAgKi8NCiAgICBwdWJsaWMgZnVuY3Rpb24gZ2V0U2V0dGluZ0xpbmtzKCkNCiAgICB7DQogICAgICAgICRzZXR0aW5nc0xpbmtzW10gPSBhcnJheSgNCiAgICAgICAgICAgICdsaW5rdHlwZScgPT4gJ0xJU1RWSUVXU0VUVElOR1MnLA0KICAgICAgICAgICAgJ2xpbmtsYWJlbCcgPT4gJ1NldHRpbmdzJywNCiAgICAgICAgICAgICdsaW5rdXJsJyA9PiAnaW5kZXgucGhwP3BhcmVudD1TZXR0aW5ncyZtb2R1bGU9JyAuICR0aGlzLT5nZXROYW1lKCkgLiAnJnZpZXc9U2V0dGluZ3MnLA0KICAgICAgICAgICAgJ2xpbmtpY29uJyA9PiAnJw0KICAgICAgICApOw0KICAgICAgICByZXR1cm4gJHNldHRpbmdzTGlua3M7DQogICAgfQ0KDQogICAgLyoqDQogICAgICogRnVuY3Rpb24gdG8gY2hlY2sgd2hldGhlciB0aGUgbW9kdWxlIGlzIGFuIGVudGl0eSB0eXBlIG1vZHVsZSBvciBub3QNCiAgICAgKiBAcmV0dXJuIDxCb29sZWFuPiB0cnVlL2ZhbHNlDQogICAgICovDQogICAgcHVibGljIGZ1bmN0aW9uIGlzRW50aXR5TW9kdWxlKCkgew0KICAgICAgICByZXR1cm4gZmFsc2UgOw0KICAgIH0NCg0KfQ0KPz4NCg==',
        ],
        'modules/%s/views' => [
            'Settings.php' => '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'
        ],
        'modules/%s/workflows' => [
            '%sTask.inc.rename' => 'PD9waHAKcmVxdWlyZV9vbmNlKCdtb2R1bGVzL01vZHVsZU5hbWUvd29ya2Zsb3cvTW9kdWxlTmFtZVRhc2sucGhwJyk7Cj8+Cg==',
            '%sTask.php.rename' => 'PD9waHAKcmVxdWlyZV9vbmNlICJtb2R1bGVzL2NvbV92dGlnZXJfd29ya2Zsb3cvVlRFbnRpdHlDYWNoZS5pbmMiOwpyZXF1aXJlX29uY2UgIm1vZHVsZXMvY29tX3Z0aWdlcl93b3JrZmxvdy9WVFdvcmtmbG93VXRpbHMucGhwIjsKY2xhc3MgTW9kdWxlTmFtZVRhc2sgZXh0ZW5kcyBWVFRhc2sKewogICAgcHVibGljICRleGVjdXRlSW1tZWRpYXRlbHkgPSB0cnVlOwoKICAgIHB1YmxpYyBmdW5jdGlvbiBnZXRGaWVsZE5hbWVzKCl7cmV0dXJuIGFycmF5KCk7fQogICAgcHVibGljIGZ1bmN0aW9uIGRvVGFzaygkZW50aXR5KXsKICAgICAgICAkc3RhdGVtZW50PSR0aGlzLT5zdGF0ZW1lbnQ7CiAgICAgICAgZWNobyAiVGhpcyBpcyBhIGR1bW15IHdvcmtmbG93IHRhc2sgd2l0aCAkc3RhdGVtZW50IjsKICAgIH0KfQoKPz4=',
        ],
        'modules/%s/actions' => [
            'ActionAjax.php.rename' => 'PD9waHAKY2xhc3MgTW9kdWxlTmFtZV9BY3Rpb25BamF4X0FjdGlvbiBleHRlbmRzIFZ0aWdlcl9BY3Rpb25fQ29udHJvbGxlcgp7CiAgICBwdWJsaWMgZnVuY3Rpb24gY2hlY2tQZXJtaXNzaW9uKFZ0aWdlcl9SZXF1ZXN0ICRyZXF1ZXN0KQogICAgewoKICAgIH0KCiAgICBwdWJsaWMgZnVuY3Rpb24gX19jb25zdHJ1Y3QoKQogICAgewogICAgICAgIHBhcmVudDo6X19jb25zdHJ1Y3QoKTsKICAgICAgICAkdGhpcy0+ZXhwb3NlTWV0aG9kKCJIZWxsb1dvcmxkIik7CiAgICB9CgoKICAgIHB1YmxpYyBmdW5jdGlvbiBwcm9jZXNzKFZ0aWdlcl9SZXF1ZXN0ICRyZXF1ZXN0KQogICAgewogICAgICAgICRtb2RlID0gJHJlcXVlc3QtPmdldCgnbW9kZScpOwogICAgICAgIGlmICghZW1wdHkoJG1vZGUpKSB7CiAgICAgICAgICAgICR0aGlzLT5pbnZva2VFeHBvc2VkTWV0aG9kKCRtb2RlLCAkcmVxdWVzdCk7CiAgICAgICAgICAgIHJldHVybjsKICAgICAgICB9CiAgICB9CgogICAgcHVibGljIGZ1bmN0aW9uIEhlbGxvV29ybGQoVnRpZ2VyX1JlcXVlc3QgJHJlcXVlc3QpewogICAgICAgICRuYW1lID0gJHJlcXVlc3QtPmdldCgnbmFtZScpOwogICAgICAgICRyZXNwb25zZSA9IG5ldyBWdGlnZXJfUmVzcG9uc2UoKTsKICAgICAgICAkcmVzcG9uc2UtPnNldEVtaXRUeXBlKFZ0aWdlcl9SZXNwb25zZTo6JEVNSVRfSlNPTik7CiAgICAgICAgJHJlc3BvbnNlLT5zZXRSZXN1bHQoJ0hlbGxvIFdvcmxkICcuICRuYW1lKTsKICAgICAgICAkcmVzcG9uc2UtPmVtaXQoKTsKICAgIH0KCn0KCgo/Pgo='
        ],
        'modules/%s/handlers' => [
            '%sHandler.php.rename' => 'PD9waHANCnJlcXVpcmVfb25jZSAnaW5jbHVkZS9ldmVudHMvVlRFdmVudEhhbmRsZXIuaW5jJzsNCmNsYXNzIE1vZHVsZU5hbWVIYW5kbGVyIGV4dGVuZHMgVlRFdmVudEhhbmRsZXINCnsNCiAgICBmdW5jdGlvbiBoYW5kbGVFdmVudCgkZXZlbnROYW1lLCAkZGF0YSkNCiAgICB7DQogICAgICAgIGdsb2JhbCAkYWRiOw0KICAgICAgICBpZiAoJGV2ZW50TmFtZSA9PSAndnRpZ2VyLmVudGl0eS5hZnRlcnNhdmUnKSB7DQogICAgICAgICAgICAkbW9kdWxlSWQgPSAkZGF0YS0+Z2V0SWQoKTsNCiAgICAgICAgICAgIC8vd3JpdGUgeW91ciBvd24gY29kZSBoZXJlDQogICAgICAgIH0NCiAgICB9DQp9'
        ],
        'modules/%s/dashboards' => [
            'Sample.php.rename' => 'PD9waHANCmNsYXNzIE1vZHVsZU5hbWVfU2FtcGxlX0Rhc2hib2FyZCBleHRlbmRzIFZ0aWdlcl9JbmRleEFqYXhfVmlldyB7DQoNCglwdWJsaWMgZnVuY3Rpb24gcHJvY2VzcyhWdGlnZXJfUmVxdWVzdCAkcmVxdWVzdCkgew0KCQkkY3VycmVudFVzZXIgPSBVc2Vyc19SZWNvcmRfTW9kZWw6OmdldEN1cnJlbnRVc2VyTW9kZWwoKTsgICAgICAgIA0KCQkkdmlld2VyID0gJHRoaXMtPmdldFZpZXdlcigkcmVxdWVzdCk7DQoJCSRtb2R1bGVOYW1lID0gJHJlcXVlc3QtPmdldE1vZHVsZSgpOw0KCQkkY29udGVudHMgPSAkcmVxdWVzdC0+Z2V0KCdjb250ZW50Jyk7DQoJCSR2aWV3ZXItPmFzc2lnbignY29udGVudCcsIChlbXB0eSgkY29udGVudHMpID8gdHJ1ZSA6IGZhbHNlKSk7DQoJICAgICRsaW5rSWQgPSAkcmVxdWVzdC0+Z2V0KCdsaW5raWQnKTsNCgkJJHdpZGdldCA9IFZ0aWdlcl9XaWRnZXRfTW9kZWw6OmdldEluc3RhbmNlKCRsaW5rSWQsICRjdXJyZW50VXNlci0+Z2V0SWQoKSk7DQoJCSR2aWV3ZXItPmFzc2lnbignV0lER0VUJywgJHdpZGdldCk7DQoJCSR2aWV3ZXItPmFzc2lnbignTU9EVUxFX05BTUUnLCAkbW9kdWxlTmFtZSk7DQoJCSRyZXN1bHQgPSAnVGhpcyBpcyBhIGR1bW15IGRhc2hib2FyZCB3aWRnZXQuJzsNCiAgICAgICAgJHZpZXdlci0+YXNzaWduKCdSRVNVTFQnLCRyZXN1bHQpOw0KICAgICAgICAkdmlld2VyLT52aWV3KCdkYXNoYm9hcmRzL1NhbXBsZS50cGwnLCAkbW9kdWxlTmFtZSk7DQoJfQ0KfQ0K'
        ],
        'layouts/v7/modules/%s' => [
            'Settings.tpl' => 'PGRpdiBjbGFzcz0iY29udGFpbmVyLWZsdWlkIj4KICAgIDxkaXYgY2xhc3M9IndpZGdldF9oZWFkZXIgcm93LWZsdWlkIj4KICAgICAgICA8aDM+e3Z0cmFuc2xhdGUoJ01vZHVsZU5hbWUnLCAnTW9kdWxlTmFtZScpfTwvaDM+CiAgICA8L2Rpdj4KICAgIDxocj4KICAgIDxkaXYgY2xhc3M9ImNsZWFyZml4Ij48L2Rpdj4KICAgIDxkaXYgY2xhc3M9InN1bW1hcnlXaWRnZXRDb250YWluZXIiPgogICAgICAgIDxkaXYgY2xhc3M9InJvdy1mbHVpZCI+CiAgICAgICAgICAgIHt2dHJhbnNsYXRlKCdIZWxsbyBXb3JsZCcsICdNb2R1bGVOYW1lJyl9CiAgICAgICAgPC9kaXY+CiAgICA8L2Rpdj4KPC9kaXY+Cg=='
        ],
        'layouts/v7/modules/%s/dashboards' => [
            'Sample.tpl' => 'PGRpdiBjbGFzcz0iZGFzaGJvYXJkV2lkZ2V0SGVhZGVyIj4NCiAgICB7aW5jbHVkZSBmaWxlPSJkYXNoYm9hcmRzL1dpZGdldEhlYWRlci50cGwifEB2dGVtcGxhdGVfcGF0aDokTU9EVUxFX05BTUV9DQo8L2Rpdj4NCjxkaXYgY2xhc3M9ImRhc2hib2FyZFdpZGdldENvbnRlbnQiPg0KICAgIDxkaXYgY2xhc3M9InBhcnN2dF91cGRhdGVzIiBzdHlsZT0icGFkZGluZy10b3A6NXB4O2hlaWdodDoxODBweDsiPg0KICAgICAgICB7JFJFU1VMVH0NCiAgICA8L2Rpdj4NCjwvZGl2Pg0KPGRpdiBjbGFzcz0id2lkZ2V0aWNvbnMgZGFzaEJvYXJkV2lkZ2V0Rm9vdGVyIj4NCiAgICA8ZGl2IGNsYXNzPSJmb290ZXJJY29ucyBwdWxsLXJpZ2h0Ij4NCiAgICAgICAge2lmICEkV0lER0VULT5pc0RlZmF1bHQoKX0NCiAgICAgICAgICAgIDxhIG5hbWU9ImRjbG9zZSIgY2xhc3M9IndpZGdldCIgZGF0YS11cmw9InskV0lER0VULT5nZXREZWxldGVVcmwoKX0iPg0KICAgICAgICAgICAgICAgIDxpIGNsYXNzPSJmYSBmYS1yZW1vdmUiIGhzcGFjZT0iMiIgYm9yZGVyPSIwIiBhbGlnbj0iYWJzbWlkZGxlIiB0aXRsZT0ie3Z0cmFuc2xhdGUoJ0xCTF9SRU1PVkUnKX0iIGFsdD0ie3Z0cmFuc2xhdGUoJ0xCTF9SRU1PVkUnKX0iPjwvaT4NCiAgICAgICAgICAgIDwvYT4NCiAgICAgICAgey9pZn0NCiAgICA8L2Rpdj4NCjwvZGl2Pg=='
        ],
        'layouts/v7/modules/%s/images' => [
            'icon.png' => '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'
        ],
        'layouts/v7/modules/%s/partials' => [
            'SidebarHeader.tpl' => 'PGRpdiBjbGFzcz0iY29sLXNtLTEyIGNvbC14cy0xMiBhcHAtaW5kaWNhdG9yLWljb24tY29udGFpbmVyIGFwcC17JFNFTEVDVEVEX01FTlVfQ0FURUdPUll9Ij4NCgk8ZGl2IGNsYXNzPSJyb3ciIHRpdGxlPSJ7dnRyYW5zbGF0ZSgkTU9EVUxFLCAkTU9EVUxFKX0iIGRhdGEtdG9nZ2xlPSJ0b29sdGlwIj4NCgkJPHNwYW4gY2xhc3M9ImFwcC1pbmRpY2F0b3ItaWNvbiBmYSB7aWYgJHNtYXJ0eS5nZXQudmlldyBlcSAnU2V0dGluZ3MnfWZhLWdlYXJze2Vsc2V9ZmEtY29ubmVjdGRldmVsb3B7L2lmfSI+PC9zcGFuPg0KCTwvZGl2Pg0KPC9kaXY+DQoNCntpbmNsdWRlIGZpbGU9Im1vZHVsZXMvVnRpZ2VyL3BhcnRpYWxzL1NpZGViYXJBcHBNZW51LnRwbCJ9'
        ],
        'layouts/v7/modules/%s/resources' => [
            '%s.js' => 'dmFyIFZ0aWdlcl9Nb2R1bGVOYW1lX0pzID0gew0KICAgIEhlbGxvV29ybGQ6IGZ1bmN0aW9uICgpIHsNCiAgICAgICAgY29uc29sZS5kaXIoJ0hlbGxvIFdvcmxkJyk7DQogICAgfSwNCiAgICByZWdpc3RlckV2ZW50czogZnVuY3Rpb24gKCkgew0KICAgICAgICB2YXIgdGhpc0luc3RhbmNlID0gdGhpczsNCiAgICAgICAgdGhpc0luc3RhbmNlLkhlbGxvV29ybGQoKTsNCiAgICB9DQp9Ow0KLy9PbiBQYWdlIExvYWQNCmpRdWVyeShkb2N1bWVudCkucmVhZHkoZnVuY3Rpb24gKCkgew0KICAgIFZ0aWdlcl9Nb2R1bGVOYW1lX0pzLnJlZ2lzdGVyRXZlbnRzKCk7DQp9KTsNCg==',
            '%s.css' => 'LyogLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLQ0KIEN1c3RvbSBTdHlsZXNoZWV0IENvZGUNCiBBZGQgWW91ciBDdXN0b20gQ1NTIFRvIFZ0aWdlckNSTQ0KLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLSAqLw=='
        ],
        'layouts/v7/modules/%s/taskforms' => [
            '%sTask.tpl' => 'e2luY2x1ZGUgZmlsZT0ibGF5b3V0cy97dmdsb2JhbCgnZGVmYXVsdF9sYXlvdXQnKX0vbW9kdWxlcy9Nb2R1bGVOYW1lL3Rhc2tmb3Jtcy9UYXNrLnRwbCJ9',
            'Task.tpl' => 'e3N0cmlwfQ0KICAgIDxkaXYgY2xhc3M9InJvdyBkZHUtd29ya2Zsb3d0YXNrLWNvbnRhaW5lciI+DQogICAgICAgIDxkaXYgY2xhc3M9ImNvbC1zbS02IGNvbC14cy02IiBzdHlsZT0iZGlzcGxheTogZmxleDtmbGV4LWRpcmVjdGlvbjogY29sdW1uO2dhcDogMTBweDsiPg0KICAgICAgICAgICAgPGRpdiBjbGFzcz0icm93IiBzdHlsZT0iYWxpZ24taXRlbXM6Y2VudGVyO2Rpc3BsYXk6IGZsZXg7Ij4NCiAgICAgICAgICAgICAgICBUaGlzIGlzIGEgZHVtbXkgd29ya2Zsb3cgdGFzaw0KICAgICAgICAgICAgPC9kaXY+DQogICAgICAgIDwvZGl2Pg0KICAgIDwvZGl2Pg0Key9zdHJpcH0=',
        ]
    ];

    public function handle()
    {
        echo "  >>> EXTENSION MODULE <<<\n";

        $moduleInformation = array();
        do {
            $moduleInformation['name'] = ucwords($this->prompt("  Enter module name: ", self::PROMPT_NAME));
            $module = $this->find($moduleInformation['name']);
            if (!$module) {
                break;
            }
            echo "  ERROR: " . $moduleInformation['name'] . " module already exists, try another.\n";
        } while (true);

        echo "  Creating ...\n";
        $this->create($moduleInformation);
        echo "  DONE.\n";
    }

    public function find($name)
    {
        return Vtiger_Module::getInstance($name);
    }

    protected function create($moduleInformation)
    {
        $module = new Vtiger_Module();
        $module->name = $moduleInformation['name'];
        $module->label = $moduleInformation['name'];
        $module->parent = null;
        $module->isentitytype = false;
        $module->save();
        $this->createFiles($module);
        $moduleManagerModel = new Settings_ModuleManager_Module_Model();
        $moduleManagerModel->enableModule($module->name);
    }

    protected function createFiles(Vtiger_Module $module)
    {

        foreach (self::$directories as $directory => $options) {
            $directory = vsprintf($directory, [$module->name]);
            if (!is_dir($directory)) {
                if (!mkdir($directory, 0755, true)) {
                    continue;
                }
            }
            foreach ($options as $filename => $content) {
                $filename = vsprintf($filename, [$module->name] );
                $content = base64_decode($content);
                $fileContents = str_replace('ModuleName', $module->name, $content);
                file_put_contents($directory . '/' . $filename, $fileContents);
            }
        }
        $targetpath = 'languages/en_us/' . $module->name.'.php';
        if (!is_file($targetpath)) {
            $templatepath = 'vtlib/ModuleDir/6.0.0';
            if (file_exists($templatepath . '/languages/en_us/ModuleName.php')) {
                $moduleFileContents = file_get_contents($templatepath . '/languages/en_us/ModuleName.php');
                $replacevars = array(
                    'ModuleName' => $module->name,
                    'Module Name' => ucfirst($module->name),
                );
                foreach ($replacevars as $key => $value) {
                    $moduleFileContents = str_replace($key, $value, $moduleFileContents);
                }
                file_put_contents($targetpath, $moduleFileContents);
                if (is_dir('languages/fa_ir/')) {
                    $targetpath = 'languages/fa_ir/' . $module->name.'.php';
                    file_put_contents($targetpath, $moduleFileContents);
                    if (file_exists($targetpath)) {
                        include_once $targetpath;
                        $languageStringsTranslation = array();
                        if(isset($languageStrings)){
                            foreach ($languageStrings as $key=>$text){
                                $translatedString = ParsVT_Tools_Console_Translate::translate('en','fa', $text);
                                $languageStringsTranslation[$key] = ($translatedString != '' ? $translatedString : $text);
                            }
                            $string  = "<?php \n/* ********************************************************************************\n * The content of this file is subject to the VTFarsi.ir Modules License(\"License\");\n * You may not use this file except in compliance with the License\n * The Initial Developer of the Original Code is VTFarsi.ir\n * Portions created by VTFarsi.ir. are Copyright(C) VTFarsi Team\n * All Rights Reserved.\n * ****************************************************************************** */\n\n";
                            $string .= '$languageStrings = ' . var_export( $languageStringsTranslation, true ) . ";\n\n";
                            file_put_contents( $targetpath, $string );
                        }
                    }
                }
            }
        }
    }

}

class ParsVT_Tools_Console_LayoutController extends ParsVT_Tools_Console_Controller
{

    // Similar grouped patterns to identify the line on which tpl filename is specified.
    const VIEWERREGEX = '/\$viewer->(view|fetch)[^\(]*\(([^\)]+)/';
    const RETURNTPLREGEX = '/(return)([ ]+[\'"]+[^;]+)/';

    const TPLREGEX = '/[\'"]([^\'"]+)/';

    public function handle()
    {
        echo "  >>> LAYOUT <<<\n";

        $layoutInformation = array();
        do {
            $layoutInformation['name'] = strtolower($this->prompt("  Enter layout name: ", self::PROMPT_NAME));
            if (!file_exists('layouts/' . $layoutInformation['name'])) {
                break;
            }
            echo "  ERROR: " . $layoutInformation['name'] . " already exists, try another.\n";
        } while (true);

        echo "  Creating ...\n";
        $this->create($layoutInformation);
        echo "  DONE.\n";
    }

    protected function create($layoutInformation)
    {
        $files = array();
        $this->findFiles('includes', '.php$', $files);
        $this->findFiles('modules', '.php$', $files);

        $layoutdir = 'layouts/' . $layoutInformation['name'] . '/';

        foreach ($files as $file) {
            $tplfolder = $layoutdir . "modules/Vtiger";
            if (preg_match("/modules\/([^\/]+)\/([^\/]+)\//", $file, $fmatch)) {
                $tplfolder = $layoutdir . "modules/" . $fmatch[1];
                if ($fmatch[1] == 'Settings') {
                    $tplfolder .= '/' . $fmatch[2];
                }
            }

            $tpls = array();
            $this->findTemplateNames($file, $tpls);
            $tpls = array_unique($tpls);

            if ($tpls) {
                foreach ($tpls as $tpl) {
                    $tplname = basename($tpl, true);
                    // Fix sub-directory path
                    $tplpath = $tplfolder . '/' . substr($tpl, 0, strpos($tpl, $tplname));
                    if (!file_exists($tplpath)) {
                        mkdir($tplpath, 0755, true);
                    }
                    if (!file_exists($tplpath . $tplname)) {
                        $initialContent = "{* License Text *}\n";
                        // Enable debug to make it easy to implement.
                        $initialContent .= "{debug}{* REMOVE THIS LINE AFTER IMPLEMENTATION *}\n\n";
                        file_put_contents($tplpath . $tplname, $initialContent);
                    }
                    file_put_contents($tplpath . $tplname, "{* $file *}\n", FILE_APPEND);
                }
            }
        }
    }

    /**
     * @param $file
     * @param $tpls
     * @param bool $inreturn
     */
    protected function findTemplateNames($file, &$tpls, $inreturn = false)
    {
        $contents = file_get_contents($file);

        $regex = $inreturn ? self::RETURNTPLREGEX : self::VIEWERREGEX;
        if (preg_match_all($regex, $contents, $matches)) {
            foreach ($matches[2] as $match) {
                if (preg_match(self::TPLREGEX, $match, $matches2)) {
                    if (stripos($matches2[1], '.tpl') !== false) {
                        $tpls[] = $matches2[1];
                    }
                }
            }
            // Viewer files can also have return tpl calls - find them.
            if (!$inreturn) {
                $this->findTemplateNames($file, $tpls, true);
            }
        }
    }
}

/**
 * Class ParsVT_Tools_Console_LanguageController
 */
class ParsVT_Tools_Console_LanguageController extends ParsVT_Tools_Console_Controller
{
    /**
     *
     */
    const BASE_LANG_PREFIX = 'en_us';

    /**
     *
     */
    public function handle()
    {
        echo "  >>> LANGUAGE <<<\n";

        $languageInformation = array();
        do {
            $languageInformation['prefix'] = strtolower($this->prompt("  Enter (languagecode_countrycode): ", self::PROMPT_NAME));
            if (!file_exists('languages/' . $languageInformation['prefix'])) {
                break;
            }
            echo "  ERROR: " . $languageInformation['prefix'] . " already exists, try another.\n";
        } while (true);

        echo "  Creating ...\n";
        $this->create($languageInformation);
        echo "  DONE.\n";
    }

    /**
     * @param $languageInformation
     */
    protected function create($languageInformation)
    {
        $files = array();
        $this->findFiles('languages/' . self::BASE_LANG_PREFIX, '.php$', $files);

        foreach ($files as $file) {
            $filename = basename($file, true);
            $dir = substr($file, 0, strpos($file, $filename));
            $dir = str_replace('languages/' . self::BASE_LANG_PREFIX, 'languages/' . $languageInformation['prefix'], $dir);
            if (!file_exists($dir)) mkdir($dir);

            if (isset($languageInformation['prefix_value'])) {
                $contents = file_get_contents($file);
                $contents = preg_replace("/(=>[^'\"]+['\"])(.*)/", sprintf('$1%s$2', $languageInformation['prefix_value']), $contents);
                file_put_contents($dir . '/' . $filename, $contents);
            } else {
                copy($file, $dir . '/' . $filename);
            }
        }
    }

    /**
     * @param $languageInformation
     */
    protected function deploy($languageInformation)
    {
        if (!isset($languageInformation['label'])) {
            echo "  Language label not specified.";
            return;
        }

        $db = PearDatabase::getInstance();
        $check = $db->pquery('SELECT 1 FROM vtiger_language WHERE prefix=?', $languageInformation['prefix']);
        if ($check && $db->num_rows($check)) {
            ;
        } else {
            $db->pquery('INSERT INTO vtiger_language (id,name,prefix,label,lastupdated,isdefault,active) VALUES(?,?,?,?,?,?,?)',
                array($db->getUniqueId('vtiger_language'), $languageInformation['label'], $languageInformation['prefix'],
                    $languageInformation['label'], date('Y-m-d H:i:s'), 0, 1));
        }
    }
}

/**
 * Class ParsVT_Tools_Console_TestLanguageController
 */
class ParsVT_Tools_Console_TestLanguageController extends ParsVT_Tools_Console_LanguageController
{
    /**
     *
     */
    public function handle()
    {
        echo "  >>> TEST LANGUAGE <<<\n";

        $languageInformation = array('label' => 'TEST', 'prefix' => 'te_st', 'prefix_value' => '✔ ');

        echo "  Creating ...\n";
        $this->create($languageInformation);
        echo "  DONE\n";

        echo "  Deploying ...\n";
        $this->deploy($languageInformation);
        echo "  DONE.\n";
    }
}

/**
 * Class ParsVT_Tools_Console_ImportController
 */
class ParsVT_Tools_Console_ImportController extends ParsVT_Tools_Console_Controller
{
    /**
     * @throws Exception
     */
    public function handle()
    {
        if ($this->interactive) {
            echo "  >>> IMPORT MODULE <<<\n";
            do {
                $path = $this->prompt("  Enter package path: ", self::PROMPT_PATH);
                if (file_exists($path)) {
                    break;
                }
                echo "  ERROR: " . $path . " - file not found, try another.\n";
            } while (true);
        } else {
            $path = array_shift($this->arguments);
        }

        if (file_exists($path)) {
            $package = new Vtiger_Package();
            $module = $package->getModuleNameFromZip($path);

            $moduleInstance = Vtiger_Module::getInstance($module);
            if ($moduleInstance) {
                echo "  ERROR: Module $module already exists!\n";
            } else {
                echo "  Importing ...\n";
                $package->import($path);
                echo "  DONE.\n";
            }

        } else {
            throw new Exception("Package file $path not found.");
        }

    }
}

/**
 * Class ParsVT_Tools_Console_UpdateController
 */
class ParsVT_Tools_Console_UpdateController extends ParsVT_Tools_Console_Controller
{
    /**
     * @throws Exception
     */
    public function handle()
    {
        if ($this->interactive) {
            echo "  >>> UPDATE MODULE <<<\n";
            do {
                $path = $this->prompt("  Enter package path: ", self::PROMPT_PATH);
                if (file_exists($path)) {
                    break;
                }
                echo "  ERROR: " . $path . " - file not found, try another.\n";
            } while (true);
        } else {
            $path = array_shift($this->arguments);
        }

        if (file_exists($path)) {
            $package = new Vtiger_Package();
            $module = $package->getModuleNameFromZip($path);

            $moduleInstance = Vtiger_Module::getInstance($module);
            if (!$moduleInstance) {
                echo "  ERROR: Module $module not found!\n";
            } else {
                echo "  Updating ...\n";
                $package->update($moduleInstance, $path);
                echo "  DONE.\n";
            }

        } else {
            throw new Exception("Package file $path not found.");
        }
    }
}

/**
 * Class ParsVT_Tools_Console_RemoveController
 */
class ParsVT_Tools_Console_RemoveController extends ParsVT_Tools_Console_Controller
{
    var $db, $adb;
    public function __construct()
    {
        $adb =PearDatabase::getInstance();
        $this->adb = $adb;
        $this->db = $adb;
    }


    private function exec_disabled($value = 'exec')
    {
        $disabled = explode(',', ini_get('disable_functions'));
        return in_array($value, $disabled);
    }

    private function del($tmp_path)
    {
        global $root_directory;
        if (!is_writeable($tmp_path) && is_dir($tmp_path)) {
            chmod($tmp_path, 0755);
        }
        if (!defined('DS')) {
            define('DS', DIRECTORY_SEPARATOR);
        }
        if (is_dir($tmp_path)) {
            $handle = opendir($tmp_path);
            while ($tmp = readdir($handle)) {
                if ($tmp != '..' && $tmp != '.' && $tmp != '') {
                    if (is_writeable($tmp_path . DS . $tmp) && is_file($tmp_path . DS . $tmp)) {
                        unlink($tmp_path . DS . $tmp);
                    } elseif (!is_writeable($tmp_path . DS . $tmp) && is_file($tmp_path . DS . $tmp)) {
                        chmod($tmp_path . DS . $tmp, 0644);
                        unlink($tmp_path . DS . $tmp);
                    }

                    if (is_writeable($tmp_path . DS . $tmp) && is_dir($tmp_path . DS . $tmp)) {
                        $this->del($tmp_path . DS . $tmp);
                    } elseif (!is_writeable($tmp_path . DS . $tmp) && is_dir($tmp_path . DS . $tmp)) {
                        chmod($tmp_path . DS . $tmp, 0755);
                        $this->del($tmp_path . DS . $tmp);
                    }
                }
            }
            closedir($handle);
            rmdir($tmp_path);
        } elseif (is_file($tmp_path)) {
            if (!is_writeable($tmp_path)) {
                chmod($tmp_path, 0755);
            }
            unlink($tmp_path);
        }
        if (!is_dir($tmp_path) && !is_file($tmp_path)) {
            return true;
        } else {
            if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') { //for windows
                if ($this->exec_disabled('system')) {
                    return false;
                }
                if (!file_exists("test/data/tools/rm.exe"))
                    return false;
                ob_start(); // Turn on output buffering
                @system('"test/data/tools/rm -rf "' . $root_directory . $tmp_path . '"');
                $data = ob_get_contents(); // Capture the output into a variable
                ob_clean(); // Clean (erase) the output buffer
            } else {
                if ($this->exec_disabled('exec')) {
                    return false;
                }
                exec('rm -rf "' . $root_directory . $tmp_path . '"', $data);
            }
            if (!is_dir($tmp_path) && !is_file($tmp_path))
                return true;
            else
                return false;
        }
    }


    /**
     * Uninstall Methods
     */
    private function ModuleTableList($modulename)
    {
        $_Tables = array();
        if (file_exists("modules/$modulename/schema.xml")) {
            $schema = simplexml_load_file("modules/$modulename/schema.xml");
            if (!empty($schema->tables) && !empty($schema->tables->table)) {
                foreach ($schema->tables->table as $tablenode) {
                    $table = trim($tablenode->name);
                    if (!in_array($table, $_Tables)) {
                        $_Tables[] = $table;
                    }
                }
            }
        }
        return $_Tables;
    }

    public function removeData($module)
    {
        $out = '';
        $out .= sprintf(vtranslate("Delete %s  from vtiger_crmentity table.", $module), $module);
        $result = $this->db->pquery("DELETE FROM `vtiger_crmentity` WHERE `setype`=?", array($module));
        $out .= " - " . ($result ? vtranslate("DONE", $module) : "<b>" . vtranslate("Error", $module) . "</b>");
        $out .= "<br>";
        $out .= sprintf(vtranslate("Delete %s  from vtiger_ws_entity table.", $module), $module);
        $result = $this->db->pquery("DELETE FROM `vtiger_ws_entity` WHERE `name`=?", array($module));
        $out .= " - " . ($result ? vtranslate("DONE", $module) : "<b>" . vtranslate("Error", $module) . "</b>");
        $out .= "<br>";
        $out .= sprintf(vtranslate("Delete %s  from vtiger_entity table.", $module), $module);
        $result = $this->db->pquery("DELETE FROM `vtiger_entity` WHERE `name`=?", array($module));
        $out .= " - " . vtranslate("DONE", $module) . "</b>";
        $out .= "<br>";
        $result = $this->db->pquery("SELECT * FROM `vtiger_settings_field` WHERE `linkto` LIKE '%module=" . $module . "%'", array());
        if ($this->db->num_rows($result) > 0) {
            while ($row = $this->db->fetchByAssoc($result)) {
                $out .= sprintf(vtranslate("Delete %s  from vtiger_settings_field table.", $module), $module);
                $tmpresult = $this->db->pquery("DELETE FROM `vtiger_settings_field` WHERE `fieldid`=?", array($row['fieldid']));
                $out .= " - " . ($tmpresult ? vtranslate("DONE", $module) : "<b>" . vtranslate("Error", $module) . "</b>");
                $out .= "<br>";
            }
        }

        $out .= sprintf(vtranslate("Delete %s cron tasks.", $module), $module);
        $result = $this->db->pquery("DELETE FROM vtiger_cron_task WHERE module = ?", array($module));
        $out .= " - " . vtranslate("DONE", $module) . "<br>";

        $out .= sprintf(vtranslate("Delete %s Handlers.", $module), $module);
        $result = $this->db->pquery("DELETE FROM vtiger_eventhandlers WHERE handler_class like %'".$module."''%", array());
        $out .= " - " . vtranslate("DONE", $module) . "<br>";

        $out .= sprintf(vtranslate("Delete %s module tables.", $module), $module);
        $out .= "<br>";
        $tables = $this->ModuleTableList($module);
        foreach ($tables as $table) {
            $out .= sprintf(vtranslate("Delete %s table.", $module), $table);
            $result = $this->db->pquery("DROP TABLE IF EXISTS $table");
            $out .= " - " . ($result ? vtranslate("DONE", $module) : "<b>" . vtranslate("Error", $module) . "</b>");
            $out .= "<br>";
        }
        return $out;
    }

    /**
     * @param $moduleName
     */
    public function removeFiles($moduleName)
    {
        $out = "";
        $files = glob("layouts/*/modules/" . $moduleName);
        $out .= sprintf(vtranslate("Remove %s template folder.", $moduleName), $moduleName) . "<br />";
        foreach ($files as $file) {
            $out .= "Remove " . $file;
            $result = $this->del($file);
            $out .= " - " . ($result ? vtranslate("DONE", $moduleName) : "<b>" . vtranslate("Error", $moduleName) . "</b>");
            $out .= "<br>";
        }
        $out .= sprintf(vtranslate("Remove %s module folder", $moduleName), $moduleName);
        $result = $this->del("modules/" . $moduleName);
        $out .= " - " . ($result ? vtranslate("DONE", $moduleName) : "<b>" . vtranslate("Error", $moduleName) . "</b>");
        $out .= "<br>";
        $out .= sprintf(vtranslate("Remove %s language files:", $moduleName), $moduleName) . "<br />";
        $files = glob("languages/*/" . $moduleName . ".php");
        foreach ($files as $file) {
            if (is_file($file)) {
                $result = $this->del($file);
                $out .= "Remove " . $file . " - " . ($result ? vtranslate("DONE", $moduleName) : "<b>" . vtranslate("Error", $moduleName) . "</b>");
                $out .= "<br>";
            }
        }

        $dir = "cron/modules/" . $moduleName;
        if (is_dir($dir)) {
            $out .= sprintf(vtranslate("Remove %s cron folder", $moduleName), $moduleName);
            $result = $this->del($dir);
            $out .= " - " . ($result ? vtranslate("DONE", $moduleName) : "<b>" . vtranslate("Error", $moduleName) . "</b>");
            $out .= "<br>";
        }

        $dir = "storage/" . $moduleName;
        if (is_dir($dir)) {
            $out .= sprintf(vtranslate("Remove %s storage folder", $moduleName), $moduleName);
            $result = $this->del($dir);
            $out .= " - " . ($result ? vtranslate("DONE", $moduleName) : "<b>" . vtranslate("Error", $moduleName) . "</b>");
            $out .= "<br>";
        }

        return $out;
    }

    /**
     *
     */
    public function handle()
    {
        if ($this->interactive) {
            echo "  >>> REMOVE MODULE <<<\n";
            do {
                $module = $this->prompt("  Enter module name: ", self::PROMPT_NAME);
                $moduleInstance = Vtiger_Module::getInstance($module);
                if (!$moduleInstance) {
                    echo "  ERROR: Module $module not found, try another.\n";
                } else {
                    echo "  Removing ...\n";
                    $moduleInstance->delete();
                    $this->removeData($module);
                    $this->removeFiles($module);
                    echo "  DONE.\n";
                }
            } while (true);
        } else {
            $module = array_shift($this->arguments);
            $moduleInstance = Vtiger_Module::getInstance($module);
            if (!$moduleInstance) {
                echo "  ERROR: Module $module not found!\n";
            } else {
                echo "  Removing ...\n";
                $moduleInstance->delete();
                $this->removeData($module);
                $this->removeFiles($module);
                echo "  DONE.\n";
            }
        }
    }
}


/**
 * Class ModuleLinkCreatorConsole_Module_Model
 */
class ModuleLinkCreator_EntityModuleController extends ParsVT_Tools_Console_EntityModuleController
{
    /**
     * ModuleLinkCreator_EntityModuleController constructor.
     */
    public function __construct()
    {
        parent::__construct();
    }
    protected function createFiles(Vtiger_Module $module, Vtiger_Field $entityField)
    {
        global $vtiger_current_version;
        $targetpath = "modules/" . $module->name;
        if (!is_file($targetpath)) {
            mkdir($targetpath);
            if (version_compare($vtiger_current_version, "7.0.0", "<")) {
                $templatepath = "modules/ModuleLinkCreator/resources/ModuleDir/6.0.0";
            } else {
                $templatepath = "modules/ModuleLinkCreator/resources/ModuleDir/7.0.0";
            }
            $moduleFileContents = file_get_contents($templatepath . "/ModuleName.php");
            $moduleFileContentsHandler = file_get_contents($templatepath . "/ModuleNameHandler.php");
            $replacevars = array("__ModuleName__" => $module->name, "<modulename>" => strtolower($module->name), "<entityfieldlabel>" => $entityField->label, "<entitycolumn>" => $entityField->column, "<entityfieldname>" => $entityField->name);
            foreach ($replacevars as $key => $value) {
                $moduleFileContents = str_replace($key, $value, $moduleFileContents);
                $moduleFileContentsHandler = str_replace($key, $value, $moduleFileContentsHandler);
            }
            file_put_contents($targetpath . "/" . $module->name . ".php", $moduleFileContents);
            file_put_contents($targetpath . "/" . $module->name . "Handler.php", $moduleFileContentsHandler);
        }
    }
    /**
     * Create new module base on console
     *
     * @param string $moduleName
     * @param string $parent - Default is "Tools"
     * @param string $entityfieldlabel
     * @return Vtiger_Module
     */
    public function createModule($moduleName, $parent = "Tools", $entityfieldlabel = "Name")
    {
        global $vtiger_current_version;
        global $adb;
        $moduleInformation["name"] = $moduleName;
        $moduleInformation["parent"] = $parent;
        $moduleInformation["entityfieldlabel"] = $entityfieldlabel;
        $this->create($moduleInformation);
        $lcasemodname = strtolower($moduleName);
        $primaryKey = $lcasemodname . "id";
        $module_basetable = "vtiger_" . $lcasemodname;
        if (Vtiger_Utils::CheckTable($module_basetable)) {
            $adb->pquery("ALTER TABLE " . $module_basetable . " DROP PRIMARY KEY, ADD PRIMARY KEY (" . $primaryKey . ")", array());
        }
        if (version_compare($vtiger_current_version, "7.0.0", "<")) {
            
        } else {
            $moduleUserSpecificTable = Vtiger_Functions::getUserSpecificTableName($moduleName);
            if (!Vtiger_Utils::CheckTable($moduleUserSpecificTable)) {
                Vtiger_Utils::CreateTable($moduleUserSpecificTable, "(`recordid` INT(19) NOT NULL,\r\n\t\t\t\t\t   `userid` INT(19) NOT NULL,\r\n\t\t\t\t\t   Index `record_user_idx` (`recordid`, `userid`)\r\n\t\t\t\t\t\t)", true);
            }
        }
        return Vtiger_Module::getInstance($moduleName);
    }

    protected function create($moduleInformation) {
        $moduleInformation['entityfieldname']  = strtolower($this->toAlphaNumeric($moduleInformation['entityfieldlabel']));

        $module = new Vtiger_Module();
        $module->name = $moduleInformation['name'];
        $module->parent=$moduleInformation['parent'];
        $module->save();

        $module->initTables();

        $block = new Vtiger_Block();
        $block->label = 'LBL_'. strtoupper($module->name) . '_INFORMATION';
        $module->addBlock($block);

        $blockcf = new Vtiger_Block();
        $blockcf->label = 'LBL_CUSTOM_INFORMATION';
        $module->addBlock($blockcf);

        $field1  = new Vtiger_Field();
        $field1->name = $moduleInformation['entityfieldname'];
        $field1->label= $moduleInformation['entityfieldlabel'];
        $field1->uitype= 2;
        $field1->column = $field1->name;
        $field1->columntype = 'VARCHAR(255)';
        $field1->typeofdata = 'V~M';
        $block->addField($field1);

        $module->setEntityIdentifier($field1);

        /** Common fields that should be in every module, linked to vtiger CRM core table */
        $field2 = new Vtiger_Field();
        $field2->name = 'assigned_user_id';
        $field2->label = 'Assigned To';
        $field2->table = 'vtiger_crmentity';
        $field2->column = 'smownerid';
        $field2->uitype = 53;
        $field2->typeofdata = 'V~M';
        $block->addField($field2);

        $field3 = new Vtiger_Field();
        $field3->name = 'createdtime';
        $field3->label= 'Created Time';
        $field3->table = 'vtiger_crmentity';
        $field3->column = 'createdtime';
        $field3->uitype = 70;
        $field3->typeofdata = 'T~O';
        $field3->displaytype= 2;
        $block->addField($field3);

        $field4 = new Vtiger_Field();
        $field4->name = 'modifiedtime';
        $field4->label= 'Modified Time';
        $field4->table = 'vtiger_crmentity';
        $field4->column = 'modifiedtime';
        $field4->uitype = 70;
        $field4->typeofdata = 'T~O';
        $field4->displaytype= 2;
        $block->addField($field4);

        // Create default custom filter (mandatory)
        $filter1 = new Vtiger_Filter();
        $filter1->name = 'All';
        $filter1->isdefault = true;
        $module->addFilter($filter1);
        // Add fields to the filter created
        $filter1->addField($field1)->addField($field2, 1)->addField($field3, 2);

        // Set sharing access of this module
        $module->setDefaultSharing();

        // Enable and Disable available tools
        $module->enableTools(Array('Import', 'Export', 'Merge'));

        // Initialize Webservice support
        $module->initWebservice();

        // Create files
        $this->createFiles($module, $field1);
    }


    /**
     * @param Vtiger_Module $module
     * @param array $moduleFields
     *             Example:
     *             $fieldBlocks = array(
     *                  'Applications' => array(                        // module name
     *                      'LBL_APPLICATIONS_INFORMATION' => array(    // block name
     *                          'cf_application_status' => array(        // field name
     *                              'label' => 'Application Status',    // label
     *                              'table' => 'vtiger_applicationscf',    // table
     *                              'uitype' => 16,                        // type
     *                              'picklistvalues' => array('Yes', 'No')    // (option) if uitype is picklist: 15|16|33
     *                          )
     *                      )
     *                  )
     *              );
     */
    public function createFields(Vtiger_Module $module, $moduleFields = array())
    {
        $adb = PearDatabase::getInstance();
        foreach ($moduleFields as $moduleName => $blockNames) {
            foreach ($blockNames as $blockName => $arrFieldInfo) {
                $blockInstance = Vtiger_Block::getInstance($blockName, $module);
                if (!$blockInstance) {
                    $blockInstance = new Vtiger_Block();
                    $blockInstance->label = $blockName;
                    $module->addBlock($blockInstance);
                }
                $rsFieldSequence = $adb->pquery("SELECT sequence FROM `vtiger_field` WHERE block = ? ORDER BY sequence DESC LIMIT 0,1", array($blockInstance->id));
                $sequence = $adb->query_result($rsFieldSequence, "sequence", 0);
                foreach ($arrFieldInfo as $fieldName => $fieldInfo) {
                    $fieldInstance = Vtiger_Field::getInstance($fieldName, $module);
                    if (!$fieldInstance) {
                        $fieldInstance = new Vtiger_Field();
                    }
                    $fieldInstance->name = $fieldName;
                    $fieldInstance->label = isset($fieldInfo["label"]) && $fieldInfo["label"] ? $fieldInfo["label"] : $fieldName;
                    $fieldInstance->uitype = isset($fieldInfo["uitype"]) && $fieldInfo["uitype"] ? $fieldInfo["uitype"] : 1;
                    if (isset($fieldInfo["columnname"]) && $fieldInfo["columnname"]) {
                        $fieldInstance->column = $fieldInfo["columnname"];
                    } else {
                        $fieldInstance->column = $fieldInstance->name;
                    }
                    if (isset($fieldInfo["columntype"]) && $fieldInfo["columntype"]) {
                        $fieldInstance->columntype = $fieldInfo["columntype"];
                    } else {
                        $fieldInstance->columntype = "VARCHAR(100)";
                    }
                    if (isset($fieldInfo["typeofdata"]) && $fieldInfo["typeofdata"]) {
                        $fieldInstance->typeofdata = $fieldInfo["typeofdata"];
                    }
                    if (isset($fieldInfo["table"]) && $fieldInfo["table"]) {
                        $fieldInstance->table = $fieldInfo["table"];
                    } else {
                        $fieldInstance->table = $module->basetable;
                    }
                    if (isset($fieldInfo["helpinfo"])) {
                        $fieldInstance->helpinfo = $fieldInfo["helpinfo"];
                    }
                    if (isset($fieldInfo["summaryfield"])) {
                        $fieldInstance->summaryfield = $fieldInfo["summaryfield"];
                    }
                    if (isset($fieldInfo["masseditable"])) {
                        $fieldInstance->masseditable = $fieldInfo["masseditable"];
                    }
                    if (isset($fieldInfo["displaytype"])) {
                        $fieldInstance->displaytype = $fieldInfo["displaytype"];
                    }
                    if (isset($fieldInfo["generatedtype"])) {
                        $fieldInstance->generatedtype = $fieldInfo["generatedtype"];
                    }
                    if (isset($fieldInfo["readonly"])) {
                        $fieldInstance->readonly = $fieldInfo["readonly"];
                    }
                    if (isset($fieldInfo["presence"])) {
                        $fieldInstance->presence = $fieldInfo["presence"];
                    }
                    if (isset($fieldInfo["defaultvalue"])) {
                        $fieldInstance->defaultvalue = $fieldInfo["defaultvalue"];
                    }
                    if (isset($fieldInfo["maximumlength"])) {
                        $fieldInstance->maximumlength = $fieldInfo["maximumlength"];
                    }
                    if (isset($fieldInfo["quickcreate"])) {
                        $fieldInstance->quickcreate = $fieldInfo["quickcreate"];
                    }
                    if (isset($fieldInfo["quickcreatesequence"])) {
                        $fieldInstance->quicksequence = $fieldInfo["quickcreatesequence"];
                    }
                    if (isset($fieldInfo["info_type"])) {
                        $fieldInstance->info_type = $fieldInfo["info_type"];
                    }
                    $fieldInstance->sequence = ++$sequence;
                    $blockInstance->addField($fieldInstance);
                    if ($fieldInfo["uitype"] == 15 || $fieldInfo["uitype"] == 16 || $fieldInfo["uitype"] == 33) {
                        $fieldInstance->setPicklistValues($fieldInfo["picklistvalues"]);
                    } elseif ($fieldInfo["uitype"] == 10) {
                        $fieldInstance->setRelatedModules(array($fieldInfo["related_to_module"]));
                    }
                    if (isset($fieldInfo["filter"]) && $fieldInfo["filter"] && isset($fieldInfo["filter"]["name"]) && $fieldInfo["filter"]["name"]) {
                        $filterName = $fieldInfo["filter"]["name"];
                        $filterInstance = Vtiger_Filter::getInstance($filterName, $module);
                        if (!$filterInstance) {
                            $filterInstance = new Vtiger_Filter();
                            $filterInstance->name = $filterName;
                            $filterInstance->isdefault = $fieldInfo["filter"]["isdefault"] ? $fieldInfo["filter"]["isdefault"] : false;
                            $module->addFilter($filterInstance);
                            $filterInstance->addField($fieldInstance);
                        } else {
                            $rsFieldSequence = $adb->pquery("SELECT columnindex FROM `vtiger_cvcolumnlist` WHERE cvid = ? ORDER BY columnindex DESC LIMIT 0,1", array($filterInstance->id));
                            $sequence = $adb->query_result($rsFieldSequence, "columnindex", 0);
                            $filterInstance->addField($fieldInstance, $sequence + 1);
                        }
                    }
                }
            }
        }
    }
    /**
     * @param Vtiger_Module $module
     */
    public function createCustomViews(Vtiger_Module $module, $icons = "")
    {
        global $vtiger_current_version;
        if (version_compare($vtiger_current_version, "7.0.0", "<")) {
            $tempDir = "vlayout";
            $version = "6.0.0";
        } else {
            $tempDir = "v7";
            $version = "7.0.0";
        }
        $targetpath = "modules/" . $module->name . "/views";
        if (!is_file($targetpath)) {
            mkdir($targetpath);
        }
        $files = array();
        $this->findFiles("modules/ModuleLinkCreator/resources/ModuleDir/" . $version . "/views", false, $files);
        foreach ($files as $file) {
            $filename = basename($file, true);
            $moduleFileContents = file_get_contents($file);
            $replacevars = array("__ModuleName__" => $module->name, "<modulename>" => strtolower($module->name));
            foreach ($replacevars as $key => $value) {
                $moduleFileContents = str_replace($key, $value, $moduleFileContents);
            }
            file_put_contents((string) $targetpath . "/" . $filename, $moduleFileContents);
        }
        $moduleLayout = "layouts/" . $tempDir . "/modules/" . $module->name;
        if (!is_file($moduleLayout)) {
            mkdir($moduleLayout);
        }
        $files = array();
        $this->findOnlyDirFiles("modules/ModuleLinkCreator/resources/ModuleDir/" . $version . "/templates", false, $files);
        foreach ($files as $file) {
            $filename = basename($file, true);
            $moduleFileContents = file_get_contents($file);
            file_put_contents((string) $moduleLayout . "/" . $filename, $moduleFileContents);
        }
        $moduleLayoutResources = "layouts/" . $tempDir . "/modules/" . $module->name . "/resources";
        if (!is_file($moduleLayoutResources)) {
            mkdir($moduleLayoutResources);
        }
        $files = array();
        $this->findFiles("modules/ModuleLinkCreator/resources/ModuleDir/" . $version . "/templates/resources", false, $files);
        foreach ($files as $file) {
            $filename = basename($file, true);
            $moduleFileContents = file_get_contents($file);
            $replacevars = array("<modulename>" => $module->name, "moduleNameIcon" => strtolower($module->name), "content-icon-module" => $icons);
            foreach ($replacevars as $key => $value) {
                $moduleFileContents = str_replace($key, $value, $moduleFileContents);
            }
            file_put_contents((string) $moduleLayoutResources . "/" . $filename, $moduleFileContents);
        }
    }
    /**
     * @param Vtiger_Module $module
     */
    public function createCustomModels(Vtiger_Module $module)
    {
        global $vtiger_current_version;
        if (version_compare($vtiger_current_version, "7.0.0", "<")) {
            $version = "6.0.0";
        } else {
            $version = "7.0.0";
        }
        $targetpath = "modules/" . $module->name . "/models";
        if (!is_file($targetpath)) {
            mkdir($targetpath);
        }
        $files = array();
        $this->findFiles("modules/ModuleLinkCreator/resources/ModuleDir/" . $version . "/models", false, $files);
        foreach ($files as $file) {
            $filename = basename($file, true);
            $moduleFileContents = file_get_contents($file);
            $replacevars = array("__ModuleName__" => $module->name, "<modulename>" => strtolower($module->name));
            foreach ($replacevars as $key => $value) {
                $moduleFileContents = str_replace($key, $value, $moduleFileContents);
            }
            file_put_contents((string) $targetpath . "/" . $filename, $moduleFileContents);
        }
    }
    /**
     * @param string $moduleName
     * @param array $tables
     * @return bool
     */
    public function cleanDatabase($moduleName, $tables = array())
    {
        global $adb;
        foreach ($tables as $table) {
            $adb->pquery("DROP TABLE ?", array($table));
        }
        $adb->pquery("DELETE FROM `vtiger_crmentity`  WHERE setype=?", array($moduleName));
        $adb->pquery("DELETE a.* FROM  `vtiger_blocks` a INNER JOIN `vtiger_tab` b ON a.tabid = b.tabid WHERE b.name =? ", array($moduleName));
        return true;
    }
    /**
     * @param string $moduleName
     * @return bool
     */
    public function cleanFolder($moduleName)
    {
        global $vtiger_current_version;
        if (version_compare($vtiger_current_version, "7.0.0", "<")) {
            $tempDir = "vlayout";
        } else {
            $tempDir = "v7";
        }
        $this->removeFolder("layouts/" . $tempDir . "/modules/" . $moduleName);
        $this->removeFolder("modules/" . $moduleName);
        return true;
    }
    /**
     * @param $path
     * @return bool
     */
    public function removeFolder($path)
    {
        if (!isFileAccessible($path) || !is_dir($path)) {
            return false;
        }
        if (!is_writeable($path)) {
            chmod($path, 511);
        }
        $handle = opendir($path);
        while ($tmp = readdir($handle)) {
            if ($tmp == ".." || $tmp == ".") {
                continue;
            }
            $tmpPath = $path . DS . $tmp;
            if (is_file($tmpPath)) {
                if (!is_writeable($tmpPath)) {
                    chmod($tmpPath, 438);
                }
                unlink($tmpPath);
            } else {
                if (is_dir($tmpPath)) {
                    if (!is_writeable($tmpPath)) {
                        chmod($tmpPath, 511);
                    }
                    $this->removeFolder($tmpPath);
                }
            }
        }
        closedir($handle);
        rmdir($path);
        return !is_dir($path);
    }
    /**
     * @param string $moduleName
     * @return bool
     */
    public function cleanLanguage($moduleName)
    {
        $files = glob("languages/*/" . $moduleName . ".php");
        foreach ($files as $file) {
            if (is_file($file)) {
                unlink($file);
            }
        }
        return true;
    }
    /**
     * @link http://stackoverflow.com/questions/7288029/php-delete-directory-that-is-not-empty
     * @param $dir
     */
    public function rmdir_recursive($dir)
    {
        foreach (scandir($dir) as $file) {
            if ("." === $file || ".." === $file) {
                continue;
            }
            $tmpFile = (string) $dir . "/" . $file;
            if (is_dir($tmpFile)) {
                $this->rmdir_recursive($tmpFile);
            } else {
                unlink($tmpFile);
            }
        }
        rmdir($dir);
    }
    /**
     * @param string $moduleName
     * @return bool
     */
    public function uninstallModule($moduleName)
    {
        global $adb;
        $module = Vtiger_Module::getInstance($moduleName);
        $rs = $adb->pquery("SELECT * FROM `vtiger_fieldmodulerel` WHERE `relmodule` =?", array($moduleName));
        $listFieldModule = array();
        if (0 < $adb->num_rows($rs)) {
            while ($row = $adb->fetchByAssoc($rs)) {
                if ($row["module"] != "ModComments") {
                    $listFieldModule[] = $row["fieldid"];
                }
            }
        }
        foreach ($listFieldModule as $field) {
            $adb->pquery("UPDATE `vtiger_field` SET `presence`='1' WHERE `fieldid`=?", array($field));
            $adb->pquery("DELETE FROM `vtiger_fieldmodulerel` WHERE `fieldid`=?", array($field));
        }
        if ($module) {
            $lowerModuleName = strtolower($module->name);
            $module->delete();
            $tables = array();
            $tables[] = $lowerModuleName;
            $tables[] = $lowerModuleName . "cf";
            $this->cleanDatabase($moduleName, $tables);
            $this->cleanFolder($moduleName);
            $this->cleanLanguage($moduleName);
            $this->removeHandle($moduleName);
        }
        return true;
    }
    /**
     * @param string $sourceModule
     * @param string $prefix
     * @param int $sequenceNumber
     * @return array
     */
    public function customizeRecordNumbering($sourceModule, $prefix = "NO", $sequenceNumber = 1)
    {
        $moduleModel = Settings_Vtiger_CustomRecordNumberingModule_Model::getInstance($sourceModule);
        $moduleModel->set("prefix", $prefix);
        $moduleModel->set("sequenceNumber", $sequenceNumber);
        $result = $moduleModel->setModuleSequence();
        return $result;
    }
    /**
     * @param string $moduleName
     * @param int $fieldTypeId
     */
    public function addModuleRelatedToForEvents($moduleName, $fieldTypeId)
    {
        global $adb;
        $sqlCheckProject = "SELECT * FROM `vtiger_ws_referencetype` WHERE fieldtypeid = ? AND type = ?";
        $rsCheckProject = $adb->pquery($sqlCheckProject, array($fieldTypeId, $moduleName));
        if ($adb->num_rows($rsCheckProject) < 1) {
            $adb->pquery("INSERT INTO `vtiger_ws_referencetype` (`fieldtypeid`, `type`) VALUES (?, ?)", array($fieldTypeId, $moduleName));
        }
    }
    private function findOnlyDirFiles($dir, $file_pattern, &$files)
    {
        $items = glob($dir . "/*.tpl", GLOB_NOSORT);
        foreach ($items as $item) {
            if (is_file($item)) {
                if (!$file_pattern || preg_match("/" . $file_pattern . "/", $item)) {
                    $files[] = $item;
                }
            } elseif (is_dir($item) && $dir != $item) {
                $this->findFiles($item, $file_pattern, $files);
            }
        }
    }
    private function createHandle($moduleName)
    {
        include_once "include/events/VTEventsManager.inc";
        global $adb;
        $em = new VTEventsManager($adb);
        $em->setModuleForHandler($moduleName, (string) $moduleName . "Handler.php");
        $em->registerHandler("vtiger.entity.aftersave", "modules/" . $moduleName . "/" . $moduleName . "Handler.php", (string) $moduleName . "Handler");
    }
    /**
     * @param string $moduleName
     */
    private function removeHandle($moduleName)
    {
        include_once "include/events/VTEventsManager.inc";
        global $adb;
        $em = new VTEventsManager($adb);
        $em->unregisterHandler((string) $moduleName . "Handler");
    }
}
/**
 * Class ModuleLinkCreator_Console_LanguageController
 */
class ModuleLinkCreator_Console_LanguageController extends ParsVT_Tools_Console_LanguageController
{
    /**
     * ModuleLinkCreator_Console_LanguageController constructor.
     */
    public function __construct()
    {
        parent::__construct();
    }
    /**
     * @param string $moduleName
     * @param array $languageStrings
     * @param array $jsLanguageStrings
     */
    public function createLanguage($moduleName, $languageStrings = array(), $jsLanguageStrings = array())
    {
        global $vtiger_current_version;
        if (version_compare($vtiger_current_version, "7.0.0", "<")) {
            $version = "6.0.0";
        } else {
            $version = "7.0.0";
        }
        $baseLanguageStrings = array("LBL_CUSTOM_INFORMATION" => "Custom Information");
        $baseJsLanguageStrings = array();
        if ($languageStrings && !empty($languageStrings)) {
            $baseLanguageStrings = array_merge($baseLanguageStrings, $languageStrings);
        }
        if ($jsLanguageStrings && !empty($jsLanguageStrings)) {
            $baseJsLanguageStrings = array_merge($baseJsLanguageStrings, $jsLanguageStrings);
        }
        $files = array();
        $this->findFiles("modules/ModuleLinkCreator/resources/ModuleDir/" . $version . "/languages", ".php\$", $files);
        foreach ($files as $file) {
            $filename = basename($file, true);
            $dir = substr($file, 0, strpos($file, $filename));
            $tmp = explode("/", rtrim($dir, "/"));
            $code = $tmp[count($tmp) - 1];
            $newDir = "languages/" . $code;
            if (!file_exists($newDir)) {
                mkdir($newDir);
            }
            $contents = file_get_contents($file);
            $contents = str_replace("'<languageStrings>'", var_export($baseLanguageStrings, true), $contents);
            $contents = str_replace("'<jsLanguageStrings>'", var_export($baseJsLanguageStrings, true), $contents);
            file_put_contents((string) $newDir . "/" . $moduleName . ".php", $contents);
        }
    }
}


/**
 * Class ParsVT_Tools_Console_Translate
 */
class ParsVT_Tools_Console_Translate
{

    public static function translate($from, $to, $text){
        $url = "https://translate.googleapis.com/translate_a/single?client=gtx&sl=" . $from . "&tl=" . $to . "&hl=en-US&dt=t&dt=bd&dj=1&source=icon&tk=310461.310461&q=" . urlencode($text);
        $options  = array('http' => array('user_agent' => 'AndroidTranslate/5.3.0.RC02.130475354-53000263 5.1 phone TRANSLATE_OPM5_TEST_1'));
        $context  = stream_context_create($options);
        $response = file_get_contents($url, false, $context);
        $response = json_decode($response , true);
        if (json_last_error() == JSON_ERROR_NONE) {
            if (isset($response['sentences'][0]['trans'])) {
                return $response['sentences'][0]['trans'];
            }
        }
        return $text;
    }
}


if (php_sapi_name() == 'cli') {
    ParsVT_Tools_Console_Controller::run();
} else {
    $includedFiles = get_included_files();
    if (basename(__FILE__) === basename($includedFiles[0])) {
        echo "Usage: php -f modules/ParsVT/console.php";
    }
}


