<?php

/*
 * Copyright (C) www.vtiger.com. All rights reserved.
 * @license Proprietary
 */

class ParsVT_RestClient {

	protected static $name = 'ParsVTRestClient';
	protected static $version = '1.0';
	protected $defaultHeaders = array();
	protected $defaultOptions = array();

	public function __construct() {
		global $site_URL, $current_vtiger_version;

		$this->defaultOptions[CURLOPT_REFERER] = $site_URL;
		//$this->defaultOptions[CURLOPT_USERAGENT] = self::$name.'/'.self::$version.'(CRM '.$current_vtiger_version.')';
		$this->defaultOptions[CURLOPT_RETURNTRANSFER] = true;
		$this->defaultOptions[CURLOPT_FOLLOWLOCATION] = true;
        $this->defaultOptions[CURLOPT_HEADER] = true;

        $this->defaultOptions[CURLOPT_MAXREDIRS] = 5;
		$this->defaultOptions[CURLOPT_SSL_VERIFYPEER] = 0;
		$this->defaultOptions[CURLOPT_SSL_VERIFYHOST] = 0;
		$this->defaultOptions[CURLOPT_TIMEOUT] = 30;

		$this->defaultHeaders['Content-Type'] = 'application/x-www-form-urlencoded';
		$this->defaultHeaders['Cache-Control'] = 'no-cache';
	}

	public function setDefaultOption($option, $value) {
		$this->defaultOptions[$option] = $value;
		return $this;
	}

	public function setDefaultHeader($header, $value) {
		$this->defaultHeaders[$header] = $value;
		return $this;
	}

	public function setBasicAuthentication($username, $password) {
		$this->defaultHeaders['Authorization'] = 'Basic '.base64_encode($username.':'.$password);
	}

	protected function exec($curlopts) {
		$curl = curl_init();
		foreach ($curlopts as $option => $value) {
			if ($option) {
				curl_setopt($curl, $option, $value);
			}
		}

		// To be secure - we don't want user to override this
		// and open doors for hackers.
		$cookiefile = tempnam(sys_get_temp_dir(), ".".uniqid()."co");
		$cookiefp = fopen($cookiefile, "w");

		curl_setopt($curl, CURLOPT_COOKIEJAR, $cookiefile);
		curl_setopt($curl, CURLOPT_COOKIEFILE, $cookiefile);

		// Now execute
		$response = curl_exec($curl);
		$status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);

        $header = substr($response, 0, $header_size);
        $body = substr($response, $header_size);

		$responseData = array('response' => $body, 'status' => $status, 'headers' => $this->parseHeaders($header));
		if (curl_errno($curl)) {
			$errorMessage = curl_error($curl);
			$responseData['errorMessage'] = $errorMessage;
		}
		curl_close($curl);

		fclose($cookiefp);
		unlink($cookiefile);

		return $responseData;
	}

    function parseHeaders( $text )
    {
        $headers=array();

        foreach (explode("\r\n", $text) as $i => $line) {
            // Special HTTP first line
            if (!$i && preg_match('@^HTTP/(?<protocol>[0-9.]+)\s+(?<code>\d+)(?:\s+(?<message>.*))?$@', $line, $match)) {
                $headers['@status']=$line;
                $headers['@code']=$match['code'];
                $headers['@protocol']=$match['protocol'];
                $headers['@message']=$match['message'];
                continue;
            }

            // Multiline header - join with previous
            if ($key && preg_match('/^\s/', $line)) {
                $headers[$key].=' '.trim($line);
                continue;
            }

            list ($key, $value) = explode(': ', $line, 2);
            $key=strtolower($key);
            // Append duplicate headers - namely Set-Cookie header
            if (!empty($key))
            $headers[$key]=isset($headers[$key]) ? $headers[$key].' ' : $value;
        }

        return $headers;
    }

	public function buildCurlOptions(array $headers, array $options) {
		foreach ($this->defaultOptions as $option => $value) {
			switch ($option) {
				// Stop overrides on some keys.
				case CURLOPT_REFERER:
				case CURLOPT_USERAGENT:
					$options[$option] = $value;
					break;
				default:
					// Pickup the overriding value
					if (!isset($options[$option])) {
						$options[$option] = $value;
					}
					break;
			}
		}

		$headeropts = array();
		foreach ($this->defaultHeaders as $key => $value) {
			// Respect the overriding value
			if ($headers && isset($headers[$key]))
				continue;
			$headeropts[] = ($key.': '.$value);
		}
		foreach ($headers as $key => $value)
			$headeropts[] = ($key.': '.$value);
		$options[CURLOPT_HTTPHEADER] = $headeropts;

		return $options;
	}

	public function get($url, $params = array(), $headers = array(), $options = array()) {
		$curlopts = $this->buildCurlOptions($headers, $options);


		$curlopts[CURLOPT_HTTPGET] = true;

		if (!empty($params)) {
			if (stripos($url, '?') === false)
				$url .= '?';
			else
				$url .= '&';
			$url .= http_build_query($params, '', '&');
		}

		$curlopts[CURLOPT_URL] = $url;
		return $this->exec($curlopts);
	}

	public function post($url, $params = array(), $headers = array(), $options = array(), $raw = false) {
		$curlopts = $this->buildCurlOptions($headers, $options);

		$curlopts[CURLOPT_POST] = true;
		if ($params) {
            if ($raw)
			    $curlopts[CURLOPT_POSTFIELDS] = json_encode($params);
            else
			    $curlopts[CURLOPT_POSTFIELDS] = http_build_query($params, '', '&');
		}

		$curlopts[CURLOPT_URL] = $url;
		return $this->exec($curlopts);
	}

	public function getRequest($url, $params = array(), $headers = array(), $options = array()) {
		$curlopts = $this->buildCurlOptions($headers, $options);

		$curlopts[CURLOPT_CUSTOMREQUEST] = 'GET';
        $curlopts[CURLOPT_POST] = true;
        if (!empty($params)) {
            $curlopts[CURLOPT_POSTFIELDS] = json_encode($params);
        }
		$curlopts[CURLOPT_URL] = $url;
		return $this->exec($curlopts);
	}

	public function put($url, $params = array(), $headers = array(), $options = array(), $raw = false) {
		$curlopts = $this->buildCurlOptions($headers, $options);

		$curlopts[CURLOPT_CUSTOMREQUEST] = 'PUT';
		if ($params) {
            if ($raw)
                $curlopts[CURLOPT_POSTFIELDS] = json_encode($params);
            else
                $curlopts[CURLOPT_POSTFIELDS] = http_build_query($params, '', '&');
        }

		$curlopts[CURLOPT_URL] = $url;
		return $this->exec($curlopts);
	}

}
