### راهنمای کار


  + [ابزار کنسول](#intro)
  + [شروع به کار با CLI](#cliconsole)
  + [شروع به کار با کدنویسی](#manualconsole)

### ابزار کنسول <a id='intro'></a>
این ابزار CLI (واسط خط فرمان - Command Line Interface) به شما کمک می کند تا پیاده سازی ساختار ماژول، قالب و بسته زبان برای ویتایگر را دریافت کنید.

 <br>
 <br>
 
 ### شروع به کار با CLI <a id='cliconsole'></a>
برای شروع با کار و ورود به محیط CLI در سیستم عامل ویندوز وارد Command Prompt و در محیط Linux وارد Terminal شوید، وارد مسیر روت ویتایگر شوید و دستور زیر را اجرا کنید:
```
cd VTIGER_ROOT_DIRECTORY
php -f modules/ParsVT/console.php
```

پس از اجرا محیط زیر را مشاهده خواهید کرد:
```
  _____                __      __ _______
  |  __ \               \ \    / /|__   __|
  | |__) |__ _  _ __  ___\ \  / /    | |    ___  ___   _ __ ___
  |  ___// _` || '__|/ __|\ \/ /     | |   / __|/ _ \ | '_ ` _ \
  | |   | (_| || |   \__ \ \  /      | | _| (__| (_) || | | | | |
  |_|    \__,_||_|   |___/  \/       |_|(_)\___|\___/ |_| |_| |_|



  Welcome to ParsVT CRM Console.
  This tool will enable you to get started with developing extensions with ease.
  Have a good time. Press CTRL+C or type "exit" to quit.
  Choose the options below:
  1. Create New Entity Module.
  2. Create New Extension Module.
  3. Create New Layout.
  4. Create New Language Pack.
  5. Create Test Language Pack.
  6. Import Module.
  7. Update Module.
  8. Remove Module.
  Enter your choice:

```
 <br>
 <br>

###  گزینه های قابل انتخاب

* گزینه Create New Entity Module به شما اجازه ساخت ماژول Entity جدید در ویتایگر را میدهد
* گزینه Create New Extension Module به شما اجازه ساخت ماژول Extension جدید در ویتایگر را میدهد
* گزینهCreate New Layout به شما اجازه ساخت ساختار یک قالب جدید در ویتایگر را میدهد
* گزینه Create New Language Pack به شما اجازه ساخت یک بسته زبان جدید در ویتایگر را میدهد
* گزینه Create Test Language Pack به شما اجازه ساخت یک بسته زبان تستی در ویتایگر را میدهد
* گزینه Import Module به شما اجازه نصب ماژول جدید از طریق آدرس فایل نصب در ویتایگر را میدهد
* گزینه Update Module به شما اجازه بروزرسانی ماژول موجود از طریق آدرس فایل نصب در ویتایگر را میدهد
* گزینه Remove Module به شما اجازه حذف ماژول های موجود در ویتایگر را میدهد

 
 <br>
 <br>

#### ساخت ماژول جدید

```
Enter your choice: 1
>>> MODULE <<<
Enter module name: MySandboxModule
Entity field (Name): name
Creating ...DONE.
```
 
برای این متد تنها کافی است نام ماژول و سپس نام فیلد اصلی را وارد نمایید.
همچنین ماژول ساخته شده برای زبان فارسی دارای بسته زبان ترجمه شده خواهد بود
 
 <br>
 <br>

#### ساخت قالب جدید
این متد فایل های پایه قالب را می سازد و شما باید به صورت تجربی کد های مورد نظر خود را در فایل ها جایگذاری نمایید. این روش تجربی است و باید توسط توسعه دهنده صورت پذیرد.
 
 
 <br>
 <br>

#### ساخت بسته زبان جدید و تستی
این متد به شما اجازه ساخت زبان جدید از طریق cli را میدهد

```
Enter your choice: 3
>>> LANGUAGE <<<
Enter (languagecode_countrycode): kn_in
Creating ...DONE.
```

 <br>
 <br>

#### نصب ماژول 
این متد به شما اجازه نصب ماژول جدید از طریق cli را میدهد

```
Enter package path: /Downloads/OthModule.zip
Importing ...DONE.
```

> ``📝`` نکته: 
> این متد با دستور زیر نیز به صورت خودکار انجام می گردد

```
 php -f modules/ParsVT/console.php – -–import=/Downloads/OthModule.zip
 ```


 <br>
 <br>

#### بروزرسانی ماژول
این متد به شما اجازه بروزرسانی ماژول موجود از طریق cli را میدهد

```
Enter package path: /Downloads/OthModule-v2.zip
Updating ...DONE.
```

> ``📝`` نکته:
> این متد با دستور زیر نیز به صورت خودکار انجام می گردد

```
php -f vtlib/tools/console.php – -–update=/Downloads/OthModule-v2.zip
 ```


 <br>
 <br>


#### حذف ماژول
این متد به شما اجازه حذف ماژول موجود از طریق cli را میدهد

```
  Removing ...  DONE.
```

> ``📝`` نکته:
> این متد با دستور زیر نیز به صورت خودکار انجام می گردد

```
php -f vtlib/tools/console.php – -–remove=OthModule
 ```


 <br>
 <br>

### شروع به کار با کدنویسی<a id='manualconsole'></a>

برای کدنویسی بدون استفاده از محیط CLI در داخل سی آر ام می توانید از کلاس ParsVT_ModuleController_Model و تابع build  مطابق راهنما استفاده کنید


#### متد اصلی
```php
public static function build($moduleInformation = [], $type = 'entity', $log = false)
```

#### ورودی‌ها
- **$moduleInformation** → آرایه‌ای از اطلاعات مورد نیاز برای ساخت ماژول، قالب یا زبان
- **$type** → نوع ماژول (entity, extension, layout, language)
- **$log** → اگر `true` باشد، لاگ ویتایگر فعال می‌شود

---

#### انواع ماژول و پارامترهای ضروری

##### 1. ماژول Entity 
- `name` → نام ماژول
- `parent` → دسته‌بندی ماژول (Marketing, Sales, Support, Inventory, Tools, Projects)
- `entityfieldname` → نام فیلد اصلی بدون فاصله به انگلیسی
- `entityfieldlabel` → لیبل فیلد اصلی
- کلاس مرتبط: `ParsVT_Tools_Console_EntityModuleController`

##### 2. ماژول Extension 
- `name` → نام افزونه
- کلاس مرتبط: `ParsVT_Tools_Console_ExtensionModuleController`

##### 3. قالب جدید (layout)
- `name` → نام قالب (layout)
- کلاس مرتبط: `ParsVT_Tools_Console_LayoutController`

##### 4. بسته زبانی جدید (language)
- `prefix` → پیشوند زبان (مثل fa_ir برای فارسی)
- کلاس مرتبط: `ParsVT_Tools_Console_LanguageController`

---

#### عملکرد متد build

1. **فعال‌سازی لاگ (اختیاری)**  
   اگر `$log = true` باشد، لاگ ویتایگر (`$Vtiger_Utils_Log`) فعال می‌شود.

2. **بررسی ورودی‌ها**  
   اگر ورودی خالی باشد یا پارامترهای لازم وجود نداشته باشند، خطا بازمی‌گرداند.

3. **بررسی وجود قبلی ماژول**
 - entity و extension → بررسی وجود ماژول در دیتابیس
 - layout → بررسی وجود پوشه در `layouts/`
 - language → بررسی وجود پوشه در `languages/`

   اگر وجود داشته باشد، پیام خطا نمایش داده می‌شود:
   ```
   ERROR: <name> already exists, try another.
   ```
---

#### خطاهای احتمالی
- `Invalid parameters!` → ورودی خالی باشد
- `Invalid type given.` → نوع ماژول اشتباه داده شود
- `Missing parameter value for option (xxx)` → یکی از پارامترهای ضروری ارسال نشده باشد
- `Ooops! Something went wrong. Please Try again later !` → مشکل داخلی  


#### نمونه کد برای تست

##### 1. ایجاد یک ماژول Entity جدید
```php
if (file_exists('vendor/autoload.php')) {
    include_once 'config.php';
    require_once 'vendor/autoload.php';
}
include_once 'includes/Loader.php';
include_once 'vtlib/Vtiger/Module.php';
include_once 'includes/runtime/EntryPoint.php';
$moduleInfo = [
    'name' => 'Books',
    'parent' => 'Sales',
    'entityfieldname' => 'book_name',
    'entityfieldlabel' => 'Book Name'
];

$result = ParsVT_ModuleController_Model::build($moduleInfo, 'entity', true);
echo $result;
```
---

##### 2. ایجاد یک Extension جدید
```php
if (file_exists('vendor/autoload.php')) {
    include_once 'config.php';
    require_once 'vendor/autoload.php';
}
include_once 'includes/Loader.php';
include_once 'vtlib/Vtiger/Module.php';
include_once 'includes/runtime/EntryPoint.php';

$moduleInfo = [
    'name' => 'CustomReports'
];

$result = ParsVT_ModuleController_Model::build($moduleInfo, 'extension');
echo $result;
```
---

##### 3. ایجاد یک Layout جدید
```php
if (file_exists('vendor/autoload.php')) {
    include_once 'config.php';
    require_once 'vendor/autoload.php';
}
include_once 'includes/Loader.php';
include_once 'vtlib/Vtiger/Module.php';
include_once 'includes/runtime/EntryPoint.php';
$moduleInfo = [
    'name' => 'ModernTheme'
];

$result = ParsVT_ModuleController_Model::build($moduleInfo, 'layout');
echo $result;
```
---

##### 4. ایجاد یک زبان جدید (مثلاً فارسی)
```php
if (file_exists('vendor/autoload.php')) {
    include_once 'config.php';
    require_once 'vendor/autoload.php';
}
include_once 'includes/Loader.php';
include_once 'vtlib/Vtiger/Module.php';
include_once 'includes/runtime/EntryPoint.php';
$moduleInfo = [
    'prefix' => 'fa_ir'
];

$result = ParsVT_ModuleController_Model::build($moduleInfo, 'language');
echo $result;
```


