### مقدمه 
API مخفف رابط  کاربردی برنامه‌نویسی بوده و مجموعه‌ای از پروتکل‌هایی است که به منظور ساخت و یکپارچه‌سازی نرم‌افزار استفاده می‌شود. API اجازه می‌دهد تا محصول یا خدمات شما با سایر محصولات و خدمات دیگر، ارتباط برقرار کند بدون اینکه بداند چطور آنها برنامه‌نویسی شده‌اند. این امر می‌تواند توسعه‌ی برنامه، صرفه‌جویی در وقت و هزینه را برای شما آسان کند. هنگامی که محصولات و نرم‌افزارهای جدیدی را طراحی کرده و آن ها را مدیریت می‌کنید، API به شما انعطاف‌پذیری و آزادی عمل می‌دهد و فرصت‌هایی برای ایده‌های جدید فراهم می‌کند.

API مخفف کلمه”Application Programing Interface” به معنای رابط برنامه‌نویسی کاربردی است. واسطه‌ای نرم‌افزاری است که به دو برنامه اجازه می‌دهد که با یکدیگر ارتباط داشته باشند. هر بار که از یک برنامه مثل اینستاگرام استفاده می‌کنید یا یک پیام ارسال می‌کنید و یا حتی وضعیت تلفن خود را بررسی می‌کنید، در حقیقت از یک API استفاده می‌کنید.

در ویتایگر شما می توانید از API ها بر روی پروتکل های HTTP(s) برای ارسال یا واکشی داده ها از Vtiger و ادغام با برنامه های شخص ثالث استفاده کنید.

 <br>
 <br>
 
 ### API پیش فرض ویتایگر
ویتایگر نسخه اپن سورس به صورت پیش فرض یک سرویس REST API جهت توسعه در اختیار کاربران قرار میدهد. 

در این API شما پیش از هر درخواست باید عملیات ورود و دریافت توکن را انجام دهید و سپس  عملیات مورد نظر خود را انجام دهید.

لیست عملیات های این وب سرویس به شرح زیر می باشد:

* getchallenge
* login
* create
* retrieve
* update
* delete
* sync
* query
* listtypes
* describe
* logout
* extendsession



برای اطلاعات بیشتر به لینک زیر مراجعه نمایید:
<br>
[https://community.vtiger.com/help/vtigercrm/developers/third-party-app-integration.html](https://community.vtiger.com/help/vtigercrm/developers/third-party-app-integration.html)
 <br>
 <br>
 
 
 <br>
 <br>

### REST API نسخه 1 پارس ویتایگر
این API برای رفع نواقص API پیش فرض ویتایگر ارائه گردید و عملیات های بیشتری را برای کار در اختیار برنامه نویس قرار میدهد. برای اطلاعات بیشتر به راهنمای زیر مراجعه نمایید
<br>
[راهنمای API پارس ویتایگر](index.php?module=ParsVT&view=RestAPI&parent=Settings)
<br>
<br>

###  API نسخه 2 پارس ویتایگر
این API پس از انتشار REST API نسخه 1 و جهت ارائه API استاندارد دیگری سازگار با API پیش فرض ویتایگر و مبتنی بر API نسخه ابری ویتایگر منتشر شد.  این API بیش از 135 عملیات ها را برای کار در اختیار برنامه نویس قرار میدهد. برای اطلاعات بیشتر به راهنمای زیر مراجعه نمایید.
این API بر روی پروتکل های REST و SOAP ارائه گردیده است.
<br>
[راهنمای API پارس ویتایگر](index.php?module=ParsVT&view=RestAPI&parent=Settings)
<br>
<br>


###  سایر API های پارس ویتایگر
پارس ویتایگر به جز API های ذکر شده چندین API دیگر برای کار با Zapier و Make و همچنین API مرکز تلفنی و هوش تجاری ارائه میکند.
<br>
[راهنمای API پارس ویتایگر](index.php?module=ParsVT&view=RestAPI&parent=Settings)
<br>
<br>


### راهنمای توسعه در ویتایگر
پس از کلیک بر روی فعال سازی **فعال سازی API های سفارشی** فایل موجود در مسیر زیر 
از
```
modules/ParsVT/models/override/WebService.php.rename
```

به 

```
modules/ParsVT/models/override/WebService.php
```
تغییر نام میدهد و شما میتوانید کد های مورد نظر خود را در این فایل وارد نمایید

 <br>
 <br>

#### 💡 راهنمای ویرایش فایل WebService.php
در این فایل شما میتوانید هرکدام از API های سفارشی خود را به صورت یک آرایه در متغییرهای $operations و $operations_parameters اضافه نمایید


در متغییر $operations هر API سفارشی باید به صورت یک آرایه شامل پارامتر های زیر باشد:

* کلید آرایه با نام API جهت فراخوانی مقدار دهی می شود و محتوای آن برابر یک آرایه با4 پارامتر می باشد. 
* * پارامتر اول نام API سفارشی جهت فراخوانی همانند کلید اصلی
* * پارامتر دوم آدرس فایلی که تابع وب سرویس در آن آورده شده است
* * پارامتر سوم نام تابع به زبان PHP که API سفارشی جهت فراخوانی از آن استفاده میکند
* * پارامتر چهارم متد درخواست که میتواند GET یا POST باشد
 <br>

برای مثال خروجی یک نمونه تابع برای متفییر $operations به صورت زیر خواهد بود

```
   'custom_method_name' => array('custom_method_name', 'modules/ParsVT/handlers/CustomAPIs.php', 'vtws_custom_method_function', 'GET'), //GET or POST
```


 <br>

در متغییر $operations_parameters هر API سفارشی باید به صورت یک آرایه شامل پارامتر های زیر باشد:

* کلید آرایه با نام API جهت فراخوانی مقدار دهی می شود و محتوای آن برابر یک آرایه با پارامتر های تابع API می باشد. 
* در صورتی که API مقدار ورودی نداشته باشد مقدار باید به صورت یک آرایه خالی وارد شود
* در صورتی که پارامتر های ورودی از نوع String باشد مقدار آن با کلمه string مقدار دهی می شود. برای مثال اگر پارامتر اول با نام param1 از نوع string باشد کد به صورت زیر است:
```
array('param1', 'string', 1),
```

* در صورتی که پارامتر های ورودی از نوع Json باشد مقدار آن با کلمه encoded مقدار دهی می شود. برای مثال اگر پارامتر دوم با نام param2 از نوع json باشد کد به صورت زیر است:
```
array('param2', 'encoded', 2),
```

* در صورتی که پارامتر های ورودی از نوع Boolean باشد مقدار آن با کلمه boolean مقدار دهی می شود. برای مثال اگر پارامتر سوم با نام param3 از نوع boolean باشد کد به صورت زیر است:
```
array('param3', 'boolean', 3),
```

* برای مثال خروجی یک نمونه تابع برای متفییر $operations_parameters به صورت زیر خواهد بود

```
    'custom_method_name' => array(
        array('param1', 'string', 1),
        array('param2', 'encoded', 2),
        array('param3', 'boolean', 3),
    ),
    ```

 <br>

در فایل modules/ParsVT/models/override/WebService.php به صورت پیش فرض یک تابع جهت بازیابی لیبل رکورد براساس آی دی آورده شده است.
تعریف متغیر آن برای $operations و $operations_parameters به صورت زیر خواهد بود.

$operations
```
  'get_record_label' => array(
      'get_record_label',  //نام API سفارشی جهت فراخوانی
      'modules/ParsVT/handlers/CustomAPIs.php',  //آدرس فایلی که تابع وب سرویس در آن آورده شده است
      'vtws_get_record_label', //نام تابع API سفارشی جهت فراخوانی
      'GET'  // نوع متد که میتواند GET یا POST باشد
     ),
```

$operations_parameters
```
    'get_record_label' => array(
        array('record', 'string', 1),
    ),
```

نحوه فراخوانی آن به صورت زیر است
```
http://yourcrm.com/modules/ParsVT/ws/API/V2/vtiger/extended/get_record_label?record=12x1900
```

 <br>


> ``📝`` نکته:
> *  API سفارشی هم در وب سرویس REST 2 و SOAP 2 و هم در API پیش فرض ویتایگر قابل دسترسی است.
> * پس از توسعه API شما باید بر روی دکمه **فعال سازی API های سفارشی** کلید نمایید تا API سفارشی شما فعال گردد.



 ### API عمومی بدون نیاز به احراز هویت
 
 در حالی که اکثر API ها نیاز به دسترسی از طریق نام کاربری و گذرواژه یا کلید دسترسی جهت دسترسی را دارند، پارس ویتایگر این امکان را فراهم نموده که برای برخی متدهای دلخواه کاربر این روش بدون احراز هویت انجام پذیرد. این مورد به ویژه برای مبتدیان مفید است، زیرا به این معنی است که می توانید فوراً کاوش API های مختلف را شروع کنید. همچنین برای توسعه دهندگان وب که به دنبال دسترسی به مجموعه داده های نمونه برای آزمایش هستند مفید است.

در ادامه یک نمونه متد با نام WhatsMyIP برای برگرداندن آی پی کاربر در مسیر زیر آورده شده است
```
modules/ParsVT/V2/Public/Network.php
```


نحوه فراخوانی آن به صورت زیر است
```
http://yourcrm.com/modules/ParsVT/ws/API/V2/Public/Network/WhatsMyIP
```
 
 
