### مقدمه (Custom Functions)
تابع های سفارشی گردش کار، توابع پیچیده ای می باشند که برای انجام امور خاص طراحی شده اند. در نرم افزار اولیه ویتایگر تنها توابع سفارشی موجود تابع "ارسال اطلاعات ورود به بخش پورتال و "بروزرسانی موجودی انبار" در ماژولهای مرتبط با انبار نظیر فاکتور می باشد که به منظور ارسال ایمیلی با محتوای اطلاعات مربوط به دسترسی های بخش پورتال و بروزرسانی تعداد موجودی محصولات پس از انتخاب محصول در فاکتور، سفارش خرید و فروش طراحی شده است. لازم به ذکر است شما نمی توانید با استفاده از رابط گرافیکی کاربر (GUI) نرم افزار ویتایگر تابع سفارشی دیگری ایجاد کنید و می بایست برای این منظور از راهنمای توسعه که در ادامه آمده است استفاده نمایید.

 <br>
 <br>
 
 ### توابع سفارشی پارس ویتایگر
پس از نصب بسته فارسی ساز پارس ویتایگر و در بخش تنظیمات متفرقه می توانید با کلیک بر روی **افزودن توابع سفارشی ارجاع به**  توابع سفارشی **ارجاع به ایجاد کننده رکورد** ، **ارجاع به نقش مافوق** را برای همه ماژول ها و تابع **بروزرسانی ارجاع به یادداشت با ارجاع به رکورد مرتبط** برای یادداشت ها و توابع **بروزرسانی ارجاع به تیکت با ارجاع به مخاطب مرتبط** و **بروزرسانی ارجاع به تیکت با ارجاع به سازمان مرتبط** را برای ماژول تیکت ها فعال نمایید.
 
 <br>
 <br>

### تفاوت Custom Functions با Handlers
 Handler  ها در ویتایگر بر روی رویداد های ویتایگر کار میکنند ولی توابع سفارشی صرفا با بخش گردش کار ها کار میکنند و ازطریق اضافه کردن Custom Task به Entity ماژول های ویتایگر به شما اجازه میدهند تا اقدامات سفارشی را به گردش کار اضافه کنید. 

 
 <br>
 <br>


> ``📝`` نکته:
> توجه داشته باشید لطفا در هنگام ایجاد هر گونه تغییر مراقب باشید، بهتر است ابتدا از پایگاه داده خود نسخه پشتیبان تهیه کنید


 <br>
 <br>

### راهنمای توسعه در ویتایگر
پس از کلیک بر روی فعال سازی **فعال سازی توابع سفارشی** فایل موجود در مسیر زیر 
از
```
modules/ParsVT/handlers/ParsVTCustomFunction.php.rename
```

به 

```
modules/ParsVT/handlers/ParsVTCustomFunction.php
```
تغییر نام میدهد و شما میتوانید کد های مورد نظر خود را در این فایل وارد نمایید

 <br>
 <br>

#### 💡 کلاس ParsVTCustomFunctions
در این کلاس شما میتوانید هرکدام از توابع سفارشی خود را به صورت یک آرایه در متغییر $custom_functions اضافه نمایید


متغییر هر آرایه باید شامل پارامتر های زیر باشد:

* کلید module با نام ماژولی که میخواهید تابع سفارشی بر روی آن فعال شود مقدار دهی می شود. در صورت خالی بودن این مقدار تابع برای همه ماژول های موجود فعال میگردد.
* کلید label عنوان تابع سفارشی است که آن را در بخش Task های تابع سفارشی مشاهده خواهید نمود.
* کلید path آدرس فایلی که تابع سفارشی در آن وجود دارد را مشخص می کنید شمشا میتوانید تابع سفارشی خود را در همین فایل پس از کلاس ParsVTCustomFunctions وارد نمایید.
* کلید method با نام تابع سفارشی مقدار دهی میکردد.


 <br>


> ``📝`` نکته:
> * در صورتی که نام ماژول به اشتباه وارد شود تابع سفارشی فعال نخواهد شد.
> * پس از توسعه تابع شما باید بر روی دکمه **فعال سازی توابع سفارشی** کلید نمایید تا تابع سفارشی شما فعال گردد.


