### مقدمه
برخی اوقات ممکن است شما نیاز داشته باشید که یک قابلیت خاص به ویتایگر اضافه کنید و کدهای مورد نیاز خود را به سی آر ام خود اضافه کنید. در این صورت است که handler ها به شما کمک می‌کند و شما توسط آن می‌توانید به‌راحتی این کار را انجام دهید. اگر شما قصد دارید ماژول خود را توسعه دهید و CRM خود را سفارشی‌سازی کنید؛ حتماً لازم است که کاربرد handler ها را بدانید. پس به شما توصیه می‌کنیم تا پایان این مقاله با ما همراه باشید.  
 <br>
 <br>
 
 ### رویداد ماژول (Module Event) در CRM چیست؟
یکی از مهم ترین عوامل در قابلیت توسعه پذیری سیستم ویتایگر در ساخت انواع ماژول و توسعه و یکپارچه سازی استفاده از Handler ها می باشد .اگر بخواهیم در یک کلمه رویداد های ماژول که توسط Handler ها مدیریت میشوند را تعریف کنیم میتوان گفت رویداد ها در ویتایگر در زمان وقوع وقایع که در درخواست های مختلف انجام می شود فراخوانی میشوند. این اطلاعات ارسالی این رویدادها می توان تغییر داد یا از آنها برای مقاصد دیگر استفاده کرد.
<br>
برای مثال میخواهید یک اعلان ایمیل را برای یک اقدام خاص اضافه کنید، در نهایت باید کد اصلی vtiger را تغییر دهید تا عملکرد خود را اضافه کنید. رویداد ماژول یک راه ساده برای اضافه کردن اکشن ها بدون ایجاد هیچ تغییری در هسته ویتایگر ارائه می دهد.
 
 <br>
 <br>

### انواع رویداد ها در ویتایگر استاندارد
در ادامه تمام رویدادهای ویتایگر که شما میتوانید به اطلاعات آنها دسترسی داشته باشید آورده شده است.
 
 <br>
 <br>

#### 💡 رویداد vtiger.entity.beforesave
این رویداد قبل از ذخیره شدن یک رکورد در Entity ماژول ها فراخوانی می شود و یک شی VTEntityData به شما ارسال می شود که نشان دهنده محتوای رکورد برای ذخیره می باشد. لازم به ذکر است که رکوردهای جدید دارای شناسه (id) نخواهند بود. شما می توانید محتویات entityData را پیش از ذخیره تغییر دهید لذا باید کمی مراقب باشید زیرا ممکن است اطلاعات رکورد را خراب کنید.

در مثال زیر در زمان فراخوانی این رویداد همیشه هنگام ذخیره، فیلد ارجاع به اختصاص داده شده را به admin تغییر می دهد. با این کار مطمئن خواهید شد که ادمین مالک همه رکورد های جدید یا ذخیره شده خواهد بود.


```
entityData->set('assigned_to_id', '1');
```

> ``📝`` نکته:
> از آنجایی که محتوای رکورد پیش از ذخیره قابل تغییر است، دو رویداد فرعی مربوط به vtiger.entity.beforesave وجود دارد.

 <br>

#### 💡 رویداد vtiger.entity.beforesave.modifiable
این رویداد قبل از رویداد vtiger.entity.beforesave فراخوانی می شود. اگر می‌خواهید محتوای رکورد ارسالی را قبل از ذخیره آن تغییر دهید، از این رویداد استفاده کنید.

 <br>
 <br>

#### 💡 رویداد vtiger.entity.beforesave.final
این رویداد بعد از رویداد vtiger.entity.beforesave فراخوانی می شود. اگر می‌خواهید محتوای رکورد ارسالی را قبل از ذخیره آن تغییر دهید، از این رویداد استفاده کنید.

 <br>
 <br>

#### 💡 رویداد vtiger.entity.aftersave
این رویداد پس از ذخیره یک Entity رکورد فراخوانی می شود و یک شی از نوع VTEntityData را به عنوان ورودی میگیرد. در اینجا یک مثال ساده وجود دارد که زمان ویرایش را هنگام ذخیره یک رکورد لاگ میگیرد.


```
global $log; 
$log->debug($data->getModuleName()":".$data->getId().":".$data->get('modifiedtime'));
 ```

 <br>
 <br>

#### 💡 رویداد vtiger.entity.aftersave.final
این رویداد بعد از رویداد vtiger.entity.aftersave فراخوانی می شود و از آن اطلاعات رکورد ذخیره شده می توانید برای کد نویسی های خود استفاده نمایید.


 <br>
 <br>

#### 💡 رویداد vtiger.batchevent.save
این رویداد بعد از ایجاد رکورد به صورت زمانبندی و یا با ورود اطلاعات از فایل اکسل فراخوانی می شود و از آن اطلاعات رکورد ذخیره شده می توانید برای کد نویسی های خود استفاده نمایید.


 <br>
 <br>

#### 💡 رویداد vtiger.entity.beforedelete
این رویداد پیش از حذف یک Entity رکورد فراخوانی می شود و یک شی از نوع VTEntityData را به عنوان ورودی میگیرد.

برای مثال میتوانید با نمایش پیام زیر اجازه حذف رکورد را به کاربر ندهید.

```
throw new AppException('Record is not deletable!.');
```

 <br>
 <br>

#### 💡 رویداد vtiger.entity.afterdelete
این رویداد پس از حذف یک Entity رکورد فراخوانی می شود و یک شی از نوع VTEntityData را به عنوان ورودی میگیرد و از اطلاعات آن میتوانید نظیر آی دی رکورد حذف شده میتوانید جهت توسعه های خود استفاده نمایید. 


 <br>
 <br>

#### 💡 رویداد vtiger.batchevent.delete
 رویداد پس از حذف یک Entity رکورد به صورت حذف گروهی فراخوانی می شود و یک شی از نوع VTEntityData را به عنوان ورودی میگیرد و از اطلاعات آن میتوانید نظیر آی دی رکورد حذف شده میتوانید جهت توسعه های خود استفاده نمایید. 

 <br>
 <br>

#### 💡 رویداد vtiger.entity.afterrestore
این رویداد پس از بازیابی یک رکورد در Entity ماژول ها از سطل بازیابی فراخوانی می شود و یک شی VTEntityData به شما ارسال می شود که نشان دهنده محتوای رکورد برای استفاده توسعه دهنده می باشد. 


 <br>
 <br>

#### 💡 رویداد vtiger.lead.convertlead
این رویداد پس از تبدیل یک سرنخ به مخاطب ، سازمان یا فرصت فراخوانی میشود و شما میتوانید اطلاعات رکورد های جدید ایجاد شده و رکورد اصلی که اطلاعات به آن منتقل میشود را از طریق کد زیر دریافت نمایید.

```
$convertedEntityIdsInfo = $entityData->entityIds;  //رکورد های ایجاد شده
$transferRelatedRecordsTo = $entityData->transferRelatedRecordsTo; // ماژول اصلی که اطلاعات رد آن ذخیره شده است
```

 <br>
 <br>

#### 💡 رویداد vtiger.picklist.afterrename
این رویداد پس از تغییر نام یک فهرست انتخابی فراخوانی میشود و در صورت نیاز میتوانیذ از طریق مقادیر زیر به محتوای جدید و قدیم دسترسی داشته باشید.

```
$entityData['newvalue'];  //مقدار جدید فهرست انتخابی
$entityData['oldvalue'];  //مقدار قدیم فهرست انتخابی
```

 <br>
 <br>

#### 💡 رویداد vtiger.picklist.afterdelete
 رویداد پس از حذف  یک فهرست انتخابی فراخوانی میشود و در صورت نیاز میتوانیذ از طریق مقادیر زیر به محتوای چایگزین شده و حرف شده دسترسی داشته باشید.


```
$entityData['replacevalue'];  //مقدار جدیدی که اطلاعات قبلی با آن جایگزین می شوند
$entityData['valuetodelete'];  // مقداری که حذف شده است
```

 <br>
 <br>



#### 💡 رویداد vtiger.module.enabled
رویداد پس از فعالسازی یک ماژول، فراخوانی می شود و شما میتوانید پس از فعالسازی یک ماژول، عملیاتی را انجام دهید. ورودی این رویداد یک آرایه با پارامتر module می باشد که مقدار داده ای آن با نام ماژول مقصد مقداردهی شده است .


```
array('module' => $modulename);  // نام ماژول مقصد برای انجام فرایند
```

 <br>
 <br>


 #### 💡 رویداد vtiger.module.disable
رویداد پس از غیر فعال کردن یک ماژول، فراخوانی می شود و میتوانید عملیات سفارشی خودرا پس از غیر فعال کردن یک ماژول پیاده سازی کنید. ورودی این رویداد یک آرایه با پارامتر module می باشد که مقدار داده ای آن با نام ماژول مقصد مقداردهی شده است .


```
array('module' => $modulename);  // نام ماژول مقصد برای انجام فرایند
```

 <br>
 <br>


#### 💡 رویداد vtiger.module.postinstall
رویداد پس از نصب یک ماژول فراخوانی می شود. در صورتی که نیاز دارید، پس از نصب یک ماژول عملیاتی روی سیستم شما انجام شود، میتوانید از این متد استفاده نمایید. ورودی این رویداد یک آرایه با پارامتر module می باشد که مقدار داده ای آن با نام ماژول مقصد مقداردهی شده است.


```
array('module' => $modulename);  // نام ماژول مقصد برای انجام فرایند
```

 <br>
 <br>


#### 💡 رویداد vtiger.module.preuninstall 
رویداد پیش از حذف یک ماژول فراخوانی می شود و عملیات شما پیش از حذف  یک ماژول انجام می گردد. ورودی این رویداد یک آرایه با پارامتر module می باشد که مقدار داده ای آن با نام ماژول مقصد مقداردهی شده است.


```
array('module' => $modulename);  // نام ماژول مقصد برای انجام فرایند
```

 <br>
 <br>


#### 💡 رویداد vtiger.module.preupdate
رویداد پیش از آپدیت و بروزرسانی یک ماژول فراخوانی میشود و میتواند پیش از بروزرسانی ماژول، عملیاتی روی سیستم شما انجام دهد. ورودی این رویداد یک آرایه با پارامتر module می باشد که مقدار داده ای آن با نام ماژول مقصد مقداردهی شده است.


```
array('module' => $modulename);  // نام ماژول مقصد برای انجام فرایند
```

 <br>
 <br>



#### 💡 رویداد vtiger.module.postupdate
رویداد پس از بروزرسانی یا آپدیت ماژول فراخوانی می شود و میتوانید با استفاده از این متد، پس از بروزرسانی ماژول، عملیات سفارشی خود را روی سیستم پیاده سازی کنید. ورودی این رویداد یک آرایه با پارامتر module می باشد که مقدار داده ای آن با نام ماژول مقصد مقداردهی شده است .


```
array('module' => $modulename);  // نام ماژول مقصد برای انجام فرایند
```

 <br>
 <br>


#### 💡 رویداد vtiger.after.portal.enabled
رویداد پس از فعالسازی ماژول پورتال مشتریان فراخوانی می شود. در این رویداد شما میتوانید بلافاصله پس از فعال شدن ماژول پورتال مشترکین، توسعه خود را پیاده سازی کنید . این رویداد پس از فراخوانی آی دی مخاطب را در قالب یک آرایه به فرمت زیر را در اختیار شما قرار می دهد.

```
array($entityId);
```

 <br>
 <br>


#### 💡 رویداد vtiger.after.first.user.login
رویداد پس از اولین ورود کاربر روی نرم افزار فراخوانی می شود. ورودی این متد یک شئ از نوع VTEntityData می باشد که میتوانید از اطلاعات آن نظیر آی دی کاربر  لاگین شده و ... در توسعه های خود استفاده نمایید. 


 <br>
 <br>


#### 💡 رویداد vtiger.users.after.login
رویداد پس از هر بار ورود کاربر روی نرم افزار فراخوانی میشود. این متد نیز یک شئ از نوع VTEntityData را به عنوان ورودی گرفته و اطلاعات کاربر لاگین شده را در اختیار شما قرار می دهد و بر اساس این اطلاعات می توانید توسعه خود را انجام دهید.


 <br>
 <br>


#### 💡 رویداد vtiger.users.logout
رویداد پس از هر بار خروج  کاربر از نرم افزار فراخوانی می شود. این متد یک شئ از نوع VTEntityData را به عنوان ورودی گرفته و اطلاعات مربوط به کاربر خارج شده از سیستم نظیر شناسه کاربر، نام و... را در اختیار شما قرار می دهد.


 <br>
 <br>


#### 💡 رویداد vtiger.users.after.changepassword
رویداد پس از تغییر پسورد کاربر فراخوانی می گردد. این رویداد یک شئ از نوع VTEntityData را به عنوان ورودی گرفته و پس از تغییر پسورد کاربر، میتوانید اطلاعات کاربر مربوطه را داشته باشید و در توسعه خود از آن استفاده کنید.


 <br>
 <br>


#### 💡 رویداد vtiger.users.after.changeaccesskey
رویداد پس از تغییر کلید دسترسی  کاربر در تنظیمات پروفایل فراخوانی می گردد. این رویداد یک شئ از نوع VTEntityData را به عنوان ورودی گرفته و بلافاصله پس از تغییر کلید دسترسی کاربر، اطلاعات مربوط به کاربر مربوطه را در اختیار شما قرار می دهد و میتوانید از این اطلاعات در توسعه خود استفاده نمایید.

 <br>
 <br>


#### 💡 رویداد vtiger.webform.after.save
رویداد پس از ذخیره سازی یک وب فرم فراخوانی می گردد. این رویداد یک شئ از نوع VTEntityData را به عنوان ورودی گرفته و شما میتوانید بلافاصله پس از ایجاد و ذخیره یک وب فرم اطلاعات آن نظیر آی دی و ... را داشته باشید و از آن ها در توسعه های خود استفاده نمایید.

```
$InfoWebform = $entityData->getData();  //اطلاعات مربوط به وب فرم
```


 <br>
 <br>


#### 💡 رویداد vtiger.entity.beforerelate
این رویداد پیش از ارتباط رکورد ها با یکدیگر فراخوانی می گردد. این رویداد یک آرایه را به عنوان ورودی میگیرد و اطلاعات را به فرمت زیر پیش از ایجاد ارتباط اختیار شما قرار می دهد و میتوانید در توسعه های خود از این اطلاعات استفاده کنید.

این رویداد در نسخه ویتایگر 7.3.0 به بعد قابل استفاده می باشد.

```
array('sourceModule'=>$sourceModule, 'sourceRecordId'=>$sourceRecordId,
                  'destinationModule'=>$destinationModule,'destinationRecordIds'=>$destinationRecordIds);
```

 <br>
 <br>


#### 💡 رویداد vtiger.entity.afterrelate
این رویداد پس از ارتباط رکورد ها با یکدیگر فراخوانی می گردد. این رویداد یک آرایه را به عنوان ورودی میگیرد و اطلاعات را به فرمت زیر پس از ایجاد ارتباط اختیار شما قرار می دهد و میتوانید در توسعه های خود از این اطلاعات استفاده کنید.

این رویداد در نسخه ویتایگر 7.3.0 به بعد قابل استفاده می باشد.
 
```
array('sourceModule'=>$sourceModule, 'sourceRecordId'=>$sourceRecordId,
                  'destinationModule'=>$destinationModule,'destinationRecordIds'=>$destinationRecordIds);
```

<br>
 <br>


#### 💡 رویداد vtiger.entity.tagadd
رویداد پس از اضافه شدن یک تگ فراخوانی میگردد. این رویداد پس از فراخوانی آرایه ای از اطلاعات تگ ایجاد شده نظیر آی دی تگ، آی دی رکورد، نام ماژول و ... را در اختیار شما قرار می دهد و شما میتوانید از این اطلاعات در توسعه های خود استفاده کنید.

```
array('tagid' => $tagId, 'userid' => $userId, 'recordid' => $recordId, 'module' => $module)
```

 <br>
 <br>


#### 💡 رویداد vtiger.entity.record.delete
رویداد پس از حذف یک رکورد ماژول در سطل بازیابی  فراخوانی می گردد. پس از حذف یک رکورد آرایه ای از اطلاعات رکورد حذف شده از جمله آی دی رکورد و ... در اختیار شما قرار میگیرد. 

```
array('type'=>'RECORD','recordIds'=>$recordIds);
```

 <br>
 <br>


#### 💡 رویداد vtiger.filter.beforesave
رویداد پیش از ایجاد و ذخیره سازی یک لیست یا فیلتر در نمایش لیستی یک ماژول فراخوانی می شود. این رویداد یک شئ از نوع  Record Model را به عنوان ورودی میگیرد. 

 <br>
 <br>


#### 💡 رویداد vtiger.filter.aftersave
رویداد  پس از ایجاد و ذخیره سازی یک لیست یا فیلتر در نمایش لیستی یک ماژول فراخوانی می شود. این رویداد یک شئ از نوع  Record Model را به عنوان ورودی گرفته و با اطلاعات مربوط به لیست یا فیلتر ایجاد شده میتوانید توسعه های خود را انجام دهید.

 <br>
 <br>


#### 💡 رویداد vtiger.filter.beforedelete
رویداد  پیش از حذف یک لیست یا فیلتر در نمایش لیستی یک ماژول فراخوانی می شود. این رویداد یک شئ از نوع  Record Model را به عنوان ورودی گرفته و قبل از حذف لیست یا فیلتر اطلاعاتی نظیر آی دی لیست و ... را در اختیار شما قرار می دهد و شمامیتوانید از این اطلاعات در توسعه خود استفاده کنید.

 <br>
 <br>


#### 💡 رویداد vtiger.filter.afterdelete
رویداد   پس از حذف یک لیست یا فیلتر در نمایش لیستی یک ماژول فراخوانی می شود. این رویداد یک شئ از نوع  Record Model را به عنوان ورودی گرفته و پس از حذف لیست یا فیلتر اطلاعاتی نظیر آی دیلیست و ... را در اختیار شما قرار می دهد و میتوانید از این اطلاعات در توسعه های خود استفاده

 <br>
 <br>


#### 💡 رویداد vtiger.entity.list.delete
رویداد پس از حذف لیست یا فیلتر موجود در نمایش لیستی یک ماژول فراخوانی میگردد.

```
array('type'=>'LIST','recordIds'=>array($cvId));

``` 

<br>
<br>


#### 💡 رویداد vtiger.emailtemplates.beforesave
رویداد پیش از ذخیره قالب ایمیل فراخوانی می گردد. این رویداد یک شئ از نوع  Record Model را به عنوان ورودی گرفته و اطلاعات کامل قالب ایمیل ایجاد شده نظیر نام و ...  قبل از اعمال تغییرات را در اختیار شما قرار می دهد و میتوانید از آن ها در در توسعه خود استفاده کنید.

 <br>
 <br>


#### 💡 رویداد vtiger.emailtemplates.aftersave
رویداد  پس از ذخیره قالب ایمیل فراخوانی می گردد. این رویداد یک شئ از نوع  Record Model به عنوان ورودی گرفته و اطلاعات کامل قالب ایمیل را پس از ذخیره کردن در اختیار شما قرار می دهد و میتوانید از این اطلاعات در توسعه خود استفاده کنید.

 <br>
 <br>


#### 💡 رویداد vtiger.entity.detail.view
رویداد بلافاصله پس از وارد شدن به صفحه اطلاعات یک رکورد فراخوانی می گردد. این رویداد یک شئ از نوع  Record Model را به عنوان ورودی میگیرد.

 <br>
 <br>


#### 💡 رویداد vtiger.entity.edit.view
رویداد بلافاصله پس از وارد شدن به صفحه ویرایش یک رکورد فراخوانی می گردد. این رویداد یک شئ از نوع  Record Model را به عنوان ورودی میگیرد.
 
<br>
 <br>


#### 💡 رویداد vtiger.entity.list.view
رویداد بلافاصله پس از وارد شدن به لیست رکوردهای یک ماژول فراخوانی می گردد.این رویداد یک شئ از نوع  Record Model را به عنوان ورودی میگیرد.

 <br>
 <br>


#### 💡 رویداد vtiger.entity.afterworkflow
رویداد بلافاصله پس از اجرای گردش کار بر روی یک رکورد فراخوانی می گردد.

 <br>
 <br>


#### 💡 رویداد vtiger.entity.beforeworkflow
رویداد بلافاصله قبل از اجرای گردش کار بر روی یک رکورد فراخوانی می گردد.

 <br>
 <br>


### راهنمای توسعه در ویتایگر
پس از کلیک بر روی فعال سازی **فعال سازی Handler های سفارشی** فایل موجود در مسیر زیر 
از
```
modules/ParsVT/handlers/CustomHandler.php.rename
```

به 

```
modules/ParsVT/handlers/CustomHandler.php
```
تغییر نام میدهد و شما میتوانید کد های مورد نظر خود را در این فایل در بخش هر رویداد به صورت مجزا وارد نمایید

 <br>
 <br>


### شی VTEntityData در ویتایگر
شی VTEntityData دسترسی به Entity رکورد ها را فراهم می کند و توابع  زیر را در دسترس برنامه نویس قرار میدهد.

#### 💡 تابع getModuleName
نام ماژول را باز میگرداند

#### 💡 تابع getId
شناسه Id رکورد را برمی‌گرداند، اگر رکورد جدید باشد و هنوز ذخیره نشده باشد، خالی خواهد شد.

#### 💡 تابع getData
فیلدهای رکورد را به صورت آرایه ای برمی گرداند که در آن نام فیلد کلید آرایه و مقدار فیلد ، مقدار آرایه است.

#### 💡 تابع isNew
اگر رکورد جدیدی ایجاد شود true را برمی‌گرداند، در غیر این صورت false را برمی‌گرداند.



### شی Vtiger_Record_Model در ویتایگر
شی Vtiger_Record_Model یا (Record Model) توابع  زیر را در دسترس برنامه نویس قرار میدهد.

#### 💡 تابع getModule()->name
نام ماژول را باز میگرداند

#### 💡 تابع getId
شناسه Id رکورد را برمی‌گرداند، اگر رکورد جدید باشد و هنوز ذخیره نشده باشد، خالی خواهد شد.

#### 💡 تابع getData
فیلدهای رکورد را به صورت آرایه ای برمی گرداند که در آن نام فیلد کلید آرایه و مقدار فیلد ، مقدار آرایه است.



#### ویرایش فیلد های یک شی Entity 
در رویدادهای خاص، به عنوان مثال، "vtiger.entity.beforesave.modifiable" ممکن است موجودیت را تغییر دهید تا ذخیره شود.

 به عنوان مثال، برای یک شی VTEntityData به نام $data، می توانید فیلد simple_field را با استفاده از کد زیر به مقدار "value" تغییر دهید.
```
$entityData->set('simple_field', 'value');
```
اکنون مقدار با ذخیره simple_field به مقدار "value" ذخیره می شود.

